/*
    history
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_HISTORY_H__
#define __MISC_HISTORY_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MISC_TYPE_HISTORY            (misc_history_get_type ())
#define MISC_HISTORY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MISC_TYPE_HISTORY, MiscHistory))
#define MISC_HISTORY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MISC_TYPE_HISTORY, MiscHistoryClass))
#define MISC_IS_HISTORY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MISC_TYPE_HISTORY))
#define MISC_IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MISC_TYPE_HISTORY))
#define MISC_HISTORY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MISC_TYPE_HISTORY, MiscHistoryClass))


#define MISC_HISTORY_NUM_DEF 4
#define MISC_HISTORY_NUM_MIN 0
#define MISC_HISTORY_NUM_MAX 9


typedef struct _MiscHistory      MiscHistory;
typedef struct _MiscHistoryClass MiscHistoryClass;
typedef struct _MiscHistoryItem  MiscHistoryItem;


struct _MiscHistory
{
  /*< private >*/
  GObject    parent;

  /*< public >*/

  /*< private >*/
  gint       num;
  gint       position;
  gulong     handler_destroy;
  GtkWidget *menu_shell;
  GtkWidget *menu_item_head;
  GtkWidget *menu_item_foot;
  GList     *glist;
};
struct _MiscHistoryClass
{
  GObjectClass parent_class;

  /* -- signals -- */
  void (*activate) (MiscHistory *history,
                                const gchar *file);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
misc_history_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ウインドウメニュー関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
GObject*
misc_history_new (void);


/*  ja:メニューにファイルを追加する
    history,オブジェクト
       file,ファイル                                                        */
void
misc_history_add_file (MiscHistory *history,
                       const gchar *file);


/*  ja:メニューのファイルを取得する
    history,オブジェクト
        RET,ファイルのリスト                                                */
GList *
misc_history_get_file (MiscHistory *history);


/*  ja:メニューを取得する
    history,オブジェクト
        RET,メニュー                                                        */
#define misc_history_get_menu(history)                                      \
                            ((history)?MISC_HISTORY(history)->menu_shell:NULL)


/*  ja:メニューを設定する
       history,オブジェクト
    menu_shell,メニュー
      position,位置(0...,-1:末尾)                                           */
void
misc_history_set_menu (MiscHistory *history,
                       GtkWidget   *menu_shell,
                       gint         position);


/*  ja:メニューの数を取得する
    history,オブジェクト
        RET,メニューの数                                                    */
gint
misc_history_get_num (MiscHistory *history);


/*  ja:メニューの数を設定する
    history,オブジェクト
        num,メニューの数
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
misc_history_set_num (MiscHistory *history,
                      const gint   num);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MISC_HISTORY_H__ */
