/*
    winmenu
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_WINMENU_H__
#define __MISC_WINMENU_H__


#include "misc_mdi.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MISC_TYPE_WINMENU            (misc_winmenu_get_type ())
#define MISC_WINMENU(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MISC_TYPE_WINMENU, MiscWinmenu))
#define MISC_WINMENU_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MISC_TYPE_WINMENU, MiscWinmenuClass))
#define MISC_IS_WINMENU(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MISC_TYPE_WINMENU))
#define MISC_IS_WINMENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MISC_TYPE_WINMENU))
#define MISC_WINMENU_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MISC_TYPE_WINMENU, MiscWinmenuClass))


typedef struct _MiscWinmenu      MiscWinmenu;
typedef struct _MiscWinmenuClass MiscWinmenuClass;


struct _MiscWinmenu
{
  /*< private >*/
  GObject    parent;

  /*< public >*/

  /*< private >*/
  gint       position;
  gulong     handler_add;
  gulong     handler_change;
  gulong     handler_remove;
  gulong     handler_destroy_mdi;
  gulong     handler_destroy_menu;
  MiscMdi   *mdi;
  GtkWidget *menu_shell;
  GtkWidget *menu_item_head;
  GtkWidget *menu_item_foot;
  GList     *glist;
};
struct _MiscWinmenuClass
{
  GObjectClass parent_class;

  /* -- signals -- */
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
misc_winmenu_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ウインドウメニュー関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
GObject*
misc_winmenu_new (void);


/*  ja:MDIを取得する
    winmenu,オブジェクト
       mdi,MDI                                                              */
#define misc_winmenu_get_mdi(winmenu)                                       \
                                    ((winmenu)?MISC_WINMENU(winmenu)->mdi:NULL)


/*  ja:MDIを設定する
    winmenu,オブジェクト
       mdi,MDI                                                              */
void
misc_winmenu_set_mdi (MiscWinmenu *winmenu,
                      MiscMdi     *mdi);


/*  ja:メニューを取得する
    winmenu,オブジェクト
       menu,メニュー                                                        */
#define misc_winmenu_get_menu(winmenu)                                      \
                                ((winmenu)?MISC_WINMENU(winmenu)->menu:NULL)


/*  ja:メニューを設定する
       winmenu,オブジェクト
    menu_shell,メニュー
      position,位置(0...,-1:末尾)                                           */
void
misc_winmenu_set_menu (MiscWinmenu *winmenu,
                       GtkWidget   *menu_shell,
                       gint         position);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MISC_WINMENU_H__ */
