#include <stdio.h>
#include <stdlib.h>
#include "chunk.h"


/*	4ĤʸID
	 c1,1ʸ
	 c2,2ʸ
	 c3,3ʸ
	 c4,4ʸ
	RET,ID																	*/
FOURCC make4cc(char c1,char c2,char c3,char c4)
{
	int s=1;

	return *(char *)&s==0
		?(DWORD)(BYTE)c1<<24 | (DWORD)(BYTE)c2<<16
								| (DWORD)(BYTE)c3<<8 | (DWORD)(BYTE)c4
		:(DWORD)(BYTE)c1 | (DWORD)(BYTE)c2<<8
								| (DWORD)(BYTE)c3<<16 | (DWORD)(BYTE)c4<<24;
}


/*	4ĤʸID
	fourcc,ID
	     n,(1..4)
	   RET,ʸ																*/
char getidcc(FOURCC fourcc,int n)
{
	int s=1;

	return (char)(fourcc>>((*(char *)&s==0?4-n:n-1)*8));
}


/*	DWORDǡɤ߹
	buf,ǼХåե
	 fp,եݥ
	RET,0:,-1:顼													*/
int fdword(DWORD *buf,FILE *fp)
{
	int c,i;
	DWORD s=0;

	for (i=0;i<4;i++) {
		if ((c=fgetc(fp))==EOF)
			return -1;
		s+=(DWORD)c<<(i*8);
	}
	*buf=s;
	return 0;
}


/*	եݥ󥿤󥯹¤Τ
	 fp,եݥ
	RET,󥯹¤														*/
CHUNK *chunkopen(FILE *fp)
{
	long size;
	CHUNK *ck;

	if (fseek(fp,0,SEEK_END)!=0 || (size=ftell(fp))==-1
				|| fseek(fp,0,SEEK_SET)!=0 || (ck=malloc(sizeof(CHUNK)))==NULL)
		return NULL;
	ck->num=1;
	if ((ck->list=calloc(ck->num,sizeof(struct chunklist)))==NULL) {
		free(ck);
		return NULL;
	}
	ck->list[ck->num-1].size=size-(long)sizeof(DWORD)-(long)sizeof(FOURCC);
	return ck;
}


/*	󥯹¤Τ
	RET,0:,-1:顼													*/
int chunkfree(CHUNK *ck)
{
	free(ck->list);
	free(ck);
	return 0;
}


/*	󥯤
	 fp,եݥ
	 ck,󥯹¤
	RET,0:,-1:顼													*/
int chunkin(FILE *fp,CHUNK *ck)
{
	if (ck->num>1 && ck->list[ck->num-1].id!=make4cc('R','I','F','F')
						&& ck->list[ck->num-1].id!=make4cc('L','I','S','T'))
		return -1;
	if ((ck->list=realloc(ck->list,
								(ck->num+1)*sizeof(struct chunklist)))==NULL) {
		ck->num=0;
		return -1;
	}
	if ((ck->list[ck->num].offset=ftell(fp))==-1
			|| fread(&ck->list[ck->num].id,sizeof(FOURCC),1,fp)!=1
			|| fdword(&ck->list[ck->num].size,fp)!=0
			|| ((ck->list[ck->num].id==make4cc('R','I','F','F')
					|| ck->list[ck->num].id==make4cc('L','I','S','T'))
				&& fread(&ck->list[ck->num].form,sizeof(FOURCC),1,fp)!=1)) {
		fseek(fp,ck->list[ck->num].offset,SEEK_SET);
		return -1;
	}
	ck->num++;
	return 0;
}


/*	󥯤Ф
	 fp,եݥ
	 ck,󥯹¤
	RET,0:,-1:顼													*/
int chunkout(FILE *fp,CHUNK *ck)
{
	if (ck->num<=1)
		return -1;
	ck->num--;
	if (fseek(fp,ck->list[ck->num].offset,SEEK_SET)!=0)
		return -1;
	if ((ck->list=realloc(ck->list,ck->num*sizeof(struct chunklist)))==NULL) {
		ck->num=0;
		return -1;
	}
	return 0;
}


/*	Υ󥯤˰ư
	 fp,եݥ
	 ck,󥯹¤
	RET,0:,-1:顼													*/
int chunknext(FILE *fp,CHUNK *ck)
{
	DWORD size;
	long offset;

	if ((offset=ftell(fp))==-1)
		return -1;
	if (fseek(fp,sizeof(FOURCC),SEEK_CUR)!=0 || fdword(&size,fp)!=0) {
		fseek(fp,offset,SEEK_SET);
		return -1;
	}
	size=(size+1)&~1;
	if (ck->list[ck->num-1].offset+ck->list[ck->num-1].size<=offset+size
											|| fseek(fp,size,SEEK_CUR)!=0) {
		fseek(fp,offset,SEEK_SET);
		return -1;
	}
	return 0;
}


/*	󥯤ID
	 fp,եݥ
	RET,ID																	*/
FOURCC chunkid(FILE *fp)
{
	FOURCC id;

	return fread(&id,sizeof(FOURCC),1,fp)==1
				&& fseek(fp,-(long)sizeof(FOURCC),SEEK_CUR)==0?id:(FOURCC)-1;
}


/*	󥯤Υ
	 fp,եݥ
	RET,ե															*/
DWORD chunksize(FILE *fp)
{
	DWORD size;

	return fseek(fp,sizeof(FOURCC),SEEK_CUR)==0 && fdword(&size,fp)==0
			&& fseek(fp,-(long)sizeof(DWORD)-(long)sizeof(FOURCC),SEEK_CUR)==0
															?size:(DWORD)-1;
}


/*	󥯤Υե
	 fp,եݥ
	RET,ե															*/
FOURCC chunkform(FILE *fp)
{
	FOURCC id,form;

	return fread(&id,sizeof(FOURCC),1,fp)==1
		&& fseek(fp,sizeof(DWORD),SEEK_CUR)==0
		&& fread(&form,sizeof(FOURCC),1,fp)==1
		&& fseek(fp,-(long)sizeof(DWORD)-(long)sizeof(FOURCC)*2,SEEK_CUR)==0
		&& (id==make4cc('R','I','F','F') || id==make4cc('L','I','S','T'))
															?form:(FOURCC)-1;
}
