#include <stdio.h>
#include <stdlib.h>
#include "chunk.h"


#define HEADER_TYPE_VALUE 0
#define HEADER_TYPE_HEX 1
#define HEADER_TYPE_FOURCC 2


typedef	struct {
	int mode;	/*  */
	int size;	/*  */
	char *name;	/* ̾ */
} HEADERS;


/*	إåɽ
	   fp,եݥ
	 head,إå
	space,ڤο															*/
static void
printavi (FILE *fp, HEADERS *head, int space)
{
	int i, j, c, value;

	for (i = 0; head[i].size > 0; i++)
	  {
		for (j = 0; j < space; j++)
			printf ("    ");
		value = 0;
		for (j = 0; j < head[i].size; j++)
			value += fgetc (fp) << (j * 8);
		printf ("             %s : ", head[i].name);
		switch (head[i].mode)
		  {
			case HEADER_TYPE_VALUE:
				printf ("%d\n", value);
				break;
			case HEADER_TYPE_HEX:
				printf ("%Xh\n", value);
				break;
			case HEADER_TYPE_FOURCC:
				printf ("%Xh", value);
				for (j = 0; j < 4; j++)
				  {
					c = (value >> (j * 8)) & 0xff;
					if (c < '\x20' || '\x7e' < c)
						break;
				  }
				if (j == 4)
				  {
					printf (" \'");
					for (j = 0; j < 4; j++)
						putchar ((value >> (j * 8)) & 0xff);
					putchar ('\'');
				  }
				printf ("\n");
		  }
	  }
}


/*	AVIRIFFեĥ꡼ɽ
	   fp,եݥ
	   ck,󥯥ݥ
	space,ڤο
	  RET,0:,-1:顼													*/
static int
chunkavi (FILE *fp, CHUNK *ck, int space)
{
	int i;
	DWORD size;
	FOURCC id, form;
	static type = 0;
	HEADERS avimain[] = {
		{HEADER_TYPE_VALUE,  4, "Micro Sec Per Frame"},
		{HEADER_TYPE_VALUE,  4, "Max Byte Per Sec"},
		{HEADER_TYPE_VALUE,  4, "Padding Granularity"},
		{HEADER_TYPE_HEX,    4, "Flags"},
		{HEADER_TYPE_VALUE,  4, "Total Frames"},
		{HEADER_TYPE_VALUE,  4, "Initial Frames"},
		{HEADER_TYPE_VALUE,  4, "Streams"},
		{HEADER_TYPE_VALUE,  4, "Suggested Buffer Size"},
		{HEADER_TYPE_VALUE,  4, "Width"},
		{HEADER_TYPE_VALUE,  4, "Height"},
		{0, 0, NULL}
	};
	HEADERS avistream[] = {
		{HEADER_TYPE_FOURCC, 4, "Type"},
		{HEADER_TYPE_FOURCC, 4, "Handler"},
		{HEADER_TYPE_HEX,    4, "Flags"},
		{HEADER_TYPE_VALUE,  2, "Priority"},
		{HEADER_TYPE_VALUE,  2, "Language"},
		{HEADER_TYPE_VALUE,  4, "Initial Frames"},
		{HEADER_TYPE_VALUE,  4, "Scale"},
		{HEADER_TYPE_VALUE,  4, "Rate"},
		{HEADER_TYPE_VALUE,  4, "Start"},
		{HEADER_TYPE_VALUE,  4, "Length"},
		{HEADER_TYPE_VALUE,  4, "Suggested Buffer Size"},
		{HEADER_TYPE_VALUE,  4, "Quality"},
		{HEADER_TYPE_VALUE,  4, "Sample Size"},
		{HEADER_TYPE_VALUE,  2, "Frame Left"},
		{HEADER_TYPE_VALUE,  2, "Frame Top"},
		{HEADER_TYPE_VALUE,  2, "Frame Right"},
		{HEADER_TYPE_VALUE,  2, "Frame Bottom"},
		{0, 0, NULL}
	};
	HEADERS bitmap[] = {
		{HEADER_TYPE_VALUE,  4, "Size"},
		{HEADER_TYPE_VALUE,  4, "Width"},
		{HEADER_TYPE_VALUE,  4, "Height"},
		{HEADER_TYPE_VALUE,  2, "Planes"},
		{HEADER_TYPE_VALUE,  2, "Bit Count"},
		{HEADER_TYPE_FOURCC, 4, "Compression"},
		{HEADER_TYPE_VALUE,  4, "Size Image"},
		{HEADER_TYPE_VALUE,  4, "X Pels Per Meter"},
		{HEADER_TYPE_VALUE,  4, "Y Pels Per Meter"},
		{HEADER_TYPE_VALUE,  4, "Color Used"},
		{HEADER_TYPE_VALUE,  4, "Color Important"},
		{0, 0, NULL}
	};
	HEADERS wave[] = {
		{HEADER_TYPE_HEX,    2, "Format Tag"},
		{HEADER_TYPE_VALUE,  2, "Channels"},
		{HEADER_TYPE_VALUE,  4, "Samples Per Sec"},
		{HEADER_TYPE_VALUE,  4, "Avg Bytes Per Sec"},
		{HEADER_TYPE_VALUE,  2, "Block Align"},
		{HEADER_TYPE_VALUE,  2, "Bits Per Sample"},
		{0, 0, NULL}
	};
	HEADERS wavex[] = {
		{HEADER_TYPE_HEX,    2, "Format Tag"},
		{HEADER_TYPE_VALUE,  2, "Channels"},
		{HEADER_TYPE_VALUE,  4, "Samples Per Sec"},
		{HEADER_TYPE_VALUE,  4, "Avg Bytes Per Sec"},
		{HEADER_TYPE_VALUE,  2, "Block Align"},
		{HEADER_TYPE_VALUE,  2, "Bits Per Sample"},
		{HEADER_TYPE_VALUE,  2, "Size"},
		{0, 0, NULL}
	};

	do
	  {
		if ((id = chunkid (fp)) == (FOURCC)-1
									|| (size = chunksize (fp)) == (DWORD)-1)
			return -1;
		printf ("%08lX ", ftell (fp));
		for (i = 0; i < space; i++)
			printf ("    ");
		printf ("%c%c%c%c (%08lX)", getidcc (id, 1), getidcc (id, 2),
									getidcc (id, 3), getidcc (id, 4), size);
		if (id == make4cc ('R', 'I', 'F', 'F')
										|| id == make4cc ('L', 'I', 'S', 'T'))
		  {
			if ((form = chunkform (fp)) == (FOURCC)-1)
				return -1;
			printf (" \'%c%c%c%c\'\n", getidcc (form, 1), getidcc (form, 2),
										getidcc (form, 3), getidcc (form, 4));
			if (form != make4cc ('m', 'o', 'v', 'i')
										&& (chunkin (fp, ck) != 0
										|| chunkavi (fp, ck, space + 1) != 0
													|| chunkout (fp, ck) != 0))
				return -1;
		  }
		else
		  {
			putchar ('\n');
		  }
		/* ܺɽ */
		if (chunkin (fp, ck) != 0)
			return -1;
		if (id == make4cc ('a', 'v', 'i', 'h'))
		  {
			printavi (fp, avimain, space);
		  }
		else if (id == make4cc ('s', 't', 'r', 'h'))
		  {
			if (fread (&type, sizeof(FOURCC), 1, fp) != 1
								|| fseek (fp, -sizeof(FOURCC), SEEK_CUR) != 0)
				return -1;
			printavi (fp, avistream, space);
		  }
		else if (id == make4cc ('s', 't', 'r', 'f'))
		  {
			if (type == make4cc ('v', 'i', 'd', 's'))
				printavi (fp, bitmap, space);
			else if (type == make4cc ('a', 'u', 'd', 's'))
				printavi (fp, size <= 16 ? wave : wavex, space);
		  }
		else if (id == make4cc ('f', 'm', 't', ' '))
			printavi (fp, size <= 16 ? wave : wavex, space);
		if (chunkout (fp, ck) != 0)
			return -1;
	  }
	while (chunknext (fp, ck) == 0);
	return 0;
}


/*	RIFFեĥ꡼ɽ
	   fp,եݥ
	   ck,󥯥ݥ
	space,ڤο
	  RET,0:,-1:顼													*/
static int chunktree(FILE *fp,CHUNK *ck,int space)
{
	int i;
	DWORD size;
	FOURCC id,form;

	do {
		if ((id=chunkid(fp))==(FOURCC)-1 || (size=chunksize(fp))==(DWORD)-1)
			return -1;
		printf("%08lX ",ftell(fp));
		for (i=0;i<space;i++)
			printf("    ");
		printf("%c%c%c%c (%08lX)",
				getidcc(id,1),getidcc(id,2),getidcc(id,3),getidcc(id,4),size);
		if (id==make4cc('R','I','F','F') || id==make4cc('L','I','S','T')) {
			if ((form=chunkform(fp))==(FOURCC)-1)
				return -1;
			printf(" \'%c%c%c%c\'\n",getidcc(form,1),getidcc(form,2),
											getidcc(form,3),getidcc(form,4));
			if (chunkin(fp,ck)!=0
						|| chunktree(fp,ck,space+1)!=0 || chunkout(fp,ck)!=0)
				return -1;
		} else {
			putchar('\n');
		}
	} while (chunknext(fp,ck)==0);
	return 0;
}


int main(int argc,char *argv[])
{
	int i;			/* 롼ץ */
	int mode = 0;	/* 0:AVIɽ,1:ɸɽ */
	int s=0;		/* argvΥե̾ */
	CHUNK *ck;		/* 󥯥ݥ */
	FILE *fp;		/* եݥ */

	for (i=1;i<argc;i++)
		if ((argv[i])[0] != '-')
			s++;
		else if (tolower ((argv[i])[1]) != 's' || (argv[i])[2] != '\0')
		  {
			s = 0;
			break;
		  }
		else
		  {
			mode = 1;
		  }
	if (s <= 0)
	  {
		/* ˥ե̾ʤȤ */
		printf(	"Copyright (C) 1999-2003 Kazuki IWAMOTO\n"
				"\n"
				"Usage: %s [OPTION...] <rifffile...>\n"
				"\n"
				"  -s  standard dump\n"
				"\n", argv[0]);
		return 0;
	  }

	for (i = 1; i < argc; i++)
		if ((argv[i])[0] != '-')
		  {
			/* ե򳫤 */
			if ((fp=fopen(argv[i],"rb"))==NULL) {
				printf("%s can not open.\n",argv[s]);
				return -1;
			}
			/* եݥ󥿤󥯥ݥ󥿤 */
			if ((ck=chunkopen(fp))==NULL) {
				printf("chunk open error.\n");
				return -1;
			}
			/* 󥯤ɽ */
			if ((mode == 0 ? chunkavi (fp, ck, 0)
												: chunktree (fp, ck, 0)) != 0)
			  {
				printf("chunk error.\n");
				return -1;
			  }
			/* 󥯥ݥ󥿤 */
			if (chunkfree(ck)!=0)
			  {
				printf("chunk free error.\n");
				return -1;
			  }
		  }
	return 0;
}
