/*
    memapi
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __MEMAPI_H__
#define __MEMAPI_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:֐Q                                                             *
*                                                                             *
******************************************************************************/
/*  ja:̓eRs[
    lpvDest,Rs[
     lpvSrc,Rs[
     uBytes,oCg                                                        */
#define MemoryCopy(lpvDest,lpvSrc,uBytes) MoveMemory(lpvDest,lpvSrc,uBytes)


/*  ja:̓eݒ肷
    lpvDest,ݒ
     nValue,l
     uBytes,oCg                                                        */
#define MemorySet(lpvDest,nValue,uBytes) FillMemory(lpvDest,uBytes,nValue)


/*  ja:̓er
    lpvBuf1,obt@1
    lpvBuf2,obt@2
     uBytes,oCg
        RET,:lpvBuf1,:lpvBuf2,0:                    */
INT WINAPI
MemoryCompare (LPCVOID lpvBuf1,
               LPCVOID lpvBuf2,
               UINT    uBytes);


/*  ja:mۂ
    uBytes,TCY
       RET,mۂ,NULL:G[                                       */
#define MemoryAlloc(uBytes)                                                 \
        ((uBytes)>0?HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,uBytes):NULL)


/*  ja:
    lpMemory,mۂ
         RET,TRUE:I,FALSE:G[                                     */
#define MemoryFree(lpMemory)                                                \
                        (!(lpMemory)||HeapFree(GetProcessHeap(),0,lpMemory))


/*  ja:̃TCYύX
    lpMemory,mۂ
      uBytes,TCY
         RET,mۂ,NULL:G[                                     */
#define MemoryReAlloc(lpMemory,uBytes)                                      \
            ((uBytes)>0?!(lpMemory)?MemoryAlloc(uBytes)                     \
            :HeapReAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,lpMemory,uBytes) \
            :(MemoryFree(lpMemory),NULL))


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MEMAPI_H__ */
