/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __GSHOT_H__
#define __GSHOT_H__


#include "fndir.h"
#include <windows.h>
#include <vfw.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define APPLICATION _T("GtkShot")
#define MAX_RATE 8              /* ja:[g̗ۑ */


#include <pshpack1.h>
typedef struct _GSRINDEX
{
  UINT64 uiOffset;
  DWORD dwSize;
  DWORD dwFlags;
} GSRINDEX, *LPGSRINDEX;
#include <poppack.h>
typedef struct _FILELIST
{
  DWORD dwIndex;                /* ja:CfbNX̐(GSRł̓TEh̐) */
  HANDLE hFile;                 /* ja:t@Cnh */
  TCHAR szFile[MAXPATH];        /* ja:t@C */
  UINT64 uiBytes;               /* ja:őTCY */
  UINT64 uiOffset;              /* ja:ItZbg */
/* ja: */
  DWORD dwOffset;               /* ja:obt@̃ItZbg */
  DWORD dwData, dwMemory;       /* ja:Kσ̃TCY,̃TCY */
  LPBYTE lpbData, lpbMemory;    /* ja:KσAhX,̃AhX */
/* ja:L */
  DWORD dwBase;                 /* ja:1ZN^̃oCg */
  DWORD dwVideo;                /* ja:Xg[̃Tv */
  DWORD dwWave;                 /* ja:Xg[̃Tv */
/* ja:AVIŗL */
  AVIINDEXENTRY *lpAviIdx;      /* ja:CfbNX */
/* ja:GtkShot RawŗL */
  LPGSRINDEX lpGsrIdxV, lpGsrIdxW;/* ja:CfbNX */
} FILELIST, *LPFILELIST;
typedef struct _PROPERTY
{
  BOOL fAudio;                  /* ja:TRUE:^,FALSE:^Ȃ */
  DWORD dwRate;                 /* ja:^惌[g(1bԂ̃t[~1000) */
  UINT uFormat;                 /* ja:0:AVI,1:AVI,2:GtkShot Raw */
  LPWAVEFORMATEX lpWfx;         /* ja:WAVEFORMATEX\ */
  FOURCC fccHandler;            /* ja:rfI֌W̕ϐ */
  LPBITMAPINFO lpBmiOut;        /* ja:k̃tH[}bg */
  LONG lKey, lDataRate, lQ, cbState;
  LPVOID lpState;
} PROPERTY, *LPPROPERTY;
typedef struct _RECORD
{
  DWORD dwWeeks;                /* ja:j,ŉ:j */
  int nDay, nHour, nMinute, nSecond;/* ja:,,,b */
  UINT uTimeLimit, uAlloc;      /* ^掞,^Ö̗m */
  PROPERTY stProp;              /* ja:vpeB */
  int nFileList;                /* ja:t@C̃Xg̐ */
  LPFILELIST lpFileList;        /* ja:t@CXg */
  BOOL fAlloc;                  /* ja:^掞,^Ö̗m */
  BOOL fDone;                   /* ja:TRUE:^sO,FALSE:^s */
} RECORD, *LPRECORD;
typedef struct _VSCAPTURE
{
  int nList, nFileList;         /* ja:Xg̈ʒu,Xg̑ */
  LPFILELIST lpFileList;        /* ja:Xg */
  COMPVARS cv;
  DWORD dwDrop;                 /* ja:t[ */
  DWORD dwFrame;                /* ja:Lv`t[ */
  LPBITMAPINFO lpBmiIn;         /* ja:Lv`̃tH[}bg */
  LPBITMAPINFO lpBmiOut;        /* ja:ۂɃt@CɏtH[}bg */
  LPPROPERTY lpProp;            /* ja:vpeB */
  int nImgByte;                 /* ja:kɓWJobt@̃TCY */
  LPVOID lpBits;                /* ja:kɓWJobt@ */
} VSCAPTURE,*LPVSCAPTURE;


/* ja:VXeϐ */
extern int nRegStat;            /* ja:WXg,0:Read,1:Write,2:Create */
extern BOOL fControl;           /* ja:TRUE:Lv`p,FALSE:f */
extern BOOL fDebug;             /* ja:TRUE:fobN[h,FALSE:ʏ */
extern BOOL fLayout;            /* ja:TRUE:TCYύXK,FALSE:ύX\ */
extern BOOL fSort[2];           /* ja:\[g̏(t@C/TCY) */
extern DWORD dwMaxSizeFormat;   /* ja:WAVEFORMATEX\̂̃TCY */
extern HBRUSH hBrush;           /* ja:wĩuV */
extern LPWAVEFORMATEX lpWfx;    /* ja:WAVEFORMATEX\ */
extern LPTSTR lpszFormat[4];    /* ja:tH[}bg */
extern SIZE siMainWnd;          /* ja:CEChẼTCY */
extern TCHAR szFrameFormat[128];
extern int nDays[13];
extern WAVEFORMATEX stWfx;
extern PROPERTY stProperty;


/* ja:R[obN */
extern LPTSTR lpszWarning;      /* ja:Lv`̒vIł͂ȂG[ */
extern VSCAPTURE stVsCap;


/* ja:ݒ */
extern int nDeviceID;           /* ja:foCX */
extern int nFileList;           /* ja:t@C̃Xg̐ */
extern int nRecordList;         /* ja:\̃Xg̐ */
extern LPFILELIST lpFileList;   /* ja:t@CXg */
extern LPRECORD lpRecordList;   /* ja:\񃊃Xg */
extern BOOL fColor;             /* ja:TRUE:VXeF,FALSE:wwiF */
extern BOOL fJust;              /* ja:TRUE:cێȂ,FALSE:ێ */
extern BOOL fMakeUserHitOKToCapture;/* ja:TRUE:mF,FALSE:mFȂ */
extern BOOL fNumFrame;          /* ja:TRUE:Aԕۑ,FALSE: */
extern BOOL fPreview;           /* ja:TRUE:vr[,FALSE:vr[Ȃ */
extern BOOL fOverlay;           /* ja:TRUE:I[o[C,FALSE:Ȃ */
extern BOOL fOverWrite;         /* ja:TRUE:㏑mF,FALSE:㏑ */
extern BOOL fRate;              /* ja:TRUE:TEhɓ,FALSE:ƎvZ */
extern BOOL fRecycle;           /* ja:TRUE:ݔ𗘗p,FALSE:pȂ */
extern BOOL fScale;             /* ja:TRUE:XP[O,FALSE:Ȃ */
extern BOOL fTimer;             /* ja:TRUE:^C}L,FALSE:^C} */
extern BOOL fTopMost;           /* ja:TRUE:ɎOɕ\,FALSE:ʏ */
extern COLORREF crColor;        /* ja:wwiF */
extern DWORD dwHistory[MAX_RATE];/* ja:[g(1bԂ̃t[~1000)̗ */
extern DWORD dwPreviewRate;     /* ja:vr[[g(vZ͏LƓ) */
extern DWORD dwSaveFilter;      /* ja:t@Cۑ鎞̃tB^ */
extern TCHAR szCaptureFile[MAXPATH];/* ja:ۑt@C(AVI) */
extern TCHAR szFrameFile[MAXPATH];/* ja:ۑt@C(BMP) */
extern UINT uFrame;             /* ja:AԐl */
extern UINT64 uiMaxBytes;       /* ja:TCY */


/* ja:Lv`֌W̐ݒ */
extern CAPDRIVERCAPS cdrive;
extern CAPSTATUS cstat;
extern CAPTUREPARMS cparam;


extern HINSTANCE hInst;         /* ja:CX^Xnh */
extern HWND hWndMain;           /* ja:CEChE */
extern HWND hWndCap;            /* ja:Lv`EChE */
extern HWND hWndTool;           /* ja:CEChẼc[o[ */
extern HWND hWndStat;           /* ja:CEChẼXe[^Xo[ */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GSHOT_H__ */
