/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "bmmacro.h"
#include "dialog.h"
#include "gshot.h"
#include "memapi.h"
#include "prop.h"
#include "resource.h"
#include "valstr.h"
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
PropDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  static LPPROPERTY lpProp;
  static FOURCC fccHandler;
  static LONG lKey, lDataRate, lQ, cbState;
  static LPVOID lpState;
  static LPBITMAPINFO lpBmiOut;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int  i, j;
          DWORD dwTemp[MAX_RATE];
          TCHAR szText[128];

          lpProp = (LPPROPERTY)lParam;
          MemoryCopy (lpWfx, lpProp->lpWfx, dwMaxSizeFormat);
          cbState = 0;
          lpState = NULL;
          lpBmiOut = NULL;
          if (lpProp->cbState > 0)
            {
              lpState = MemoryAlloc (lpProp->cbState);
              if (!lpState)
                {
                  MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  MemoryFree (lpState);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              MemoryCopy (lpState, lpProp->lpState, lpProp->cbState);
            }
          if (lpProp->lpBmiOut)
            {
              int  nLength;

              nLength = bmHdrByte ((LPBITMAPINFOHEADER)lpProp->lpBmiOut);
              lpBmiOut = MemoryAlloc (nLength);
              if (!lpBmiOut)
                {
                  MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              MemoryCopy (lpBmiOut, lpProp->lpBmiOut, nLength);
            }
          fccHandler = lpProp->fccHandler;
          lKey = lpProp->lKey;
          lDataRate = lpProp->lDataRate;
          lQ = lpProp->lQ;
          cbState = lpProp->cbState;
          /* ja:`FbN{bNX̐ݒ */
          if (!CheckDlgButton (hDlg, IDC_CHECKBOX31,
                                lpProp->fAudio ? BST_CHECKED : BST_UNCHECKED))
            {
              MessageBox (hDlg, _T("CheckDlgButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:R{{bNX̐ݒ */
          for (i = 0; i < (fDebug ? 4 : 3); i++)
            if (SendDlgItemMessage (hDlg, IDC_COMBOBOX31, CB_ADDSTRING,
                                                0, (LPARAM)lpszFormat[i]) < 0)
              {
                MessageBox (hDlg, _T("CB_ADDSTRING"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return TRUE;
              }
          if (SendDlgItemMessage (hDlg, IDC_COMBOBOX31, CB_SETCURSEL,
                                                lpProp->uFormat, 0) == CB_ERR)
            {
              MessageBox (hDlg, _T("CB_SETCURSEL"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:R{{bNX̐ݒ */
          MemoryCopy (dwTemp, dwHistory, MAX_RATE * sizeof (DWORD));
          for (i = 0; i < MAX_RATE - 1; i++)
            for (j = i + 1; j < MAX_RATE; j++)
              if (dwTemp[j] < dwTemp[i])
                {
                  DWORD dwDmy;

                  dwDmy = dwTemp[j];
                  dwTemp[j] = dwTemp[i];
                  dwTemp[i] = dwDmy;
                }
          SendDlgItemMessage (hDlg, IDC_COMBOBOX32, CB_LIMITTEXT, 12, 0);
          for (i = 0; i < MAX_RATE; i++)
            if (dwTemp[i] != 0)
              {
                FloatStr (dwTemp[i], 1000, szText);
                if (SendDlgItemMessage (hDlg, IDC_COMBOBOX32, CB_ADDSTRING,
                                                        0, (LPARAM)szText) < 0)
                  {
                    MessageBox (hDlg, _T("CB_ADDSTRING"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
          FloatStr (lpProp->dwRate, 1000, szText);
          if (!SetDlgItemText (hDlg, IDC_COMBOBOX32, szText))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Rg[̕\ */
          if (!EnableDlgItem (hDlg, IDC_CHECKBOX31, cstat.fAudioHardware)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTON32,
                                    cstat.fAudioHardware && lpProp->fAudio))
            {
              MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int i, nRate, nScale;
                TCHAR szText[128];

                lpProp->fAudio
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX31) == BST_CHECKED;
                lpProp->uFormat = SendDlgItemMessage (hDlg, IDC_COMBOBOX31,
                                                        CB_GETCURSEL, 0, 0);
                /* ja:[g */
                GetDlgItemText (hDlg, IDC_COMBOBOX32, szText, 128);
                StrFloat (&nRate, &nScale, szText);
                lpProp->dwRate = MulDiv (nRate, 1000, nScale);
                /* ja:rfI */
                MemoryFree (lpProp->lpState);
                MemoryFree (lpProp->lpBmiOut);
                lpProp->fccHandler = fccHandler;
                lpProp->lKey = lKey;
                lpProp->lDataRate = lDataRate;
                lpProp->lQ = lQ;
                lpProp->cbState = cbState;
                lpProp->lpState = lpState;
                lpProp->lpBmiOut = lpBmiOut;
                /* ja:TEh */
                MemoryCopy (lpProp->lpWfx, lpWfx, dwMaxSizeFormat);
                /* ja:[g̗ */
                for (i = 0; i < MAX_RATE - 1; i++)
                  if (dwHistory[i] == lpProp->dwRate)
                    break;
                MemoryCopy (dwHistory + 1, dwHistory, i * sizeof (DWORD));
                dwHistory[0] = lpProp->dwRate;
              }
            case IDCANCEL:
              if (LOWORD (wParam) == IDCANCEL)
                {
                  MemoryFree (lpState);
                  MemoryFree (lpBmiOut);
                }
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_COMBOBOX31:
            case IDC_COMBOBOX32:
              if (HIWORD (wParam) != CBN_EDITCHANGE
                                        && HIWORD (wParam) != CBN_SELCHANGE)
                return TRUE;
              goto loop;
            case IDC_PUSHBUTTON31:
              {

                if (SendDlgItemMessage (hDlg, IDC_COMBOBOX31,
                                                    CB_GETCURSEL, 0, 0) == 0)
                  {
                    /* ja:AVI */
                    if (!capDlgVideoCompression (hWndCap))
                      return TRUE;
                  }
                else
                  {
                    BOOL fResult;
                    COMPVARS cv;
                    DWORD dwVideo;
                    LPBITMAPINFO lpBmiIn;   /* ja:Lv`̃tH[}bg */

                    /* en:AVI,GSR */
                    MemorySet (&cv, 0, sizeof (COMPVARS));
                    cv.cbSize = sizeof (COMPVARS);
                    cv.dwFlags = ICMF_COMPVARS_VALID;
                    cv.fccHandler = fccHandler;
                    cv.lKey = lKey;
                    cv.lDataRate = lDataRate;
                    cv.lQ = lQ;
                    cv.lpState = lpState;
                    cv.cbState = cbState;
                    /* ja:wb^擾 */
                    dwVideo = capGetVideoFormatSize (hWndCap);
                    if (dwVideo == 0)
                      {
                        MessageBox (hDlg, _T("capGetVideoFormatSize"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    lpBmiIn = MemoryAlloc (dwVideo);
                    if (!lpBmiIn)
                      {
                        MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    if (capGetVideoFormat (hWndCap, lpBmiIn, dwVideo) == 0)
                      {
                        MessageBox (hDlg, _T("capGetVideoFormat"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        MemoryFree (lpBmiIn);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    if (fccHandler == 0
                        && (lpBmiIn->bmiHeader.biCompression == BI_RGB
                        || lpBmiIn->bmiHeader.biCompression == BI_BITFIELDS))
                        cv.fccHandler = comptypeDIB;
                    fResult = ICCompressorChoose (hDlg, ICMF_CHOOSE_KEYFRAME,
                                                    lpBmiIn, NULL, &cv, NULL);
                    if (fResult)
                      {
                        MemoryFree (lpState);
                        MemoryFree (lpBmiOut);
                        cbState = 0;
                        lpState = NULL;
                        lpBmiOut = NULL;
                        if (cv.cbState > 0)
                          {
                            lpState = MemoryAlloc (cv.cbState);
                            if (!lpState)
                              {
                                MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                                EndDialog (hDlg, IDCANCEL);
                                return TRUE;
                              }
                            MemoryCopy (lpState, cv.lpState, cv.cbState);
                          }
                        if (cv.lpbiOut)
                          {
                            int nLength;

                            nLength
                                = bmHdrByte ((LPBITMAPINFOHEADER)cv.lpbiOut);
                            lpBmiOut = MemoryAlloc (nLength);
                            if (!lpBmiOut)
                              {
                                MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                                MemoryFree (lpState);
                                EndDialog (hDlg, IDCANCEL);
                                return TRUE;
                              }
                            MemoryCopy (lpBmiOut,cv. lpbiOut, nLength);
                          }
                        fccHandler = cv.fccHandler;
                        if (fccHandler == comptypeDIB
                          && (lpBmiIn->bmiHeader.biCompression == BI_RGB
                          || lpBmiIn->bmiHeader.biCompression == BI_BITFIELDS))
                          fccHandler = 0;
                        lKey = cv.lKey;
                        lDataRate = cv.lDataRate;
                        lQ = cv.lQ;
                        cbState = cv.cbState;
                      }
                    ICCompressorFree (&cv);
                    MemoryFree (lpBmiIn);
                    if (!fResult)
                      return TRUE;
                  }
              }
              goto loop;
            case IDC_PUSHBUTTON32:
              {
                ACMFORMATCHOOSE afc;

                MemorySet (&afc, 0, sizeof (ACMFORMATCHOOSE));
                afc.cbStruct = sizeof (ACMFORMATCHOOSE);
                afc.fdwStyle = ACMFORMATCHOOSE_STYLEF_INITTOWFXSTRUCT;
                afc.hwndOwner = hDlg;
                afc.pwfx = lpWfx;
                afc.cbwfx = dwMaxSizeFormat;
                afc.fdwEnum = ACM_FORMATENUMF_INPUT;
                if (acmFormatChoose (&afc) != MMSYSERR_NOERROR)
                  return TRUE;
              }
            case IDC_CHECKBOX31:
            loop:
              {
                int nRate, nScale;
                BOOL fResult;
                TCHAR szText[128];

                GetDlgItemText (hDlg, IDC_COMBOBOX32, szText, 128);
                fResult = StrFloat (&nRate, &nScale, szText);
                if (!EnableDlgItem (hDlg, IDOK,
                                            fResult && nRate > 0 && nScale > 0)
                    || !EnableDlgItem (hDlg, IDC_PUSHBUTTON32,
                            cstat.fAudioHardware && IsDlgButtonChecked (hDlg,
                                            IDC_CHECKBOX31) == BST_CHECKED))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}
