/*
    avicore
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "avibase.h"


/******************************************************************************
*                                                                             *
* ja:AVIメモリ関数                                                            *
*                                                                             *
******************************************************************************/
/*  ja:AVIメモリを確保する
    length,確保するバイト数
       RET,AVIメモリ,NULL:エラー                                            */
AviMemory *
avi_memory_malloc (const gsize length)
{
  AviMemory *avi_memory;

  avi_memory = g_malloc (length);
  avi_memory->counter = 1;
  avi_memory->length = length;
  avi_memory->data = g_malloc0 (length);
  return avi_memory;
}


/*  ja:AVIメモリを再確保する
    avi_memory,AVIメモリ
        length,確保するバイト数
           RET,AVIメモリ,NULL:エラー                                        */
AviMemory *
avi_memory_realloc (AviMemory   *avi_memory,
                    const gsize  length)
{
  if (!avi_memory)
    return avi_memory_malloc (length);
  avi_memory->length = length;
  avi_memory->data = g_realloc (avi_memory->data, length);
  return avi_memory;
}


/*  ja:AVIメモリを複製する
      data,複製するメモリ
    length,複製るバイト数
       RET,AVIメモリ,NULL:エラー                                            */
AviMemory *
avi_memory_dup (gconstpointer data,
                const gsize   length)
{
  AviMemory *avi_memory;

  avi_memory = g_malloc (length);
  avi_memory->counter = 1;
  avi_memory->length = length;
  avi_memory->data = g_memdup (data, length);
  return avi_memory;
}


/*  ja:AVIメモリの参照数を増やす
    avi_memory,AVIメモリ
           RET,TRUE:正常終了,FALSE:エラー                                   */
gboolean
avi_memory_ref (AviMemory *avi_memory)
{
  return avi_memory ? avi_memory->counter++, TRUE : FALSE;
}


/*  ja:AVIメモリの参照数を減らす
    avi_memory,AVIメモリ
           RET,TRUE:正常終了,FALSE:エラー                                   */
gboolean
avi_memory_unref (AviMemory *avi_memory)
{
  if (!avi_memory)
    return FALSE;
  avi_memory->counter--;
  if (avi_memory->counter <= 0)
    {
      g_free (avi_memory->data);
      g_free (avi_memory);
    }
  return TRUE;
}
