/*
    dialog
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __DIALOG_H__
#define __DIALOG_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
typedef struct _DLGITEMPOSITION
{
  int nID;
  BOOL fLeft, fTop, fRight, fBottom; /* ja:TRUE:͌Œ,FALSE:͉ */
  int nLeft, nTop, nRight, nBottom;  /* ja:EChẺƂ̋ */
  int nWidth, nHeight;               /* ja:Rg[̃TCY */
} DLGITEMPOSITION, *LPDLGITEMPOSITION;


/*  ja:_CAO{bNX̃Rg[̕\Ԃݒ肷
        hDlg,_CAO{bNX
         nID,Rg[ID
    nCmdShow,\@
         RET,TRUE:I,FALSE:G[                                     */
BOOL WINAPI
ShowDlgItem (HWND hDlg,
             int  nID,
             int  nCmdShow);


/*  ja:_CAO{bNX̃Rg[L܂͖
       hDlg,_CAO{bNX
        nID,Rg[ID
    fEnable,TRUE:L,FALSE:
        RET,TRUE:I,FALSE:G[                                      */
BOOL WINAPI
EnableDlgItem (HWND hDlg,
               int  nID,
               BOOL fEnable);


/*  ja:_CAO{bNX̃Rg[̈ʒu
            hDlg,_CAO{bNX
    lpDlgItemPos,_CAO
          nCount,Rg[̐
             RET,TRUE:I,FALSE:G[                                 */
BOOL WINAPI
InitDlgItemPosition (HWND              hDlg,
                     LPDLGITEMPOSITION lpDlgItemPos,
                     int               nCount);


/*  ja:_CAO{bNX̃Rg[̈ʒuݒ肷
            hDlg,_CAO{bNX
    lpDlgItemPos,_CAO
          nCount,Rg[̐
             RET,TRUE:I,FALSE:G[                                 */
BOOL WINAPI
SetDlgItemPosition (HWND              hDlg,
                    LPDLGITEMPOSITION lpDlgItemPos,
                    int               nCount);


/*  ja:[hX_CAO{bNX쐬
       hInstance,W[̃nh
      lpTemplate,_CAO{bNXev[g̖O
      hWndParent,I[i[EBhẼnh
    lpDialogFunc,_CAO{bNXvV[W
             RET,_CAO{bNX̃nh                               */
#define CreateDialogGUI(hInstance,lpTemplate,hWndParent,lpDialogFunc)       \
        CreateDialogParamGUI(hInstance,lpTemplate,hWndParent,lpDialogFunc,0)

/*  ja:[hX_CAO{bNX쐬
       hInstance,W[̃nh
      lpTemplate,_CAO{bNXev[g̖O
      hWndParent,I[i[EBhẼnh
    lpDialogFunc,_CAO{bNXvV[W
          lParam,l
             RET,_CAO{bNX̃nh                               */
HWND WINAPI
CreateDialogParamGUI (HINSTANCE hInstance,
                      LPCTSTR   lpTemplate,
                      HWND      hWndParent,
                      DLGPROC   lpDialogFunc,
                      LPARAM    lParam);


/*  ja:[__CAO{bNX쐬
       hInstance,W[̃nh
      lpTemplate,_CAO{bNXev[g̖O
      hWndParent,I[i[EBhẼnh
    lpDialogFunc,_CAO{bNXvV[W
             RET,_CAO{bNX̃nh                               */
#define DialogBoxGUI(hInstance,lpTemplate,hWndParent,lpDialogFunc)          \
        DialogBoxParamGUI(hInstance,lpTemplate,hWndParent,lpDialogFunc,0)


/*  ja:[__CAO{bNX쐬
       hInstance,W[̃nh
      lpTemplate,_CAO{bNXev[g̖O
      hWndParent,I[i[EBhẼnh
    lpDialogFunc,_CAO{bNXvV[W
          lParam,l
             RET,_CAO{bNX̃nh                               */
INT_PTR WINAPI
DialogBoxParamGUI (HINSTANCE hInstance,
                   LPCTSTR   lpTemplate,
                   HWND      hWndParent,
                   DLGPROC   lpDialogFunc,
                   LPARAM    lParam);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __DIALOG_H__ */
