/*
    other
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "fndir.h"
#include "other.h"


/******************************************************************************
*                                                                             *
* ja:჌x֐Q                                                            *
*                                                                             *
******************************************************************************/
/*  ja:WXg̃L[̒l擾
             hKey,L[̃nh
    lpszValueName,L[̖O
           dwType,f[^̃^Cv
           lpData,f[^󂯎obt@
           dwData,f[^̃TCY
              RET,ERROR_SUCCESS:I                                    */
LONG WINAPI
RegGetValueEx (HKEY   hKey,
               LPTSTR lpszValueName,
               DWORD  dwType,
               LPVOID lpData,
               DWORD  dwData)
{
  return RegQueryValueEx (hKey, lpszValueName, NULL, &dwType, lpData, &dwData);
}


/*  ja:\[X當ǂݍ
    hInstance,CX^X
          uID,ID
          RET,                                                        */
LPTSTR WINAPI
LoadText (HINSTANCE hInstance,
          UINT      uID)
{
  static TCHAR szStringBuffer[4096];
  int n;

  n = LoadString (hInstance, uID, szStringBuffer, 4095);
  szStringBuffer[n + 1] = '\0';
  return szStringBuffer;
}


/*  ja:XN[o[ݒ肷
     hWnd,EChE
     nBar,XN[o[^Cv
     nMin,ŏl
     nMax,ől
    nPage,y[W
     nPos,ʒu                                                              */
VOID WINAPI
SetScrollBar (HWND hWnd,
              int  nBar,
              int  nMin,
              int  nMax,
              UINT nPage,
              int  nPos)
{
  SCROLLINFO si;

  si.cbSize = sizeof (SCROLLINFO);
  si.fMask = SIF_PAGE | SIF_POS | SIF_RANGE | SIF_DISABLENOSCROLL;
  si.nMin = nMin;
  si.nMax = nMax;
  si.nPage = nPage;
  si.nPos = nPos;
  SetScrollInfo (hWnd, nBar, &si, TRUE);
}


/*  ja:gqr
    lpszFile,t@C
    lpszWild,ChJ[h܂ރt@C
         RET,TRUE:,FALSE:Ȃ                                   */
BOOL WINAPI
CompareWildcard (LPCTSTR lpszFile,
                 LPCTSTR lpszWild)
{
  int i;
  FNDIR fd[2];
  TCHAR szFile[2][MAXPATH];

  SplitFileName (lpszFile, &fd[0]);
  SplitFileName (lpszWild, &fd[1]);
  for (i = 0; i < 2; i++)
    {
      int j, k;

      for (j = 0; j < 2; j++)
        {
          lstrcpy (&szFile[j][0], i == 0 ? fd[j].szName
                    : fd[j].szExt[0] == '.' ? fd[j].szExt + 1 : fd[j].szExt);
          CharUpper (&szFile[j][0]);
        }
      j = k = 0;
      while (szFile[0][j] != '\0' && szFile[1][k] != '\0')
        switch (szFile[1][k])
          {
            case '?':
              j++;
              k++;
              break;
            case '*':
              while (szFile[1][k] == '*')
                k++;
              while (szFile[0][j] != szFile[1][k] && szFile[0][j] != '\0')
                j++;
                break;
            default:
              if (szFile[0][j++] != szFile[1][k++])
                return FALSE;
          }
      if (szFile[0][j] != '\0' || szFile[1][k] != '\0')
        return FALSE;
    }
  return TRUE;
}
