/*
    bmmacro
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __BMMACRO_H__
#define __BMMACRO_H__


#include <windows.h>


/******************************************************************************
*                                                                             *
* ja:rbg}bv}N                                                       *
*                                                                             *
******************************************************************************/
/*  ja:RGBQUAD\̂̐߂
          biWidth,
         biHeight,
       biBitCount,1sNZ̃rbg
    biCompression,k`
        biClrUsed,F
              RET,RGBQUAD\̂̐                                         */
#define bxClrUsed(biWidth,biHeight,biBitCount,biCompression,biClrUsed)      \
                ((biClrUsed)>0?(biClrUsed):((biBitCount)<=8?1<<(biBitCount):0))


/*  ja:RGBQUAD\̂܂DWORDz̃oCg߂
          biWidth,
         biHeight,
       biBitCount,1sNZ̃rbg
    biCompression,k`
        biClrUsed,F
              RET,oCg                                                  */
#define bxClrByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed)      \
            ((biCompression)!=BI_BITFIELDS                                  \
            ?bxClrUsed(biWidth,biHeight,biBitCount,biCompression,biClrUsed) \
                                            *sizeof(RGBQUAD):sizeof(DWORD)*3)


/*  ja:BITMAPINFOHEADER\̂RGBQUAD\̂܂DWORDz̃oCg߂
          biWidth,
         biHeight,
       biBitCount,1sNZ̃rbg
    biCompression,k`
        biClrUsed,F
              RET,oCg                                                  */
#define bxHdrByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed)      \
            (bxClrByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed) \
                                                    +sizeof(BITMAPINFOHEADER))


/*  ja:1C̃oCg߂
          biWidth,
         biHeight,
       biBitCount,1sNZ̃rbg
    biCompression,k`
        biClrUsed,F
              RET,oCg                                                  */
#define bxLineByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed)     \
                                        ((((biWidth)*(biBitCount)+31)&~31)/8)


/*  ja:sNZf[^̃oCg߂
          biWidth,
         biHeight,
       biBitCount,1sNZ̃rbg
    biCompression,k`
        biClrUsed,F
              RET,oCg                                                  */
#define bxImgByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed)      \
            (bxLineByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed)\
                                                                *(biHeight))


/*  ja:rbg}bṽoCg߂
          biWidth,
         biHeight,
       biBitCount,1sNZ̃rbg
    biCompression,k`
        biClrUsed,F
              RET,oCg                                                  */
#define bxAllByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed)      \
            (bxHdrByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed) \
            +bxImgByte(biWidth,biHeight,biBitCount,biCompression,biClrUsed))


/*  ja:RGBQUAD\̂̐߂
    pbmih,BITMAPINFOHEADER\̂ւ̃|C^
      RET,RGBQUAD\̂̐                                                 */
#define bmClrUsed(pbmih) bxClrUsed((pbmih)->biWidth,(pbmih)->biHeight,      \
                (pbmih)->biBitCount,(pbmih)->biCompression,(pbmih)->biClrUsed)


/*  ja:RGBQUAD\̂܂DWORDz̃oCg߂
    pbmih,BITMAPINFOHEADER\̂ւ̃|C^
      RET,oCg                                                          */
#define bmClrByte(pbmih) bxClrByte((pbmih)->biWidth,(pbmih)->biHeight,      \
                (pbmih)->biBitCount,(pbmih)->biCompression,(pbmih)->biClrUsed)


/*  ja:BITMAPINFOHEADER\̂RGBQUAD\̂܂DWORDz̃oCg߂
    pbmih,BITMAPINFOHEADER\̂ւ̃|C^
      RET,oCg                                                          */
#define bmHdrByte(pbmih) max((pbmih)->biSize,                               \
                bxHdrByte((pbmih)->biWidth,(pbmih)->biHeight,               \
                (pbmih)->biBitCount,(pbmih)->biCompression,(pbmih)->biClrUsed))


/*  ja:1C̃oCg߂
    pbmih,BITMAPINFOHEADER\̂ւ̃|C^
      RET,oCg                                                          */
#define bmLineByte(pbmih) bxLineByte((pbmih)->biWidth,(pbmih)->biHeight,    \
                (pbmih)->biBitCount,(pbmih)->biCompression,(pbmih)->biClrUsed)


/*  ja:sNZf[^̃oCg߂
    pbmih,BITMAPINFOHEADER\̂ւ̃|C^
      RET,oCg                                                          */
#define bmImgByte(pbmih) bxImgByte((pbmih)->biWidth,(pbmih)->biHeight,      \
                (pbmih)->biBitCount,(pbmih)->biCompression,(pbmih)->biClrUsed)


/*  ja:rbg}bṽoCg߂
    pbmih,BITMAPINFOHEADER\̂ւ̃|C^
      RET,oCg                                                          */
#define bmAllByte(pbmih) (bmHdrByte(pbmih)+bmImgByte(pbmih))


#endif /* __BMMACRO_H__ */
