/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "dialog.h"
#include "env.h"
#include "gshot.h"
#include "resource.h"
#include <commctrl.h>
#include <limits.h>
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
EnvDlgProc (HWND   hDlg,
            UINT   uMsg,
            WPARAM wParam,
            LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        /* ja:`FbN{bNX̐ݒ */
        if (!CheckDlgButton (hDlg, IDC_CHECKBOX61,
                        cparam.fAbortLeftMouse ? BST_CHECKED : BST_UNCHECKED)
                || !CheckDlgButton (hDlg, IDC_CHECKBOX62,
                        cparam.fAbortRightMouse ? BST_CHECKED : BST_UNCHECKED)
                || !CheckDlgButton (hDlg, IDC_CHECKBOX63,
                        cparam.fLimitEnabled ? BST_CHECKED : BST_UNCHECKED)
                || !CheckDlgButton (hDlg, IDC_CHECKBOX64,
                        fMakeUserHitOKToCapture ? BST_CHECKED : BST_UNCHECKED)
                || !CheckDlgButton (hDlg, IDC_CHECKBOX65,
                        fRecycle ? BST_CHECKED : BST_UNCHECKED)
                || !CheckDlgButton (hDlg, IDC_CHECKBOX66,
                        fRate ? BST_CHECKED : BST_UNCHECKED))
          {
            MessageBox (hDlg, _T("CheckDlgButton"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
            return TRUE;
          }
        /* ja:GfBgRg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_EDIT61, EM_LIMITTEXT, 12, 0);
        SendDlgItemMessage (hDlg, IDC_EDIT62, EM_LIMITTEXT, 4, 0);
        SendDlgItemMessage (hDlg, IDC_EDIT63, EM_LIMITTEXT, 12, 0);
        SendDlgItemMessage (hDlg, IDC_EDIT64, EM_LIMITTEXT, 12, 0);
        SendDlgItemMessage (hDlg, IDC_EDIT65, EM_LIMITTEXT, 12, 0);
        if (!SetDlgItemInt (hDlg, IDC_EDIT61, cparam.wTimeLimit, FALSE)
                || !SetDlgItemInt (hDlg, IDC_EDIT62,
                                            cparam.wPercentDropForError, FALSE)
                || !SetDlgItemInt (hDlg, IDC_EDIT63,
                                            cparam.wNumVideoRequested, FALSE)
                || !SetDlgItemInt (hDlg, IDC_EDIT64,
                                            cparam.wNumAudioRequested, FALSE)
                || !SetDlgItemInt (hDlg, IDC_EDIT65,
                                            cparam.dwAudioBufferSize, FALSE))
          {
            MessageBox (hDlg, _T("SetDlgItemInt"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
            return TRUE;
          }
        /* ja:Abv_ERg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_UPDOWN61, UDM_SETRANGE32, 0, INT_MAX);
        SendDlgItemMessage (hDlg, IDC_UPDOWN62,
                                    UDM_SETRANGE, 0, MAKELPARAM (100, 0));
        SendDlgItemMessage (hDlg, IDC_UPDOWN63,
                                    UDM_SETRANGE, 0, MAKELPARAM (1024, 2));
        SendDlgItemMessage (hDlg, IDC_UPDOWN64,
                                    UDM_SETRANGE, 0, MAKELPARAM (10, 2));
        SendDlgItemMessage (hDlg, IDC_UPDOWN65, UDM_SETRANGE32, 0, INT_MAX);
        /* ja:Rg[̕\ */
        if (!EnableDlgItem (hDlg, IDC_EDIT61, cparam.fLimitEnabled)
                || !EnableDlgItem (hDlg, IDC_STATIC61, cparam.fLimitEnabled)
                || !EnableDlgItem (hDlg, IDC_UPDOWN61, cparam.fLimitEnabled)
                || !EnableDlgItem (hDlg, IDOK, FALSE))
          {
            MessageBox (hDlg, _T("EnableDlgItem"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
          }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                cparam.fAbortLeftMouse
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX61) == BST_CHECKED;
                cparam.fAbortRightMouse
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX62) == BST_CHECKED;
                cparam.fLimitEnabled
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX63) == BST_CHECKED;
                fMakeUserHitOKToCapture
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX64) == BST_CHECKED;
                fRecycle
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX65) == BST_CHECKED;
                fRate
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX66) == BST_CHECKED;
                cparam.wTimeLimit
                            = GetDlgItemInt (hDlg, IDC_EDIT61, NULL, FALSE);
                cparam.wPercentDropForError
                            = GetDlgItemInt (hDlg, IDC_EDIT62, NULL, FALSE);
                cparam.wNumVideoRequested
                            = GetDlgItemInt (hDlg, IDC_EDIT63, NULL, FALSE);
                cparam.wNumAudioRequested
                            = GetDlgItemInt (hDlg, IDC_EDIT64, NULL, FALSE);
                cparam.dwAudioBufferSize
                            = GetDlgItemInt (hDlg, IDC_EDIT65, NULL, FALSE);
              }
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_EDIT61:
            case IDC_EDIT62:
            case IDC_EDIT63:
            case IDC_EDIT64:
            case IDC_EDIT65:
              if (HIWORD (wParam) != EN_CHANGE)
                return TRUE;
              goto loop;
            case IDC_CHECKBOX63:
              {
                BOOL fResult;

                fResult
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX63) == BST_CHECKED;
                if (!EnableDlgItem (hDlg, IDC_EDIT61, fResult)
                            || !EnableDlgItem (hDlg, IDC_STATIC61, fResult)
                            || !EnableDlgItem (hDlg, IDC_UPDOWN61, fResult))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              goto loop;
            case IDC_CHECKBOX61:
            case IDC_CHECKBOX62:
            case IDC_CHECKBOX64:
            case IDC_CHECKBOX65:
            case IDC_CHECKBOX66:
              loop:
              {
                UINT uPercent, uVideo, uAudio;

                uPercent = GetDlgItemInt (hDlg, IDC_EDIT62, NULL, FALSE);
                uVideo = GetDlgItemInt (hDlg, IDC_EDIT63, NULL, FALSE);
                uAudio = GetDlgItemInt (hDlg, IDC_EDIT64, NULL, FALSE);
                if (!EnableDlgItem (hDlg, IDOK, uPercent <= 100
                                            && 2 <= uVideo && uVideo <= 1024
                                            && 2 <= uAudio && uAudio <= 10))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
          }
          return TRUE;
    }
  return FALSE;
}
