/*
    GtkShot for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "argument.h"
#include "dialog.h"
#include "gshot.h"
#include "license.h"
#include "memapi.h"
#include "other.h"
#include "resource.h"
#include "valstr.h"
#include "wndmain.h"
#include <commctrl.h>
#include <tchar.h>
#include <shlobj.h>


#define MAINCLASS _T("GtkShot Main Window Class")


/* ja:VXeϐ */
int nRegStat = 7;               /* ja:WXg,0:Read,1:Write,2:Create */
BOOL fControl = FALSE;          /* ja:TRUE:Lv`p,FALSE:f */
BOOL fDebug = FALSE;            /* ja:TRUE:fobN[h,FALSE:ʏ */
BOOL fLayout = TRUE;            /* ja:TRUE:TCYύXK,FALSE:ύX\ */
BOOL fSort[2] = {FALSE, FALSE}; /* ja:\[g̏(t@C/TCY) */
DWORD dwMaxSizeFormat;          /* ja:WAVEFORMATEX\̂̃TCY */
HBRUSH hBrush = NULL;           /* ja:wĩuV */
LPWAVEFORMATEX lpWfx = NULL;    /* ja:WAVEFORMATEX\ */
LPTSTR lpszFormat[4];           /* ja:tH[}bg */
SIZE siMainWnd;                 /* ja:CEChẼTCY */
TCHAR szFrameFormat[128];
int nDays[13] = {31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
WAVEFORMATEX stWfx = {WAVE_FORMAT_PCM, 2, 22050, 44100, 2, 8, 0};
PROPERTY stProperty = {FALSE, 15000, 1, NULL,
        0, NULL, 0, 0, ICQUALITY_DEFAULT, 0, NULL};/* ja:W̃vpeB */


/* ja:R[obN */
LPTSTR lpszWarning = NULL;      /* ja:Lv`̒vIł͂ȂG[ */
VSCAPTURE stVsCap;


/* ja:ݒ */
int nDeviceID = 0;              /* ja:foCX */
int nFileList = 0;              /* ja:t@C̃Xg̐ */
int nRecordList = 0;            /* ja:\̃Xg̐ */
LPFILELIST lpFileList = NULL;   /* ja:t@CXg */
LPRECORD lpRecordList = NULL;   /* ja:\񃊃Xg */
BOOL fColor = TRUE;             /* ja:TRUE:VXeF,FALSE:wwiF */
BOOL fJust = FALSE;             /* ja:TRUE:cێȂ,FALSE:ێ */
BOOL fMakeUserHitOKToCapture = TRUE;/* ja:TRUE:mF,FALSE:mFȂ */
BOOL fNumFrame = FALSE;         /* ja:TRUE:Aԕۑ,FALSE: */
BOOL fPreview = FALSE;          /* ja:TRUE:vr[,FALSE:vr[Ȃ */
BOOL fOverlay = FALSE;          /* ja:TRUE:I[o[C,FALSE:Ȃ */
BOOL fOverWrite = FALSE;        /* ja:TRUE:㏑mF,FALSE:㏑ */
BOOL fRate = TRUE;              /* ja:TRUE:TEhɓ,FALSE:ƎvZ */
BOOL fRecycle = FALSE;          /* ja:TRUE:ݔ𗘗p,FALSE:pȂ */
BOOL fScale = FALSE;            /* ja:TRUE:XP[O,FALSE:Ȃ */
BOOL fTimer =FALSE;             /* ja:TRUE:^C}L,FALSE:^C} */
BOOL fTopMost = FALSE;          /* ja:TRUE:ɎOɕ\,FALSE:ʏ */
COLORREF crColor;               /* ja:wwiF */
DWORD dwHistory[MAX_RATE];      /* ja:[g(1bԂ̃t[~1000)̗ */
DWORD dwPreviewRate = 15000;    /* ja:vr[[g(vZ͏LƓ) */
DWORD dwSaveFilter = 1;         /* ja:t@Cۑ鎞̃tB^ */
TCHAR szCaptureFile[MAXPATH];   /* ja:ۑt@C(AVI) */
TCHAR szFrameFile[MAXPATH];     /* ja:ۑt@C(BMP) */
UINT uFrame = 0;                /* ja:AԐl */
UINT64 uiMaxBytes = 1024 * 1024 * 1024;/* ja:TCY */


/* ja:Lv`֌W̐ݒ */
CAPDRIVERCAPS cdrive;
CAPSTATUS cstat;
CAPTUREPARMS cparam;


HINSTANCE hInst;                /* ja:CX^Xnh */
HWND hWndMain;                  /* ja:CEChE */
HWND hWndCap = NULL;            /* ja:Lv`EChE */
HWND hWndTool;                  /* ja:CEChẼc[o[ */
HWND hWndStat;                  /* ja:CEChẼXe[^Xo[ */


/******************************************************************************
*                                                                             *
* ja:C֐Q                                                             *
*                                                                             *
******************************************************************************/
int WINAPI
WinMain (HINSTANCE hInstance,
         HINSTANCE hPrevInstance,
         LPSTR     lpszCmdLine,
         int       nCmdShow)
{
  int i, j, nArgc;
  int nLeft = CW_USEDEFAULT, nTop = CW_USEDEFAULT;
  int nWidth = CW_USEDEFAULT, nHeight = CW_USEDEFAULT;
  BOOL fSecondWindow = FALSE;   /* ja:TRUE:2N,FALSE:1ڂANeBu */
  DWORD dwType = REG_BINARY, dwLength;
  HACCEL hAccel;                /* ja:ANZ[^L[ */
  HKEY hKey, hKeySub;           /* ja:WXgL[ */
  LPITEMIDLIST pid;
  MSG msg;
  SYSTEMTIME stSysTime;
  TCHAR **lpszArgv, szName[MAXPATH];
  WNDCLASS wc;

  InitCommonControls ();
  /* ja:ϐ̏ */
  GetLocalTime (&stSysTime);
  if (stSysTime.wYear % 4 == 0 && stSysTime.wYear % 100 != 0
                                                || stSysTime.wYear % 400 == 0)
    nDays[2]++;
  lstrcpy (szFrameFormat, LoadText (hInst, IDS_CAP_FRAME));
  for (i = 0; i < 4; i++)
    {
      lpszFormat[i] = MemoryAlloc (sizeof (TCHAR) * 128);
      if (!lpszFormat[i])
        {
          MessageBox (NULL, _T("MemoryAlloc"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      lstrcpy (lpszFormat[i], LoadText (hInst, IDS_FORMAT_STD + i));
    }
  if (SHGetSpecialFolderLocation (NULL, CSIDL_PERSONAL, &pid) == NOERROR)
    {
      if (!SHGetPathFromIDList (pid, szCaptureFile))
        {
          MessageBox (NULL, _T("SHGetPathFromIDList"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      CoTaskMemFree (pid);
    }
  else
    {
      szCaptureFile[0]='\0';
    }
  lstrcpy (szFrameFile, szCaptureFile);
  lstrcat (szCaptureFile, _T("\\capture.avi"));
  lstrcat (szFrameFile, _T("\\capture.bmp"));
  hInst = hInstance;
  crColor = GetSysColor (COLOR_WINDOW);
  MemorySet (dwHistory, 0, MAX_RATE * sizeof (DWORD));
  /* ja:I[fBIkɊւݒ */
  if (acmMetrics (NULL, ACM_METRIC_MAX_SIZE_FORMAT, &dwMaxSizeFormat) != 0)
    {
      MessageBox (NULL, _T("acmMetrics"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }
  lpWfx = MemoryAlloc (dwMaxSizeFormat);
  stProperty.lpWfx = MemoryAlloc (dwMaxSizeFormat);
  if (!lpWfx || !stProperty.lpWfx)
    {
      MessageBox (NULL, _T("MemoryAlloc"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }
  *stProperty.lpWfx = stWfx;

  /* ja:R}hC̉ */
  if (!MakeArgument (&nArgc, &lpszArgv, lpszCmdLine))
    {
      MessageBox (NULL, _T("MakeArgument"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  /* ja:WXg̈R}hC擾 */
  for (i = 0; i < nArgc; i++)
    if (((lpszArgv[i])[0] == '-' || (lpszArgv[i])[0] == '/')
                        && (int)CharUpper ((LPTSTR)(lpszArgv[i])[1]) == 'Q')
    {
      if (IsCharNumeric ((lpszArgv[i])[2]) && (lpszArgv[i])[3] == '\0')
        nRegStat = (lpszArgv[i])[2] - '0';
      else
        nRegStat = 7;
    }

  if (nRegStat & 1 && (RegOpenKeyEx (HKEY_CURRENT_USER,
                                _T("Software\\maid.org\\GtkShot"),
                                0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS
                        || RegOpenKeyEx (HKEY_CURRENT_USER,
                                _T("Software\\IwamotoKazuki\\Gleaming Shot"),
                                0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS))
    {
      /* ja:WXgǂݏo */
      RegGetValueEx (hKey, _T("Left"), REG_DWORD, &nLeft, sizeof (int));
      RegGetValueEx (hKey, _T("Top"), REG_DWORD, &nTop, sizeof (int));
      RegGetValueEx (hKey, _T("Width"), REG_DWORD, &nWidth, sizeof (int));
      RegGetValueEx (hKey, _T("Height"), REG_DWORD, &nHeight, sizeof (int));
      RegGetValueEx (hKey, _T("DeviceID"), REG_DWORD,&nDeviceID, sizeof (int));
      RegGetValueEx (hKey, _T("MakeUserHitOKToCapture"), REG_DWORD,
                                    &fMakeUserHitOKToCapture, sizeof (BOOL));
      RegGetValueEx (hKey, _T("Color"), REG_DWORD, &fColor, sizeof (BOOL));
      RegGetValueEx (hKey, _T("Just"), REG_DWORD, &fJust, sizeof (BOOL));
      RegGetValueEx (hKey, _T("NumFrame"), REG_DWORD,
                                    &fNumFrame, sizeof (BOOL));
      RegGetValueEx (hKey, _T("Preview"), REG_DWORD, &fPreview, sizeof (BOOL));
      RegGetValueEx (hKey, _T("Overlay"), REG_DWORD, &fOverlay, sizeof (BOOL));
      RegGetValueEx (hKey, _T("OverWrite"), REG_DWORD,
                                    &fOverWrite, sizeof (BOOL));
      RegGetValueEx (hKey, _T("Rate"), REG_DWORD, &fRate, sizeof (BOOL));
      RegGetValueEx (hKey, _T("Recycle"), REG_DWORD, &fRecycle, sizeof (BOOL));
      RegGetValueEx (hKey, _T("Scale"), REG_DWORD, &fScale, sizeof (BOOL));
      RegGetValueEx (hKey, _T("Timer"), REG_DWORD, &fTimer, sizeof (BOOL));
      RegGetValueEx (hKey, _T("TopMost"), REG_DWORD, &fTopMost, sizeof (BOOL));
      RegGetValueEx (hKey, _T("crColor"), REG_DWORD,
                                    &crColor, sizeof (COLORREF));
      RegGetValueEx (hKey, _T("PreviewRate"), REG_DWORD,
                                    &dwPreviewRate, sizeof (DWORD));
      RegGetValueEx (hKey, _T("SaveFilter"), REG_DWORD,
                                    &dwSaveFilter, sizeof (DWORD));
      RegGetValueEx (hKey, _T("Frame"), REG_DWORD, &uFrame, sizeof (UINT));
      RegGetValueEx (hKey, _T("MaxBytes"), REG_BINARY,
                                    &uiMaxBytes, sizeof (UINT64));
      RegGetValueEx (hKey, _T("CaptureFile"), REG_SZ,
                                    szCaptureFile, MAXPATH * sizeof (TCHAR));
      RegGetValueEx (hKey, _T("FrameFile"), REG_SZ,
                                    szFrameFile, MAXPATH * sizeof (TCHAR));
      /* ja:vpeB */
      RegGetValueEx (hKey, _T("CaptureAudio"), REG_DWORD,
                                    &stProperty.fAudio, sizeof (BOOL));
      RegGetValueEx (hKey, _T("FrameRate"), REG_DWORD,
                                    &stProperty.dwRate, sizeof (DWORD));
      RegGetValueEx (hKey, _T("Format"), REG_DWORD,
                                    &stProperty.uFormat, sizeof (UINT));
      RegGetValueEx (hKey, _T("WaveFormatEx"), REG_BINARY,
                                    stProperty.lpWfx, dwMaxSizeFormat);
      RegGetValueEx (hKey, _T("Handler"), REG_DWORD,
                                    &stProperty.fccHandler, sizeof (FOURCC));
      RegGetValueEx (hKey, _T("Key"), REG_DWORD,
                                    &stProperty.lKey, sizeof (LONG));
      RegGetValueEx (hKey, _T("DataRate"), REG_DWORD,
                                    &stProperty.lDataRate, sizeof (LONG));
      RegGetValueEx (hKey, _T("Q"), REG_DWORD,
                                    &stProperty.lQ, sizeof (LONG));
      stProperty.cbState = 0;
      stProperty.lpState = NULL;
      if (RegQueryValueEx (hKey, _T("State"), NULL, &dwType, NULL,
            &stProperty.cbState) == ERROR_SUCCESS && stProperty.cbState > 0)
        {
          stProperty.lpState = MemoryAlloc (stProperty.cbState);
          if (!stProperty.lpState)
            {
              MessageBox (NULL, _T("MemoryAlloc"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              return 0;
            }
          RegGetValueEx (hKey, _T("State"), REG_BINARY,
                                    stProperty.lpState, stProperty.cbState);
        }
      stProperty.lpBmiOut = NULL;
      if (RegQueryValueEx (hKey, _T("Bmi"), NULL, &dwType, NULL,
                                &dwLength) == ERROR_SUCCESS && dwLength > 0)
        {
          stProperty.lpBmiOut = MemoryAlloc (dwLength);
          if (!stProperty.lpBmiOut)
            {
              MessageBox (NULL, _T("MemoryAlloc"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              return 0;
            }
          RegGetValueEx (hKey, _T("Bmi"), REG_BINARY,
                                                stProperty.lpBmiOut, dwLength);
        }
      /* ja:t@CXg */
      RegGetValueEx (hKey, _T("FileList"), REG_DWORD,
                                    &nFileList, sizeof (int));
      if (nFileList > 0)
        {
          lpFileList = MemoryAlloc (nFileList * sizeof (FILELIST));
          if (!lpFileList)
            {
              MessageBox (NULL, _T("MemoryAlloc"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return 0;
            }
          for (i = 0; i < nFileList; i++)
            {
              wsprintf (szName, _T("ListFile%04d"), i);
              RegGetValueEx (hKey, szName, REG_SZ,
                                lpFileList[i].szFile, MAXPATH * sizeof (TCHAR));
              wsprintf (szName, _T("ListBytes%04d"), i);
              RegGetValueEx (hKey, szName, REG_BINARY,
                                    &lpFileList[i].uiBytes, sizeof (UINT64));
            }
        }
      /* ja: */
      for (i = 0; i < MAX_RATE; i++)
        {
          wsprintf (szName, _T("History%04d"), i);
          RegGetValueEx (hKey, szName, REG_DWORD,
                                    &dwHistory[i], sizeof (DWORD));
        }
      /* ja:^C} */
      RegGetValueEx (hKey, _T("RecordList"), REG_DWORD,
                                    &nRecordList, sizeof (int));
      if (nRecordList > 0)
        {
          lpRecordList = MemoryAlloc (nRecordList * sizeof (RECORD));
          if (!lpRecordList)
            {
              MessageBox (NULL, _T("MemoryAlloc"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return 0;
            }
          for (i = 0; i < nRecordList; i++)
            {
              wsprintf (szName, _T("Record%04d"),i);
              if (RegOpenKeyEx (hKey, szName,
                                0, KEY_ALL_ACCESS, &hKeySub) != ERROR_SUCCESS)
                break;
              lpRecordList[i].stProp.lpWfx = MemoryAlloc (dwMaxSizeFormat);
              if (!lpRecordList[i].stProp.lpWfx)
                {
                  MessageBox (NULL, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  return 0;
                }
              RegGetValueEx (hKeySub, _T("Weeks"), REG_DWORD,
                                    &lpRecordList[i].dwWeeks, sizeof (DWORD));
              RegGetValueEx (hKeySub, _T("Day"), REG_DWORD,
                                    &lpRecordList[i].nDay, sizeof (int));
              RegGetValueEx (hKeySub, _T("Hour"), REG_DWORD,
                                    &lpRecordList[i].nHour, sizeof (int));
              RegGetValueEx (hKeySub, _T("Minute"), REG_DWORD,
                                    &lpRecordList[i].nMinute, sizeof (int));
              RegGetValueEx (hKeySub, _T("Second"), REG_DWORD,
                                    &lpRecordList[i].nSecond, sizeof (int));
              RegGetValueEx (hKeySub, _T("TimeLimit"), REG_DWORD,
                                &lpRecordList[i].uTimeLimit, sizeof (UINT));
              RegGetValueEx (hKeySub, _T("Alloc"), REG_DWORD,
                                    &lpRecordList[i].uAlloc, sizeof (UINT));
              RegGetValueEx (hKeySub, _T("FileList"), REG_DWORD,
                                    &lpRecordList[i].nFileList, sizeof (int));
              /* ja:vpeB */
              RegGetValueEx (hKeySub, _T("CaptureAudio"), REG_DWORD,
                                &lpRecordList[i].stProp.fAudio, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("FrameRate"), REG_DWORD,
                            &lpRecordList[i].stProp.dwRate, sizeof (DWORD));
              RegGetValueEx (hKeySub, _T("Format"), REG_DWORD,
                            &lpRecordList[i].stProp.uFormat, sizeof (UINT));
              RegGetValueEx (hKeySub, _T("WaveFormatEx"), REG_BINARY,
                                lpRecordList[i].stProp.lpWfx, dwMaxSizeFormat);
              RegGetValueEx (hKeySub, _T("Handler"), REG_DWORD,
                        &lpRecordList[i].stProp.fccHandler, sizeof (FOURCC));
              RegGetValueEx (hKeySub, _T("Key"), REG_DWORD,
                                &lpRecordList[i].stProp.lKey, sizeof (LONG));
              RegGetValueEx (hKeySub, _T("DataRate"), REG_DWORD,
                            &lpRecordList[i].stProp.lDataRate, sizeof (LONG));
              RegGetValueEx (hKeySub, _T("Q"), REG_DWORD,
                                &lpRecordList[i].stProp.lQ, sizeof (LONG));
              lpRecordList[i].stProp.cbState = 0;
              lpRecordList[i].stProp.lpState = NULL;
              if (RegQueryValueEx (hKeySub, _T("State"), NULL, &dwType, NULL,
                            &lpRecordList[i].stProp.cbState) == ERROR_SUCCESS
                                        && lpRecordList[i].stProp.cbState > 0)
                {
                  lpRecordList[i].stProp.lpState
                                = MemoryAlloc (lpRecordList[i].stProp.cbState);
                  if (!lpRecordList[i].stProp.lpState)
                    {
                      MessageBox (NULL, _T("MemoryAlloc"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                      return 0;
                    }
                  RegGetValueEx (hKeySub, _T("State"), REG_BINARY,
                                            lpRecordList[i].stProp.lpState,
                                            lpRecordList[i].stProp.cbState);
                }
              lpRecordList[i].stProp.lpBmiOut = NULL;
              if (RegQueryValueEx (hKeySub, _T("Bmi"), NULL, &dwType, NULL,
                                &dwLength) == ERROR_SUCCESS && dwLength > 0)
                {
                  lpRecordList[i].stProp.lpBmiOut = MemoryAlloc (dwLength);
                  if (!lpRecordList[i].stProp.lpBmiOut)
                    {
                      MessageBox (NULL, _T("MemoryAlloc"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                      return 0;
                    }
                  RegGetValueEx (hKeySub, _T("Bmi"), REG_BINARY,
                                    lpRecordList[i].stProp.lpBmiOut, dwLength);
                }
              /* ja:t@CXg */
              lpRecordList[i].lpFileList = MemoryAlloc
                            (lpRecordList[i].nFileList * sizeof (FILELIST));
              if (!lpRecordList[i].lpFileList)
                {
                  MessageBox (NULL, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  return 0;
                }
              for (j = 0; j < lpRecordList[i].nFileList; j++)
                {
                  wsprintf (szName, _T("ListFile%04d"), j);
                  RegGetValueEx (hKeySub, szName, REG_SZ,
                                        lpRecordList[i].lpFileList[j].szFile,
                                                    MAXPATH * sizeof (TCHAR));
                  wsprintf (szName, _T("ListBytes%04d"), j);
                  RegGetValueEx (hKeySub, szName, REG_BINARY,
                                        &lpRecordList[i].lpFileList[j].uiBytes,
                                                            sizeof (UINT64));
                }
              lpRecordList[i].fAlloc = lpRecordList[i].fDone = FALSE;
            }
          nRecordList = i;
        }
      /* ja:ǂݏô */
      if (RegGetValueEx (hKey, _T("SecondWindow"), REG_DWORD,
                            &fSecondWindow, sizeof (BOOL)) != ERROR_SUCCESS)
        fSecondWindow = FALSE;
      if (RegCloseKey (hKey) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegCloseKey"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
    }
  else if (DialogBoxGUI (hInstance, MAKEINTRESOURCE (DIALOG_1),
                                                NULL, LicenseDlgProc) != IDOK)
    {
      /* ja:CZXւ̓ӂȂAI */
      return 0;
    }

  /* ja:R}hC */
  for (i = 0; i < nArgc; i++)
    if (((lpszArgv[i])[0] == '-' || (lpszArgv[i])[0] == '/'))
      switch ((int)CharUpper ((LPTSTR)(lpszArgv[i])[1]))
        {
          case '*':
            fDebug=TRUE;
            break;
          case 'D':
            nDeviceID = (lpszArgv[i])[2] - '0';
          case 'Q':
            break;
          case 'X':
            fSecondWindow = (lpszArgv[i])[2] - '0';
            break;
          default:
            MessageBox (NULL, LoadText (hInst, IDS_OTHER_COMMAND),
                              APPLICATION, MB_OK | MB_ICONSTOP);
            return 0;
        }

  FreeArgument (nArgc, &lpszArgv);

  if (!fSecondWindow && FindWindow (MAINCLASS, NULL))
    return 0;

  /* ja:I[o[Cƃvr[͔rI */
  if (fPreview)
    fOverlay = FALSE;
  else if (fOverlay)
    fPreview = FALSE;

  if (nDeviceID == -1)
    nDeviceID = 0;

  wc.style         = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = WndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE (ICON_1));
  wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
  wc.hbrBackground = NULL;
  wc.lpszMenuName  = MAKEINTRESOURCE (MENU_1);
  wc.lpszClassName = MAINCLASS;
  if (RegisterClass (&wc) == 0)
    {
      MessageBox (NULL, _T("RegisterClass"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  /* ja:ANZ[^ */
  hAccel = LoadAccelerators (hInstance, MAKEINTRESOURCE (MENU_1));
  if (!hAccel)
    {
      MessageBox (NULL, _T("LoadAccelerators"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  /* ja:CEChE */
  hWndMain = CreateWindowEx (fTopMost ? WS_EX_TOPMOST : 0,
                                                        MAINCLASS, APPLICATION,
            WS_CAPTION | WS_CLIPCHILDREN | WS_OVERLAPPED | WS_SYSMENU
            | WS_THICKFRAME | WS_MINIMIZEBOX | (fScale ? WS_MAXIMIZEBOX : 0),
            nLeft, nTop, nWidth, nHeight, HWND_DESKTOP, NULL, hInstance, NULL);
  if (!hWndMain)
    {
      MessageBox (NULL, _T("CreateWindowEx"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  ShowWindow (hWndMain, nCmdShow);
  if (!UpdateWindow (hWndMain))
    {
      MessageBox (hWndMain, _T("UpdateWindow"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }

  while (GetMessage (&msg, NULL, 0, 0))
    if (!TranslateAccelerator (hWndMain, hAccel, &msg))
      {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
      }
  return msg.wParam;
}
