/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "dialog.h"
#include "gshot.h"
#include "memapi.h"
#include "other.h"
#include "resource.h"
#include "save.h"
#include <commctrl.h>
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
/*  ja:^C}\בւ
    RET,:lParam2,:lParam1,0:                                */
int CALLBACK
ListViewCallback (LPARAM lParam1,
                  LPARAM lParam2,
                  LPARAM lParam)
{
  int nResult = 0;

  switch (lParam)
    {
      case 0:
        nResult = lstrcmpi (((LPFILELIST)lParam1)->szFile,
                                                ((LPFILELIST)lParam2)->szFile);
        break;
      case 1:
        nResult = ((LPFILELIST)lParam1)->uiBytes
                                            - ((LPFILELIST)lParam2)->uiBytes;
    }
  if (fSort[lParam])
    nResult =- nResult;
  return nResult;
}


BOOL CALLBACK
SaveDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  static HIMAGELIST hImage;
  static POINT ptDrag;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          HWND hWnd;
          LV_COLUMN lvc;
          LV_ITEM lvi;
          RECT rc;
          TCHAR szText[128];

          hImage = NULL;
          /* ja:`FbN{bNX */
          if (!CheckDlgButton (hDlg, IDC_CHECKBOX21,
                                    fNumFrame ? BST_CHECKED : BST_UNCHECKED))
            {
              MessageBox (hDlg, _T("CheckDlgButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:GfBgRg[̐ݒ */
          SendDlgItemMessage (hDlg, IDC_EDIT21, EM_LIMITTEXT, MAXPATH, 0);
          SendDlgItemMessage (hDlg, IDC_EDIT22, EM_LIMITTEXT, 12, 0);
          SendDlgItemMessage (hDlg, IDC_EDIT23, EM_LIMITTEXT, MAXPATH, 0);
          SendDlgItemMessage (hDlg, IDC_EDIT24, EM_LIMITTEXT, 12, 0);
          if (!SetDlgItemText (hDlg, IDC_EDIT21, szCaptureFile)
                            || !SetDlgItemText (hDlg, IDC_EDIT23, szFrameFile))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!SetDlgItemInt (hDlg, IDC_EDIT22,
                                    (UINT)(uiMaxBytes / 1024 / 1024), FALSE)
                        || !SetDlgItemInt (hDlg, IDC_EDIT24, uFrame, FALSE))
            {
              MessageBox (hDlg, _T("SetDlgItemInt"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Xgr[̐ݒ */
          hWnd = GetDlgItem (hDlg, IDC_LISTVIEW21);
          if (!hWnd)
            {
              MessageBox (hDlg, _T("GetDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!GetClientRect (hWnd, &rc))
            {
              MessageBox (hDlg, _T("GetClientRect"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          rc.right -= GetSystemMetrics (SM_CXVSCROLL);
          lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
          lvc.fmt = LVCFMT_LEFT;
          lvc.cx = rc.right / 4 * 3;
          lvc.pszText = LoadText (hInst, IDS_LIST_NAME);
          lvc.iSubItem = 0;
          if (ListView_InsertColumn (hWnd, 0, &lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          lvc.fmt = LVCFMT_RIGHT;
          lvc.cx = rc.right / 4;
          lvc.pszText = LoadText (hInst, IDS_LIST_SIZE);
          lvc.iSubItem = 1;
          if (ListView_InsertColumn (hWnd, 1, &lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          for (i = 0; i < nFileList; i++)
            {
              (LPFILELIST)lvi.lParam = MemoryAlloc (sizeof (FILELIST));
              if (!lvi.lParam)
                {
                  MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              lvi.mask = LVIF_TEXT | LVIF_PARAM;
              lvi.pszText = lpFileList[i].szFile;
              lvi.iItem = ListView_GetItemCount (hWnd);
              lvi.iSubItem = 0;
              *(LPFILELIST)lvi.lParam = lpFileList[i];
              if (ListView_InsertItem (hWnd, &lvi) == -1)
                {
                  MessageBox (hDlg, _T("ListView_InsertItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              wsprintf (szText, _T("%uMB"),
                                (UINT)(lpFileList[i].uiBytes / 1024 / 1024));
              lvi.mask = LVIF_TEXT;
              lvi.pszText = szText;
              lvi.iSubItem = 1;
              if (!ListView_SetItem (hWnd, &lvi))
                {
                  MessageBox (hDlg, _T("ListView_SetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
            }
          /* ja:Abv_ERg[̐ݒ */
          SendDlgItemMessage (hDlg, IDC_UPDOWN21,
                                UDM_SETRANGE, 0, MAKELPARAM (UD_MAXVAL, 1));
          SendDlgItemMessage (hDlg, IDC_UPDOWN22,
                                UDM_SETRANGE, 0, MAKELPARAM (UD_MAXVAL, 0));
          /* ja:Rg[̕\ */
          if (!EnableDlgItem (hDlg, IDC_EDIT24, fNumFrame)
                    || !EnableDlgItem (hDlg, IDC_UPDOWN22, fNumFrame)
                    || !EnableDlgItem (hDlg, IDOK, FALSE))
            {
              MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_NOTIFY:
        if (LOWORD (wParam) == IDC_LISTVIEW21)
          switch (((LPNMHDR)lParam)->code)
            {
              case LVN_BEGINDRAG:
                {
                  int nIndex, nSelected;
                  POINT pt;
                  RECT rc, rc0, rc1;

                  nSelected = 0;
                  nIndex = -1;
                  while ((nIndex = ListView_GetNextItem
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                nIndex, LVNI_SELECTED)) != -1)
                    {
                      RECT rc2;

                      /* ja:hbO镔̍ŏ̋`߂ */
                      if (!ListView_GetItemRect (((LPNMHDR)lParam)->hwndFrom,
                                                    nIndex, &rc0, LVIR_LABEL)
                                || !ListView_GetItemRect 
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                    nIndex, &rc1, LVIR_ICON))
                        {
                          MessageBox (hDlg, _T("ListView_GetItemRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      UnionRect (&rc2, &rc0, &rc1);
                      if (nSelected == 0)
                        {
                          rc = rc2;
                        }
                      else
                        {
                          rc0 = rc;
                          UnionRect (&rc, &rc0, &rc2);
                        }
                      nSelected++;
                    }
                  if (nSelected <= 1)
                    {
                      hImage = ListView_CreateDragImage
                                                (((LPNMHDR)lParam)->hwndFrom,
                                        ((LPNM_LISTVIEW)lParam)->iItem, &pt);
                      if (!hImage)
                        {
                          MessageBox (hDlg, _T("ListView_CreateDragImage"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                    }
                  else
                    {
                      HBITMAP hBmp0, hBmp1;
                      HBRUSH hBrush0, hBrush1;
                      HDC hDC, hMemDC0, hMemDC1;
                      HPEN hPen0, hPen1;

                      /* ja:hbOp̃C[W */
                      hDC = GetDC (((LPNMHDR)lParam)->hwndFrom);
                      if (!hDC)
                        {
                          MessageBox (hDlg, _T("GetDC"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hMemDC0 = CreateCompatibleDC (hDC);
                      hMemDC1 = CreateCompatibleDC (hDC);
                      if (!hMemDC0 || !hMemDC1)
                        {
                          MessageBox (hDlg, _T("GetDC"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          if (hMemDC0)
                            DeleteDC (hMemDC0);
                          if (hMemDC1)
                            DeleteDC (hMemDC1);
                          ReleaseDC (((LPNMHDR)lParam)->hwndFrom, hDC);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hBmp0 = CreateCompatibleBitmap (hDC,
                                    rc.right - rc.left, rc.bottom - rc.top);
                      hBmp1 = CreateCompatibleBitmap (hDC,
                                    rc.right - rc.left, rc.bottom - rc.top);
                      if (!hBmp0 || !hBmp1)
                        {
                          MessageBox (hDlg, _T("CreateCompatibleBitmap"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          if (hBmp0)
                            DeleteObject (hBmp0);
                          if (hBmp1)
                            DeleteObject (hBmp1);
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          ReleaseDC (((LPNMHDR)lParam)->hwndFrom, hDC);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      if (ReleaseDC (((LPNMHDR)lParam)->hwndFrom, hDC) != 1)
                        {
                          MessageBox (hDlg, _T("ReleaseDC"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hBrush0 = GetStockObject (BLACK_BRUSH);
                      hBrush1 = GetStockObject (WHITE_BRUSH);
                      hPen1 = GetStockObject (BLACK_PEN);
                      if (!hBrush0 || !hBrush1 || !hPen1)
                        {
                          MessageBox (hDlg, _T("GetStockObject"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hBmp0 = SelectObject (hMemDC0, hBmp0);
                      hBmp1 = SelectObject (hMemDC1, hBmp1);
                      rc0 = rc;
                      OffsetRect (&rc0, -rc.left, -rc.top);
                      if (!FillRect (hMemDC0, &rc0, hBrush0)
                                        || !FillRect (hMemDC1, &rc0, hBrush1))
                        {
                          MessageBox (hDlg, _T("CreatePen"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (SelectObject (hMemDC0, hBmp0));
                          DeleteObject (SelectObject (hMemDC1, hBmp1));
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hPen0 = CreatePen (PS_SOLID, 0, RGB (128, 128, 128));
                      if (!hPen0)
                        {
                          MessageBox (hDlg, _T("CreatePen"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (SelectObject (hMemDC0, hBmp0));
                          DeleteObject (SelectObject (hMemDC1, hBmp1));
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hBrush0 = SelectObject (hMemDC0, hBrush0);
                      hBrush1 = SelectObject (hMemDC1, hBrush1);
                      hPen0 = SelectObject (hMemDC0, hPen0);
                      hPen1 = SelectObject (hMemDC1, hPen1);
                      nIndex = -1;
                      while ((nIndex = ListView_GetNextItem
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                nIndex, LVNI_SELECTED)) != -1)
                        {
                          if (!ListView_GetItemRect
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                    nIndex, &rc0, LVIR_LABEL)
                                    || !ListView_GetItemRect
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                    nIndex, &rc1, LVIR_ICON))
                            {
                              MessageBox (hDlg, _T("ListView_GetItemRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                              DeleteObject (SelectObject (hMemDC0, hBmp0));
                              DeleteObject (SelectObject (hMemDC1, hBmp1));
                              SelectObject (hMemDC0, hBrush0);
                              SelectObject (hMemDC1, hBrush1);
                              DeleteObject (SelectObject (hMemDC0, hPen0));
                              SelectObject (hMemDC1, hPen1);
                              DeleteDC (hMemDC0);
                              DeleteDC (hMemDC1);
                              EndDialog (hDlg, IDCANCEL);
                              return 0;
                            }
                          OffsetRect (&rc0, -rc.left, -rc.top);
                          OffsetRect (&rc1, -rc.left, -rc.top);
                          if (!MoveToEx (hMemDC0, rc0.left,
                                rc0.top + (rc0.bottom - rc0.top) / 2, NULL)
                                || !MoveToEx (hMemDC1, rc0.left,
                                rc0.top + (rc0.bottom - rc0.top) / 2, NULL))
                            {
                              MessageBox (hDlg, _T("MoveToEx"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                              DeleteObject (SelectObject (hMemDC0, hBmp0));
                              DeleteObject (SelectObject (hMemDC1, hBmp1));
                              SelectObject (hMemDC0, hBrush0);
                              SelectObject (hMemDC1, hBrush1);
                              DeleteObject (SelectObject (hMemDC0, hPen0));
                              SelectObject (hMemDC1, hPen1);
                              DeleteDC (hMemDC0);
                              DeleteDC (hMemDC1);
                              EndDialog (hDlg, IDCANCEL);
                              return 0;
                            }
                          if (!LineTo (hMemDC0, rc0.right,
                                        rc0.top + (rc0.bottom - rc0.top) / 2)
                                || !LineTo (hMemDC1, rc0.right,
                                        rc0.top + (rc0.bottom - rc0.top) / 2))
                            {
                              MessageBox (hDlg, _T("LineTo"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                              DeleteObject (SelectObject (hMemDC0, hBmp0));
                              DeleteObject (SelectObject (hMemDC1, hBmp1));
                              SelectObject (hMemDC0, hBrush0);
                              SelectObject (hMemDC1, hBrush1);
                              DeleteObject (SelectObject (hMemDC0, hPen0));
                              SelectObject (hMemDC1, hPen1);
                              DeleteDC (hMemDC0);
                              DeleteDC (hMemDC1);
                              EndDialog (hDlg, IDCANCEL);
                              return 0;
                            }
                          if (!Rectangle (hMemDC0, rc1.left, rc1.top,
                                                    rc1.right, rc1.bottom)
                                    || !Rectangle (hMemDC1, rc1.left, rc1.top,
                                                    rc1.right, rc1.bottom))
                            {
                              MessageBox (hDlg, _T("Rectangle"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                              DeleteObject (SelectObject (hMemDC0, hBmp0));
                              DeleteObject (SelectObject (hMemDC1, hBmp1));
                              SelectObject (hMemDC0, hBrush0);
                              SelectObject (hMemDC1, hBrush1);
                              DeleteObject (SelectObject (hMemDC0, hPen0));
                              SelectObject (hMemDC1, hPen1);
                              DeleteDC (hMemDC0);
                              DeleteDC (hMemDC1);
                              EndDialog (hDlg, IDCANCEL);
                              return 0;
                            }
                        }
                      hBmp0 = SelectObject (hMemDC0, hBmp0);
                      hBmp1 = SelectObject (hMemDC1, hBmp1);
                      SelectObject (hMemDC0, hBrush0);
                      SelectObject (hMemDC1, hBrush1);
                      hPen0 = SelectObject (hMemDC0, hPen0);
                      SelectObject (hMemDC1, hPen1);
                      if (!DeleteDC (hMemDC0) | !DeleteDC (hMemDC1))
                        {
                          MessageBox (hDlg, _T("Rectangle"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteObject (hPen0);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hImage = ImageList_Create (rc.right - rc.left,
                                            rc.bottom - rc.top, TRUE, 1, 1);
                      if (!hImage)
                        {
                          MessageBox (hDlg, _T("ImageList_Create"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteObject (hPen0);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      if (ImageList_Add (hImage, hBmp0, hBmp1) == -1)
                        {
                          MessageBox (hDlg, _T("ImageList_Add"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteObject (hPen0);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      if (!DeleteObject (hBmp0) | !DeleteObject (hBmp1)
                                                    | !DeleteObject (hPen0))
                        {
                          MessageBox (hDlg, _T("Rectangle"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      pt.x = rc.left;
                      pt.y = rc.top;
                    }
                  ptDrag = ((LPNM_LISTVIEW)lParam)->ptAction;
                  if (MapWindowPoints (((LPNMHDR)lParam)->hwndFrom,
                                                        hDlg, &ptDrag, 1) == 0)
                    {
                      MessageBox (hDlg, _T("MapWindowPoints"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  if (!ImageList_BeginDrag (hImage, 0,
                                            ptDrag.x - pt.x, ptDrag.y - pt.y))
                    {
                      MessageBox (hDlg, _T("ImageList_BeginDrag"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  if (!ImageList_DragEnter (((LPNMHDR)lParam)->hwndFrom,
                                        ptDrag.x - rc.left, ptDrag.y - rc.top))
                    {
                      MessageBox (hDlg, _T("ImageList_DragEnter"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  SetCapture (hDlg);
                }
                break;
              case LVN_ITEMCHANGED:/* ja:IȂǂω */
                {
                  int nSelected;

                  nSelected = ListView_GetSelectedCount
                                                (((LPNMHDR)lParam)->hwndFrom);
                  /* ja:Rg[̕\ */
                  if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON23, nSelected > 0)
                    || !EnableDlgItem (hDlg, IDC_PUSHBUTTON24, nSelected > 0))
                    {
                      MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                    }
                }
                break;
              case LVN_COLUMNCLICK:/* ja:wb^NbN */
                ListView_SortItems (((LPNMHDR)lParam)->hwndFrom,
                        ListViewCallback, ((LPNM_LISTVIEW)lParam)->iSubItem);
                fSort[((LPNM_LISTVIEW)lParam)->iSubItem]
                                = !fSort[((LPNM_LISTVIEW)lParam)->iSubItem];
            }
        return 0;
      case WM_MOUSEMOVE:
        if (hImage && !ImageList_DragMove (LOWORD (lParam), HIWORD (lParam)))
          {
            MessageBox (hDlg, _T("ImageList_DragMove"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
          }
        return 0;
      case WM_LBUTTONUP:
        if (hImage)
          {
            int i = 0, nIndex, nSelected;
            HWND hWnd;
            FILELIST **pFl;
            LV_HITTESTINFO lht;
            LV_ITEM lvi;
            TCHAR szText[128];

            hWnd = GetDlgItem (hDlg, IDC_LISTVIEW21);
            if (!hWnd)
              {
                MessageBox (hDlg, _T("GetDlgItem"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return 0;
              }
            if (!ImageList_DragLeave (hWnd))
              {
                MessageBox (hDlg, _T("ImageList_DragLeave"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return 0;
              }
            ImageList_EndDrag ();
            if (!ImageList_Destroy (hImage))
              {
                MessageBox (hDlg, _T("ImageList_Destroy"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return 0;
              }
            hImage = NULL;
            ReleaseCapture ();
            lht.pt.x = LOWORD (lParam);
            lht.pt.y = HIWORD (lParam);
            if (MapWindowPoints (hDlg, hWnd, &lht.pt, 1) == 0)
              {
                MessageBox (hDlg, _T("MapWindowPoints"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return 0;
              }
            if (ListView_HitTest (hWnd, &lht) == -1)
              return 0;
            nSelected = ListView_GetSelectedCount (hWnd);
            pFl = MemoryAlloc (nSelected * sizeof (LPFILELIST));
            if (!pFl)
              {
                MessageBox (hDlg, _T("MemoryAlloc"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return TRUE;
              }
            lvi.mask = LVIF_PARAM;
            lvi.iItem = -1;
            lvi.iSubItem = 0;
            while ((lvi.iItem = ListView_GetNextItem (hWnd,
                                            lvi.iItem, LVNI_SELECTED)) != -1)
              {
                if (!ListView_GetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    MemoryFree (pFl);
                    EndDialog (hDlg, IDCANCEL);
                    return 0;
                  }
                pFl[i++] = (LPFILELIST)lvi.lParam;
              }
            lvi.iItem = lht.iItem;
            for (i = nSelected - 1; i >= 0; i--)
              {
                lvi.mask = LVIF_PARAM | LVIF_TEXT;
                lvi.iSubItem = 0;
                lvi.pszText = pFl[i]->szFile;
                lvi.lParam = (LPARAM)pFl[i];
                if (ListView_InsertItem (hWnd, &lvi) == -1)
                  {
                    MessageBox (hDlg, _T("ListView_InsertItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    MemoryFree (pFl);
                    EndDialog (hDlg, IDCANCEL);
                    return 0;
                  }
                wsprintf (szText, _T("%uMB"),
                                        (UINT)(pFl[i]->uiBytes / 1024 / 1024));
                lvi.mask = LVIF_TEXT;
                lvi.pszText = szText;
                lvi.iSubItem = 1;
                if (!ListView_SetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    MemoryFree (pFl);
                    EndDialog (hDlg, IDCANCEL);
                    return 0;
                  }
              }
            MemoryFree (pFl);
            while ((nIndex = ListView_GetNextItem (hWnd,
                                                    -1, LVNI_SELECTED)) != -1)
              if (!ListView_DeleteItem (hWnd, nIndex))
                {
                  MessageBox (hDlg, _T("ListView_DeleteItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return 0;
                }
            goto loop;
          }
        return 0;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                HWND hWnd;
                LV_ITEM lvi;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW21);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                MemoryFree (lpFileList);
                lpFileList = NULL;
                nFileList = ListView_GetItemCount (hWnd);
                if (nFileList > 0 && !(lpFileList = MemoryAlloc (nFileList
                                                        * sizeof (FILELIST))))
                  {
                    MessageBox (hDlg, _T("MemoryAlloc"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    nFileList = 0;
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                lvi.mask = LVIF_PARAM;
                lvi.iSubItem = 0;
                for (lvi.iItem = 0; lvi.iItem < nFileList; lvi.iItem++)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    lpFileList[lvi.iItem] = *(LPFILELIST)lvi.lParam;
                  }
                GetDlgItemText (hDlg, IDC_EDIT21, szCaptureFile, MAXPATH);
                uiMaxBytes = (UINT64)GetDlgItemInt (hDlg, IDC_EDIT22,
                                                    NULL, FALSE) * 1024 * 1024;
                GetDlgItemText (hDlg, IDC_EDIT23, szFrameFile, MAXPATH);
                uFrame = GetDlgItemInt (hDlg, IDC_EDIT24, NULL, FALSE);
                fNumFrame = IsDlgButtonChecked (hDlg, IDC_CHECKBOX21)
                                                                == BST_CHECKED;
              }
            case IDCANCEL:
              {
                int i, nCount;
                HWND hWnd;
                LV_ITEM lvi;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW21);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                nCount = ListView_GetItemCount (hWnd);
                for (i = 0; i < nCount; i++)
                  {
                    lvi.mask = LVIF_PARAM;
                    lvi.iItem = i;
                    lvi.iSubItem = 0;
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        break;
                      }
                    MemoryFree ((LPFILELIST)lvi.lParam);
                  }
                if (hImage && !ImageList_Destroy (hImage))
                  MessageBox (hDlg, _T("ImageList_Destroy"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                if (!EndDialog (hDlg, LOWORD (wParam)))
                  MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              }
              return TRUE;
            case IDC_CHECKBOX21:
              {
                BOOL fResult;

                fResult = IsDlgButtonChecked (hDlg, IDC_CHECKBOX21)
                                                                == BST_CHECKED;
                if (!EnableDlgItem (hDlg, IDC_EDIT24, fResult)
                            || !EnableDlgItem (hDlg, IDC_UPDOWN22, fResult))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              goto loop;
            case IDC_EDIT21:
            case IDC_EDIT22:
              if (HIWORD (wParam) != EN_CHANGE)
                return TRUE;
              EnableDlgItem (hDlg, IDC_PUSHBUTTON22, SendDlgItemMessage (hDlg,
                                        IDC_EDIT21, WM_GETTEXTLENGTH, 0, 0) > 0
                        && GetDlgItemInt (hDlg, IDC_EDIT22, NULL, FALSE) > 0);
              EnableDlgItem (hDlg, IDC_PUSHBUTTON25, SendDlgItemMessage (hDlg,
                                        IDC_EDIT21, WM_GETTEXTLENGTH, 0, 0) > 0
                        && GetDlgItemInt (hDlg, IDC_EDIT22, NULL, FALSE) > 0);
              goto loop;
            case IDC_EDIT23:
            case IDC_EDIT24:
              if (HIWORD (wParam) != EN_CHANGE)
                return TRUE;
              goto loop;
            case IDC_PUSHBUTTON22:/* ja:ǉ */
              {
                HWND hWnd;
                LV_ITEM lvi;
                TCHAR szText[128];

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW21);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                (LPFILELIST)lvi.lParam = MemoryAlloc (sizeof (FILELIST));
                if (!lvi.lParam)
                  {
                    MessageBox (hDlg, _T("MemoryAlloc"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                GetDlgItemText (hDlg, IDC_EDIT21,
                                    ((LPFILELIST)lvi.lParam)->szFile, MAXPATH);
                ((LPFILELIST)lvi.lParam)->uiBytes = (UINT64)GetDlgItemInt
                                (hDlg, IDC_EDIT22, NULL, FALSE) * 1024 * 1024;
                lvi.mask = LVIF_PARAM | LVIF_TEXT;
                lvi.pszText = ((LPFILELIST)lvi.lParam)->szFile;
                lvi.iItem = ListView_GetItemCount (hWnd);
                lvi.iSubItem = 0;
                if (ListView_InsertItem (hWnd, &lvi) == -1)
                  {
                    MessageBox (hDlg, _T("ListView_InsertItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                wsprintf (szText, _T("%uMB"),
                    (UINT)(((LPFILELIST)lvi.lParam)->uiBytes / 1024 / 1024));
                lvi.mask = LVIF_TEXT;
                lvi.pszText = szText;
                lvi.iSubItem = 1;
                if (!ListView_SetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              goto loop;
            case IDC_PUSHBUTTON23:/* ja:폜 */
              {
                HWND hWnd;
                LV_ITEM lvi;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW21);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                lvi.mask = LVIF_PARAM;
                lvi.iSubItem = 0;
                while ((lvi.iItem = ListView_GetNextItem (hWnd, -1,
                                            LVNI_ALL | LVNI_SELECTED)) != -1)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    MemoryFree ((LPFILELIST)lvi.lParam);
                    if (!ListView_DeleteItem (hWnd, lvi.iItem))
                      {
                        MessageBox (hDlg, _T("ListView_DeleteItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                  }
              }
              goto loop;
            case IDC_PUSHBUTTON24:/* ja:ړ */
              {
                int nIndex;
                HWND hWnd;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW21);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                while ((nIndex = ListView_GetNextItem (hWnd, -1,
                                            LVNI_ALL | LVNI_SELECTED)) != -1)
                  {
                    LV_ITEM lvi;
                    TCHAR szText[128];

                    lvi.mask = LVIF_PARAM;
                    lvi.iItem = nIndex;
                    lvi.iSubItem = 0;
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    lvi.mask = LVIF_PARAM | LVIF_TEXT;
                    lvi.pszText = ((LPFILELIST)lvi.lParam)->szFile;
                    lvi.iItem = ListView_GetItemCount (hWnd);
                    if (ListView_InsertItem (hWnd, &lvi) == -1)
                      {
                        MessageBox (hDlg, _T("ListView_InsertItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    wsprintf (szText, _T("%uMB"),
                      (UINT)(((LPFILELIST)lvi.lParam)->uiBytes / 1024 / 1024));
                    lvi.mask = LVIF_TEXT;
                    lvi.pszText = szText;
                    lvi.iSubItem = 1;
                    if (!ListView_SetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_SetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    if (!ListView_DeleteItem (hWnd, nIndex))
                      {
                        MessageBox (hDlg, _T("ListView_DeleteItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                  }
              }
              goto loop;
            case IDC_PUSHBUTTON25:/* ja:m */
              {
                int nCount;
                HWND hWnd;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW21);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                nCount = ListView_GetItemCount (hWnd);
                if (nCount == 0)
                  {
                    TCHAR szFile[MAXPATH];

                    GetDlgItemText (hDlg, IDC_EDIT21, szFile, MAXPATH);
                    AllocateFile (szFile, (UINT64)GetDlgItemInt (hDlg,
                                IDC_EDIT22, NULL, FALSE) * 1024 * 1024, TRUE);
                  }
                else
                  {
                    LV_ITEM lvi;

                    lvi.mask = LVIF_PARAM;
                    lvi.iSubItem = 0;
                    for (lvi.iItem = 0; lvi.iItem < nCount; lvi.iItem++)
                      {
                        if (!ListView_GetItem (hWnd, &lvi))
                          {
                            MessageBox (hDlg, _T("ListView_GetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                            EndDialog (hDlg, IDCANCEL);
                            return TRUE;
                          }
                        if (!AllocateFile (((LPFILELIST)lvi.lParam)->szFile,
                                    ((LPFILELIST)lvi.lParam)->uiBytes, TRUE))
                          break;
                      }
                  }
              }
              return TRUE;
            case IDC_PUSHBUTTON21:
            case IDC_PUSHBUTTON26:
              {
                FNDIR fd;
                OPENFILENAME ofn;
                TCHAR szFile[MAXPATH], szPath[MAXPATH];

                if (LOWORD (wParam) == IDC_PUSHBUTTON21)
                  {
                    GetDlgItemText (hDlg, IDC_EDIT21, szFile, MAXPATH);
                    switch (stProperty.uFormat)
                      {
                        case 0:
                          ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_STD);
                          ofn.lpstrDefExt = _T("avi");
                          break;
                        case 1:
                          ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_AVI);
                          ofn.lpstrDefExt = _T("avi");
                          break;
                        case 2:
                          ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_GSR);
                          ofn.lpstrDefExt = _T("gsr");
                          break;
                        default:
                          ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_DBG);
                          ofn.lpstrDefExt = _T("txt");
                      }
                  }
                else
                  {
                    GetDlgItemText (hDlg, IDC_EDIT23, szFile, MAXPATH);
                    ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_BMP);
                    ofn.lpstrDefExt = _T("bmp");
                  }
                SplitFileName (szFile, &fd);
                lstrcpy (szPath, fd.szDrive);
                lstrcat (szPath, fd.szDir);
                lstrcpy (szFile, fd.szName);
                lstrcat (szFile, fd.szExt);
                ofn.lStructSize = sizeof (OPENFILENAME);
                ofn.hwndOwner = hDlg;
                ofn.nFilterIndex = 1;
                ofn.lpstrCustomFilter = NULL;
                ofn.lpstrFile = szFile;
                ofn.nMaxFile = MAXPATH;
                ofn.lpstrFileTitle = NULL;
                ofn.lpstrInitialDir = szPath;
                ofn.lpstrTitle = NULL;
                ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR
                                                        | OFN_PATHMUSTEXIST;
                if (!GetSaveFileName (&ofn))
                    return FALSE;
                if (!SetDlgItemText (hDlg, LOWORD (wParam) == IDC_PUSHBUTTON21
                                            ? IDC_EDIT21 : IDC_EDIT23, szFile))
                  {
                    MessageBox (hDlg, _T("SetDlgItemText"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              loop:
              if (!EnableDlgItem (hDlg, IDOK,
                            GetDlgItemInt (hDlg, IDC_EDIT22, NULL, FALSE) > 0))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog(hDlg,IDCANCEL);
                }
          }
        return TRUE;
    }
  return FALSE;
}
