/*
    GtkShot for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "bmmacro.h"
#include "dialog.h"
#include "error.h"
#include "gshot.h"
#include "memapi.h"
#include "other.h"
#include "prop.h"
#include "save.h"
#include "resource.h"
#include "timer.h"
#include "valstr.h"
#include <commctrl.h>
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
/*  ^C}\בւ
    RET,:lParam2,:lParam1,0:                                */
static int CALLBACK
ListViewRecCallback (LPARAM lParam1,
                     LPARAM lParam2,
                     LPARAM lParam)
{
  int i, n1 = 0, n2 = 0;

  /* ja:j */
  for (i = 0; i < 7; i++)
    {
      if (((LPRECORD)lParam1)->dwWeeks >> i & 1
                                    && !((LPRECORD)lParam2)->dwWeeks >> i & 1)
        return -1;
      else if (!((LPRECORD)lParam1)->dwWeeks >> i & 1
                                    && ((LPRECORD)lParam2)->dwWeeks >> i & 1)
        return 1;
    }
  /* ja: */
  n1 = ((((LPRECORD)lParam1)->nDay * 24 + ((LPRECORD)lParam1)->nHour) * 60
        + ((LPRECORD)lParam1)->nMinute) * 60 + ((LPRECORD)lParam1)->nSecond;
  n2 = ((((LPRECORD)lParam2)->nDay * 24 + ((LPRECORD)lParam2)->nHour) * 60
        + ((LPRECORD)lParam2)->nMinute) * 60 + ((LPRECORD)lParam2)->nSecond;
  if (n1 != n2)
    return n1 - n2;
  /* ja:Ԃ */
  if (((LPRECORD)lParam1)->uTimeLimit != ((LPRECORD)lParam2)->uTimeLimit)
    return ((LPRECORD)lParam2)->uTimeLimit - ((LPRECORD)lParam1)->uTimeLimit;
  /* ja:t@C̐ */
  return ((LPRECORD)lParam2)->nFileList - ((LPRECORD)lParam1)->nFileList;
}


BOOL CALLBACK
TimerDlgProc (HWND   hDlg,
              UINT   uMsg,
              WPARAM wParam,
              LPARAM lParam)
{
  static BOOL fComboBox;
  static HIMAGELIST hImage;
  static POINT ptDrag;
  static PROPERTY stProp;
  static int nTimeList[8] = {15, 30, 45, 60, 90, 120, 150, 180};

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i, nLength;
          HWND hWnd;
          LV_COLUMN lvc;
          RECT rc;
          SYSTEMTIME stSysTime;
          TCHAR szText[128];

          fComboBox = TRUE;
          hImage = NULL;
          stProp = stProperty;
          if (!(stProp.lpWfx = MemoryAlloc (dwMaxSizeFormat))
                    || stProperty.cbState > 0
                && !(stProp.lpState = MemoryAlloc (stProperty.cbState)))
            {
              MessageBox (hDlg, _T("MemoryAlloc"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          MemoryCopy (stProp.lpWfx, stProperty.lpWfx, dwMaxSizeFormat);
          MemoryCopy (stProp.lpState, stProperty.lpState, stProperty.cbState);
          if (stProperty.lpBmiOut)
            {
              nLength = bmHdrByte ((LPBITMAPINFOHEADER)stProperty.lpBmiOut);
              stProp.lpBmiOut = MemoryAlloc (nLength);
              if (!stProp.lpBmiOut)
                {
                  MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              MemoryCopy (stProp.lpBmiOut, stProperty.lpBmiOut, nLength);
            }
          /* ja:`FbN{bNX̐ݒ */
          if (!CheckDlgButton (hDlg, IDC_CHECKBOX88,
                                        fTimer ? BST_CHECKED : BST_UNCHECKED))
            {
              MessageBox (hDlg, _T("CheckDlgButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:R{{bNX̐ݒ */
          SendDlgItemMessage (hDlg, IDC_COMBOBOX81, CB_LIMITTEXT, 12, 0);
          for (i = 0; i < 8; i++)
            {
              wsprintf (szText, _T("%d"), nTimeList[i]);
              if (SendDlgItemMessage (hDlg, IDC_COMBOBOX81, CB_ADDSTRING,
                                                        0, (LPARAM)szText) < 0)
                {
                  MessageBox (hDlg, _T("CB_ADDSTRING"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
            }
          if (!SetDlgItemInt (hDlg, IDC_COMBOBOX81, 0, FALSE))
            {
              MessageBox (hDlg, _T("SetDlgItemInt"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:GfBgRg[̐ݒ */
          for (i = IDC_EDIT81; i <= IDC_EDIT8A; i++)
            SendDlgItemMessage (hDlg, i, EM_LIMITTEXT, 12, 0);
          SendDlgItemMessage (hDlg, IDC_EDIT88, EM_LIMITTEXT, MAXPATH, 0);
          if (!SetDlgItemText (hDlg, IDC_EDIT88, szCaptureFile))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          GetLocalTime (&stSysTime);
          if (!SetDlgItemInt (hDlg, IDC_EDIT81, stSysTime.wDay, FALSE)
                || !SetDlgItemInt (hDlg,IDC_EDIT82, stSysTime.wHour, FALSE)
                || !SetDlgItemInt (hDlg,IDC_EDIT83, stSysTime.wMinute, FALSE)
                || !SetDlgItemInt (hDlg,IDC_EDIT84, stSysTime.wSecond, FALSE)
                || !SetDlgItemInt (hDlg,IDC_EDIT85, stSysTime.wHour, FALSE)
                || !SetDlgItemInt (hDlg,IDC_EDIT86, stSysTime.wMinute, FALSE)
                || !SetDlgItemInt (hDlg,IDC_EDIT87, stSysTime.wSecond, FALSE)
                || !SetDlgItemInt (hDlg,IDC_EDIT89,
                                    (UINT)(uiMaxBytes / 1024 / 1024), FALSE)
                || !SetDlgItemInt (hDlg, IDC_EDIT8A, 0, FALSE))
            {
              MessageBox (hDlg, _T("SetDlgItemInt"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Xgr[̐ݒ */
          hWnd = GetDlgItem (hDlg, IDC_LISTVIEW81);
          if (!hWnd)
            {
              MessageBox (hDlg, _T("GetDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!GetClientRect (hWnd, &rc))
            {
              MessageBox (hDlg, _T("GetClientRect"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          rc.right -= GetSystemMetrics (SM_CXVSCROLL);
          lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
          lvc.fmt = LVCFMT_LEFT;
          lvc.cx = rc.right * 4 / 15;
          lvc.pszText = LoadText (hInst, IDS_TIMER_START);
          lvc.iSubItem = 0;
          if (ListView_InsertColumn (hWnd, 0, &lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          lvc.cx = rc.right / 5;
          lvc.pszText = LoadText (hInst, IDS_TIMER_END);
          lvc.iSubItem = 1;
          if (ListView_InsertColumn (hWnd, 1, &lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          lvc.pszText = LoadText (hInst, IDS_TIMER_FORMAT);
          lvc.cx = rc.right * 2 / 15;
          lvc.iSubItem = 2;
          if (ListView_InsertColumn (hWnd, 2, &lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          lvc.fmt = LVCFMT_RIGHT;
          lvc.cx = rc.right / 10;
          lvc.pszText = LoadText (hInst, IDS_TIMER_RATE);
          lvc.iSubItem = 3;
          if (ListView_InsertColumn (hWnd, 3, &lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          lvc.fmt = LVCFMT_LEFT;
          lvc.cx = rc.right * 3 / 10;
          lvc.pszText = LoadText (hInst, IDS_TIMER_FILE);
          lvc.iSubItem = 4;
          if (ListView_InsertColumn (hWnd, 4, &lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          for (i = 0; i < nRecordList; i++)
            {
              int nHour, nMinute, nSecond;
              LV_ITEM lvi;

              (LPRECORD)lvi.lParam = MemoryAlloc (sizeof (RECORD));
              if (!lvi.lParam)
                {
                  MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              *(LPRECORD)lvi.lParam = lpRecordList[i];
              /* ja:t@CXg */
              ((LPRECORD)lvi.lParam)->lpFileList = MemoryAlloc
                            (lpRecordList[i].nFileList * sizeof (FILELIST));
              if (!((LPRECORD)lvi.lParam)->lpFileList)
                {
                  MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              MemoryCopy (((LPRECORD)lvi.lParam)->lpFileList,
                                lpRecordList[i].lpFileList,
                                lpRecordList[i].nFileList * sizeof (FILELIST));
              /* ja:vpeB */
              ((LPRECORD)lvi.lParam)->stProp = lpRecordList[i].stProp;
              ((LPRECORD)lvi.lParam)->stProp.lpWfx
                                            = MemoryAlloc (dwMaxSizeFormat);
              if (!((LPRECORD)lvi.lParam)->stProp.lpWfx)
                {
                  MessageBox (hDlg, _T("MemoryAlloc"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              MemoryCopy (((LPRECORD)lvi.lParam)->stProp.lpWfx,
                                lpRecordList[i].stProp.lpWfx, dwMaxSizeFormat);
              if (((LPRECORD)lvi.lParam)->stProp.cbState > 0)
                {
                  ((LPRECORD)lvi.lParam)->stProp.lpState = MemoryAlloc
                                    (((LPRECORD)lvi.lParam)->stProp.cbState);
                  if (!((LPRECORD)lvi.lParam)->stProp.lpState)
                    {
                      MessageBox (hDlg, _T("MemoryAlloc"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                      EndDialog (hDlg, IDCANCEL);
                      return TRUE;
                    }
                  MemoryCopy (((LPRECORD)lvi.lParam)->stProp.lpState,
                                    lpRecordList[i].stProp.lpState,
                                    ((LPRECORD)lvi.lParam)->stProp.cbState);
                }
              if (lpRecordList[i].stProp.lpBmiOut)
                {
                  nLength = bmHdrByte ((LPBITMAPINFOHEADER)
                                            lpRecordList[i].stProp.lpBmiOut);
                  ((LPRECORD)lvi.lParam)->stProp.lpBmiOut
                                                    = MemoryAlloc (nLength);
                  if (!((LPRECORD)lvi.lParam)->stProp.lpBmiOut)
                    {
                      MessageBox (hDlg, _T("MemoryAlloc"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                      EndDialog (hDlg, IDCANCEL);
                      return TRUE;
                    }
                  MemoryCopy (((LPRECORD)lvi.lParam)->stProp.lpBmiOut,
                                    lpRecordList[i].stProp.lpBmiOut, nLength);
                }
              /* ja:Jn */
              if (lpRecordList[i].dwWeeks == 0)
                {
                  wsprintf (szText, LoadText (hInst, IDS_TIMER_DAY),
                                                    lpRecordList[i].nDay,
                                                    lpRecordList[i].nHour,
                                                    lpRecordList[i].nMinute,
                                                    lpRecordList[i].nSecond);
                }
              else
                {
                  int j;
                  TCHAR szWeek[128];

                  szWeek[0] = '\0';
                  for (j = 0; j < 7; j++)
                    if (lpRecordList[i].dwWeeks >> j & 1)
                      {
                        GetDlgItemText (hDlg, j +  IDC_CHECKBOX81,
                                                                szText, 128);
                        lstrcat (szWeek, szText);
                      }
                  wsprintf (szText, LoadText (hInst, IDS_TIMER_WEEK), szWeek,
                                                    lpRecordList[i].nHour,
                                                    lpRecordList[i].nMinute,
                                                    lpRecordList[i].nSecond);
                }
              lvi.mask = LVIF_TEXT | LVIF_PARAM;
              lvi.pszText = szText;
              lvi.iItem = ListView_GetItemCount (hWnd);
              lvi.iSubItem = 0;
              if (ListView_InsertItem (hWnd, &lvi) == -1)
                {
                  MessageBox (hDlg, _T("ListView_InsertItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              /* ja:I */
              nSecond = lpRecordList[i].nSecond + lpRecordList[i].uTimeLimit;
              nMinute = lpRecordList[i].nMinute + nSecond / 60;
              nHour = lpRecordList[i].nHour + nMinute / 60;
              wsprintf (szText, LoadText (hInst, IDS_TIMER_TIME),
                                    nHour % 24, nMinute % 60, nSecond % 60);
              lvi.mask = LVIF_TEXT;
              lvi.iSubItem = 1;
              if (!ListView_SetItem (hWnd, &lvi))
                {
                  MessageBox (hDlg, _T("ListView_SetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              /* ja:` */
              lvi.pszText = lpszFormat[lpRecordList[i].stProp.uFormat];
              lvi.iSubItem = 2;
              if (!ListView_SetItem (hWnd, &lvi))
                {
                  MessageBox (hDlg, _T("ListView_SetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              /* ja:[g */
              FloatStr (lpRecordList[i].stProp.dwRate, 1000, szText);
              lvi.pszText = szText;
                lvi.iSubItem = 3;
              if (!ListView_SetItem (hWnd, &lvi))
                {
                  MessageBox (hDlg, _T("ListView_SetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
              /* ja:t@C */
              lvi.pszText = lpRecordList[i].lpFileList[0].szFile;
              lvi.iSubItem = 4;
              if (!ListView_SetItem (hWnd, &lvi))
                {
                  MessageBox (hDlg, _T("ListView_SetItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
            }
          /* ja:Xgr[̐ݒ */
          hWnd = GetDlgItem (hDlg, IDC_LISTVIEW82);
          if (!hWnd)
            {
              MessageBox (hDlg, _T("GetDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!GetClientRect (hWnd, &rc))
            {
              MessageBox (hDlg, _T("GetClientRect"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          rc.right -= GetSystemMetrics (SM_CXVSCROLL);
          lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
          lvc.fmt = LVCFMT_LEFT;
          lvc.cx = rc.right / 4 * 3;
          lvc.pszText = LoadText (hInst, IDS_LIST_NAME);
          lvc.iSubItem = 0;
          if (ListView_InsertColumn (hWnd, 0,& lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          lvc.fmt = LVCFMT_RIGHT;
          lvc.cx = rc.right / 4;
          lvc.pszText = LoadText (hInst, IDS_LIST_SIZE);
          lvc.iSubItem = 1;
          if (ListView_InsertColumn (hWnd, 1, &lvc) == -1)
            {
              MessageBox (hDlg, _T("ListView_InsertColumn"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Abv_ERg[̐ݒ */
          SendDlgItemMessage (hDlg, IDC_UPDOWN81,
                                UDM_SETRANGE, 0, MAKELPARAM (31, 1));
          SendDlgItemMessage (hDlg, IDC_UPDOWN82,
                                UDM_SETRANGE, 0, MAKELPARAM (23, 0));
          SendDlgItemMessage (hDlg, IDC_UPDOWN83,
                                UDM_SETRANGE, 0, MAKELPARAM (59, 0));
          SendDlgItemMessage (hDlg, IDC_UPDOWN84,
                                UDM_SETRANGE, 0, MAKELPARAM (59, 0));
          SendDlgItemMessage (hDlg, IDC_UPDOWN85,
                                UDM_SETRANGE, 0, MAKELPARAM (23, 0));
          SendDlgItemMessage (hDlg, IDC_UPDOWN86,
                                UDM_SETRANGE, 0, MAKELPARAM (59, 0));
          SendDlgItemMessage (hDlg, IDC_UPDOWN87,
                                UDM_SETRANGE, 0, MAKELPARAM (59, 0));
          SendDlgItemMessage (hDlg, IDC_UPDOWN88,
                                UDM_SETRANGE, 0, MAKELPARAM (UD_MAXVAL, 1));
          SendDlgItemMessage (hDlg, IDC_UPDOWN89,
                                UDM_SETRANGE, 0, MAKELPARAM (UD_MAXVAL, 0));
          /* ja:Rg[̕\ */
          if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON85, FALSE)
                                        || !EnableDlgItem (hDlg, IDOK, FALSE))
            {
              MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_NOTIFY:
        if (LOWORD (wParam) == IDC_LISTVIEW81)
          switch (((LPNMHDR)lParam)->code)
            {
              case LVN_ITEMCHANGED:/* ja:IȂǂω */
                {
                  int i, nHour, nMinute, nSecond, nCount;
                  HWND hWnd;
                  LV_ITEM lvi;
                  TCHAR szText[128];

                  /* ja:Rg[̕\ */
                  if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON88,
                                            ListView_GetSelectedCount
                                            (((LPNMHDR)lParam)->hwndFrom) > 0))
                    {
                      MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                    }
                  if (!(((LPNM_LISTVIEW)lParam)->uNewState & LVIS_FOCUSED)
                        || ((LPNM_LISTVIEW)lParam)->uOldState & LVIS_FOCUSED)
                    return 0;
                  /* ja:`FbN{bNX̐ݒ */
                  for (i = 0; i < 7; i++)
                    if (!CheckDlgButton (hDlg, i + IDC_CHECKBOX81, ((LPRECORD)
                        (((LPNM_LISTVIEW)lParam)->lParam))->dwWeeks >> i & 1
                                                ? BST_CHECKED : BST_UNCHECKED))
                      {
                        MessageBox (hDlg, _T("CheckDlgButton"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return 0;
                      }
                  /* ja:GfBgRg[̐ݒ */
                  nSecond = ((LPRECORD)
                                    (((LPNM_LISTVIEW)lParam)->lParam))->nSecond
                            + ((LPRECORD)
                                (((LPNM_LISTVIEW)lParam)->lParam))->uTimeLimit;
                  nMinute = ((LPRECORD)(((LPNM_LISTVIEW)lParam)->lParam))->
                                                        nMinute + nSecond / 60;
                  nHour = ((LPRECORD)(((LPNM_LISTVIEW)lParam)->lParam))->
                                                        nHour + nMinute / 60;
                  if (!SetDlgItemInt (hDlg, IDC_EDIT81, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->nDay, TRUE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT82, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->nHour, TRUE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT83, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->nMinute, TRUE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT84, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->nSecond, TRUE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT85, nHour % 24,TRUE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT86, nMinute % 60, TRUE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT87, nSecond % 60, TRUE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT8A, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->uAlloc, FALSE))
                    {
                      MessageBox (hDlg, _T("SetDlgItemInt"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  /* ja:Rg[̕\ */
                  if (!EnableDlgItem (hDlg, IDC_EDIT81, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->dwWeeks == 0)
                        || !EnableDlgItem (hDlg, IDC_STATIC81,( (LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->dwWeeks == 0)
                        || !EnableDlgItem (hDlg, IDC_UPDOWN81, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->dwWeeks == 0))
                    {
                      MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  /* ja:vpeB */
                  MemoryFree (stProp.lpState);
                  MemoryFree (stProp.lpBmiOut);
                  stProp.lpState = NULL;
                  stProp.lpBmiOut = NULL;
                  stProp.fAudio = ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->stProp.fAudio;
                  stProp.dwRate = ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->stProp.dwRate;
                  stProp.uFormat = ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->stProp.uFormat;
                  stProp.fccHandler = ((LPRECORD)
                        (((LPNM_LISTVIEW)lParam)->lParam))->stProp.fccHandler;
                  stProp.lKey = ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->stProp.lKey;
                  stProp.lDataRate = ((LPRECORD)
                        (((LPNM_LISTVIEW)lParam)->lParam))->stProp.lDataRate;
                  stProp.lQ = ((LPRECORD)
                                (((LPNM_LISTVIEW)lParam)->lParam))->stProp.lQ;
                  stProp.cbState = ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->stProp.cbState;
                  MemoryCopy (stProp.lpWfx, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->stProp.lpWfx,
                                                            dwMaxSizeFormat);
                  if (stProp.cbState > 0)
                    {
                      stProp.lpState = MemoryAlloc (stProp.cbState);
                      if (!stProp.lpState)
                        {
                          MessageBox (hDlg, _T("MemoryAlloc"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                          EndDialog (hDlg, IDCANCEL);
                          return TRUE;
                        }
                      MemoryCopy (stProp.lpState, ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->stProp.lpState,
                                                            stProp.cbState);
                    }
                  if (((LPRECORD)(((LPNM_LISTVIEW)lParam)->lParam))->
                                                            stProp.lpBmiOut)
                    {
                      int nLength;

                      nLength = bmHdrByte ((LPBITMAPINFOHEADER)((LPRECORD)
                                        (((LPNM_LISTVIEW)lParam)->lParam))->
                                                            stProp.lpBmiOut);
                      stProp.lpBmiOut = MemoryAlloc (nLength);
                      if (!stProp.lpBmiOut)
                        {
                          MessageBox (hDlg, _T("MemoryAlloc"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                          EndDialog (hDlg, IDCANCEL);
                          return TRUE;
                        }
                      MemoryCopy (stProp.lpBmiOut, ((LPRECORD)
                                        (((LPNM_LISTVIEW)lParam)->lParam))->
                                                    stProp.lpBmiOut, nLength);
                    }
                  /* ja:Xgr[̐ݒ */
                  hWnd = GetDlgItem (hDlg, IDC_LISTVIEW82);
                  if (!hWnd)
                    {
                      MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  nCount = ListView_GetItemCount (hWnd);
                  lvi.mask = LVIF_PARAM;
                  lvi.iSubItem = 0;
                  for (lvi.iItem = 0; lvi.iItem < nCount; lvi.iItem++)
                    {
                      if (!ListView_GetItem (hWnd, &lvi))
                        {
                          MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      MemoryFree ((LPFILELIST)lvi.lParam);
                    }
                  if (!ListView_DeleteAllItems (hWnd))
                    {
                      MessageBox (hDlg, _T("ListView_DeleteAllItems"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  for (i = 0; i < ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->nFileList; i++)
                    {
                      (LPFILELIST)lvi.lParam = MemoryAlloc (sizeof (FILELIST));
                      if (!lvi.lParam)
                        {
                          MessageBox (hDlg, _T("MemoryAlloc"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      lvi.mask = LVIF_TEXT | LVIF_PARAM;
                      lvi.pszText = ((LPRECORD)(((LPNM_LISTVIEW)lParam)->
                                                lParam))->lpFileList[i].szFile;
                      lvi.iItem = ListView_GetItemCount (hWnd);
                      lvi.iSubItem = 0;
                      *(LPFILELIST)lvi.lParam = ((LPRECORD)
                            (((LPNM_LISTVIEW)lParam)->lParam))->lpFileList[i];
                      if (ListView_InsertItem (hWnd, &lvi) == -1)
                        {
                          MessageBox (hDlg, _T("ListView_InsertItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      wsprintf (szText, _T("%uMB"),
                            (UINT)(((LPRECORD)(((LPNM_LISTVIEW)lParam)->
                            lParam))->lpFileList[i].uiBytes / 1024 / 1024));
                      lvi.mask = LVIF_TEXT;
                      lvi.pszText = szText;
                      lvi.iSubItem = 1;
                      if (!ListView_SetItem (hWnd, &lvi))
                        {
                          MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                    }
                }
            }
        else if (LOWORD (wParam) == IDC_LISTVIEW82)
          switch (((LPNMHDR)lParam)->code)
            {
              case LVN_BEGINDRAG:
                {
                  int nIndex, nSelected;
                  POINT pt;
                  RECT rc, rc0, rc1;

                  nSelected = 0;
                  nIndex = -1;
                  while ((nIndex = ListView_GetNextItem
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                nIndex, LVNI_SELECTED)) != -1)
                    {
                      RECT rc2;

                      /* ja:hbO镔̍ŏ̋`߂ */
                      if (!ListView_GetItemRect (((LPNMHDR)lParam)->hwndFrom,
                                                    nIndex, &rc0, LVIR_LABEL)
                                || !ListView_GetItemRect
                                        (((LPNMHDR)lParam)->hwndFrom, nIndex,
                                                            &rc1, LVIR_ICON))
                        {
                          MessageBox (hDlg, _T("ListView_GetItemRect"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      UnionRect (&rc2, &rc0, &rc1);
                      if (nSelected == 0)
                        {
                          rc = rc2;
                        }
                      else
                        {
                          rc0 = rc;
                          UnionRect (&rc, &rc0, &rc2);
                        }
                      nSelected++;
                    }
                  if (nSelected <= 1)
                    {
                      hImage = ListView_CreateDragImage
                                        (((LPNMHDR)lParam)->hwndFrom,
                                        ((LPNM_LISTVIEW)lParam)->iItem, &pt);
                      if (!hImage)
                        {
                          MessageBox (hDlg, _T("ListView_CreateDragImage"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                    }
                  else
                    {
                      HBITMAP hBmp0, hBmp1;
                      HBRUSH hBrush0, hBrush1;
                      HDC hDC, hMemDC0, hMemDC1;
                      HPEN hPen0, hPen1;

                      /* ja:hbOp̃C[W */
                      hDC = GetDC (((LPNMHDR)lParam)->hwndFrom);
                      if (!hDC)
                        {
                          MessageBox (hDlg, _T("GetDC"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hMemDC0 = CreateCompatibleDC (hDC);
                      hMemDC1 = CreateCompatibleDC (hDC);
                      if (!hMemDC0 || !hMemDC1)
                        {
                          MessageBox (hDlg, _T("GetDC"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          if (hMemDC0)
                            DeleteDC (hMemDC0);
                          if (hMemDC1)
                            DeleteDC (hMemDC1);
                          ReleaseDC (((LPNMHDR)lParam)->hwndFrom, hDC);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hBmp0 = CreateCompatibleBitmap (hDC,
                                    rc.right - rc.left, rc.bottom - rc.top);
                      hBmp1 = CreateCompatibleBitmap (hDC,
                                    rc.right - rc.left, rc.bottom - rc.top);
                      if (!hBmp0 || !hBmp1)
                        {
                          MessageBox (hDlg, _T("CreateCompatibleBitmap"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          if (hBmp0)
                            DeleteObject (hBmp0);
                          if (hBmp1)
                            DeleteObject (hBmp1);
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          ReleaseDC (((LPNMHDR)lParam)->hwndFrom, hDC);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      if (ReleaseDC (((LPNMHDR)lParam)->hwndFrom, hDC) != 1)
                        {
                          MessageBox (hDlg, _T("ReleaseDC"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hBrush0 = GetStockObject (BLACK_BRUSH);
                      hBrush1 = GetStockObject (WHITE_BRUSH);
                      hPen1 = GetStockObject (BLACK_PEN);
                      if (!hBrush0 || !hBrush1 || !hPen1)
                        {
                          MessageBox (hDlg, _T("GetStockObject"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hBmp0 = SelectObject (hMemDC0, hBmp0);
                      hBmp1 = SelectObject (hMemDC1, hBmp1);
                      rc0 = rc;
                      OffsetRect (&rc0, -rc.left, -rc.top);
                      if (!FillRect (hMemDC0, &rc0, hBrush0)
                                        || !FillRect (hMemDC1, &rc0, hBrush1))
                        {
                          MessageBox (hDlg, _T("CreatePen"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (SelectObject (hMemDC0, hBmp0));
                          DeleteObject (SelectObject (hMemDC1, hBmp1));
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hPen0 = CreatePen (PS_SOLID, 0, RGB (128, 128, 128));
                      if (!hPen0)
                        {
                          MessageBox (hDlg, _T("CreatePen"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (SelectObject (hMemDC0, hBmp0));
                          DeleteObject (SelectObject (hMemDC1, hBmp1));
                          DeleteDC (hMemDC0);
                          DeleteDC (hMemDC1);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hBrush0 = SelectObject (hMemDC0, hBrush0);
                      hBrush1 = SelectObject (hMemDC1, hBrush1);
                      hPen0 = SelectObject (hMemDC0, hPen0);
                      hPen1 = SelectObject (hMemDC1, hPen1);
                      nIndex = -1;
                      while ((nIndex = ListView_GetNextItem
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                nIndex, LVNI_SELECTED)) != -1)
                        {
                          if (!ListView_GetItemRect
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                    nIndex, &rc0, LVIR_LABEL)
                                    || !ListView_GetItemRect
                                                (((LPNMHDR)lParam)->hwndFrom,
                                                    nIndex, &rc1, LVIR_ICON))
                            {
                              MessageBox (hDlg, _T("ListView_GetItemRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                              DeleteObject (SelectObject (hMemDC0, hBmp0));
                              DeleteObject (SelectObject (hMemDC1, hBmp1));
                              SelectObject (hMemDC0, hBrush0);
                              SelectObject (hMemDC1, hBrush1);
                              DeleteObject (SelectObject (hMemDC0, hPen0));
                              SelectObject (hMemDC1, hPen1);
                              DeleteDC (hMemDC0);
                              DeleteDC (hMemDC1);
                              EndDialog (hDlg, IDCANCEL);
                              return 0;
                            }
                          OffsetRect (&rc0, -rc.left, -rc.top);
                          OffsetRect (&rc1, -rc.left, -rc.top);
                          if (!MoveToEx (hMemDC0, rc0.left,
                                rc0.top + (rc0.bottom - rc0.top) / 2, NULL)
                                || !MoveToEx (hMemDC1, rc0.left,
                                rc0.top + (rc0.bottom - rc0.top) / 2, NULL))
                            {
                              MessageBox (hDlg, _T("MoveToEx"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                              DeleteObject (SelectObject (hMemDC0, hBmp0));
                              DeleteObject (SelectObject (hMemDC1, hBmp1));
                              SelectObject (hMemDC0, hBrush0);
                              SelectObject (hMemDC1, hBrush1);
                              DeleteObject (SelectObject (hMemDC0, hPen0));
                              SelectObject (hMemDC1, hPen1);
                              DeleteDC (hMemDC0);
                              DeleteDC (hMemDC1);
                              EndDialog (hDlg, IDCANCEL);
                              return 0;
                            }
                          if (!LineTo (hMemDC0, rc0.right,
                                        rc0.top + (rc0.bottom - rc0.top) / 2)
                                || !LineTo (hMemDC1, rc0.right,
                                        rc0.top + (rc0.bottom - rc0.top) / 2))
                            {
                              MessageBox (hDlg, _T("LineTo"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                              DeleteObject (SelectObject (hMemDC0, hBmp0));
                              DeleteObject (SelectObject (hMemDC1, hBmp1));
                              SelectObject (hMemDC0, hBrush0);
                              SelectObject (hMemDC1, hBrush1);
                              DeleteObject (SelectObject (hMemDC0, hPen0));
                              SelectObject (hMemDC1, hPen1);
                              DeleteDC (hMemDC0);
                              DeleteDC (hMemDC1);
                              EndDialog (hDlg, IDCANCEL);
                              return 0;
                            }
                          if (!Rectangle (hMemDC0, rc1.left, rc1.top,
                                                    rc1.right, rc1.bottom)
                                    || !Rectangle (hMemDC1, rc1.left, rc1.top,
                                                    rc1.right, rc1.bottom))
                            {
                              MessageBox (hDlg, _T("Rectangle"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                              DeleteObject (SelectObject (hMemDC0, hBmp0));
                              DeleteObject (SelectObject (hMemDC1, hBmp1));
                              SelectObject (hMemDC0, hBrush0);
                              SelectObject (hMemDC1, hBrush1);
                              DeleteObject (SelectObject (hMemDC0, hPen0));
                              SelectObject (hMemDC1, hPen1);
                              DeleteDC (hMemDC0);
                              DeleteDC (hMemDC1);
                              EndDialog (hDlg, IDCANCEL);
                              return 0;
                            }
                        }
                      hBmp0 = SelectObject (hMemDC0, hBmp0);
                      hBmp1 = SelectObject (hMemDC1, hBmp1);
                      SelectObject (hMemDC0, hBrush0);
                      SelectObject (hMemDC1, hBrush1);
                      hPen0 = SelectObject (hMemDC0, hPen0);
                      SelectObject (hMemDC1, hPen1);
                      if (!DeleteDC (hMemDC0) | !DeleteDC (hMemDC1))
                        {
                          MessageBox (hDlg, _T("Rectangle"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteObject (hPen0);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      hImage = ImageList_Create (rc.right - rc.left,
                                            rc.bottom - rc.top, TRUE, 1, 1);
                      if (!hImage)
                        {
                          MessageBox (hDlg, _T("ImageList_Create"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteObject (hPen0);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      if (ImageList_Add (hImage, hBmp0, hBmp1) == -1)
                        {
                          MessageBox (hDlg, _T("ImageList_Add"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          DeleteObject (hBmp0);
                          DeleteObject (hBmp1);
                          DeleteObject (hPen0);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      if (!DeleteObject (hBmp0) | !DeleteObject (hBmp1)
                                                    | !DeleteObject (hPen0))
                        {
                          MessageBox (hDlg, _T("Rectangle"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                          EndDialog (hDlg, IDCANCEL);
                          return 0;
                        }
                      pt.x = rc.left;
                      pt.y = rc.top;
                    }

                  ptDrag = ((LPNM_LISTVIEW)lParam)->ptAction;
                  if (MapWindowPoints (((LPNMHDR)lParam)->hwndFrom,
                                                        hDlg, &ptDrag, 1) == 0)
                    {
                      MessageBox (hDlg, _T("MapWindowPoints"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  if (!ImageList_BeginDrag (hImage, 0,
                                            ptDrag.x - pt.x, ptDrag.y - pt.y))
                    {
                      MessageBox (hDlg, _T("ImageList_BeginDrag"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  if (!ImageList_DragEnter (((LPNMHDR)lParam)->hwndFrom,
                                        ptDrag.x - rc.left, ptDrag.y - rc.top))
                    {
                      MessageBox (hDlg, _T("ImageList_DragEnter"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return 0;
                    }
                  SetCapture (hDlg);
                }
                break;
              case LVN_ITEMCHANGED:/* ja:IȂǂω */
                {
                  int nSelected;

                  nSelected = ListView_GetSelectedCount
                                                (((LPNMHDR)lParam)->hwndFrom);
                  /* ja:Rg[̕\ */
                  if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON83, nSelected > 0)
                    || !EnableDlgItem (hDlg,IDC_PUSHBUTTON84, nSelected > 0))
                    {
                      MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                    }
                }
                break;
              case LVN_DELETEITEM:/* ja:ACe */
                {
                  int nCount;

                  nCount = ListView_GetItemCount (((LPNMHDR)lParam)->hwndFrom);
                  if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON85, nCount > 1)
                            || nCount <= 1
                            && !EnableDlgItem (hDlg, IDC_PUSHBUTTON87, FALSE))
                    {
                      MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                    }
                }
                break;
              case LVN_INSERTITEM:/* ja:ACe */
                if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON85,
                    ListView_GetItemCount (((LPNMHDR)lParam)->hwndFrom) > 0))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return 0;
                  }
                goto loop;
              case LVN_COLUMNCLICK:/* ja:wb^NbN */
                ListView_SortItems (((LPNMHDR)lParam)->hwndFrom,
                        ListViewCallback, ((LPNM_LISTVIEW)lParam)->iSubItem);
                fSort[((LPNM_LISTVIEW)lParam)->iSubItem]
                                = !fSort[((LPNM_LISTVIEW)lParam)->iSubItem];
            }
        return 0;
      case WM_MOUSEMOVE:
        if (hImage && !ImageList_DragMove (LOWORD (lParam), HIWORD (lParam)))
          {
            MessageBox (hDlg, _T("ImageList_DragMove"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
          }
        return 0;
      case WM_LBUTTONUP:
        if (hImage)
          {
            int i = 0, nIndex, nSelected;
            HWND hWnd;
            FILELIST **pFl;
            LV_HITTESTINFO lht;
            LV_ITEM lvi;
            TCHAR szText[128];

            hWnd =GetDlgItem (hDlg, IDC_LISTVIEW82);
            if (!hWnd)
              {
                MessageBox (hDlg, _T("GetDlgItem"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return 0;
              }
            if (!ImageList_DragLeave (hWnd))
              {
                MessageBox (hDlg, _T("ImageList_DragLeave"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return 0;
              }
            ImageList_EndDrag ();
            if (!ImageList_Destroy (hImage))
              {
                MessageBox (hDlg, _T("ImageList_Destroy"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return 0;
              }
            hImage = NULL;
            ReleaseCapture ();
            lht.pt.x = LOWORD (lParam);
            lht.pt.y = HIWORD (lParam);
            if (MapWindowPoints (hDlg, hWnd, &lht.pt, 1) == 0)
              {
                MessageBox (hDlg, _T("MapWindowPoints"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return 0;
              }
            if (ListView_HitTest (hWnd, &lht) == -1)
              return 0;
            nSelected = ListView_GetSelectedCount (hWnd);
            pFl = MemoryAlloc (nSelected * sizeof (LPFILELIST));
            if (!pFl)
              {
                MessageBox (hDlg, _T("MemoryAlloc"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                EndDialog (hDlg, IDCANCEL);
                return TRUE;
              }
            lvi.mask = LVIF_PARAM;
            lvi.iItem = -1;
            lvi.iSubItem = 0;
            while ((lvi.iItem = ListView_GetNextItem (hWnd,
                                            lvi.iItem, LVNI_SELECTED)) != -1)
              {
                if (!ListView_GetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    MemoryFree (pFl);
                    EndDialog (hDlg, IDCANCEL);
                    return 0;
                  }
                pFl[i++] = (LPFILELIST)lvi.lParam;
              }
            lvi.iItem = lht.iItem;
            for (i = nSelected - 1; i >= 0; i--)
              {
                lvi.mask = LVIF_PARAM | LVIF_TEXT;
                lvi.iSubItem = 0;
                lvi.pszText = pFl[i]->szFile;
                lvi.lParam = (LPARAM)pFl[i];
                if (ListView_InsertItem (hWnd, &lvi) == -1)
                  {
                    MessageBox (hDlg, _T("ListView_InsertItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    MemoryFree (pFl);
                    EndDialog (hDlg, IDCANCEL);
                    return 0;
                  }
                wsprintf (szText, _T("%uMB"),
                                        (UINT)(pFl[i]->uiBytes / 1024 / 1024));
                lvi.mask = LVIF_TEXT;
                lvi.pszText = szText;
                lvi.iSubItem = 1;
                if (!ListView_SetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    MemoryFree (pFl);
                    EndDialog (hDlg, IDCANCEL);
                    return 0;
                  }
              }
            MemoryFree (pFl);
            while ((nIndex = ListView_GetNextItem (hWnd,
                                                    -1, LVNI_SELECTED)) != -1)
              if (!ListView_DeleteItem (hWnd, nIndex))
                {
                  MessageBox (hDlg, _T("ListView_DeleteItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return 0;
                }
          }
        return 0;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int i;
                HWND hWnd;
                LV_ITEM lvi;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW81);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                for (i = 0; i < nRecordList; i++)
                  {
                    MemoryFree (lpRecordList[i].stProp.lpWfx);
                    MemoryFree (lpRecordList[i].stProp.lpState);
                    MemoryFree (lpRecordList[i].stProp.lpBmiOut);
                    MemoryFree (lpRecordList[i].lpFileList);
                  }
                MemoryFree (lpRecordList);
                lpRecordList = NULL;
                nRecordList = ListView_GetItemCount (hWnd);
                if (nRecordList > 0
                                && !(lpRecordList = MemoryAlloc (nRecordList
                                                        * sizeof (RECORD))))
                  {
                    MessageBox (hDlg, _T("MemoryAlloc"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    nRecordList = 0;
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                lvi.mask = LVIF_PARAM;
                lvi.iSubItem = 0;
                for (lvi.iItem = 0; lvi.iItem < nRecordList; lvi.iItem++)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    lpRecordList[lvi.iItem] = *(LPRECORD)lvi.lParam;
                  }
                fTimer = IsDlgButtonChecked (hDlg, IDC_CHECKBOX88)
                                                                == BST_CHECKED;
              }
            case IDCANCEL:
              {
                int nCount;
                HWND hWnd;
                LV_ITEM lvi;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW81);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                nCount = ListView_GetItemCount (hWnd);
                lvi.mask = LVIF_PARAM;
                lvi.iSubItem = 0;
                for (lvi.iItem = 0; lvi.iItem < nCount; lvi.iItem++)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        break;
                      }
                    if (LOWORD (wParam) != IDOK)
                      {
                        MemoryFree (((LPRECORD)lvi.lParam)->stProp.lpWfx);
                        MemoryFree (((LPRECORD)lvi.lParam)->stProp.lpState);
                        MemoryFree (((LPRECORD)lvi.lParam)->stProp.lpBmiOut);
                        MemoryFree (((LPRECORD)lvi.lParam)->lpFileList);
                      }
                    MemoryFree ((LPRECORD)lvi.lParam);
                  }
                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW82);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    return TRUE;
                  }
                nCount = ListView_GetItemCount (hWnd);
                for (lvi.iItem = 0; lvi.iItem < nCount; lvi.iItem++)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        break;
                      }
                    MemoryFree ((LPFILELIST)lvi.lParam);
                  }
                if (hImage && !ImageList_Destroy (hImage))
                  MessageBox (hDlg, _T("ImageList_Destroy"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                MemoryFree (stProp.lpWfx);
                if (!EndDialog (hDlg, LOWORD (wParam)))
                  MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              }
              return TRUE;
            case IDC_CHECKBOX81:
            case IDC_CHECKBOX82:
            case IDC_CHECKBOX83:
            case IDC_CHECKBOX84:
            case IDC_CHECKBOX85:
            case IDC_CHECKBOX86:
            case IDC_CHECKBOX87:
              {
                int i;
                DWORD dwWeeks = 0;
                SYSTEMTIME stSysTime;

                for (i = IDC_CHECKBOX87; i >= IDC_CHECKBOX81; i--)
                  dwWeeks = dwWeeks << 1
                    | (IsDlgButtonChecked (hDlg, i) == BST_CHECKED ? 1 : 0);
                GetLocalTime (&stSysTime);
                if (!SetDlgItemInt (hDlg, IDC_EDIT81,
                                    dwWeeks == 0 ? stSysTime.wDay : 0, TRUE))
                  {
                    MessageBox (hDlg, _T("SetDlgItemInt"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                if (!EnableDlgItem (hDlg, IDC_EDIT81, dwWeeks == 0)
                        || !EnableDlgItem (hDlg, IDC_STATIC81, dwWeeks == 0)
                        || !EnableDlgItem (hDlg, IDC_UPDOWN81, dwWeeks == 0))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
              return TRUE;
            case IDC_COMBOBOX81:
              {
                int nIndex, nHour, nMinute;
                UINT uTime;

                switch (HIWORD (wParam))
                  {
                    case CBN_EDITCHANGE:
                      uTime = GetDlgItemInt (hDlg, IDC_COMBOBOX81,
                                                                NULL, FALSE);
                      break;
                    case CBN_SELCHANGE:
                      nIndex = SendDlgItemMessage (hDlg, IDC_COMBOBOX81,
                                                        CB_GETCURSEL, 0, 0);
                      if (nIndex == CB_ERR)
                        return TRUE;
                      uTime = nTimeList[nIndex];
                      break;
                    default:
                      return TRUE;
                  }
                fComboBox = FALSE;
                nMinute = GetDlgItemInt (hDlg, IDC_EDIT83, NULL, TRUE) + uTime;
                nHour = GetDlgItemInt (hDlg, IDC_EDIT82, NULL, TRUE)
                                                                + nMinute / 60;
                if (!SetDlgItemInt (hDlg, IDC_EDIT85, nHour % 24, FALSE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT86, nMinute % 60, FALSE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT87,
                        GetDlgItemInt (hDlg, IDC_EDIT84, NULL, TRUE), FALSE))
                  {
                    MessageBox (hDlg, _T("SetDlgItemInt"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                fComboBox = TRUE;
              }
              return TRUE;
            case IDC_EDIT81:
            case IDC_EDIT82:
            case IDC_EDIT83:
            case IDC_EDIT84:
            case IDC_EDIT85:
            case IDC_EDIT86:
            case IDC_EDIT87:
              if (HIWORD (wParam) != EN_CHANGE)
                return TRUE;
              loop:
              {
                int i, nDay, nHour0, nMinute0, nSecond0;
                int nHour1, nMinute1, nSecond1;
                DWORD dwWeeks = 0;
                INT nTime;

                nDay = GetDlgItemInt (hDlg, IDC_EDIT81, NULL, TRUE);
                nHour0 = GetDlgItemInt (hDlg, IDC_EDIT82, NULL, TRUE);
                nMinute0 = GetDlgItemInt (hDlg, IDC_EDIT83, NULL, TRUE);
                nSecond0 = GetDlgItemInt (hDlg, IDC_EDIT84, NULL, TRUE);
                nHour1 = GetDlgItemInt (hDlg, IDC_EDIT85, NULL, TRUE);
                nMinute1 = GetDlgItemInt (hDlg, IDC_EDIT86, NULL, TRUE);
                nSecond1 = GetDlgItemInt (hDlg, IDC_EDIT87, NULL, TRUE);
                nTime = (nHour1 * 60 + nMinute1) * 60 + nSecond1
                                    - (nHour0 * 60 + nMinute0) * 60 - nSecond0;
                for (i = IDC_CHECKBOX87; i >= IDC_CHECKBOX81; i--)
                  dwWeeks = dwWeeks << 1
                    | (IsDlgButtonChecked (hDlg, i) == BST_CHECKED ? 1 : 0);
                if (nTime < 0)
                    nTime += 24 * 60 * 60;
                if ((1 <= nDay && nDay <= 31 || dwWeeks != 0)
                                            && 0 <= nHour0 && nHour0 <= 23
                                            && 0 <= nMinute0 && nMinute0 <= 59
                                            && 0 <= nSecond0 && nSecond0 <= 59
                                            && 0 <= nHour1 && nHour1 <= 23
                                            && 0 <= nMinute1 && nMinute1 <= 59
                                            && 0 <= nSecond1 && nSecond1 <= 59)
                  {
                    if (fComboBox && !SetDlgItemInt (hDlg, IDC_COMBOBOX81,
                                                            nTime / 60, TRUE))
                      {
                        MessageBox (hDlg, _T("SetDlgItemInt"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    EnableDlgItem (hDlg, IDC_PUSHBUTTON87, nTime > 0
                        && ListView_GetItemCount
                                        (GetDlgItem (hDlg, IDC_LISTVIEW82)) > 0
                        && GetDlgItemInt (hDlg, IDC_EDIT8A, NULL, FALSE)
                                                                    < 60 * 60);
                  }
                else
                  {
                    EnableDlgItem (hDlg, IDC_PUSHBUTTON87, FALSE);
                  }
              }
              return TRUE;
            case IDC_EDIT88:
            case IDC_EDIT89:
              if (HIWORD (wParam) == EN_CHANGE)
                {
                  EnableDlgItem (hDlg, IDC_PUSHBUTTON82,
                    SendDlgItemMessage (hDlg, IDC_EDIT88,
                                                    WM_GETTEXTLENGTH, 0, 0) > 0
                        && GetDlgItemInt (hDlg, IDC_EDIT89, NULL, FALSE) > 0);
                }
              return TRUE;
            case IDC_PUSHBUTTON81:/* ja:Q */
              {
                FNDIR fd;
                OPENFILENAME ofn;
                TCHAR szFile[MAXPATH], szPath[MAXPATH];

                GetDlgItemText (hDlg, IDC_EDIT88, szFile, MAXPATH);
                switch (stProp.uFormat)
                  {
                    case 0:
                      ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_STD);
                      ofn.lpstrDefExt = _T("avi");
                      break;
                    case 1:
                      ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_AVI);
                      ofn.lpstrDefExt = _T("avi");
                      break;
                    case 2:
                      ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_GSR);
                      ofn.lpstrDefExt = _T("gsr");
                      break;
                    default:
                      ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_DBG);
                      ofn.lpstrDefExt = _T("txt");
                  }
                SplitFileName (szFile, &fd);
                lstrcpy (szPath, fd.szDrive);
                lstrcat (szPath, fd.szDir);
                lstrcpy (szFile, fd.szName);
                lstrcat (szFile, fd.szExt);
                ofn.lStructSize = sizeof (OPENFILENAME);
                ofn.hwndOwner = hDlg;
                ofn.nFilterIndex = 1;
                ofn.lpstrCustomFilter = NULL;
                ofn.lpstrFile = szFile;
                ofn.nMaxFile = MAXPATH;
                ofn.lpstrFileTitle = NULL;
                ofn.lpstrInitialDir = szPath;
                ofn.lpstrTitle = NULL;
                ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR
                                                        | OFN_PATHMUSTEXIST;
                if (!GetSaveFileName (&ofn))
                  return FALSE;
                if (!SetDlgItemText (hDlg, IDC_EDIT88, szFile))
                  {
                    MessageBox (hDlg, _T("SetDlgItemText"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              return TRUE;
          case IDC_PUSHBUTTON82:/* ja:ǉ */
              {
                HWND hWnd;
                LV_ITEM lvi;
                TCHAR szText[128];

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW82);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                (LPFILELIST)lvi.lParam = MemoryAlloc (sizeof (FILELIST));
                if (!lvi.lParam)
                  {
                    MessageBox (hDlg, _T("MemoryAlloc"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                GetDlgItemText (hDlg,IDC_EDIT88,
                                    ((LPFILELIST)lvi.lParam)->szFile, MAXPATH);
                ((LPFILELIST)lvi.lParam)->uiBytes = (UINT64)GetDlgItemInt
                                (hDlg, IDC_EDIT89, NULL, FALSE) * 1024 * 1024;
                lvi.mask = LVIF_PARAM | LVIF_TEXT;
                lvi.pszText = ((LPFILELIST)lvi.lParam)->szFile;
                lvi.iItem = ListView_GetItemCount (hWnd);
                lvi.iSubItem = 0;
                if (ListView_InsertItem (hWnd, &lvi) == -1)
                  {
                    MessageBox (hDlg, _T("ListView_InsertItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                wsprintf (szText, _T("%uMB"),
                    (UINT)(((LPFILELIST)lvi.lParam)->uiBytes / 1024 / 1024));
                lvi.mask = LVIF_TEXT;
                lvi.pszText = szText;
                lvi.iSubItem = 1;
                if (!ListView_SetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              return TRUE;
            case IDC_PUSHBUTTON83:/* ja:폜 */
              {
                HWND hWnd;
                LV_ITEM lvi;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW82);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                lvi.mask = LVIF_PARAM;
                lvi.iSubItem = 0;
                while ((lvi.iItem = ListView_GetNextItem (hWnd, -1,
                                            LVNI_ALL | LVNI_SELECTED)) != -1)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    MemoryFree ((LPFILELIST)lvi.lParam);
                    if (!ListView_DeleteItem (hWnd, lvi.iItem))
                      {
                        MessageBox (hDlg, _T("ListView_DeleteItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                  }
              }
              return TRUE;
            case IDC_PUSHBUTTON84:/* ja:ړ */
              {
                int nIndex;
                HWND hWnd;
                LV_ITEM lvi;
                TCHAR szText[128];

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW82);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                while ((nIndex = ListView_GetNextItem (hWnd, -1,
                                            LVNI_ALL | LVNI_SELECTED)) != -1)
                  {
                    lvi.mask = LVIF_PARAM;
                    lvi.iItem = nIndex;
                    lvi.iSubItem = 0;
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    lvi.mask = LVIF_PARAM | LVIF_TEXT;
                    lvi.pszText = ((LPFILELIST)lvi.lParam)->szFile;
                    lvi.iItem = ListView_GetItemCount (hWnd);
                    if (ListView_InsertItem (hWnd, &lvi) == -1)
                      {
                        MessageBox (hDlg, _T("ListView_InsertItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    wsprintf (szText, _T("%uMB"), (UINT)
                            (((LPFILELIST)lvi.lParam)->uiBytes / 1024 / 1024));
                    lvi.mask = LVIF_TEXT;
                    lvi.pszText = szText;
                    lvi.iSubItem = 1;
                    if (!ListView_SetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    if (!ListView_DeleteItem (hWnd, nIndex))
                      {
                        MessageBox (hDlg, _T("ListView_DeleteItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                  }
              }
              return TRUE;
            case IDC_PUSHBUTTON85:/* ja:m */
              {
                int nCount;
                HWND hWnd;
                LV_ITEM lvi;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW82);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                nCount = ListView_GetItemCount (hWnd);
                lvi.mask = LVIF_PARAM;
                lvi.iSubItem = 0;
                for (lvi.iItem = 0; lvi.iItem < nCount; lvi.iItem++)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    if (!AllocateFile (((LPFILELIST)lvi.lParam)->szFile,
                                    ((LPFILELIST)lvi.lParam)->uiBytes, TRUE))
                      break;
                  }
              }
              return TRUE;
            case IDC_PUSHBUTTON86:/* ja:vpeB */
              DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_3),
                                        hDlg, PropDlgProc, (LPARAM)&stProp);
              return TRUE;
            case IDC_PUSHBUTTON87:/* ja:\ */
              {
                int i, nHour, nMinute, nSecond;
                HWND hWnd;
                LV_ITEM lvi;
                LPRECORD lpRecord;
                UINT uTime;
                TCHAR szText[128];

                lpRecord = MemoryAlloc (sizeof (RECORD));
                if (!lpRecord)
                  {
                    MessageBox (hDlg, _T("MemoryAlloc"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:擾 */
                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW82);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                lpRecord->dwWeeks = 0;
                for (i = IDC_CHECKBOX87; i >= IDC_CHECKBOX81; i--)
                  lpRecord->dwWeeks = lpRecord->dwWeeks << 1
                    | (IsDlgButtonChecked (hDlg, i) == BST_CHECKED ? 1 : 0);
                lpRecord->nDay=lpRecord->dwWeeks == 0
                        ? GetDlgItemInt (hDlg, IDC_EDIT81, NULL, FALSE) : 0;
                lpRecord->nHour = GetDlgItemInt (hDlg, IDC_EDIT82,
                                                                NULL, FALSE);
                lpRecord->nMinute = GetDlgItemInt (hDlg, IDC_EDIT83,
                                                                NULL, FALSE);
                lpRecord->nSecond = GetDlgItemInt (hDlg, IDC_EDIT84,
                                                                NULL, FALSE);
                lpRecord->uTimeLimit
                        = (GetDlgItemInt (hDlg, IDC_EDIT85, NULL, FALSE) * 60
                        + GetDlgItemInt (hDlg, IDC_EDIT86, NULL, FALSE)) * 60
                        + GetDlgItemInt (hDlg, IDC_EDIT87, NULL, FALSE);
                uTime = (lpRecord->nHour * 60 + lpRecord->nMinute) * 60
                                                        + lpRecord->nSecond;
                if (lpRecord->uTimeLimit < uTime)
                  lpRecord->uTimeLimit += 24 * 60 * 60;
                lpRecord->uTimeLimit -= uTime;
                lpRecord->nFileList = ListView_GetItemCount (hWnd);
                lpRecord->uAlloc
                            = GetDlgItemInt (hDlg, IDC_EDIT8A, NULL, FALSE);
                lpRecord->lpFileList = MemoryAlloc (lpRecord->nFileList
                                                        * sizeof (FILELIST));
                if (!lpRecord->lpFileList)
                  {
                    MessageBox (hDlg, _T("MemoryAlloc"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                lvi.mask = LVIF_PARAM;
                lvi.iSubItem = 0;
                for (lvi.iItem = 0;
                                lvi.iItem < lpRecord->nFileList; lvi.iItem++)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    lpRecord->lpFileList[lvi.iItem] = *(LPFILELIST)lvi.lParam;
                  }
                /* ja:vpeB */
                lpRecord->stProp = stProp;
                if (!(lpRecord->stProp.lpWfx = MemoryAlloc (dwMaxSizeFormat))
                        || stProp.cbState > 0
                            && !(lpRecord->stProp.lpState
                                            = MemoryAlloc (stProp.cbState)))
                  {
                    MessageBox (hDlg, _T("MemoryAlloc"),
                                      APPLICATION, MB_OK | MB_ICONSTOP);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                MemoryCopy (lpRecord->stProp.lpWfx, stProp.lpWfx,
                                                            dwMaxSizeFormat);
                MemoryCopy (lpRecord->stProp.lpState, stProp.lpState,
                                                            stProp.cbState);
                if (stProp.lpBmiOut)
                  {
                    int nLength;

                    nLength = bmHdrByte ((LPBITMAPINFOHEADER)stProp. lpBmiOut);
                    lpRecord->stProp.lpBmiOut = MemoryAlloc (nLength);
                    if (!lpRecord->stProp.lpBmiOut)
                      {
                        MessageBox (hDlg, _T("MemoryAlloc"),
                                          APPLICATION, MB_OK | MB_ICONSTOP);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    MemoryCopy (lpRecord->stProp.lpBmiOut, stProp.lpBmiOut,
                                                                    nLength);
                  }
                /* ja:Xgǉ */
                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW81);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:Jn */
                if (lpRecord->dwWeeks == 0)
                  {
                    wsprintf (szText, LoadText (hInst, IDS_TIMER_DAY),
                                                            lpRecord->nDay,
                                                            lpRecord->nHour,
                                                            lpRecord->nMinute,
                                                            lpRecord->nSecond);
                  }
                else
                  {
                    int j;
                    TCHAR szWeek[128];

                    szWeek[0] = '\0';
                    for (j = 0; j < 7; j++)
                      if (lpRecord->dwWeeks >> j & 1)
                        {
                          GetDlgItemText (hDlg, j + IDC_CHECKBOX81,
                                                                szText, 128);
                          lstrcat (szWeek, szText);
                        }
                    wsprintf (szText, LoadText (hInst, IDS_TIMER_WEEK), szWeek,
                        lpRecord->nHour, lpRecord->nMinute, lpRecord->nSecond);
                  }
                lvi.mask = LVIF_TEXT | LVIF_PARAM;
                lvi.pszText = szText;
                lvi.iItem = ListView_GetItemCount (hWnd);
                lvi.iSubItem = 0;
                lvi.lParam = (LPARAM)lpRecord;
                if (ListView_InsertItem (hWnd, &lvi) == -1)
                  {
                    MessageBox (hDlg, _T("ListView_InsertItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:I */
                nSecond = lpRecord->nSecond + lpRecord->uTimeLimit;
                nMinute = lpRecord->nMinute + nSecond / 60;
                nHour = lpRecord->nHour + nMinute / 60;
                wsprintf (szText, LoadText (hInst, IDS_TIMER_TIME),
                                    nHour % 24, nMinute % 60, nSecond % 60);
                lvi.mask = LVIF_TEXT;
                lvi.iSubItem = 1;
                if (!ListView_SetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:` */
                lvi.pszText = lpszFormat[lpRecord->stProp.uFormat];
                lvi.iSubItem = 2;
                if (!ListView_SetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:[g */
                FloatStr (lpRecord->stProp.dwRate, 1000, szText);
                lvi.pszText = szText;
                lvi.iSubItem = 3;
                if (!ListView_SetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:t@C */
                lvi.pszText = lpRecord->lpFileList[0].szFile;
                lvi.iSubItem = 4;
                if (!ListView_SetItem (hWnd, &lvi))
                  {
                    MessageBox (hDlg, _T("ListView_SetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:בւ */
                ListView_SortItems (hWnd, ListViewRecCallback, 0);
                if (!EnableDlgItem (hDlg, IDOK, TRUE))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
              return TRUE;
            case IDC_PUSHBUTTON88:/* ja:폜 */
              {
                HWND hWnd;
                LV_ITEM lvi;

                hWnd = GetDlgItem (hDlg, IDC_LISTVIEW81);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                lvi.mask = LVIF_PARAM;
                lvi.iSubItem = 0;
                while ((lvi.iItem = ListView_GetNextItem (hWnd, -1,
                                            LVNI_ALL | LVNI_SELECTED)) != -1)
                  {
                    if (!ListView_GetItem (hWnd, &lvi))
                      {
                        MessageBox (hDlg, _T("ListView_GetItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    MemoryFree (((LPRECORD)lvi.lParam)->stProp.lpWfx);
                    MemoryFree (((LPRECORD)lvi.lParam)->stProp.lpState);
                    MemoryFree (((LPRECORD)lvi.lParam)->stProp.lpBmiOut);
                    MemoryFree (((LPRECORD)lvi.lParam)->lpFileList);
                    MemoryFree ((LPRECORD)lvi.lParam);
                    if (!ListView_DeleteItem (hWnd, lvi.iItem))
                      {
                        MessageBox (hDlg, _T("ListView_DeleteItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                  }
              }
            case IDC_CHECKBOX88:
              if (!EnableDlgItem (hDlg, IDOK, TRUE))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
              return TRUE;
            case IDC_PUSHBUTTON89:/* ja:G[ */
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_7), hDlg,
                                                                ErrorDlgProc);
          }
        return TRUE;
    }
  return FALSE;
}
