/*
    GtkShot for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "callback.h"
#include "dialog.h"
#include "drive.h"
#include "env.h"
#include "gshot.h"
#include "live.h"
#include "memapi.h"
#include "other.h"
#include "prop.h"
#include "resource.h"
#include "save.h"
#include "timer.h"
#include "version.h"
#include "wndmain.h"
#include <commctrl.h>
#include <htmlhelp.h>
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:EChE֐Q                                                         *
*                                                                             *
******************************************************************************/
LRESULT CALLBACK
WndProc (HWND   hWnd,
         UINT   uMsg,
         WPARAM wParam,
         LPARAM lParam)
{
  static HBITMAP hBmp = NULL;
  static UINT uTimer = 0;

  switch (uMsg)
    {
      case WM_CREATE:/* ja:EChEꂽ */
        {
          int i, nIndex;
          HDC hDC, hDeviceContext;
          HKEY hKey;
          RECT rc = {0, 0, 32, 16};
          TBADDBITMAP tb;
          TBBUTTON tbbutton[7] = {
{STD_FILESAVE,   CM_SAVE,     0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{0,              0,           TBSTATE_ENABLED, TBSTYLE_SEP,    {0, 0}, 0, 0},
{STD_PROPERTIES, CM_PROPERTY, 0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{0,              0,           TBSTATE_ENABLED, TBSTYLE_SEP,    {0, 0}, 0, 0},
{STD_FILENEW,    CM_CAPTURE,  0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_FILENEW,    CM_FRAME,    0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_COPY,       CM_COPY,     0,               TBSTYLE_BUTTON, {0, 0}, 0, 0}};

          /* ja:c[o[ */
          hWndTool = CreateToolbarEx (hWnd, WS_CHILD | WS_VISIBLE
                                | CCS_NODIVIDER | TBSTYLE_TOOLTIPS,
                                1, 0, HINST_COMMCTRL, IDB_STD_SMALL_COLOR,
                                tbbutton, 7, 0, 0, 0, 0, sizeof (TBBUTTON));
          if (!hWndTool)
            {
              MessageBox (hWnd, _T("CreateToolbarEx"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          /* ja:Xe[^Xo[ */
          hWndStat = CreateStatusWindow (WS_CHILD | WS_VISIBLE,
                                                            _T(""), hWnd, 2);
          if (!hWndStat)
            {
              MessageBox (hWnd, _T("CreateStatusWindow"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          /* ja:Lv`EChE */
          hWndCap = capCreateCaptureWindow (NULL, WS_CHILD | WS_VISIBLE,
                                                        0, 0, 0, 0, hWnd, 3);
          if (!hWndCap)
            {
              MessageBox (hWnd, _T("capCreateCaptureWindow"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          /* ja:R[obN */
          capSetCallbackOnCapControl (hWndCap, ControlCallbackProc);
          capSetCallbackOnError (hWndCap, ErrorCallbackProc);
          capSetCallbackOnStatus (hWndCap, StatusCallbackProc);
          capSetCallbackOnYield (hWndCap, YieldCallbackProc);
          /* ja:Lv`p[^̎擾 */
          if (!capCaptureGetSetup (hWndCap, &cparam, sizeof (CAPTUREPARMS)))
            {
              MessageBox (hWnd, _T("capCaptureGetSetup"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          if (nRegStat & 1 && RegOpenKeyEx (HKEY_CURRENT_USER,
                                    _T("Software\\maid.org\\GtkShot"),
                                    0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS)
            {
              /* ja:WXgǂݏo */
              RegGetValueEx (hKey, _T("PercentDropForError"), REG_DWORD,
                                &cparam.wPercentDropForError, sizeof (UINT));
              RegGetValueEx (hKey, _T("NumVideoRequested"), REG_DWORD,
                                &cparam.wNumVideoRequested, sizeof (UINT));
              RegGetValueEx (hKey, _T("NumAudioRequested"), REG_DWORD,
                                &cparam.wNumAudioRequested, sizeof (UINT));
              RegGetValueEx (hKey, _T("AbortLeftMouse"), REG_DWORD,
                                &cparam.fAbortLeftMouse, sizeof (BOOL));
              RegGetValueEx (hKey, _T("AbortRightMouse"), REG_DWORD,
                                &cparam.fAbortRightMouse, sizeof (BOOL));
              RegGetValueEx (hKey, _T("LimitEnabled"), REG_DWORD,
                                &cparam.fLimitEnabled, sizeof (BOOL));
              RegGetValueEx (hKey, _T("TimeLimit"), REG_DWORD,
                                &cparam.wTimeLimit, sizeof (UINT));
              RegGetValueEx (hKey, _T("AudioBufferSize"), REG_DWORD,
                                &cparam.dwAudioBufferSize, sizeof (DWORD));
              if (RegCloseKey (hKey) != ERROR_SUCCESS)
                {
                  MessageBox (NULL, _T("RegCloseKey"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                  return 0;
                }
            }
          cparam.fMakeUserHitOKToCapture = FALSE;
          cparam.dwIndexSize = 324000;
          /* ja:foCX̐ݒ */
          if (!InitHardware (hWnd))
            return 0;
          /* ja:ɎOɕ\ύX̏ */
          if (!ChangeTopMost (hWnd))
            return 0;
          /* ja:foCXReLXg */
          hDeviceContext = GetDC (hWnd);
          if (!hDeviceContext)
            {
              MessageBox (hWnd, _T("GetDC"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          hDC = CreateCompatibleDC (hDeviceContext);
          if (!hDC)
            {
              MessageBox (hWnd, _T("CreateCompatibleDC"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              ReleaseDC (hWnd, hDeviceContext);
              DestroyWindow (hWnd);
              return 0;
            }
          hBmp = CreateCompatibleBitmap (hDeviceContext, 32, 16);
          if (!hBmp)
            {
              MessageBox (hWnd, _T("CreateCompatibleBitmap"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DeleteDC (hDC);
              ReleaseDC (hWnd, hDeviceContext);
              DestroyWindow (hWnd);
              return 0;
            }
          if (ReleaseDC (hWnd, hDeviceContext) != 1)
            {
              MessageBox (hWnd, _T("ReleaseDC"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DeleteDC (hDC);
              DestroyWindow (hWnd);
              return 0;
            }
          hBrush = CreateSolidBrush (GetSysColor (COLOR_BTNFACE));
          if (!hBrush)
            {
              MessageBox (hWnd, _T("CreateSolidBrush"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DeleteDC (hDC);
              DestroyWindow (hWnd);
              return 0;
            }
          hBmp = SelectObject (hDC, hBmp);
          if (!FillRect (hDC, &rc, hBrush))
            {
              MessageBox (hWnd, _T("FillRect"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              hBmp = SelectObject (hDC, hBmp);
              DeleteDC (hDC);
              DestroyWindow (hWnd);
              return 0;
            }
          if (!DeleteObject (hBrush))
            {
              MessageBox (hWnd, _T("DeleteObject"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              hBrush = NULL;
              hBmp = SelectObject (hDC, hBmp);
              DeleteDC (hDC);
              DestroyWindow (hWnd);
              return 0;
            }
          hBrush = NULL;
          /* ja:֘AtĂACR{^ɂ */
          for (i = 0; i < 2; i++)
            {
              SHFILEINFO shfi;

              if (!SHGetFileInfo (i == 0 ? _T("X.AVI") : _T("X.BMP"),
                                                0, &shfi, sizeof (SHFILEINFO),
                    SHGFI_ICON | SHGFI_SMALLICON | SHGFI_USEFILEATTRIBUTES))
                {
                  MessageBox (hWnd, _T("SHGetFileInfo"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  hBmp = SelectObject (hDC, hBmp);
                  DeleteDC (hDC);
                  DestroyWindow (hWnd);
                  return 0;
                }
              if (!DrawIconEx (hDC, i * 16, 0, shfi.hIcon, 16, 16,
                                                        0, NULL, DI_NORMAL))
                {
                  MessageBox (hWnd, _T("DrawIcon"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  hBmp = SelectObject (hDC, hBmp);
                  DeleteDC (hDC);
                  DestroyWindow (hWnd);
                  return 0;
                }
            }
          hBmp = SelectObject (hDC, hBmp);
          if (!DeleteDC (hDC))
            {
              MessageBox (hWnd, _T("DeleteDC"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          tb.hInst = NULL;
          tb.nID = (UINT)hBmp;
          nIndex = SendMessage (hWndTool, TB_ADDBITMAP, 2, (LPARAM)&tb);
          if (nIndex == -1)
            {
              MessageBox (hWnd, _T("TB_ADDBITMAP"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          if (!SendMessage (hWndTool, TB_CHANGEBITMAP, CM_CAPTURE, nIndex)
            || !SendMessage (hWndTool, TB_CHANGEBITMAP, CM_FRAME, nIndex + 1))
            {
              MessageBox (hWnd, _T("TB_CHANGEBITMAP"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          /* ja:wĩuV */
          hBrush = CreateSolidBrush (fColor
                                    ? GetSysColor (COLOR_WINDOW) : crColor);
          if (!hBrush)
            {
              MessageBox (hWnd, _T("CreateSolidBrush"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          /* ja:^C} */
          uTimer = SetTimer (hWnd, 1, 500, NULL);
          if (uTimer == 0)
            {
              MessageBox (hWnd, _T("SetTimer"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
            }
        }
        return 0;
      case WM_SYSCOLORCHANGE:
        if (fColor)
          {
            if (!DeleteObject (hBrush))
              {
                MessageBox (hWnd, _T("DeleteObject"),
                                  APPLICATION, MB_OK | MB_ICONSTOP);
                hBrush = NULL;
                DestroyWindow (hWnd);
                return 0;
            }
            /* ja:wĩuV */
            hBrush = CreateSolidBrush (GetSysColor (COLOR_WINDOW));
            if (!hBrush)
              {
                MessageBox (hWnd, _T("CreateSolidBrush"),
                                  APPLICATION, MB_OK | MB_ICONSTOP);
                DestroyWindow (hWnd);
                return 0;
              }
          }
        break;
      case WM_NCHITTEST:
        {
          DWORD dwResult;

          dwResult = DefWindowProc (hWnd, uMsg, wParam, lParam);
          if (!fScale && HTSIZEFIRST <= dwResult && dwResult <= HTSIZELAST)
            dwResult = HTCAPTION;
          return dwResult;
        }
      case WM_GETMINMAXINFO:
        if (!fScale && fLayout)
          {
            ((LPMINMAXINFO)lParam)->ptMinTrackSize.x = siMainWnd.cx;
            ((LPMINMAXINFO)lParam)->ptMinTrackSize.y = siMainWnd.cy;
            ((LPMINMAXINFO)lParam)->ptMaxTrackSize
                                    = ((LPMINMAXINFO)lParam)->ptMinTrackSize;
          }
        return 0;
      case WM_SIZE:/* ja:TCYύXꂽ */
        ResizeWindow (hWnd);
        /* ja:vr[̐ݒ */
        if (fPreview && !capPreview (hWndCap, wParam != SIZE_MINIMIZED))
          {
            MessageBox (hWnd, _T("capPreview"),
                              APPLICATION, MB_OK | MB_ICONSTOP);
            DestroyWindow (hWnd);
            return 0;
          }
        /* ja:I[o[C̐ݒ */
        if (fOverlay && !capOverlay (hWndCap, wParam != SIZE_MINIMIZED))
          {
            MessageBox (hWnd, _T("capOverlay"),
                              APPLICATION, MB_OK | MB_ICONSTOP);
            DestroyWindow (hWnd);
          }
        return 0;
      case WM_PAINT:
        {
          PAINTSTRUCT ps;

          if (BeginPaint (hWnd, &ps) == NULL)
            {
              MessageBox (hWnd, _T("BeginPaint"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          if (!FillRect (ps.hdc, &ps.rcPaint, hBrush))
            {
              MessageBox (hWnd, _T("FillRect"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
            }
          EndPaint (hWnd, &ps);
        }
        return 0;
      case WM_PALETTECHANGED:
      case WM_QUERYNEWPALETTE:
        SendMessage (hWndCap, uMsg, wParam, lParam);
        break;
      case WM_NOTIFY:
        switch (((LPNMHDR)lParam)->code)
          {
            case TTN_NEEDTEXT:
              ((LPTOOLTIPTEXT)lParam)->lpszText
                            = (LPTSTR)(((LPNMHDR)lParam)->idFrom + TIPBASE);
              ((LPTOOLTIPTEXT)lParam)->hinst = hInst;
              break;
            case TTN_SHOW:
              {
                TCHAR szText[MAXPATH];

                if (LoadString (hInst, ((LPNMHDR)lParam)->idFrom,
                                                    szText, MAXPATH - 1) != 0)
                  {
                    SendMessage (hWndStat, SB_SIMPLE, TRUE, 0);
                    if (!SendMessage (hWndStat, SB_SETTEXT,
                                        SBT_NOBORDERS | 255, (LPARAM)szText))
                      {
                        MessageBox (hWnd, _T("SB_SETTEXT"),
                                          APPLICATION, MB_OK | MB_ICONSTOP);
                        DestroyWindow (hWnd);
                      }
                  }
              }
              break;
            case TTN_POP:
              if (!SendMessage (hWndStat, SB_SETTEXT, 255, (LPARAM)_T("")))
                {
                  MessageBox (hWnd, _T("SB_SETTEXT"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                }
              SendMessage(hWndStat,SB_SIMPLE,FALSE,0);
          }
        break;
      case WM_MENUSELECT:/* ja:j[Iꂽ */
        {
          HMENU hMenu;
          UINT uIds[2] = {0, 0};

          hMenu = GetMenu (hWnd);
          if (!hMenu)
            {
              MessageBox (hWnd, _T("GetMenu"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          if (HIWORD (wParam) & MF_SYSMENU || LOWORD (wParam) >= 100
                                || HIWORD (wParam) == 0xffff && !(HMENU)lParam)
            MenuHelp (uMsg, wParam, lParam, hMenu, hInst, hWndStat, uIds);
          else
            MenuHelp (uMsg, MAKEWPARAM (IDS_FILE + LOWORD (wParam),
                    HIWORD (wParam)), lParam, hMenu, hInst, hWndStat, uIds);
        }
        return 0;
      case WM_TIMER:/* ja:^C} */
        if (fTimer && nDeviceID >= 0 && nRecordList > 0)
          {
            int i, nTime1;
            SYSTEMTIME stSysTime;

            GetLocalTime (&stSysTime);
            nTime1 = (stSysTime.wHour * 60 + stSysTime.wMinute) * 60
                                                        + stSysTime.wSecond;
            for (i = 0; i < nRecordList; i++)
              {
                int nTime2;

                nTime2 = (lpRecordList[i].nHour * 60 + lpRecordList[i].nMinute)
                                                * 60 + lpRecordList[i].nSecond;
                /* ja:Oɗ̈mۂ */
                if (lpRecordList[i].fAlloc && lpRecordList[i].uAlloc != 0
                    /* ja:t */
                    && (lpRecordList[i].nDay == stSysTime.wDay
                            && nTime2 - lpRecordList[i].uAlloc <= nTime1
                            && nTime1 < nTime2
                    || lpRecordList[i].nDay
                                == (stSysTime.wDay < nDays[stSysTime.wMonth]
                                                    ? stSysTime.wDay + 1 : 1)
                        && nTime2 - lpRecordList[i].uAlloc + 24 * 60 * 60
                                                                    <= nTime1
                    /* ja:j */
                    || lpRecordList[i].dwWeeks >> stSysTime.wDayOfWeek & 1
                                && nTime2 - lpRecordList[i].uAlloc <= nTime1
                                && nTime1 < nTime2
                    || lpRecordList[i].dwWeeks >> (stSysTime.wDayOfWeek < 6
                                        ? stSysTime.wDayOfWeek + 1 : 0) & 1
                    && nTime2 - lpRecordList[i].uAlloc + 24 * 60 * 60
                                                                    <= nTime1))
                  {
                    int j;

                    for (j = 0; j < lpRecordList[i].nFileList; j++)
                      if (!AllocateFile (lpRecordList[i].lpFileList[j].szFile,
                                lpRecordList[i].lpFileList[j].uiBytes, FALSE))
                        break;
                    lpRecordList[i].fAlloc = FALSE;
                  }
                else
                  {
                    lpRecordList[i].fAlloc = TRUE;
                  }
                /* ja:^ */
                if (
                    /* ja:t */
                    lpRecordList[i].nDay == stSysTime.wDay
                            && nTime2 <= nTime1
                            && nTime1 < nTime2 + lpRecordList[i].uTimeLimit
                      || lpRecordList[i].nDay == (stSysTime.wDay > 1
                            ? stSysTime.wDay - 1 : nDays[stSysTime.wMonth - 1])
                            && nTime1 <= (int)(nTime2
                                + lpRecordList[i].uTimeLimit - 24 * 60 * 60)
                    /* ja:j */
                    || lpRecordList[i].dwWeeks >> stSysTime.wDayOfWeek & 1
                            && nTime2 <= nTime1
                            && nTime1 < nTime2 + lpRecordList[i].uTimeLimit
                      || lpRecordList[i].dwWeeks >> (stSysTime.wDayOfWeek > 0
                                        ? stSysTime.wDayOfWeek - 1 : 6) & 1
                            && nTime1 <= (int)(nTime2
                                + lpRecordList[i].uTimeLimit - 24 * 60 * 60))
                  {
                    if (lpRecordList[i].fDone)
                      CaptureFile (&lpRecordList[i].stProp,
                                                    lpRecordList[i].lpFileList,
                                                    lpRecordList[i].nFileList,
                                                    lpRecordList[i].uTimeLimit,
                                                    FALSE);
                    lpRecordList[i].fDone = FALSE;
                  }
                else
                  {
                    lpRecordList[i].fDone=TRUE;
                  }
              }
          }
        return 0;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case CM_SAVE:/* ja:Otĕۑ */
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_2),
                                                            hWnd, SaveDlgProc);
              return 0;
            case CM_PROPERTY:/* ja:vpeB */
              DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_3),
                                    hWnd, PropDlgProc, (LPARAM)&stProperty);
              return 0;
            case CM_EXIT:/* ja:I */
              SendMessage (hWnd, WM_CLOSE, 0, 0);
              return 0;
            case CM_CAPTURE:/* ja:Lv`[ */
              {
                if (nFileList == 0)
                  {
                    FILELIST stFList;
                    FNDIR fd;
                    OPENFILENAME ofn;
                    TCHAR szFile[MAXPATH], szPath[MAXPATH];

                    SplitFileName (szCaptureFile, &fd);
                    lstrcpy (szPath, fd.szDrive);
                    lstrcat (szPath, fd.szDir);
                    lstrcpy (stFList.szFile, fd.szName);
                    lstrcat (stFList.szFile, fd.szExt);
                    switch (stProperty.uFormat)
                      {
                        case 0:
                            ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_STD);
                            ofn.lpstrDefExt = _T("avi");
                            break;
                        case 1:
                            ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_AVI);
                            ofn.lpstrDefExt = _T("avi");
                            break;
                        case 2:
                            ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_GSR);
                            ofn.lpstrDefExt = _T("gsr");
                            break;
                        default:
                            ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_DBG);
                            ofn.lpstrDefExt = _T("txt");
                      }
                    ofn.lStructSize = sizeof (OPENFILENAME);
                    ofn.hwndOwner = hWnd;
                    ofn.nFilterIndex = 1;
                    ofn.lpstrCustomFilter = NULL;
                    ofn.lpstrFile = stFList.szFile;
                    ofn.nMaxFile = MAXPATH;
                    ofn.lpstrFileTitle = NULL;
                    ofn.lpstrInitialDir = szPath;
                    ofn.lpstrTitle = NULL;
                    ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR
                                                        | OFN_PATHMUSTEXIST;
                    if (!GetSaveFileName (&ofn))
                      return 0;
                    stFList.uiBytes = uiMaxBytes;
                    CaptureFile (&stProperty, &stFList, 1, 0, TRUE);
                  }
                else
                  {
                    CaptureFile (&stProperty, lpFileList, nFileList, 0, TRUE);
                  }
              }
              return 0;
            case CM_FRAME:/* ja:t[ */
              {
                FNDIR fd;
                TCHAR szFile[MAXPATH + 1], szPath[MAXPATH];

                SplitFileName (szFrameFile, &fd);
                if (fd.szName[0] == '\0')
                  {
                    OPENFILENAME ofn;

                    /* ja:t@Cs̎A͂𑣂 */
                    szFile[0] = '\0';
                    lstrcpy (szPath, fd.szDrive);
                    lstrcat (szPath, fd.szDir);
                    ofn.lStructSize = sizeof (OPENFILENAME);
                    ofn.hwndOwner = hWnd;
                    ofn.lpstrFilter = LoadText (hInst, IDS_FILTER_BMP);
                    ofn.nFilterIndex = 1;
                    ofn.lpstrCustomFilter = NULL;
                    ofn.lpstrFile = szFile;
                    ofn.nMaxFile = MAXPATH;
                    ofn.lpstrFileTitle = NULL;
                    ofn.lpstrInitialDir = szPath;
                    ofn.lpstrTitle = NULL;
                    ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR
                                                        | OFN_PATHMUSTEXIST;
                    ofn.lpstrDefExt = _T("bmp");
                    if (!GetSaveFileName(&ofn))
                      return 0;
                  }
                else
                  {
                    lstrcpy (szFile, szFrameFile);
                    if (fNumFrame)
                      {
                        int i;

                        /* ja:AԂŃLv`鎞 */
                        SplitFileName (szFile, &fd);
                        for (i = 0; fd.szName[i] !=' \0'; i++)
                          if (fd.szName[i] == '%')
                            break;
                        if (fd.szName[i] == '%')
                          {
                            /* ja:%΂g */
                            wsprintf (szPath, szFile, uFrame++);
                            lstrcpy (szFile, szPath);
                          }
                        else
                          {
                            /* ja:t@Čɐlt */
                            wsprintf (szFile, _T("%s%s%s%u%s"),
                                                fd.szDrive, fd.szDir,
                                                fd.szName, uFrame++, fd.szExt);
                          }
                      }
                  }
                /* ja:mF̃_CAO */
                if (fMakeUserHitOKToCapture
                    && MessageBox (hWndMain, LoadText (hInst, IDS_CAP_START),
                        APPLICATION, MB_OKCANCEL | MB_ICONINFORMATION) != IDOK)
                  return 0;
                /* ja:Ƀt@C鎞ݔɎ̂Ă */
                if (fRecycle && IsFile (szFile))
                  {
                    SHFILEOPSTRUCT shfo;

                    MemorySet (&shfo, 0, sizeof (SHFILEOPSTRUCT));
                    szFile[lstrlen (szFile) + 1] = '\0';
                    shfo.hwnd = hWnd;
                    shfo.wFunc = FO_DELETE;
                    shfo.pFrom = szFile;
                    shfo.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION
                                                | FOF_NOERRORUI | FOF_SILENT;
                    SHFileOperation( &shfo);
                  }
                if (!capFileSaveDIB (hWndCap, szFile))
                  {
                    MessageBox (hWnd, _T("capFileSaveDIB"),
                                      APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWnd);
                  }
              }
              return 0;
            case CM_COPY:/* ja:Nbv{[h֓] */
              if (!capEditCopy (hWndCap))
                {
                  MessageBox (hWnd, _T("capEditCopy"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                }
              return 0;
            case CM_LIVE:/* ja:Cu,vr[,I[o[C֌W */
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_4),
                                                            hWnd, LiveDlgProc);
              return 0;
            case CM_TOP:/* ja:ɎOɕ\ */
              fTopMost =! fTopMost;
              /* ja:ɎOɕ\ύX̏ */
              ChangeTopMost (hWnd);
              return 0;
            case CM_REDRAW:/* ja:ŐV̏ɍXV */
              if (!capGrabFrameNoStop (hWndCap))
                {
                  MessageBox (hWnd, _T("capGrabFrameNoStop"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                }
              return 0;
            case CM_FORMAT:/* ja:rfI` */
              if (capDlgVideoFormat (hWndCap))
                {
                  if (!capGetStatus (hWndCap, &cstat, sizeof (CAPSTATUS)))
                    {
                      MessageBox (hWnd, _T("capGetStatus"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                      DestroyWindow (hWnd);
                      return FALSE;
                    }
                  if (!fScale)
                    SetMainWindowSize (hWnd,
                                    cstat.uiImageWidth, cstat.uiImageHeight);
                  /* ja:\tgEFAk̃`FbN */
                  CheckCompress ();
                }
              return 0;
            case CM_SOURCE:/* ja:rfI\[X */
              if (capDlgVideoSource (hWndCap)
                        && !capGetStatus (hWndCap, &cstat, sizeof (CAPSTATUS)))
                {
                  MessageBox (hWnd, _T("capGetStatus"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                  return FALSE;
                }
              return 0;
            case CM_DISPLAY:/* ja:rfIfBXvC */
              if (capDlgVideoDisplay (hWndCap)
                        && !capGetStatus (hWndCap, &cstat, sizeof (CAPSTATUS)))
                {
                  MessageBox (hWnd, _T("capGetStatus"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                  return FALSE;
                }
              return 0;
            case CM_DEVICE:/* ja:foCX̕ύX */
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_5),
                                                        hWnd, DriveDlgProc);
              return 0;
            case CM_ENV:/* ja: */
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_6),
                                                            hWnd, EnvDlgProc);
              return 0;
            case CM_TIMER:/* ja:^C} */
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_8),
                                                        hWnd, TimerDlgProc);
              return 0;
            case CM_TOPIC:
              {
                DWORD dwLength;
                TCHAR szFile[MAXPATH];

                dwLength = GetModuleFileName (hInst, szFile, MAXPATH);
                if (0 < dwLength && dwLength < MAXPATH)
                  {
                    FNDIR fd;

                    SplitFileName (szFile, &fd);
                    lstrcpy (fd.szExt, _T(".chm"));
                    MergeFileName (szFile, &fd);
                    if (!HtmlHelp (hWnd, szFile, HH_DISPLAY_TOPIC, 0))
                      MessageBox (hWnd, LoadText (hInst, IDS_OTHER_HELP),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  }
              }
              return 0;
            case CM_VERSION:
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_9),
                                                            hWnd, HelpDlgProc);
              return 0;
          }
        break;
      case WM_DESTROY:/* ja:EChEj */
        if (uTimer != 0 && !KillTimer (hWnd, 1))
          MessageBox (hWnd, _T("KillTimer"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        if ((hBrush && !DeleteObject (hBrush))
                                            | (hBmp && !DeleteObject (hBmp)))
          MessageBox (hWnd, _T("DeleteObject"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        if (hWndCap)
          {
            /* ja:R[obN */
            capSetCallbackOnCapControl (hWndCap, NULL);
            capSetCallbackOnError (hWndCap, NULL);
            capSetCallbackOnStatus (hWndCap, NULL);
            capSetCallbackOnVideoStream (hWndCap, NULL);
            capSetCallbackOnWaveStream (hWndCap, NULL);
            capSetCallbackOnYield (hWndCap, NULL);
            /* ja:ؒf */
            if (nDeviceID != -1 && !capDriverDisconnect (hWndCap))
              MessageBox (hWnd, _T("capDriverDisconnect"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              RegWrite();
          }
        PostQuitMessage (0);
        return 0;
    }
  return DefWindowProc (hWnd, uMsg, wParam, lParam);
}
