/*
    orzpref
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __ORZ_PREF_H__
#define __ORZ_PREF_H__


#include "gcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ORZ_TYPE_PREF            (orz_pref_get_type ())
#define ORZ_PREF(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_PREF, OrzPref))
#define ORZ_PREF_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_PREF, OrzPrefClass))
#define ORZ_IS_PREF(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_PREF))
#define ORZ_IS_PREF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_PREF))
#define ORZ_PREF_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_PREF, OrzPrefClass))


typedef struct _OrzPref      OrzPref;
typedef struct _OrzPrefClass OrzPrefClass;

struct _OrzPref
{
  /*< private >*/
  GtkDialog parent_instance;

  /*< public >*/
  GtkWidget *ok_button;     /* ja:了解 */
  GtkWidget *cancel_button; /* ja:取消 */

  /*< private >*/
  GtkWidget *history_spin;  /* ja:履歴 */
  GtkWidget *newfile_check; /* ja:新規ファイル */
  GtkWidget *second_check;  /* ja:新規ウインドウ */
  GtkWidget *width_spin;    /* ja:ウインドウサイズ */
  GtkWidget *height_spin;   /* ja:ウインドウサイズ */
  GtkWidget *left_radio;    /* ja:ノートブックの位置 */
  GtkWidget *top_radio;     /* ja:ノートブックの位置 */
  GtkWidget *right_radio;   /* ja:ノートブックの位置 */
  GtkWidget *bottom_radio;  /* ja:ノートブックの位置 */
};

struct _OrzPrefClass
{
  GtkDialogClass parent_class;

  /* -- signals -- */
  void (*escape) (OrzPref *pref);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_pref_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
orz_pref_new (void);


/*  ja:履歴を取得する
    pref,ウィジェット
     RET,履歴                                                               */
gint
orz_pref_get_history (OrzPref *pref);


/*  ja:新規ファイルを取得する
    pref,ウィジェット
     RET,新規ファイル                                                       */
gboolean
orz_pref_get_newfile (OrzPref *pref);


/*  ja:新規ウインドウを取得する
    pref,ウィジェット
     RET,新規ウインドウ                                                     */
gboolean
orz_pref_get_second (OrzPref *pref);


/*  ja:ウインドウサイズを取得する
      pref,ウィジェット
     width,幅
    height,高さ                                                             */
void
orz_pref_get_size (OrzPref *pref,
                   gint    *width,
                   gint    *height);


/*  ja:ノートブックの位置を取得する
    pref,ウィジェット
     RET,ノートブックの位置                                                 */
GtkPositionType
orz_pref_get_tab (OrzPref *pref);


/*  ja:履歴を設定する
       pref,ウィジェット
    history,履歴                                                            */
void
orz_pref_set_history (OrzPref    *pref,
                      const gint  history);


/*  ja:新規ファイルを設定する
       pref,ウィジェット
    newfile,新規ファイル                                                    */
void
orz_pref_set_newfile (OrzPref        *pref,
                      const gboolean  newfile);


/*  ja:新規ウインドウを設定する
      pref,ウィジェット
    second,新規ウインドウ                                                   */
void
orz_pref_set_second (OrzPref        *pref,
                     const gboolean  second);


/*  ja:ウインドウサイズを設定する
      pref,ウィジェット
     width,幅
    height,高さ                                                             */
void
orz_pref_set_size (OrzPref    *pref,
                   const gint  width,
                   const gint  height);


/*  ja:ノートブックの位置を設定する
     pref,ウィジェット
    n_pos,ノートブックの位置                                                */
void
orz_pref_set_tab (OrzPref               *pref,
                  const GtkPositionType  n_pos);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ORZ_PREF_H__ */
