/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __COMMCTRL_H__
#define __COMMCTRL_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "user32.h"

/* ja:共通 */
#define CLR_NONE    0xffffffff
#define CLR_DEFAULT 0xff000000
#define CLR_HILIGHT CLR_DEFAULT
#define CCS_TOP              0x00000001
#define CCS_NOMOVEY          0x00000002
#define CCS_BOTTOM           0x00000003
#define CCS_NORESIZE         0x00000004
#define CCS_NOPARENTALIGN    0x00000008
#define CCS_ADJUSTABLE       0x00000020
#define CCS_NODIVIDER        0x00000040
#define CCS_VERT             0x00000080
#define CCS_LEFT             (CCS_VERT|CCS_TOP)
#define CCS_RIGHT            (CCS_VERT|CCS_BOTTOM)
#define CCS_NOMOVEX          (CCS_VERT|CCS_NOMOVEY)
#define CCM_FIRST            0x2000
#define CCM_SETBKCOLOR       (CCM_FIRST+1)
#define CCM_SETCOLORSCHEME   (CCM_FIRST+2)
#define CCM_GETCOLORSCHEME   (CCM_FIRST+3)
#define CCM_GETDROPTARGET    (CCM_FIRST+4)
#define CCM_SETUNICODEFORMAT (CCM_FIRST+5)
#define CCM_GETUNICODEFORMAT (CCM_FIRST+6)
#define CCM_SETVERSION       (CCM_FIRST+7)
#define CCM_GETVERSION       (CCM_FIRST+8)
#define CCM_SETNOTIFYWINDOW  (CCM_FIRST+9)
#define CCM_SETWINDOWTHEME   (CCM_FIRST+11)
#define CCM_DPISCALE         (CCM_FIRST+12)
#define NM_FIRST             (0)
#define NM_LAST              (-99)
#define NM_OUTOFMEMORY       (NM_FIRST-1)
#define NM_CLICK             (NM_FIRST-2)
#define NM_DBLCLK            (NM_FIRST-3)
#define NM_RETURN            (NM_FIRST-4)
#define NM_RCLICK            (NM_FIRST-5)
#define NM_RDBLCLK           (NM_FIRST-6)
#define NM_SETFOCUS          (NM_FIRST-7)
#define NM_KILLFOCUS         (NM_FIRST-8)
#include "pshpack1.h"
typedef struct _INITCOMMONCONTROLSEX
{
  DWORD dwSize;
  DWORD dwICC;
} INITCOMMONCONTROLSEX, *PINITCOMMONCONTROLSEX, *LPINITCOMMONCONTROLSEX;
typedef struct _NMHDR
{
  HWND hwndFrom;
  UINT_PTR idFrom;
  UINT code;
} NMHDR, *PNMHDR, *LPNMHDR;
#include "poppack.h"

/* ja:ツールバー */
#define TBSTATE_CHECKED       0x01
#define TBSTATE_PRESSED       0x02
#define TBSTATE_ENABLED       0x04
#define TBSTATE_HIDDEN        0x08
#define TBSTATE_INDETERMINATE 0x10
#define TBSTATE_WRAP          0x20
#define TBSTYLE_BUTTON     0x00
#define TBSTYLE_SEP        0x01
#define TBSTYLE_CHECK      0x02
#define TBSTYLE_GROUP      0x04
#define TBSTYLE_CHECKGROUP (TBSTYLE_GROUP|TBSTYLE_CHECK)
#define TBSTYLE_TOOLTIPS 0x0100
#define TBSTYLE_WRAPABLE 0x0200
#define TBSTYLE_ALTDRAG  0x0400
#define TB_ENABLEBUTTON          (WM_USER+1)
#define TB_CHECKBUTTON           (WM_USER+2)
#define TB_PRESSBUTTON           (WM_USER+3)
#define TB_HIDEBUTTON            (WM_USER+4)
#define TB_INDETERMINATE         (WM_USER+5)
#define TB_MARKBUTTON            (WM_USER+6)
#define TB_ISBUTTONENABLED       (WM_USER+9)
#define TB_ISBUTTONCHECKED       (WM_USER+10)
#define TB_ISBUTTONPRESSED       (WM_USER+11)
#define TB_ISBUTTONHIDDEN        (WM_USER+12)
#define TB_ISBUTTONINDETERMINATE (WM_USER+13)
#define TB_ISBUTTONHIGHLIGHTED   (WM_USER+14)
#define TB_SETSTATE              (WM_USER+17)
#define TB_GETSTATE              (WM_USER+18)
#define TB_ADDBITMAP             (WM_USER+19)
#define TB_ADDBUTTONSA           (WM_USER+20)
#define TB_ADDBUTTONSW           (WM_USER+68)
#define TB_HITTEST               (WM_USER+69)
#define TB_INSERTBUTTONA         (WM_USER+21)
#define TB_INSERTBUTTONW         (WM_USER+67)
#define TB_DELETEBUTTON          (WM_USER+22)
#define TB_GETBUTTON             (WM_USER+23)
#define TB_BUTTONCOUNT           (WM_USER+24)
#define TB_COMMANDTOINDEX        (WM_USER+25)
#define TB_SAVERESTOREA          (WM_USER+26)
#define TB_SAVERESTOREW          (WM_USER+76)
#define TB_CUSTOMIZE             (WM_USER+27)
#define TB_ADDSTRINGA            (WM_USER+28)
#define TB_ADDSTRINGW            (WM_USER+77)
#define TB_GETITEMRECT           (WM_USER+29)
#define TB_BUTTONSTRUCTSIZE      (WM_USER+30)
#define TB_SETBUTTONSIZE         (WM_USER+31)
#define TB_SETBITMAPSIZE         (WM_USER+32)
#define TB_AUTOSIZE              (WM_USER+33)
#define TB_GETTOOLTIPS           (WM_USER+35)
#define TB_SETTOOLTIPS           (WM_USER+36)
#define TB_SETPARENT             (WM_USER+37)
#define TB_SETROWS               (WM_USER+39)
#define TB_GETROWS               (WM_USER+40)
#define TB_GETBITMAPFLAGS        (WM_USER+41)
#define TB_SETCMDID              (WM_USER+42)
#define TB_CHANGEBITMAP          (WM_USER+43)
#define TB_GETBITMAP             (WM_USER+44)
#define TB_GETBUTTONTEXTA        (WM_USER+45)
#define TB_GETBUTTONTEXTW        (WM_USER+75)
#define TB_REPLACEBITMAP         (WM_USER+46)
#define TB_SETINDENT             (WM_USER+47)
#define TB_SETIMAGELIST          (WM_USER+48)
#define TB_GETIMAGELIST          (WM_USER+49)
#define TB_LOADIMAGES            (WM_USER+50)
#define TB_GETRECT               (WM_USER+51)
#define TB_SETHOTIMAGELIST       (WM_USER+52)
#define TB_GETHOTIMAGELIST       (WM_USER+53)
#define TB_SETDISABLEDIMAGELIST  (WM_USER+54)
#define TB_GETDISABLEDIMAGELIST  (WM_USER+55)
#define TB_SETSTYLE              (WM_USER+56)
#define TB_GETSTYLE              (WM_USER+57)
#define TB_GETBUTTONSIZE         (WM_USER+58)
#define TB_SETBUTTONWIDTH        (WM_USER+59)
#define TB_SETMAXTEXTROWS        (WM_USER+60)
#define TB_GETTEXTROWS           (WM_USER+61)
#define TB_GETOBJECT             (WM_USER+62)
#define TB_GETBUTTONINFOW        (WM_USER+63)
#define TB_GETBUTTONINFOA        (WM_USER+65)
#define TB_SETBUTTONINFOW        (WM_USER+64)
#define TB_SETBUTTONINFOA        (WM_USER+66)
#define TB_SETDRAWTEXTFLAGS      (WM_USER+70)
#define TB_GETHOTITEM            (WM_USER+71)
#define TB_SETHOTITEM            (WM_USER+72)
#define TB_SETANCHORHIGHLIGHT    (WM_USER+73)
#define TB_GETANCHORHIGHLIGHT    (WM_USER+74)
#define TB_MAPACCELERATORA       (WM_USER+78)
#define TB_MAPACCELERATORW       (WM_USER+90)
#define TB_GETINSERTMARK         (WM_USER+79)
#define TB_SETINSERTMARK         (WM_USER+80)
#define TB_INSERTMARKHITTEST     (WM_USER+81)
#define TB_MOVEBUTTON            (WM_USER+82)
#define TB_GETMAXSIZE            (WM_USER+83)
#define TB_SETEXTENDEDSTYLE      (WM_USER+84)
#define TB_GETEXTENDEDSTYLE      (WM_USER+85)
#define TB_GETPADDING            (WM_USER+86)
#define TB_SETPADDING            (WM_USER+87)
#define TB_SETINSERTMARKCOLOR    (WM_USER+88)
#define TB_GETINSERTMARKCOLOR    (WM_USER+89)
#define TB_SETCOLORSCHEME        CCM_SETCOLORSCHEME
#define TB_GETCOLORSCHEME        CCM_GETCOLORSCHEME
#define TB_SETUNICODEFORMAT      CCM_SETUNICODEFORMAT
#define TB_GETUNICODEFORMAT      CCM_GETUNICODEFORMAT
#define TB_GETSTRINGW            (WM_USER+91)
#define TB_GETSTRINGA            (WM_USER+92)
#ifdef UNICODE
# define TB_GETSTRING      TB_GETSTRINGW
# define TB_ADDBUTTONS     TB_ADDBUTTONSW
# define TB_INSERTBUTTON   TB_INSERTBUTTONW
# define TB_SAVERESTORE    TB_SAVERESTOREW
# define TB_ADDSTRING      TB_ADDSTRINGW
# define TB_GETBUTTONTEXT  TB_GETBUTTONTEXTW
# define TB_GETBUTTONINFO  TB_GETBUTTONINFOW
# define TB_SETBUTTONINFO  TB_SETBUTTONINFOW
# define TB_MAPACCELERATOR TB_MAPACCELERATORW
#else /* not UNICODE */
# define TB_GETSTRING      TB_GETSTRINGA
# define TB_ADDBUTTONS     TB_ADDBUTTONSA
# define TB_INSERTBUTTON   TB_INSERTBUTTONA
# define TB_SAVERESTORE    TB_SAVERESTOREA
# define TB_ADDSTRING      TB_ADDSTRINGA
# define TB_GETBUTTONTEXT  TB_GETBUTTONTEXTA
# define TB_GETBUTTONINFO  TB_GETBUTTONINFOA
# define TB_SETBUTTONINFO  TB_SETBUTTONINFOA
# define TB_MAPACCELERATOR TB_MAPACCELERATORA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _TBBUTTON
{
  INT iBitmap;
  INT idCommand;
  BYTE fsState;
  BYTE fsStyle;
  BYTE bReserved[2];
  DWORD dwData;
  INT iString;
} TBBUTTON, *PTBBUTTON, *LPTBBUTTON;
#include "poppack.h"
typedef CONST TBBUTTON  *PCTBBUTTON, *LPCTBBUTTON;

/* ja:ツールチップ */
#define TTN_FIRST        (-520)
#define TTN_LAST         (-549)
#define TTN_SHOW         (TTN_FIRST-1)
#define TTN_POP          (TTN_FIRST-2)
#define TTN_NEEDTEXTA    (TTN_FIRST-0)
#define TTN_NEEDTEXTW    (TTN_FIRST-10)
#define TTN_GETDISPINFOA TTN_NEEDTEXTA
#define TTN_GETDISPINFOW TTN_NEEDTEXTW
#ifdef UNICODE
# define TTN_NEEDTEXT TTN_NEEDTEXTW
# define TTN_GETDISPINFO TTN_GETDISPINFOW
#else /* not UNICODE */
# define TTN_NEEDTEXT TTN_GETDISPINFOA
# define TTN_GETDISPINFO TTN_GETDISPINFOA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _TOOLTIPTEXTA
{
  NMHDR hdr;
  LPSTR lpszText;
  CHAR szText[80];
  HINSTANCE hinst;
  UINT uFlags;
} TOOLTIPTEXTA, *PTOOLTIPTEXTA, *LPTOOLTIPTEXTA;
typedef struct _TOOLTIPTEXTW
{
  NMHDR hdr;
  LPWSTR lpszText;
  WCHAR szText[80];
  HINSTANCE hinst;
  UINT uFlags;
} TOOLTIPTEXTW, *PTOOLTIPTEXTW, *LPTOOLTIPTEXTW;
#include "poppack.h"
#ifdef UNICODE
# define TOOLTIPTEXT TOOLTIPTEXTW
# define PTOOLTIPTEXT PTOOLTIPTEXTW
# define LPTOOLTIPTEXT LPTOOLTIPTEXTW
#else /* not UNICODE */
# define TOOLTIPTEXT TOOLTIPTEXTA
# define PTOOLTIPTEXT PTOOLTIPTEXTA
# define LPTOOLTIPTEXT LPTOOLTIPTEXTA
#endif /* not UNICODE */

/* ja:ステータスウインドウ */
#define STATUSCLASSNAMEA "msctls_statusbar32"
#define STATUSCLASSNAMEW (w32ldr_tchar_to_wc("msctls_statusbar32"))
#ifdef UNICODE
# define STATUSCLASSNAME STATUSCLASSNAMEW
#else /* not UNICODE */
# define STATUSCLASSNAME STATUSCLASSNAMEA
#endif /* not UNICODE */
#define SB_SETTEXTA       (WM_USER+1)
#define SB_SETTEXTW       (WM_USER+11)
#define SB_GETTEXTA       (WM_USER+2)
#define SB_GETTEXTW       (WM_USER+13)
#define SB_GETTEXTLENGTHA (WM_USER+3)
#define SB_GETTEXTLENGTHW (WM_USER+12)
#define SB_SETPARTS       (WM_USER+4)
#define SB_GETPARTS       (WM_USER+6)
#define SB_GETBORDERS     (WM_USER+7)
#define SB_SETMINHEIGHT   (WM_USER+8)
#define SB_SIMPLE         (WM_USER+9)
#define SB_GETRECT        (WM_USER+10)
#ifdef UNICODE
# define SB_SETTEXT       SB_SETTEXTW
# define SB_GETTEXT       SB_GETTEXTW
# define SB_GETTEXTLENGTH SB_GETTEXTLENGTHW
#else /* not UNICODE */
# define SB_SETTEXT       SB_SETTEXTA
# define SB_GETTEXT       SB_GETTEXTA
# define SB_GETTEXTLENGTH SB_GETTEXTLENGTHA
#endif /* not UNICODE */
#define SBT_NOBORDERS  0x0100
#define SBT_POPOUT     0x0200
#define SBT_RTLREADING 0x0400

/* ja:プロパティシート */
#include "w32prsht.h"

/* ja:イメージリスト */
#define ILC_MASK     0x0001
#define ILC_COLOR    0x0000
#define ILC_COLORDDB 0x00fe
#define ILC_COLOR4   0x0004
#define ILC_COLOR8   0x0008
#define ILC_COLOR16  0x0010
#define ILC_COLOR24  0x0018
#define ILC_COLOR32  0x0020
#define ILC_PALETTE  0x0800
#define ILD_NORMAL        0x0000
#define ILD_TRANSPARENT   0x0001
#define ILD_BLEND25       0x0002
#define ILD_FOCUS         ILD_BLEND25
#define ILD_BLEND50       0x0004
#define ILD_BLEND         ILD_BLEND50
#define ILD_SELECTED      ILD_BLEND50
#define ILD_MASK          0x0010
#define ILD_IMAGE         0x0020
#define ILD_ROP           0x0040
#define ILD_OVERLAYMASK   0x0f00
#define ILD_PRESERVEALPHA 0x1000
#define ILD_SCALE         0x2000
#define ILD_DPISCALE      0x4000
#define ILD_ASYNC         0x8000
#define ILS_NORMAL   0x0000
#define ILS_GLOW     0x0001
#define ILS_SHADOW   0x0002
#define ILS_SATURATE 0x0004
#define ILS_ALPHA    0x0008
#define ImageList_ExtractIcon(hInstance,hImage,i) ImageList_GetIcon(hImage,i,0)
#define ImageList_LoadBitmap(hInstance,lpszBitmap,cx,cGrow,crMask) ImageList_LoadImage(hInstance,lpszBitmap,cx,cGrow,crMask,IMAGE_BITMAP,0)
#define ImageList_RemoveAll(hImage) ImageList_Remove(hImage,-1)
typedef LPVOID HIMAGELIST;
typedef LPVOID LPSTREAM;
#include "pshpack1.h"
typedef struct _IMAGELISTDRAWPARAMS
{
  DWORD cbSize;
  HIMAGELIST himl;
  INT i;
  HDC hdcDst;
  INT x;
  INT y;
  INT cx;
  INT cy;
  INT xBitmap;
  INT yBitmap;
  COLORREF rgbBk;
  COLORREF rgbFg;
  UINT fStyle;
  DWORD dwRop;
  DWORD fState;
  DWORD Frame;
  COLORREF crEffect;
} IMAGELISTDRAWPARAMS, *PIMAGELISTDRAWPARAMS, *LPIMAGELISTDRAWPARAMS;
typedef struct _IMAGEINFO
{
  HBITMAP hbmImage;
  HBITMAP hbmMask;
  INT Unused1;
  INT Unused2;
  RECT rcImage;
} IMAGEINFO, *PIMAGEINFO, *LPIMAGEINFO;
#include "poppack.h"

/* ja:リストビュー */
#include "w32lview.h"

/* ja:ツリービュー */
#include "w32tview.h"

/* ja:プログレスコントロール */
#include "w32prgrs.h"

/* ja:ヘッダコントロール */
#define WC_HEADERA "SysHeader32"
#define WC_HEADERW (w32ldr_tchar_to_wc("SysHeader32"))
#ifdef UNICODE
# define WC_HEADER WC_HEADERW
#else /* not UNICODE */
# define WC_HEADER WC_HEADERA
#endif /* not UNICODE */
#define HDS_HORZ       0x0000
#define HDS_BUTTONS    0x0002
#define HDS_HOTTRACK   0x0004
#define HDS_HIDDEN     0x0008
#define HDS_DRAGDROP   0x0040
#define HDS_FULLDRAG   0x0080
#define HDS_FILTERBAR  0x0100
#define HDS_FLAT       0x0200
#define HDS_CHECKBOXES 0x0400
#define HDM_FIRST        0x1200
#define HDM_GETITEMCOUNT (HDM_FIRST+0)
#define HDM_INSERTITEMA  (HDM_FIRST+1)
#define HDM_INSERTITEMW  (HDM_FIRST+10)
#define HDM_DELETEITEM   (HDM_FIRST+2)
#define HDM_GETITEMA     (HDM_FIRST+3)
#define HDM_GETITEMW     (HDM_FIRST+11)
#define HDM_SETITEMA     (HDM_FIRST+4)
#define HDM_SETITEMW     (HDM_FIRST+12)
#define HDM_LAYOUT       (HDM_FIRST+5)
#define HDM_HITTEST      (HDM_FIRST+6)
#ifdef UNICODE
# define HDM_INSERTITEM HDM_INSERTITEMW
# define HDM_GETITEM HDM_GETITEMW
# define HDM_SETITEM HDM_SETITEMW
#else /* not UNICODE */
# define HDM_INSERTITEM HDM_INSERTITEMA
# define HDM_GETITEM HDM_GETITEMA
# define HDM_SETITEM HDM_SETITEMA
#endif /* not UNICODE */
#define HDN_FIRST            (-300)
#define HDN_LAST             (-399)
#define HDN_ITEMCHANGINGA    (HDN_FIRST-0)
#define HDN_ITEMCHANGINGW    (HDN_FIRST-20)
#define HDN_ITEMCHANGEDA     (HDN_FIRST-1)
#define HDN_ITEMCHANGEDW     (HDN_FIRST-21)
#define HDN_ITEMCLICKA       (HDN_FIRST-2)
#define HDN_ITEMCLICKW       (HDN_FIRST-22)
#define HDN_ITEMDBLCLICKA    (HDN_FIRST-3)
#define HDN_ITEMDBLCLICKW    (HDN_FIRST-23)
#define HDN_DIVIDERDBLCLICKA (HDN_FIRST-5)
#define HDN_DIVIDERDBLCLICKW (HDN_FIRST-25)
#define HDN_BEGINTRACKA      (HDN_FIRST-6)
#define HDN_BEGINTRACKW      (HDN_FIRST-26)
#define HDN_ENDTRACKA        (HDN_FIRST-7)
#define HDN_ENDTRACKW        (HDN_FIRST-27)
#define HDN_TRACKA           (HDN_FIRST-8)
#define HDN_TRACKW           (HDN_FIRST-28)
#ifdef UNICODE
# define HDN_ITEMCHANGING HDN_ITEMCHANGINGW
# define HDN_ITEMCHANGED HDN_ITEMCHANGEDW
# define HDN_ITEMCLICK HDN_ITEMCLICKW
# define HDN_ITEMDBLCLICK HDN_ITEMDBLCLICKW
# define HDN_DIVIDERDBLCLICK HDN_DIVIDERDBLCLICKW
# define HDN_BEGINTRACK HDN_BEGINTRACKW
# define HDN_ENDTRACK HDN_ENDTRACKW
# define HDN_TRACK HDN_TRACKW
#else /* not UNICODE */
# define HDN_ITEMCHANGING HDN_ITEMCHANGINGA
# define HDN_ITEMCHANGED HDN_ITEMCHANGEDA
# define HDN_ITEMCLICK HDN_ITEMCLICKA
# define HDN_ITEMDBLCLICK HDN_ITEMDBLCLICKA
# define HDN_DIVIDERDBLCLICK HDN_DIVIDERDBLCLICKA
# define HDN_BEGINTRACK HDN_BEGINTRACKA
# define HDN_ENDTRACK HDN_ENDTRACKA
# define HDN_TRACK HDN_TRACKA
#endif /* not UNICODE */

#define HDI_WIDTH       0x0001
#define HDI_HEIGHT      HDI_WIDTH
#define HDI_TEXT        0x0002
#define HDI_FORMAT      0x0004
#define HDI_LPARAM      0x0008
#define HDI_BITMAP      0x0010
#define HDF_LEFT        0x0000
#define HDF_RIGHT       0x0001
#define HDF_CENTER      0x0002
#define HDF_JUSTIFYMASK 0x0003
#define HDF_RTLREADING  0x0004
#define HDF_BITMAP      0x2000
#define HDF_STRING      0x4000
#define HDF_OWNERDRAW   0x8000
#include "pshpack1.h"
typedef struct _HD_ITEMA
{
  UINT mask;
  INT cxy;
  LPSTR pszText;
  HBITMAP hbm;
  INT cchTextMax;
  INT fmt;
  LPARAM lParam;
} HD_ITEMA, *PHD_ITEMA, *LPHD_ITEMA;
typedef struct _HD_ITEMW
{
  UINT mask;
  INT cxy;
  LPWSTR pszText;
  HBITMAP hbm;
  INT cchTextMax;
  INT fmt;
  LPARAM lParam;
} HD_ITEMW, *PHD_ITEMW, *LPHD_ITEMW;
#include "poppack.h"
#ifdef UNICODE
# define HD_ITEM HD_ITEMW
# define PHD_ITEM PHD_ITEMW
# define LPHD_ITEM LPHD_ITEMW
#else /* not UNICODE */
# define HD_ITEM HD_ITEMA
# define PHD_ITEM PHD_ITEMA
# define LPHD_ITEM LPHD_ITEMA
#endif /* not UNICODE */

#include "pshpack1.h"
typedef struct _HD_LAYOUT
{
  LPRECT prc;
  LPWINDOWPOS pwpos;
} HD_LAYOUT, *PHD_LAYOUT, *LPHD_LAYOUT;
#include "poppack.h"

#define HHT_NOWHERE   0x0001
#define HHT_ONHEADER  0x0002
#define HHT_ONDIVIDER 0x0004
#define HHT_ONDIVOPEN 0x0008
#define HHT_TORIGHT   0x0400
#define HHT_TOLEFT    0x0800

#include "pshpack1.h"
typedef struct _HD_NOTIFYA
{
  NMHDR hdr;
  INT iItem;
  INT iButton;
  HD_ITEMA *pitem;
} HD_NOTIFYA, *PHD_NOTIFYA, *LPHD_NOTIFYA;
typedef struct _HD_NOTIFYW
{
  NMHDR hdr;
  INT iItem;
  INT iButton;
  HD_ITEMW *pitem;
} HD_NOTIFYW, *PHD_NOTIFYW, *LPHD_NOTIFYW;
#include "poppack.h"
#ifdef UNICODE
# define HD_NOTIFY HD_NOTIFYW
# define PHD_NOTIFY PHD_NOTIFYW
# define LPHD_NOTIFY LPHD_NOTIFYW
#else /* not UNICODE */
# define HD_NOTIFY HD_NOTIFYA
# define PHD_NOTIFY PHD_NOTIFYA
# define LPHD_NOTIFY LPHD_NOTIFYA
#endif /* not UNICODE */

#define Header_DeleteItem(hWnd,index) SendMessageA(hWnd,HDM_DELETEITEM,index,0)
#define Header_GetItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_GETITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_GetItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_GETITEMW,index,GPOINTER_TO_INT(phdi))
#define Header_GetItemCount(hWnd) SendMessageA(hWnd,HDM_GETITEMCOUNT,0,0)
#define Header_InsertItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_INSERTITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_InsertItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_INSERTITEMW,index,GPOINTER_TO_INT(phdi))
#define Header_Layout(hWnd,playout) SendMessageA(hWnd,HDM_LAYOUT,0,GPOINTER_TO_INT(playout))
#define Header_SetItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_SETITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_SetItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_SETITEMW,index,GPOINTER_TO_INT(phdi))
#ifdef UNICODE
# define Header_GetItem Header_GetItemW
# define Header_InsertItem Header_InsertItemW
# define Header_SetItem Header_SetItemW
#else /* not UNICODE */
# define Header_GetItem Header_GetItemA
# define Header_InsertItem Header_InsertItemA
# define Header_SetItem Header_SetItemA
#endif /* not UNICODE */

/* ja:スピンボタンコントロール */
#include "w32updwn.h"


extern W32LdrExport commctrl_exports[];


HPROPSHEETPAGE WINAPI CreatePropertySheetPageA (LPCPROPSHEETPAGEA lppsp);
HPROPSHEETPAGE WINAPI CreatePropertySheetPageW (LPCPROPSHEETPAGEW lppsp);
HWND WINAPI CreateUpDownControl (DWORD dwStyle, INT x, INT y, INT cx, INT cy, HWND hParent, INT nID, HINSTANCE hInst, HWND hBuddy, INT nUpper, INT nLower, INT nPos);
BOOL WINAPI DestroyPropertySheetPage (HPROPSHEETPAGE hPage);
INT WINAPI ImageList_Add (HIMAGELIST hImage, HBITMAP hBitmap, HBITMAP hBitmapMask);
INT WINAPI ImageList_AddIcon (HIMAGELIST hImage, HICON hIcon);
INT WINAPI ImageList_AddMasked (HIMAGELIST hImage, HBITMAP hBitmap, COLORREF crMask);
BOOL WINAPI ImageList_BeginDrag (HIMAGELIST hImage, INT iTrack, INT dxHotspot, INT dyHotspot);
BOOL WINAPI ImageList_Copy (HIMAGELIST hImageDst, INT iDst, HIMAGELIST hImageSrc, INT iSrc, UINT uFlags);
HIMAGELIST WINAPI ImageList_Create (INT cx, INT cy, UINT flags, INT cInitial, INT cGrow);
BOOL WINAPI ImageList_Destroy (HIMAGELIST hImage);
BOOL WINAPI ImageList_DragEnter (HWND hWndLock, INT x, INT y);
BOOL WINAPI ImageList_DragLeave (HWND hWndLock);
BOOL WINAPI ImageList_DragMove (INT x, INT y);
BOOL WINAPI ImageList_DragShowNolock (BOOL fShow);
BOOL WINAPI ImageList_Draw (HIMAGELIST hImage, INT i, HDC hdcDst, INT x, INT y, UINT fStyle);
BOOL WINAPI ImageList_DrawEx (HIMAGELIST hImage, INT i, HDC hdcDst, INT x, INT y, INT dx, INT dy, COLORREF rgbBk, COLORREF rgbFg, UINT fStyle);
BOOL WINAPI ImageList_DrawIndirect (LPIMAGELISTDRAWPARAMS lpImageListDrawIndirect);
HIMAGELIST WINAPI ImageList_Duplicate (HIMAGELIST hImage);
VOID WINAPI ImageList_EndDrag (VOID);
COLORREF WINAPI ImageList_GetBkColor (HIMAGELIST hImage);
HIMAGELIST ImageList_GetDragImage (LPPOINT lppt, LPPOINT lpptHotspot);
HICON WINAPI ImageList_GetIcon (HIMAGELIST hImage, INT i, UINT flags);
BOOL WINAPI ImageList_GetIconSize (HIMAGELIST hImage, INT *cx, INT *cy);
INT WINAPI ImageList_GetImageCount (HIMAGELIST hImage);
BOOL WINAPI ImageList_GetImageInfo (HIMAGELIST hImage, INT i, LPIMAGEINFO lpImageInfo);
HIMAGELIST WINAPI ImageList_LoadImageA (HINSTANCE hInstance, LPCSTR lpszBitmap, INT cx, INT cGrow, COLORREF crMask, UINT uType, UINT uFlags);
HIMAGELIST WINAPI ImageList_LoadImageW (HINSTANCE hInstance, LPCWSTR lpszBitmap, INT cx, INT cGrow, COLORREF crMask, UINT uType, UINT uFlags);
HIMAGELIST WINAPI ImageList_Merge (HIMAGELIST hImage1, INT i1, HIMAGELIST hImage2, INT i2, INT dx, INT dy);
HIMAGELIST WINAPI ImageList_Read (LPSTREAM lpstm);
BOOL WINAPI ImageList_Remove (HIMAGELIST hImage, INT i);
BOOL WINAPI ImageList_Replace (HIMAGELIST hImage, INT i, HBITMAP hBitmap, HBITMAP hBitmapMask);
INT WINAPI ImageList_ReplaceIcon (HIMAGELIST hImage, INT i, HICON hIcon);
COLORREF ImageList_SetBkColor (HIMAGELIST hImage, COLORREF clrBk);
BOOL WINAPI ImageList_SetDragCursorImage (HIMAGELIST hImage, INT iDrag, INT dxHotspot, INT dyHotspot);
BOOL WINAPI ImageList_SetIconSize (HIMAGELIST hImage, INT cx, INT cy);
BOOL WINAPI ImageList_SetImageCount (HIMAGELIST hIMage, UINT uNewCount);
BOOL WINAPI ImageList_SetOverlayImage (HIMAGELIST hIMage, INT iImage, INT iOverlay);
BOOL WINAPI ImageList_Write (HIMAGELIST hImage, LPSTREAM lpstm);
void WINAPI InitCommonControls (VOID);
BOOL WINAPI InitCommonControlsEx (LPINITCOMMONCONTROLSEX pInitCtrls);
INT WINAPI PropertySheetA (LPCPROPSHEETHEADERA lppsph);
INT WINAPI PropertySheetW (LPCPROPSHEETHEADERW lppsph);


#ifdef UNICODE
# define CreatePropertySheetPage CreatePropertySheetPageW
# define ImageList_LoadImage ImageList_LoadImageW
# define PropertySheet PropertySheetW
#else /* not UNICODE*/
# define CreatePropertySheetPage CreatePropertySheetPageA
# define ImageList_LoadImage ImageList_LoadImageA
# define PropertySheet PropertySheetA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __COMMCTRL_H__ */
