/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __GDI32_H__
#define __GDI32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define RGB(r,g,b) ((COLORREF)((BYTE)(r)|((BYTE)(g)<<8)|((BYTE)(b)<<16)))
#define TRANSPARENT 1
#define OPAQUE      2
typedef LPVOID HBRUSH, HGDIOBJ;
typedef DWORD COLORREF, *PCOLORREF, *LPCOLORREF;
#include <pshpack1.h>
typedef struct _SIZE
{
  LONG cx;
  LONG cy;
} SIZE, *PSIZE, *LPSIZE;
#include "poppack.h"
/* ja:ビットマップ */
#include <pshpack1.h>
typedef struct _BITMAP
{
  LONG bmType;
  LONG bmWidth;
  LONG bmHeight;
  LONG bmWidthBytes;
  WORD bmPlanes;
  WORD bmBitsPixel;
  LPVOID bmBits;
} BITMAP, *PBITMAP, *LPBITMAP;
typedef struct _PALETTEENTRY
{
  BYTE peRed;
  BYTE peGreen;
  BYTE peBlue;
  BYTE peFlags;
} PALETTEENTRY, *PPALETTEENTRY, *LPPALETTEENTRY;
#include "poppack.h"
/* ja:フォント */
typedef LPVOID HFONT;
#define ANSI_CHARSET        0
#define DEFAULT_CHARSET     1
#define SYMBOL_CHARSET      2
#define SHIFTJIS_CHARSET    128
#define HANGEUL_CHARSET     129
#define GB2312_CHARSET      134
#define CHINESEBIG5_CHARSET 136
#define GREEK_CHARSET       161
#define TURKISH_CHARSET     162
#define HEBREW_CHARSET      177
#define ARABIC_CHARSET      178
#define BALTIC_CHARSET      186
#define RUSSIAN_CHARSET     204
#define EASTEUROPE_CHARSET  238
#define THAI_CHARSET        222
#define JOHAB_CHARSET       130
#define MAC_CHARSET         77
#define OEM_CHARSET         255
#define OUT_DEFAULT_PRECIS   0
#define OUT_STRING_PRECIS    1
#define OUT_CHARACTER_PRECIS 2
#define OUT_STROKE_PRECIS    3
#define OUT_TT_PRECIS        4
#define OUT_DEVICE_PRECIS    5
#define OUT_RASTER_PRECIS    6
#define OUT_TT_ONLY_PRECIS   7
#define OUT_OUTLINE_PRECIS   8
#define CLIP_DEFAULT_PRECIS   0x00
#define CLIP_CHARACTER_PRECIS 0x01
#define CLIP_STROKE_PRECIS    0x02
#define CLIP_MASK             0x0F
#define CLIP_LH_ANGLES        0x10
#define CLIP_TT_ALWAYS        0x20
#define CLIP_EMBEDDED         0x80
#define DEFAULT_QUALITY 0
#define DRAFT_QUALITY   1
#define PROOF_QUALITY   2
#define DEFAULT_PITCH  0x00
#define FIXED_PITCH    0x01
#define VARIABLE_PITCH 0x02
#define LF_FACESIZE 32
#include <pshpack1.h>
typedef struct _LOGFONTA
{
  LONG lfHeight;
  LONG lfWidth;
  LONG lfEscapement;
  LONG lfOrientation;
  LONG lfWeight;
  BYTE lfItalic;
  BYTE lfUnderline;
  BYTE lfStrikeOut;
  BYTE lfCharSet;
  BYTE lfOutPrecision;
  BYTE lfClipPrecision;
  BYTE lfQuality;
  BYTE lfPitchAndFamily;
  CHAR lfFaceName[LF_FACESIZE];
} LOGFONTA, *PLOGFONTA, *LPLOGFONTA;
typedef struct _LOGFONTW
{
  LONG lfHeight;
  LONG lfWidth;
  LONG lfEscapement;
  LONG lfOrientation;
  LONG lfWeight;
  BYTE lfItalic;
  BYTE lfUnderline;
  BYTE lfStrikeOut;
  BYTE lfCharSet;
  BYTE lfOutPrecision;
  BYTE lfClipPrecision;
  BYTE lfQuality;
  BYTE lfPitchAndFamily;
  WCHAR lfFaceName[LF_FACESIZE];
} LOGFONTW, *PLOGFONTW, *LPLOGFONTW;
#include "poppack.h"
#ifdef UNICODE
# define LOGFONT LOGFONTW
# define PLOGFONT PLOGFONTW
# define LPLOGFONT LPLOGFONTW
#else /* not UNICODE */
# define LOGFONT LOGFONTA
# define PLOGFONT PLOGFONTA
# define LPLOGFONT LPLOGFONTA
#endif /* not UNICODE */


extern W32LdrExport gdi32_exports[];


BOOL WINAPI BitBlt (HDC hdcDest, INT nXDest, INT nYDest, INT nWidth, INT nHeight, HDC hdcSrc, INT nXSrc, INT nYSrc, DWORD dwRop);
HDC WINAPI CreateCompatibleDC (HDC hdc);
BOOL WINAPI DeleteDC (HDC hdc);
BOOL WINAPI DeleteObject (HGDIOBJ hObject);
INT WINAPI GetDeviceCaps (HDC hdc, INT nIndex);
COLORREF WINAPI GetNearestColor (HDC hdc, COLORREF crColor);
INT WINAPI GetObjectA (HGDIOBJ hObject, INT cbBuffer, LPVOID lpvObject);
INT WINAPI GetObjectW (HGDIOBJ hObject, INT cbBuffer, LPVOID lpvObject);
UINT WINAPI GetSystemPaletteEntries (HDC hdc, UINT iStartIndex, UINT nEntries, LPPALETTEENTRY lppe);
HGDIOBJ WINAPI SelectObject (HDC hdc, HGDIOBJ hgdiobj);


#ifdef UNICODE
# define GetObject GetObjectW
#else /* not UNICODE*/
# define GetObject GetObjectA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GDI32_H__ */
