/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32private.h"
#include "commctrl.h"
#include <gdk/gdkkeysyms.h>


typedef struct _W32LdrNoteData
{
  W32LdrWindowData wd;
  GtkWidget *notebook;
  GtkWidget *button_help;
  GtkWidget *button_apply, *button_ok, *button_cancel, *button_close;
  GtkWidget *button_back, *button_next, *button_finish;
} W32LdrNoteData;


static LRESULT WINAPI
w32prsht_DefWindowProc (HWND   hWnd,
                        UINT   Msg,
                        WPARAM wParam,
                        LPARAM lParam)
{
  W32LdrWindowData *wd;
  W32LdrNoteData *nd;

  nd = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (!nd)
    return 0;
  wd = &nd->wd;
  switch (Msg)
    {
      case PSM_SETCURSEL:
        {
          gint page, n_pages;
#if ! GTK_CHECK_VERSION(2,2,0)
          GList *glist;
#endif /* not GTK_CHECK_VERSION(2,2,0) */

          page = lParam ? gtk_notebook_page_num (GTK_NOTEBOOK (nd->notebook),
                                            GINT_TO_POINTER (lParam)) : wParam;
#if GTK_CHECK_VERSION(2,2,0)
          n_pages = gtk_notebook_get_n_pages (GTK_NOTEBOOK (nd->notebook));
#else /* not GTK_CHECK_VERSION(2,2,0) */
          glist = gtk_container_get_children (GTK_CONTAINER (nd->notebook));
          n_pages = g_list_length (glist);
          g_list_free (glist);
#endif /* not GTK_CHECK_VERSION(2,2,0) */
          if (0 <= page && page < n_pages)
            {
              gtk_notebook_set_current_page (GTK_NOTEBOOK (nd->notebook), page);
              return TRUE;
            }
        }
        return FALSE;
      case PSM_REMOVEPAGE:
        {
          gint page, n_pages;
#if ! GTK_CHECK_VERSION(2,2,0)
          GList *glist;
#endif /* not GTK_CHECK_VERSION(2,2,0) */

          page = lParam ? gtk_notebook_page_num (GTK_NOTEBOOK (nd->notebook),
                                            GINT_TO_POINTER (lParam)) : wParam;
#if GTK_CHECK_VERSION(2,2,0)
          n_pages = gtk_notebook_get_n_pages (GTK_NOTEBOOK (nd->notebook));
#else /* not GTK_CHECK_VERSION(2,2,0) */
          glist = gtk_container_get_children (GTK_CONTAINER (nd->notebook));
          n_pages = g_list_length (glist);
          g_list_free (glist);
#endif /* not GTK_CHECK_VERSION(2,2,0) */
          if (0 <= page && page < n_pages)
            gtk_notebook_remove_page (GTK_NOTEBOOK (nd->notebook), page);
        }
        return 0;
      case PSM_ADDPAGE:
        if (lParam)
          {
            HPROPSHEETPAGE hPage;
            W32LdrPageData *pd;

            hPage = GINT_TO_POINTER (lParam);
            pd = g_object_get_data (G_OBJECT (hPage), "user_data");
            if (pd)
              {
                gtk_notebook_append_page (GTK_NOTEBOOK (nd->notebook), hPage,
                                                    gtk_label_new (pd->title));
                gtk_widget_show (hPage);
                return TRUE;
              }
          }
        return FALSE;
      case PSM_CHANGED:
        if (wParam && nd->button_apply)
          {
            HPROPSHEETPAGE hPage;
            W32LdrPageData *pd;

            hPage = GINT_TO_POINTER (wParam);
            pd = g_object_get_data (G_OBJECT (hPage), "user_data");
            if (pd)
              {
                pd->edited = TRUE;
                gtk_widget_set_sensitive (nd->button_apply, TRUE);
                return TRUE;
              }
          }
        return FALSE;
      case PSM_RESTARTWINDOWS:
        return 0;
      case PSM_REBOOTSYSTEM:
        return 0;
      case PSM_CANCELTOCLOSE:
        if (nd->button_ok)
          gtk_widget_hide (nd->button_ok);
        if (nd->button_cancel)
          gtk_widget_set_sensitive (nd->button_cancel, FALSE);
        if (nd->button_close)
          gtk_widget_show (nd->button_close);
        return TRUE;
      case PSM_QUERYSIBLINGS:
        {
          gint i;
          GtkWidget *child;

          for (i = 0; (child = gtk_notebook_get_nth_page
                                        (GTK_NOTEBOOK (nd->notebook), i)); i++)
            {
              LRESULT lResult;

              lResult = wd->widechar ? SendMessageW (child, PSM_QUERYSIBLINGS,
                                                            wParam, lParam)
                                     : SendMessageA (child, PSM_QUERYSIBLINGS,
                                                            wParam, lParam);
              if (lResult != 0)
              return lResult;
            }
        }
        return 0;
      case PSM_UNCHANGED:
        if (wParam && nd->button_apply)
          {
            HPROPSHEETPAGE hPage;
            W32LdrPageData *pd;

            hPage = GINT_TO_POINTER (wParam);
            pd = g_object_get_data (G_OBJECT (hPage), "user_data");
            if (pd)
              {
                gint i;
                GtkWidget *child;

                pd->edited = FALSE;
                for (i = 0; (child = gtk_notebook_get_nth_page
                                        (GTK_NOTEBOOK (nd->notebook), i)); i++)
                  {
                    pd = g_object_get_data (G_OBJECT (child), "user_data");
                    if (!pd)
                      return FALSE;
                    if (pd->edited)
                      break;
                  }
                if (!child)
                  {
                    gtk_widget_set_sensitive (nd->button_apply, FALSE);
                    return TRUE;
                  }
              }
          }
        return FALSE;
      case PSM_APPLY:
        {
          gboolean result = TRUE;
          gint i;
          GtkWidget *child;
          NMHDR nmh;
          W32LdrWindowData *wd;
          W32LdrNoteData *nd;

          nd = g_object_get_data (G_OBJECT (hWnd), "user_data");
          wd = &nd->wd;
          nmh.hwndFrom = hWnd;
          nmh.idFrom = wd->wID;
          nmh.code = PSN_APPLY;
          for (i = 0; (child = gtk_notebook_get_nth_page
                                        (GTK_NOTEBOOK (nd->notebook), i)); i++)
            if ((wd->widechar ? SendMessageW (child, WM_NOTIFY, wd->wID,
                                    GPOINTER_TO_INT (&nmh))
                              : SendMessageA (child, WM_NOTIFY, wd->wID,
                                    GPOINTER_TO_INT (&nmh))) != PSNRET_NOERROR)
              result = FALSE;
          return result;
        }
      case PSM_SETTITLEA:
      case PSM_SETTITLEW:
        {
          gchar *utf8str;

          utf8str = lParam > G_MAXUINT16 ? Msg ==  PSM_SETTITLEA
                            ? w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam))
                            : g_utf16_to_utf8 (GINT_TO_POINTER (lParam),
                                                        -1, NULL, NULL, NULL)
                            : w32ldr_atom_get_name (lParam);
          if (utf8str)
            {
              gtk_window_set_title (GTK_WINDOW (hWnd), utf8str);
              g_free (utf8str);
            }
        }
        return 0;
      case PSM_SETWIZBUTTONS:
        if (nd->button_back)
          gtk_widget_set_sensitive (nd->button_back, lParam & PSWIZB_BACK);
        if (nd->button_next)
          gtk_widget_set_sensitive (nd->button_back, lParam & PSWIZB_NEXT);
        if (nd->button_finish)
          gtk_widget_set_sensitive (nd->button_back, lParam & PSWIZB_FINISH);
        return 0;
      case PSM_PRESSBUTTON:
        switch (wParam)
          {
            case PSBTN_BACK:
              if (nd->button_back)
                gtk_button_clicked (GTK_BUTTON (nd->button_back));
              break;
            case PSBTN_NEXT:
              if (nd->button_next)
                gtk_button_clicked (GTK_BUTTON (nd->button_next));
              break;
            case PSBTN_FINISH:
              if (nd->button_finish)
                gtk_button_clicked (GTK_BUTTON (nd->button_finish));
              break;
            case PSBTN_OK:
              if (nd->button_ok)
                gtk_button_clicked (GTK_BUTTON (nd->button_ok));
              break;
            case PSBTN_APPLYNOW:
              if (nd->button_apply)
                gtk_button_clicked (GTK_BUTTON (nd->button_apply));
              break;
            case PSBTN_CANCEL:
              if (nd->button_cancel)
                gtk_button_clicked (GTK_BUTTON (nd->button_cancel));
              break;
            case PSBTN_HELP:
              if (nd->button_help)
                gtk_button_clicked (GTK_BUTTON (nd->button_help));
          }
        return TRUE;
      case PSM_SETCURSELID:
        return FALSE;
      case PSM_SETFINISHTEXTA:
      case PSM_SETFINISHTEXTW:
        if (nd->button_finish)
          {
            gchar *utf8str;

            utf8str = Msg ==  PSM_SETFINISHTEXTA
                            ? w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam))
                            : g_utf16_to_utf8 (GINT_TO_POINTER (lParam),
                                                        -1, NULL, NULL, NULL);
            gtk_button_set_label (GTK_BUTTON (nd->button_finish), utf8str);
            g_free (utf8str);
          }
        return 0;
      case PSM_GETTABCONTROL:
        return GPOINTER_TO_INT (NULL);
      case PSM_ISDIALOGMESSAGE:
        return FALSE;
      case PSM_GETCURRENTPAGEHWND:
        {
          gint page;

          page = gtk_notebook_get_current_page (GTK_NOTEBOOK (nd->notebook));
          if (page >= 0)
            return GPOINTER_TO_INT (gtk_notebook_get_nth_page
                                        (GTK_NOTEBOOK (nd->notebook), page));
        }
        return GPOINTER_TO_INT (NULL);
    }
  return wd->widechar ? DefWindowProcW (hWnd, Msg, wParam, lParam)
                       : DefWindowProcA (hWnd, Msg, wParam, lParam);
}


/* ja:ボタンが押されたとき */
static void
w32prsht_clicked_current (GtkWidget *widget,
                          GtkWidget *prsht)
{
  gint page;
  W32LdrNoteData *nd;

  nd = g_object_get_data (G_OBJECT (prsht), "user_data");
  page = gtk_notebook_get_current_page (GTK_NOTEBOOK (nd->notebook));
  if (page >= 0)
    {
      GtkWidget *child;

      child = gtk_notebook_get_nth_page (GTK_NOTEBOOK (nd->notebook), page);
      if (child)
        {
          NMHDR nmh;
          W32LdrWindowData *wd;

          wd = &nd->wd;
          nmh.hwndFrom = prsht;
          nmh.idFrom = wd->wID;
          nmh.code = GPOINTER_TO_UINT (g_object_get_data
                                            (G_OBJECT (widget), "user_data"));
          if (wd->widechar)
            SendMessageW (child, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
          else
            SendMessageA (child, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
        }
    }
}


/* ja:ボタンが押されたとき */
static void
w32prsht_clicked_all (GtkWidget *widget,
                      GtkWidget *prsht)
{
  gint i;
  GtkWidget *child;
  NMHDR nmh;
  W32LdrWindowData *wd;
  W32LdrNoteData *nd;

  nd = g_object_get_data (G_OBJECT (prsht), "user_data");
  wd = &nd->wd;
  nmh.hwndFrom = prsht;
  nmh.idFrom = wd->wID;
  nmh.code = GPOINTER_TO_UINT (g_object_get_data
                                            (G_OBJECT (widget), "user_data"));
  for (i = 0; (child = gtk_notebook_get_nth_page
                                        (GTK_NOTEBOOK (nd->notebook), i)); i++)
    if (wd->widechar)
      SendMessageW (child, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
    else
      SendMessageA (child, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
}


/* ja:ページが切り替わったとき */
static void
w32prsht_switch_page (GtkNotebook     *notebook,
                      GtkNotebookPage *page,
                      guint            page_num,
                      GtkWidget       *prsht)
{
  GtkWidget *child;

  child = gtk_notebook_get_nth_page (notebook, page_num);
  if (child)
    {
      W32LdrWindowData *wd;
      NMHDR nmh;

      wd = g_object_get_data (G_OBJECT (prsht), "user_data");
      nmh.hwndFrom = prsht;
      nmh.idFrom = wd->wID;
      nmh.code = PSN_SETACTIVE;
      if (wd->widechar)
        SendMessageW (child, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
      else
        SendMessageA (child, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
    }
}


/* ja:破棄 */
static void
w32prsht_destroy (GtkWidget *widget,
                  gpointer   user_data)
{
  gint i;
  GtkWidget *child;
  NMHDR nmh;
  W32LdrWindowData *wd;
  W32LdrNoteData *nd;

  nd = g_object_get_data (G_OBJECT (widget), "user_data");
  wd = &nd->wd;
  nmh.hwndFrom = widget;
  nmh.idFrom = wd->wID;
  nmh.code = PSN_RESET;
  for (i = 0; (child = gtk_notebook_get_nth_page
                                        (GTK_NOTEBOOK (nd->notebook), i)); i++)
    if (wd->widechar)
      SendMessageW (child, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
    else
      SendMessageA (child, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
}


/* ja:ボタンが押されたとき */
static void
w32prsht_cancel_clicked (GtkWidget *widget,
                         GtkWidget *prsht)
{
  gint i;
  GtkWidget *child;
  NMHDR nmh;
  W32LdrWindowData *wd;
  W32LdrNoteData *nd;

  nd = g_object_get_data (G_OBJECT (prsht), "user_data");
  wd = &nd->wd;
  nmh.hwndFrom = prsht;
  nmh.idFrom = wd->wID;
  nmh.code = PSN_QUERYCANCEL;
  for (i = 0; (child = gtk_notebook_get_nth_page
                                        (GTK_NOTEBOOK (nd->notebook), i)); i++)
    if (wd->widechar ? SendMessageW (child, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmh))
                     : SendMessageA (child, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmh)))
      break;
  if (!child)
    {
      g_signal_connect (G_OBJECT (prsht), "destroy",
                                        G_CALLBACK (w32prsht_destroy), NULL);
      gtk_widget_destroy (prsht);
    }
}


/* ja:閉じるボタンが押されたとき */
static gboolean
w32prsht_delete_event (GtkWidget *widget,
                       GdkEvent  *event,
                       gpointer   user_data)
{
  gboolean result = FALSE;
  gint i;
  GtkWidget *child;
  NMHDR nmh;
  W32LdrWindowData *wd;
  W32LdrNoteData *nd;

  nd = g_object_get_data (G_OBJECT (widget), "user_data");
  wd = &nd->wd;
  nmh.hwndFrom = widget;
  nmh.idFrom = wd->wID;
  nmh.code = PSN_QUERYCANCEL;
  for (i = 0; (child = gtk_notebook_get_nth_page
                                        (GTK_NOTEBOOK (nd->notebook), i)); i++)
    if (wd->widechar ? SendMessageW (child, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmh))
                     : SendMessageA (child, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmh)))
      break;
  if (child)
    result = TRUE;
  else
    g_signal_connect (G_OBJECT (widget), "destroy",
                                        G_CALLBACK (w32prsht_destroy), NULL);
  return result;
}


GtkWidget *
w32ldr_control_create_prsht (const gchar    *windowname,
                             const guint32   style,
                             const guint32   exstyle,
                             const gint      width,
                             const gint      height,
                             const guint16   id,
                             HWND            hWndParent,
                             HINSTANCE       hInstance,
                             const gboolean  widechar)
{
  gchar *title;
  GtkWidget *prsht, *notebook, *hbox, *button_cancel, *button_help;
  GtkWidget *button_apply, *button_ok, *button_close;
  GtkWidget *button_back, *button_next, *button_finish;
  W32LdrNoteData *nd;
  W32LdrWindowData *wd;

  /* ja:ダイアログ */
  prsht = gtk_dialog_new ();
  title = w32ldr_atom_get_string (windowname);
  if (title)
    {
      gtk_window_set_title (GTK_WINDOW (prsht), title);
      g_free (title);
    }
  gtk_dialog_set_has_separator (GTK_DIALOG (prsht), FALSE);
  g_signal_connect (G_OBJECT (prsht), "delete-event",
                                    G_CALLBACK (w32prsht_delete_event), NULL);
  /* ja:ノートブック */
  notebook = gtk_notebook_new ();
  g_signal_connect (G_OBJECT (prsht), "switch-page",
                                    G_CALLBACK (w32prsht_switch_page), NULL);
  gtk_widget_show (notebook);
  /* ja:ボタン */
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), SPACING);
  if (style & PSH_HASHELP)
    {
      button_help = gtk_button_new_from_stock (GTK_STOCK_HELP);
      g_object_set_data (G_OBJECT (button_help), "user_data",
                                            GUINT_TO_POINTER (PSN_HELP));
      g_signal_connect (G_OBJECT (button_help), "clicked",
                                G_CALLBACK (w32prsht_clicked_current), prsht);
      gtk_box_pack_start (GTK_BOX (hbox), button_help, FALSE, FALSE, 0);
      gtk_widget_show (button_help);
    }
  else
    {
      button_help = NULL;
    }
  button_cancel = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
  g_object_set_data (G_OBJECT (button_cancel), "user_data",
                                        GUINT_TO_POINTER (PSN_QUERYCANCEL));
  g_signal_connect (G_OBJECT (button_cancel), "clicked",
                                G_CALLBACK (w32prsht_cancel_clicked), prsht);
  gtk_widget_show (button_cancel);
  if (style & PSH_WIZARD)
    {
      GtkWidget *wbox;

      button_apply = button_ok = button_close = NULL;
      button_back = gtk_button_new_from_stock (GTK_STOCK_GO_BACK);
      button_next = gtk_button_new_from_stock (GTK_STOCK_GO_FORWARD);
      button_finish = gtk_button_new_from_stock (GTK_STOCK_GOTO_LAST);
      g_object_set_data (G_OBJECT (button_back), "user_data",
                                            GUINT_TO_POINTER (PSN_WIZBACK));
      g_object_set_data (G_OBJECT (button_next), "user_data",
                                            GUINT_TO_POINTER (PSN_WIZNEXT));
      g_object_set_data (G_OBJECT (button_finish), "user_data",
                                            GUINT_TO_POINTER (PSN_WIZFINISH));
      g_signal_connect (G_OBJECT (button_back), "clicked",
                                G_CALLBACK (w32prsht_clicked_current), prsht);
      g_signal_connect (G_OBJECT (button_next), "clicked",
                                G_CALLBACK (w32prsht_clicked_current), prsht);
      g_signal_connect (G_OBJECT (button_finish), "clicked",
                                G_CALLBACK (w32prsht_clicked_current), prsht);
      wbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (wbox), button_back, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (wbox), button_next, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (hbox), button_finish, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (hbox), button_cancel, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (hbox), wbox, FALSE, FALSE, 0);
      gtk_widget_show (button_back);
      gtk_widget_show (button_next);
      gtk_widget_show (button_finish);
    }
  else
    {
      button_apply = style & PSH_NOAPPLYNOW
                        ? gtk_button_new_from_stock (GTK_STOCK_APPLY) : NULL;
      button_ok = gtk_button_new_from_stock (GTK_STOCK_OK);
      button_close = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
      button_back = button_next = button_finish = NULL;
      g_object_set_data (G_OBJECT (button_apply), "user_data",
                                                GUINT_TO_POINTER (PSN_APPLY));
      g_object_set_data (G_OBJECT (button_ok), "user_data",
                                                GUINT_TO_POINTER (PSN_APPLY));
      g_object_set_data (G_OBJECT (button_close), "user_data",
                                                GUINT_TO_POINTER (PSN_APPLY));
      g_signal_connect (G_OBJECT (button_apply), "clicked",
                                    G_CALLBACK (w32prsht_clicked_all), prsht);
      g_signal_connect (G_OBJECT (button_ok), "clicked",
                                    G_CALLBACK (w32prsht_clicked_all), prsht);
      g_signal_connect (G_OBJECT (button_close), "clicked",
                                    G_CALLBACK (w32prsht_clicked_all), prsht);
      gtk_box_pack_end (GTK_BOX (hbox), button_close, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (hbox), button_ok, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (hbox), button_cancel, FALSE, FALSE, 0);
      if (button_apply)
        {
          gtk_box_pack_end (GTK_BOX (hbox), button_apply, FALSE, FALSE, 0);
          gtk_widget_show (button_apply);
          gtk_widget_set_sensitive (button_apply, FALSE);
        }
      gtk_widget_show (button_ok);
    }
  /* ja:フレームとボックス */
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (prsht)->vbox),
                                                    notebook, TRUE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (prsht)->vbox), hbox, FALSE, FALSE, 0);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (prsht), TRUE);
  gtk_window_set_position (GTK_WINDOW (prsht), GTK_WIN_POS_CENTER_ON_PARENT);
  nd = g_malloc (sizeof (W32LdrNoteData));
  wd = &nd->wd;
  wd->dwStyle = style;
  wd->dwExStyle = exstyle;
  wd->hInstance = hInstance;
  wd->lpfnWndProc = w32prsht_DefWindowProc;
  wd->hWndParent = hWndParent;
  wd->wID = id;
  wd->dwUserData = 0;
  wd->lpDialogFunc = NULL;
  wd->lResult = -1;
  wd->dwUser = 0;
  wd->csa = NULL;
  wd->csw = NULL;
  wd->dwInitParam = 0;
  wd->widechar = widechar;
  wd->resizable = TRUE;
  wd->classname = g_strdup ("SysPropertySheet");
  wd->focus = NULL;
  wd->child = NULL;
  nd->notebook = notebook;
  nd->button_help = button_help;
  nd->button_apply = button_apply;
  nd->button_ok = button_ok;
  nd->button_cancel = button_cancel;
  nd->button_close = button_close;
  nd->button_back = button_back;
  nd->button_next = button_next;
  nd->button_finish = button_finish;
  g_object_set_data (G_OBJECT (prsht), "user_data", wd);
  return prsht;
}
