/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32private.h"


static LRESULT WINAPI
w32sbar_DefWindowProc (HWND   hWnd,
                       UINT   Msg,
                       WPARAM wParam,
                       LPARAM lParam)
{
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (!wd)
    return 0;
  switch (Msg)
    {
      case SBM_SETPOS:
        {
          gdouble value;

          value = gtk_range_get_value (GTK_RANGE (hWnd));
          gtk_range_set_value (GTK_RANGE (hWnd), wParam);
          return value;
        }
      case SBM_GETPOS:
        return gtk_range_get_value (GTK_RANGE (hWnd));
      case SBM_SETRANGE:
        gtk_range_set_range (GTK_RANGE (hWnd), wParam, lParam);
        return gtk_range_get_value (GTK_RANGE (hWnd));
      case SBM_GETRANGE:
        {
          GtkAdjustment *adjustment;

          adjustment = gtk_range_get_adjustment (GTK_RANGE (hWnd));
          *(LPINT)GINT_TO_POINTER (wParam) = adjustment->lower;
          *(LPINT)GINT_TO_POINTER (lParam) = adjustment->upper;
        }
        return TRUE;
      case SBM_ENABLE_ARROWS:
        return FALSE;
      case SBM_SETRANGEREDRAW:
        return w32sbar_DefWindowProc (hWnd, SBM_SETRANGE, wParam, lParam);
      case SBM_SETSCROLLINFO:
        return gtk_range_get_value (GTK_RANGE (hWnd));
      case SBM_GETSCROLLINFO:
        return FALSE;
    }
  return wd->widechar ? DefWindowProcW (hWnd, Msg, wParam, lParam)
                       : DefWindowProcA (hWnd, Msg, wParam, lParam);
}


#if GTK_CHECK_VERSION(2,6,0)
static gboolean
w32sbar_change_value (GtkRange      *range,
                      GtkScrollType  scroll,
                      gdouble        value,
                      gpointer       user_data)
{
  UINT uMsg;
  WPARAM wParam;
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (range), "user_data");
  uMsg = (wd->dwStyle & SBS_TYPEMASK) == SBS_HORZ ? WM_HSCROLL : WM_VSCROLL;
  switch (scroll)
    {
      case GTK_SCROLL_NONE:          return FALSE;
      case GTK_SCROLL_JUMP:          wParam = SB_THUMBPOSITION; break;
      case GTK_SCROLL_STEP_BACKWARD: return FALSE;
      case GTK_SCROLL_STEP_FORWARD:  return FALSE;
      case GTK_SCROLL_PAGE_BACKWARD: return FALSE;
      case GTK_SCROLL_PAGE_FORWARD:  return FALSE;
      case GTK_SCROLL_STEP_UP:       wParam = SB_LINEUP;        break;
      case GTK_SCROLL_STEP_DOWN:     wParam = SB_LINEDOWN;      break;
      case GTK_SCROLL_PAGE_UP:       wParam = SB_PAGEUP;        break;
      case GTK_SCROLL_PAGE_DOWN:     wParam = SB_PAGEDOWN;      break;
      case GTK_SCROLL_STEP_LEFT:     wParam = SB_LINELEFT;      break;
      case GTK_SCROLL_STEP_RIGHT:    wParam = SB_LINERIGHT;     break;
      case GTK_SCROLL_PAGE_LEFT:     wParam = SB_PAGELEFT;      break;
      case GTK_SCROLL_PAGE_RIGHT:    wParam = SB_PAGERIGHT;     break;
      case GTK_SCROLL_START:         wParam = SB_THUMBTRACK;    break;
      case GTK_SCROLL_END:           wParam = SB_ENDSCROLL;     break;
      default: return FALSE;
    }
  if (wd->widechar)
    SendMessageW (wd->hWndParent, uMsg,
                MAKEWPARAM (wParam, (gint16)value), GPOINTER_TO_INT (range));
  else
    SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wParam, (gint16)value), GPOINTER_TO_INT (range));
  return FALSE;
}
#endif /* GTK_CHECK_VERSION(2,6,0) */


GtkWidget *
w32ldr_control_create_scroll (const gchar    *windowname,
                              const guint32   style,
                              const guint32   exstyle,
                              const gint      width,
                              const gint      height,
                              const guint16   id,
                              HWND            hWndParent,
                              HINSTANCE       hInstance,
                              const gboolean  widechar)
{
  GtkWidget *scroll;
  W32LdrWindowData *wd;

  switch (style & SBS_TYPEMASK)
    {
      case SBS_HORZ:
        scroll = gtk_hscrollbar_new
                    (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 1, 1, 1)));
        break;
      case SBS_VERT:
        scroll = gtk_vscrollbar_new
                    (GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 0, 1, 1, 1)));
        break;
      default:
        g_print ("Unsupported Control ScrollBar.\n");
        return NULL;
    }
#if GTK_CHECK_VERSION(2,6,0)
  g_signal_connect (G_OBJECT (scroll), "change-value",
                                    G_CALLBACK (w32sbar_change_value), NULL);
#endif /* GTK_CHECK_VERSION(2,6,0) */
  wd = g_malloc (sizeof (W32LdrWindowData));
  wd->dwStyle = style;
  wd->dwExStyle = exstyle;
  wd->hInstance = hInstance;
  wd->lpfnWndProc = w32sbar_DefWindowProc;
  wd->hWndParent = hWndParent;
  wd->wID = id;
  wd->dwUserData = 0;
  wd->lpDialogFunc = NULL;
  wd->lResult = -1;
  wd->dwUser = 0;
  wd->csa = NULL;
  wd->csw = NULL;
  wd->dwInitParam = 0;
  wd->widechar = widechar;
  wd->resizable = TRUE;
  wd->classname = g_strdup ("SCROLLBAR");
  wd->focus = NULL;
  wd->child = NULL;
  g_object_set_data (G_OBJECT (scroll), "user_data", wd);
  return scroll;
}
