/*
    Video maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __FILE_H__
#define __FILE_H__


#include "vmaid.h"


G_BEGIN_DECLS


#define FILE_SAVE_AVI 0
#define FILE_SAVE_BITMAP 1
#define FILE_SAVE_WAVE 2
#define FILE_SAVE_SCENARIO 2


typedef struct _FileOpen {
  gchar *file;
  gboolean merge;
} FileOpen;
typedef struct _FileSave {
  gchar *file;
  AviEdit *avi_edit[3];
  AviSave *avi_save;
} FileSave;


/******************************************************************************
*                                                                             *
* ja:ファイル入力関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:ファイルを開く(独立スレッド)
    file_open,Open情報
          RET,ウインドウ情報                                                */
VmaidWindow *
file_open_edit (FileOpen *file_open);


/*  ja:AVIファイルを保存する(独立スレッド)
    file_save,Save情報
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
file_save_edit (FileSave *file_save);


G_END_DECLS


#endif /* __FILE_H__ */
