/*
    Video maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __SIGFILE_H__
#define __SIGFILE_H__


#include "vmaid.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(タイマ)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_timeout (gpointer data);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(フレーム)                                        *
*                                                                             *
******************************************************************************/
gboolean
signal_focus_in (GtkWidget     *widget,
                 GdkEventFocus *event,
                 VmaidWindow   *vmaid);


gboolean
signal_focus_out (GtkWidget     *widget,
                  GdkEventFocus *event,
                  VmaidWindow   *vmaid);


void
signal_realize (GtkWidget *widget,
                gpointer   user_data);


void
signal_value_changed_hscroll (GtkAdjustment *adjust,
                              VmaidWindow   *vmaid);


gboolean
signal_config (GtkWidget         *widget,
               GdkEventConfigure *config,
               VmaidWindow       *vmaid);


void
signal_destroy_draw (GtkWidget   *widget,
                     VmaidWindow *vmaid);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(描画)                                            *
*                                                                             *
******************************************************************************/
gboolean
signal_expose (GtkWidget      *widget,
               GdkEventExpose *event,
               VmaidWindow    *vmaid);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(マウス)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_button_press_draw (GtkWidget      *widget,
                          GdkEventButton *event,
                          VmaidWindow    *vmaid);


gboolean
signal_motion_notify (GtkWidget      *widget,
                      GdkEventMotion *event,
                      VmaidWindow    *vmaid);


gboolean
signal_button_release (GtkWidget      *widget,
                       GdkEventButton *event,
                       VmaidWindow    *vmaid);


gboolean
signal_scroll (GtkWidget      *widget,
               GdkEventScroll *event,
               VmaidWindow    *vmaid);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(キー)                                            *
*                                                                             *
******************************************************************************/
gboolean
signal_key_press (GtkWidget   *widget,
                  GdkEventKey *event,
                  VmaidWindow *vmaid);


G_END_DECLS


#endif /* __SIGFILE_H__ */
