/*
    Video maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __VMAID_H__
#define __VMAID_H__


#include "gcommon.h"
#include "avicore/avicore.h"
#ifdef G_OS_WIN32
# include <tchar.h>
# include <windows.h>
#endif /* G_OS_WIN32 */


G_BEGIN_DECLS


#define VMAID_VERSION_NOTICE "Video maid "VERSION" ("BUILD_ENVIRONMENT")"
#define VMAID_COPYRIGHT_NOTICE "Copyright (C) 1998-2008 Kazuki IWAMOTO"


typedef struct _VmaidCursor
{
  gint stream;                  /* ja:ストリームの位置(0,1) */
  gint frame;                   /* ja:現在の位置(0...) */
} VmaidCursor;
typedef struct _VmaidHistory
{
  AviEdit *avi_edit[2];         /* ja:AVI編集 */
  VmaidCursor cursor, select;
  struct _VmaidHistory *next;
} VmaidHistory;
typedef struct _VmaidWindow
{
  gboolean selfrm;              /* ja:選択されたフレーム表示 */
  gint top;                     /* ja:ウインドウの先頭 */
  gint width, height;           /* ja:フレームのサイズ */
  guint rate, scale;            /* ja:レート÷スケール=1秒間のフレーム数 */
  guint timer_id;               /* ja:スクロール用タイマ */
  AviEdit *avi_edit[2];         /* ja:AVI編集 */
  VmaidCursor cursor;           /* ja:キャレットの位置 */
  VmaidCursor select;           /* ja:選択開始位置,-1:選択なし */
  VmaidHistory *undo, *redo;    /* ja:編集履歴 */
  GtkWidget *drawing;           /* ja:描画領域 */
  GtkWidget *hscroll;           /* ja:水平スクロールバー */
} VmaidWindow;


extern gboolean caret;                  /* ja:キャレットの形 */
extern gboolean addext;                 /* ja:TRUE:拡張子を追加する */
extern gboolean newfile;                /* ja:TRUE:新規ファイル,FALSE:なし */
extern gboolean second;                 /* ja:TRUE:新規,FALSE:既存 */
extern gboolean default_ratio;          /* ja:TRUE:縦/横の比率を保持する */
extern gboolean default_selfrm;         /* ja:TRUE:選択されたフレーム表示 */
extern gboolean file_merge;             /* ja:TRUE:連番,FALSE:単独 */
extern gchar *open_path;                /* ja:開くのパス */
extern gchar *save_path;                /* ja:名前を付けて保存のパス */
extern gint def_width,def_height;       /* ja:デフォルトのウインドウのサイズ */
extern gint default_view;               /* ja:ウインドウが作成時の初期値 */
extern gint license;                    /* ja:ライセンス */
extern guint default_rate;              /* ja:ウインドウが作成時の初期値 */
extern guint timer_id;                  /* ja:タイマID */
extern GObject *clipboard;              /* ja:クリップボード */
extern GObject *history;                /* ja:ファイルの履歴 */
extern GdkBitmap *bitmap0;              /* ja:波背景 */
extern GdkBitmap *bitmap1;              /* ja:網背景 */
extern GtkWidget *window;               /* ja:ウインドウ */
extern GtkWidget *mdi;                  /* en:MDI */
extern GtkWidget *tview;                /* ja:リストボックス */
extern GtkWidget *status;               /* ja:ステータスウインドウ */
extern GtkPositionType n_pos;           /* ja:ノートブックの位置 */
extern PangoLayout *system_font_layout;
extern gint system_font_height;         /* ja:フォントの高さ */
extern GdkColor system_color[4];


G_END_DECLS


#endif /* __VMAID_H__ */
