/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WINDEF_H__
#define __WINDEF_H__


#include "gcommon.h"


G_BEGIN_DECLS


#define __stdcall __attribute__((__stdcall__))
#define __cdecl __attribute__((__cdecl__))
#define CALLBACK __stdcall
#define PASCAL __stdcall
#define WINAPI __stdcall
#define CDECL __cdecl
#define WINAPIV __cdecl
#define NEAR
#define FAR


/* en:Macros to split words and longs. */
#define LOBYTE(w)               ((BYTE)(WORD)(w))
#define HIBYTE(w)               ((BYTE)((WORD)(w) >> 8))
#define LOWORD(l)               ((WORD)(DWORD)(l))
#define HIWORD(l)               ((WORD)((DWORD)(l) >> 16))
#define SLOWORD(l)              ((SHORT)(LONG)(l))
#define SHIWORD(l)              ((SHORT)((LONG)(l) >> 16))
#define MAKEWORD(low,high)      ((WORD)(((BYTE)(low))                       \
                                                | ((WORD)((BYTE)(high))) << 8))
#define MAKELONG(low,high)      ((LONG)(((WORD)(low))                       \
                                            | (((DWORD)((WORD)(high))) << 16)))
#define MAKELPARAM(low,high)    ((LPARAM)MAKELONG(low,high))
#define MAKEWPARAM(low,high)    ((WPARAM)MAKELONG(low,high))
#define MAKELRESULT(low,high)   ((LRESULT)MAKELONG(low,high))


/* ja:基本 */
#define CONST const
typedef gint32      BOOL,      *PBOOL,      *LPBOOL;
typedef void        VOID,      *PVOID,      *LPVOID;
typedef const void  CVOID,     *PCVOID,     *LPCVOID;
typedef gchar       CHAR,      *PCHAR,      *LPCHAR;
typedef guchar      UCHAR,     *PUCHAR,     *LPUCHAR;
typedef gunichar2   WCHAR,     *PWCHAR,     *LPWCHAR;
typedef gunichar2   WUCHAR,    *PWUCHAR,    *LPWUCHAR;
typedef gint16      SHORT,     *PSHORT,     *LPSHORT;
typedef guint16     USHORT,    *PUSHORT,    *LPUSHORT;
typedef gint32      INT,       *PINT,       *LPINT;
typedef guint32     UINT,      *PUINT,      *LPUINT;
typedef gint32      LONG,      *PLONG,      *LPLONG;
typedef guint32     ULONG,     *PULONG,     *LPULONG;
typedef guint32     SIZE_T;
typedef gint32      INT_PTR,   *PINT_PTR,   *LPINT_PTR;
typedef guint32     UINT_PTR,  *PUINT_PTR,  *LPUINT_PTR;
typedef gint32      LONG_PTR,  *PLONG_PTR,  *LPLONG_PTR;
typedef guint32     ULONG_PTR, *PULONG_PTR, *LPULONG_PTR;
typedef glonglong   LONGLONG,  *PLONGLONG,  *LPLONGLONG;
typedef gulonglong  ULONGLONG, *PULONGLONG, *LPULONGLONG;
/* en:WORD */
typedef guint8      BYTE,   *PBYTE,   *LPBYTE;
typedef guint16     WORD,   *PWORD,   *LPWORD;
typedef guint32     DWORD,  *PDWORD,  *LPDWORD;
/* ja:文字列 */
typedef CHAR                *PSTR,    *LPSTR;
typedef CONST CHAR          *PCSTR,   *LPCSTR;
typedef WCHAR               *PWSTR,   *LPWSTR;
typedef CONST WCHAR         *PCWSTR,  *LPCWSTR;
/* ja:コールバック */
typedef LONG LRESULT;
typedef LONG LPARAM;
typedef LONG WPARAM;
/* ja:ハンドル */
typedef LPVOID HANDLE;
typedef struct _W32LdrModule *HINSTANCE, *HMODULE;
typedef GtkWidget *HWND;
typedef struct _W32LdrDC *HDC;
/* ja:アトム */
typedef WORD ATOM, *PATOM, *LPATOM;
/* ja:構造体 */
#include "pshpack1.h"
typedef struct _SECURITY_ATTRIBUTES
{
  DWORD nLength;
  LPVOID lpSecurityDescriptor;
  BOOL bInheritHandle;
} SECURITY_ATTRIBUTES, *PSECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES;
/* ja:時間 */
typedef struct _FILETIME
{
  DWORD dwLowDateTime;
  DWORD dwHighDateTime;
} FILETIME, *PFILETIME, *LPFILETIME;
typedef CONST FILETIME *PCFILETIME, *LPCFILETIME;
#include "poppack.h"


/* ja:リソース */
#define RT_CURSOR       1
#define RT_BITMAP       2
#define RT_ICON         3
#define RT_MENU         4
#define RT_DIALOG       5
#define RT_STRING       6
#define RT_FONTDIR      7
#define RT_FONT         8
#define RT_ACCELERATOR  9
#define RT_RCDATA       10
#define RT_MESSAGETABLE 11
#define RT_GROUP_CURSOR 12
#define RT_GROUP_ICON   14
#define RT_VERSION      16
#define RT_DLGINCLUDE   17
#define RT_PLUGPLAY     19
#define RT_VXD          20
#define RT_ANICURSOR    21
#define RT_ANIICON      22
#define RT_HTML         23
typedef LPCVOID HRSRC;
#define IS_INTRESOURCE(x)   ((GPOINTER_TO_UINT(x)>>16)==0)
#define MAKEINTRESOURCEA(i) (LPSTR)(GUINT_TO_POINTER((DWORD)(WORD)(i)))
#define MAKEINTRESOURCEW(i) (LPWSTR)(GUINT_TO_POINTER((DWORD)(WORD)(i)))
#ifdef UNICODE
# define MAKEINTRESOURCE MAKEINTRESOURCEW
#else /* not UNICODE */
# define MAKEINTRESOURCE MAKEINTRESOURCEA
#endif /* not UNICODE */


G_END_DECLS


#endif /* __WINDEF_H__ */
