/*
    Video maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __SIGNAL_H__
#define __SIGNAL_H__


#include "vmaid.h"


gboolean signal_timeout(gpointer data);
gboolean signal_focus_in(GtkWidget *widget,GdkEventFocus *event,
														VmaidWindow *vmaid);
gboolean signal_focus_out(GtkWidget *widget,GdkEventFocus *event,
														VmaidWindow *vmaid);
void signal_realize(GtkWidget *widget,gpointer user_data);
void signal_value_changed_hscroll(GtkAdjustment *adjust,VmaidWindow *vmaid);
gboolean signal_config(GtkWidget *widget,GdkEventConfigure *config,
														VmaidWindow *vmaid);
gboolean signal_expose(GtkWidget *widget,GdkEventExpose *event,
														VmaidWindow *vmaid);
gboolean signal_button_press(GtkWidget *widget,GdkEventButton *event,
														VmaidWindow *vmaid);
gboolean signal_motion_notify(GtkWidget *widget,GdkEventMotion *event,
														VmaidWindow *vmaid);
gboolean signal_button_release(GtkWidget *widget,GdkEventButton *event,
														VmaidWindow *vmaid);
gboolean signal_key_press(GtkWidget *widget,GdkEventKey *event,
														VmaidWindow *vmaid);
void signal_destroy_draw(GtkWidget *widget,VmaidWindow *vmaid);
void signal_style_set(GtkWidget *widget,GtkStyle *style,gpointer user_data);
void signal_activate_menu_window(GtkWidget *widget,GtkWidget *child);
void signal_activate_menu_history(GtkWidget *widget,gchar *file);
void signal_destroy_menu_history(GtkWidget *widget,gchar *file);
void signal_clicked(GtkWidget *widget,GtkWidget *child);
void signal_switch_page(GtkNotebook *notebook,GtkNotebookPage *page,
											gint page_num,gpointer user_data);
void signal_destroy_notebook(GtkWidget *widget,gpointer user_data);
void signal_select_row(GtkWidget *widget,gint row,gint column,
									GdkEventButton *event,gpointer user_data);
void signal_unselect_row(GtkWidget *widget,gint row,gint column,
									GdkEventButton *event,gpointer user_data);
void signal_drag_data_received(GtkWidget *widget,GdkDragContext *context,
		gint x,gint y,GtkSelectionData *selection_data,guint info,guint time);
gboolean signal_selection_clear(GtkWidget *widget,GdkEventSelection *event,
														gpointer user_data);
void signal_selection_get(GtkWidget *widget,GtkSelectionData *data,
									guint info,guint time,gpointer user_data);
void signal_selection_received(GtkWidget *widget,GtkSelectionData *data,
												guint time,gpointer user_data);
gboolean signal_client_event(GtkWidget *widget,GdkEventClient *event,
														gpointer user_data);
gboolean signal_delete(GtkWidget *widget,GdkEvent *event,gpointer user_data);
void signal_destroy_window(GtkWidget *widget,gpointer user_data);


#endif
