/*
    Video maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <ctype.h>
#include <locale.h>
#include <pthread.h>
#include <stdlib.h>
#include <unistd.h>
#include "vmaid.h"
#include "command.h"
#include "conf.h"
#include "file.h"
#include "general.h"
#include "other.h"
#include "profile.h"
#include "signal.h"
#include "toolbar.h"
#include "version.h"
#include <gdk/gdkrgb.h>


gboolean caret=FALSE;				/* åȤη */
gboolean newfile=FALSE;				/* TRUE:ե,FALSE:ʤ */
gboolean second=FALSE;				/* TRUE:,FALSE:¸ */
gboolean default_ratio=FALSE;		/* TRUE:/Ψݻʤ */
gboolean file_merge=FALSE;			/* TRUE:Ϣ,FALSE:ñ */
gchar *history_file[10];			/* ե */
gchar *open_path=NULL;				/* Υѥ */
gchar *save_path=NULL;				/* ̾դ¸Υѥ */
gchar *clipboard_scenario=NULL;		/* åץܡɤΥƥ */
gint def_width,def_height;			/* ǥեȤΥɥΥ */
gint history=4;						/* ե */
gint instance=-1;					/* ץ̿ѿ */
gint default_view=6;				/* ɥν */
guint default_rate=15;				/* ɥν */
guint timer_id=0;					/* ID */
VmaidCommunication *comm=NULL;		/* ץ̿ѹ¤ */
GdkAtom atom_clipboard;				/* åץܡ */
GdkAtom atom_targets;				/* å */
GdkAtom atom_scenario;				/* ʥꥪ֥ */
GdkAtom atom_videomaid;				/* ץ̿ѥȥ */
GdkBitmap *bitmap0;					/* ط */
GdkBitmap *bitmap1;					/* ط */
GtkWidget *window;					/* ɥ */
GtkWidget *notebook;				/* Ρȥ֥å */
GtkWidget *clist;					/* ꥹȥܥå */
GtkWidget *status;					/* ơɥ */
GtkPositionType n_pos=GTK_POS_TOP;	/* Ρȥ֥åΰ */
GtkItemFactory *item_factory_menu;	/* ˥塼 */
GtkItemFactory *item_factory_popup;	/* ݥåץå */
GdkFont *system_font=NULL;
gint system_fontheight;				/* եȤι⤵ */
gint system_fontascent;				/* եȤΥȤι⤵ */
GdkColor system_color[4]={	{0,0x0000,0x0000,0x0000},{0,0xffff,0xffff,0xffff},
							{0,0xffff,0xffff,0xffff},{0,0x0000,0x0000,0x8000}};
GtkTargetEntry targets_vmaid[]={	/* Video maid󶡲ǽʥ쥯 */
	{"Video maid Scenario Object",0,TARGET_VMAID}};
GtkTargetEntry targets_comm[]={		/* Video maid󶡲ǽʥ쥯 */
	{"STRING",0,TARGET_STRING}};


/******************************************************************************
*                                                                             *
* ᥤؿ                                                                  *
*                                                                             *
******************************************************************************/
static gchar *menu_translate(const gchar *path,gpointer func_data)
{
   return gettext(path);
}


int main(int argc,char *argv[])
{
	gboolean *arg_files;
	gchar *arg,*endptr,*str,*key;
	gint i,j,k,l,m,opt,leng,ascent,height;
	pthread_t id;
	OpenFile *open_file;
	PROFILE *profile;
	GdkEventClient event;
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkAccelGroup *accel_group;
	GtkStyle *style;
	GtkWidget *menubar,*toolbar,*text,*handle,*scroll,*vbox;
	GtkWidget *sub_menu,*menu_item;
	VmaidCommunication *p;
	gchar *title[4]={N_("⡼"),N_("ե"),N_(""),N_("ʹԾ")};
	GtkItemFactoryEntry menu_items[]={
{N_("/ե(_F)"),                       NULL,         NULL,            0,"<Branch>"},
{N_("/ե(F)/(_N)"),           "<control>N", command_new,     0,"<Item>"},
{N_("/ե(F)/(_O)..."),            "<control>O", command_open,    0,"<Item>"},
{N_("/ե(F)/Ĥ(_C)"),             "<control>W", command_close,   0,"<Item>"},
{N_("/ե(F)/̾Ĥ¸(_A)..."),"<control>S", command_save,    0,"<Item>"},
{N_("/ե(F)/Sep1"),                   NULL,         NULL,            0,"<Separator>"},
{N_("/ե(F)/ץӥ塼(_V)..."),      "<control>P", NULL,            0,"<Item>"},
{N_("/ե(F)/ץѥƥ(_I)..."),      "<alt>Return",command_property,0,"<Item>"},
{N_("/ե(F)/Sep2"),                   NULL,         NULL,            0,"<Separator>"},
{N_("/ե(F)/λ(_X)"),               "<control>Q", command_exit,    0,"<Item>"},
{N_("/Խ(_E)"),                           NULL,         NULL,            0,"<Branch>"},
{N_("/Խ(E)/᤹(_U)"),               "<control>Z", command_undo,    0,"<Item>"},
{N_("/Խ(E)/ľ(_R)"),               "F4",         command_redo,    0,"<Item>"},
{N_("/Խ(E)/Sep1"),                       NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/ڤ(_T)"),               "<control>X", command_cut,     0,"<Item>"},
{N_("/Խ(E)/ԡ(_C)"),                 "<control>C", command_copy,    0,"<Item>"},
{N_("/Խ(E)/Žդ(_P)"),               "<control>V", command_paste,   0,"<Item>"},
{N_("/Խ(E)/(_L)"),                   NULL,         command_delete,  0,"<Item>"},
{N_("/Խ(E)/Sep2"),                       NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/Ϣ(_M)..."),                "<control>M", NULL,            0,"<Item>"},
{N_("/Խ(E)/ե졼ذư(_J)..."),  "<control>J", command_jump,    0,"<Item>"},
{N_("/Խ(E)/Sep3"),                       NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/٤(_A)"),             "<control>A", command_all,     0,"<Item>"},
{N_("/ɽ(_V)"),                           NULL,         NULL,            0,"<Branch>"},
{N_("/ɽ(V)/ѹ(_I)..."),          NULL,         command_size,    0,"<Item>"},
{N_("/ץ(_O)"),                     NULL,         NULL,            0,"<Branch>"},
{N_("/ץ(O)/(_C)..."),          NULL,         conf_dialog,     0,"<Item>"},
{N_("/(_T)"),                         NULL,         NULL,            0,"<Branch>"},
{N_("/(T)/󥻥(_C)"),           NULL,         command_cancel,  0,"<Item>"},
{N_("/ɥ(_W)"),                     NULL,         NULL,            0,"<Branch>"},
{N_("/إ(_H)"),                         NULL,         NULL,            0,"<Branch>"},
{N_("/إ(H)/С(_A)..."),    NULL,         version_dialog,  0,"<Item>"}};
	GtkItemFactoryEntry popup_items[]={
{N_("/᤹(_U)"),                       "<control>Z", NULL,            0,"<Item>"},
{"/Sep1",                                   NULL,         NULL,            0,"<Separator>"},
{N_("/ڤ(_T)"),                       "<control>X", NULL,            0,"<Item>"},
{N_("/ԡ(_C)"),                         "<control>C", NULL,            0,"<Item>"},
{N_("/Žդ(_P)"),                       "<control>V", NULL,            0,"<Item>"},
{N_("/(_L)"),                           NULL,         NULL,            0,"<Item>"},
{"/Sep2",                                   NULL,         NULL,            0,"<Separator>"},
{N_("/٤(_A)"),                     "<control>A", NULL,            0,"<Item>"}};
	/* Drag&Drop */
	GtkTargetEntry drag_types[1]={{"text/uri-list",0,0}};
	/* ޥɥ饤  */
	struct arg_opt {
		const char *name;
		const int key;
		const char *arg;
		const char *doc;
	};
	const struct arg_opt arg_opts[]={
	{"history",'h',"NUM",         N_("ե")},
	{"new",    'n',"ON/OFF",      N_("ե򳫤")},
	{"size",   's',"WIDTH,HEIGHT",N_("ɥΥ")},
	{"second", 'x',"ON/OFF",      N_("ɥ򳫤")},
	{"version",'v',NULL,          N_("С")},
	{"help",   '?',NULL,          N_("إ")},
	{NULL,     0,  NULL,          NULL}};
	static gchar *xpm0[]={
"4 8 2 1",
" 	c None",
".	c #000000",
".   ",
".   ",
"   .",
"   .",
"  . ",
"  . ",
" .  ",
" .  "};
	static gchar *xpm1[]={
"2 2 2 1",
" 	c None",
".	c #000000",
". ",
" ."};


	/*  */
	setlocale(LC_ALL,"");
	bindtextdomain(PACKAGE,LOCALEDIR);
	textdomain(PACKAGE);
	g_thread_init(NULL);
	gtk_set_locale();
	gtk_init(&argc,&argv);
	gdk_rgb_init();

	def_width=gdk_screen_width()*2/3;
	def_height=gdk_screen_height()*2/3;
	memset(history_file,0,sizeof(gchar *)*10);
	/* 쥸ȥ꤫ɤ߽Ф */
	if ((profile=profile_open(".vmaid"))!=NULL) {
		if (!profile_get_value(profile,"vmaid","history",
				(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			history=4;
		if (!profile_get_value(profile,"vmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			newfile=FALSE;
		if (!profile_get_value(profile,"vmaid","second",
				(gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			second=FALSE;
		if (!profile_get_value(profile,"vmaid","def_width",
				(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_width=gdk_screen_width()*2/3;
		if (!profile_get_value(profile,"vmaid","def_height",
				(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_height=gdk_screen_height()*2/3;
		if (!profile_get_value(profile,"vmaid","n_pos",
				(gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			n_pos=GTK_POS_TOP;
		if (!profile_get_value(profile,"vmaid","ratio",
				(gpointer)&default_ratio,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			default_ratio=FALSE;
		if (!profile_get_value(profile,"vmaid","merge",
				(gpointer)&file_merge,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			file_merge=FALSE;
		if (!profile_get_value(profile,"vmaid","view",
				(gpointer)&default_view,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			default_view=6;
		if (!profile_get_value(profile,"vmaid","rate",
				(gpointer)&default_rate,sizeof(guint),PROFILE_VALUE_TYPE_INT))
			default_rate=15;
		open_path=profile_get_string(profile,"vmaid","openpath");
		save_path=profile_get_string(profile,"vmaid","savepath");
		/* ե */
		for (i=0;i<history;i++) {
			key=g_strdup_printf("history%d",i);
			history_file[i]=profile_get_string(profile,"vmaid",key);
			g_free(key);
			if (history_file[i]==NULL)
				break;
			if (*history_file[i]=='\0') {
				g_free(history_file[i]);
				history_file[i]=NULL;
				break;
			}
		}
		profile_close(profile);
	}
	/* ޥɥ饤β */
	arg_files=g_malloc(argc*sizeof(gboolean));
	memset(arg_files,0,argc*sizeof(gboolean));
	i=1;/* i:Υץ,j:iʸ,k:iʹߤarg */
	while (i<argc) {
		if ((argv[i])[0]=='-') {/* ץ */
			j=1;
			k=i;
			while ((argv[i])[j]!='\0' && (argv[i])[j]!='=') {
				if ((argv[i])[1]=='-') {	/* Ĺץ */
					opt=0;
					for (l=0;arg_opts[l].name!=NULL;l++) {
						leng=strlen(arg_opts[l].name);
						if (g_strncasecmp(argv[i]+2,arg_opts[l].name,leng)==0
											&& ((argv[i])[leng+2]=='\0'
												|| (argv[i])[leng+2]=='=')) {
							opt=arg_opts[l].key;
							j=leng+2;
							break;
						}
					}
				} else {					/* ûץ */
					opt=tolower((argv[i])[j++]);
				}
				arg=NULL;
				for (l=0;arg_opts[l].name!=NULL;l++)
					if (arg_opts[l].key==opt && arg_opts[l].arg!=NULL) {
						if (i==k) {
							for (m=2;(argv[i])[m]!='\0' && (argv[i])[m]!='=';
																		m++);
							arg=(argv[i])[m]=='\0'?argv[++k]:argv[i]+m+1;
							k++;
						} else {
							arg=argv[k++];
						}
						if (arg==NULL || *arg=='\0')
							opt=0;
						break;
					}
				switch (opt) {
					case 'h':
						strval(&history,arg,10,TRUE);
						if (history<0)
							history=0;
						else if (history>10)
							history=10;
						break;
					case 'n':
						newfile=g_strcasecmp(arg,"OK")==0
												|| g_strcasecmp(arg,"ON")==0
												|| g_strcasecmp(arg,"TRUE")==0
												|| g_strcasecmp(arg,"YES")==0;
						break;
					case 's':
						def_width=strtol(arg,&endptr,0);
						def_height=strtol(++endptr,&endptr,0);
						break;
					case 'x':
						second=g_strcasecmp(arg,"OK")==0
												|| g_strcasecmp(arg,"ON")==0
												|| g_strcasecmp(arg,"TRUE")==0
												|| g_strcasecmp(arg,"YES")==0;
						break;
					case 'v':
						g_print(
"Video maid "VERSION"\n"
"Copyright (C) 1998-2002 Iwamoto,Kazuki\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
						);
						g_free(arg_files);
						return 0;
					default:
						g_print(
"Copyright (c) 1998-2002 Iwamoto,Kazuki\n\n"
"Usage: %s [OPTION...] [FILE...]\n\n",argv[0]);
						for (i=0;arg_opts[i].name;i++) {
							if (arg_opts[i].arg!=NULL)
								str=g_strdup_printf("  -%c, --%s=%s",
											arg_opts[i].key,arg_opts[i].name,
															arg_opts[i].arg);
							else
								str=g_strdup_printf("  -%c, --%s",
											arg_opts[i].key, arg_opts[i].name);
							g_print("%-26s %s\n",str,arg_opts[i].doc);
							g_free(str);
						}
						g_print("\n");
						g_free(arg_files);
						return 0;
				}
			}
			i=i<k?k:i+1;
		} else {/* ե */
			arg_files[i++]=TRUE;
		}
	}

	/* ᥤ󥦥ɥ */
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window),"Video maid");
	gtk_window_set_default_size(GTK_WINDOW(window),def_width,def_height);
	gtk_signal_connect(GTK_OBJECT(window),"delete-event",
										GTK_SIGNAL_FUNC(signal_delete),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"destroy",
												signal_destroy_window,NULL);
	gtk_widget_realize(window);
	/* Drag and Drop */
	gtk_drag_dest_set(window,GTK_DEST_DEFAULT_MOTION
						| GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
												drag_types,1,GDK_ACTION_COPY);
	gtk_signal_connect(GTK_OBJECT(window),"drag-data-received",
							GTK_SIGNAL_FUNC(signal_drag_data_received),NULL);
	/* åץܡ/ץ̿ */
	atom_clipboard=gdk_atom_intern("CLIPBOARD",FALSE);
	atom_targets=gdk_atom_intern("TARGETS",FALSE);
	atom_scenario=gdk_atom_intern("Video maid Scenario Object",FALSE);
	atom_videomaid=gdk_atom_intern("Video maid InterProcess communication",
																		FALSE);
	gtk_selection_add_targets(window,atom_clipboard,
				targets_vmaid,sizeof(targets_vmaid)/sizeof(GtkTargetEntry));
	if (!second)
		gtk_selection_add_targets(window,atom_videomaid,targets_comm,1);
	gtk_signal_connect(GTK_OBJECT(window),"selection-clear-event",
								GTK_SIGNAL_FUNC(signal_selection_clear),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-get",
											signal_selection_get,NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-received",
											signal_selection_received,NULL);
	/* Ρȥ֥å */
	notebook=gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook),TRUE);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),n_pos);
	gtk_signal_connect(GTK_OBJECT(notebook),"switch-page",
								GTK_SIGNAL_FUNC(signal_switch_page),NULL);
	gtk_signal_connect(GTK_OBJECT(notebook),"destroy",
								GTK_SIGNAL_FUNC(signal_destroy_notebook),NULL);
	/* ݥåץå */
	accel_group=gtk_accel_group_new();
	item_factory_popup=gtk_item_factory_new(GTK_TYPE_MENU,
														"<main>",accel_group);
	gtk_item_factory_set_translate_func(item_factory_popup,menu_translate,
																	NULL,NULL);
	gtk_item_factory_create_items(item_factory_popup,
			sizeof(popup_items)/sizeof(GtkItemFactoryEntry),popup_items,NULL);
	/* ˥塼 */
	accel_group=gtk_accel_group_new();
	item_factory_menu=gtk_item_factory_new(GTK_TYPE_MENU_BAR,
														"<main>",accel_group);
	gtk_item_factory_set_translate_func(item_factory_menu,menu_translate,
																	NULL,NULL);
	gtk_item_factory_create_items(item_factory_menu,
			sizeof(menu_items)/sizeof(GtkItemFactoryEntry),menu_items,NULL);
	gtk_accel_group_attach(accel_group,GTK_OBJECT(window));
	menubar=gtk_item_factory_get_widget(item_factory_menu,"<main>");
	/* ġС */
	toolbar=gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_ICONS);
	for (i=0;toolbar_items[i].name!=(gpointer)-1;i++)
		if (toolbar_items[i].name==NULL) {
			gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
		} else {
			pixmap=gdk_pixmap_create_from_xpm_d(window->window,
											&mask,NULL,toolbar_items[i].xpm);
			toolbar_items[i].item=gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
						NULL,_(toolbar_items[i].name),NULL,
						gtk_pixmap_new(pixmap,mask),
						toolbar_items[i].callback,toolbar_items[i].user_data);
		}
	/* ꥹȥܥå */
	clist=gtk_clist_new_with_titles(4,title);
	gtk_clist_column_titles_show(GTK_CLIST(clist));
	gtk_clist_column_titles_passive(GTK_CLIST(clist));
	gtk_clist_set_column_justification(GTK_CLIST(clist),3,GTK_JUSTIFY_RIGHT);
	gtk_clist_set_selection_mode(GTK_CLIST(clist),GTK_SELECTION_MULTIPLE);
	gtk_signal_connect(GTK_OBJECT(clist),"select-row",signal_select_row,NULL);
	gtk_signal_connect(GTK_OBJECT(clist),"unselect-row",
													signal_unselect_row,NULL);
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scroll),clist);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
									GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	/* ơС */
	status=gtk_statusbar_new();
	/* ƥ */
	text=gtk_text_new(NULL,NULL);
	gtk_signal_connect(GTK_OBJECT(text),"style-set",signal_style_set,NULL);
	/* ľܥå/ϥɥܥå */
	vbox=gtk_vbox_new(FALSE,0);
	handle=gtk_handle_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(handle),2);
	gtk_container_add(GTK_CONTAINER(handle),menubar);
	gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
	handle=gtk_handle_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(handle),2);
	gtk_container_add(GTK_CONTAINER(handle),toolbar);
	gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),notebook,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(vbox),status,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),text,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	/* ե */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,
														"<main>/ե(F)");
	for (i=0;i<history && history_file[i]!=NULL;i++) {
		menu_item=gtk_menu_item_new_with_label(history_file[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"activate",
				GTK_SIGNAL_FUNC(signal_activate_menu_history),history_file[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"destroy",
				GTK_SIGNAL_FUNC(signal_destroy_menu_history),history_file[i]);
		gtk_object_set_user_data(GTK_OBJECT(menu_item),history_file[i]);
		gtk_menu_insert(GTK_MENU(sub_menu),menu_item,i+MENUFILE-1);
	}
	if (i>0)
		gtk_menu_insert(GTK_MENU(sub_menu),gtk_menu_item_new(),i+MENUFILE-1);
	/*  */
	timer_id=gtk_timeout_add(500,signal_timeout,NULL);

	/* ˥塼ɽ */
	set_menu_bar(NULL);

	/* ˵ưƤ뤫å */
	if (!second) {
		gtk_selection_convert(window,atom_videomaid,
								GDK_SELECTION_TYPE_STRING,GDK_CURRENT_TIME);
		gdk_threads_enter();
		while (instance<0)
			while (gtk_events_pending())
				gtk_main_iteration();
		gdk_threads_leave();
		if (instance>0) {
			/* ˵ưƤȤ */
			gdk_threads_enter();
			event.type=GDK_CLIENT_EVENT;
			event.window=window->window;
			event.send_event=TRUE;
			event.message_type=atom_videomaid;
			event.data_format=32;
			event.data.l[0]=0;
			event.data.l[4]=getpid();
			gdk_event_send_clientmessage_toall((GdkEvent *)&event);
			event.data_format=8;
			for (i=1;i<argc;i++)
				if (arg_files[i]) {
					arg=get_full_path(argv[i]);
					leng=strlen(arg)+1;
					for (j=0;j<leng;j+=16) {
						memcpy(event.data.b,arg+j,MIN(leng-j,16));
						gdk_event_send_clientmessage_toall((GdkEvent *)&event);
					}
					g_free(arg);
				}
			gdk_threads_leave();
			g_free(arg_files);
			return 0;
		}
		gtk_signal_connect(GTK_OBJECT(window),"client-event",
									GTK_SIGNAL_FUNC(signal_client_event),NULL);
		gtk_selection_owner_set(window,atom_videomaid,GDK_CURRENT_TIME);
	}

	/* ɽ */
	gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
												"<main>/(T)"))),FALSE);
	gtk_widget_show_all(window);
	gtk_widget_hide_all(text);
	gtk_window_set_policy(GTK_WINDOW(window),FALSE,TRUE,TRUE);

	/* ԥޥå */
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&bitmap0,NULL,xpm0);
	gdk_pixmap_unref(pixmap);
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&bitmap1,NULL,xpm1);
	gdk_pixmap_unref(pixmap);

	/* ƥ࿧ */
	style=gtk_widget_get_style(text);
	system_color[0]=style->text[0];
	system_color[1]=style->base[0];
	system_color[2]=style->dark[0];
	system_color[3]=style->bg[3];
	/* ƥե */
	system_font=gdk_font_ref(style->font);
	for (i=0;i<256;i++) {
		gdk_text_extents(system_font,(gchar *)&i,1,
												NULL,NULL,NULL,&ascent,NULL);
		if (system_fontascent<ascent)
			system_fontascent=ascent;
		height=gdk_char_height(system_font,i);
		if (system_fontheight<height)
			system_fontheight=height;
	}

	/* ɥ */
	j=0;
	for (i=1;i<argc;i++)
		if (arg_files[i]) {
			open_file=g_malloc(sizeof(OpenFile));
			open_file->file=g_strdup(argv[i]);
			open_file->merge=file_merge;
			pthread_create(&id,NULL,(void *)open_edit_file,open_file);
			pthread_detach(id);
			j++;
		}
	g_free(arg_files);
	if (newfile && j<=0) {
		pthread_create(&id,NULL,(void *)open_edit_file,NULL);
		pthread_detach(id);
	}

	gdk_threads_enter();
	gtk_main();
	gdk_threads_leave();

	gdk_bitmap_unref(bitmap0);
	gdk_bitmap_unref(bitmap1);

	/* 쥸ȥ˽񤭹 */
	if ((profile=profile_open(".vmaid"))!=NULL) {
		profile_set_value(profile,"vmaid","history",
				(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"vmaid","second",
				(gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"vmaid","def_width",
				(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","def_height",
				(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","n_pos",
				(gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","ratio",
			(gpointer)&default_ratio,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"vmaid","merge",
			(gpointer)&file_merge,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"vmaid","view",
				(gpointer)&default_view,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","rate",
				(gpointer)&default_rate,sizeof(guint),PROFILE_VALUE_TYPE_INT);
		if (open_path!=NULL)
			profile_set_value(profile,"vmaid","openpath",(gpointer)open_path,
										(strlen(open_path)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
		if (save_path!=NULL)
			profile_set_value(profile,"vmaid","savepath",(gpointer)save_path,
										(strlen(save_path)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
		/* ե */
		for (i=0;i<history && history_file[i]!=NULL;i++) {
			key=g_strdup_printf("history%d",i);
			profile_set_value(profile,"vmaid",key,(gpointer)history_file[i],
									(strlen(history_file[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<10) {
			key=g_strdup_printf("history%d",i++);
			profile_set_value(profile,"vmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		profile_close(profile);
	}
	gdk_font_unref(system_font);
	g_free(clipboard_scenario);
	g_free(open_path);
	g_free(save_path);
	for (i=0;i<history;i++)
		g_free(history_file[i]);
	while (comm!=NULL) {
		g_free(comm->arg);
		p=comm->next;
		g_free(comm);
		comm=p;
	}
	return 0;
}
