/*
    avicore
    copyright (c) 2000-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Avi Format                                                                  *
*                                                                             *
******************************************************************************/
#ifndef __AVIFMT_H__
#define __AVIFMT_H__


#ifdef __cplusplus
extern "C" {
#endif


/******************************************************************************
*                                                                             *
* ե빽¤                                                              *
*                                                                             *
******************************************************************************/
#define AVIF_HASINDEX		0x00000010
#define AVIF_MUSTUSEINDEX	0x00000020
#define AVIF_ISINTERLEAVED	0x00000100
#define AVIF_TRUSTCKTYPE	0x00000800
#define AVIF_WASCAPTUREFILE	0x00010000
#define AVIF_COPYRIGHTED	0x00020000
#define AVISF_DISABLED		0x00000001
#define AVIIF_LIST			0x00000001
#define AVIIF_KEYFRAME		0x00000010
#define AVIIF_NOTIME		0x00000100
#define AVIIF_COMPUSE		0x0FFF0000


#define AMH_SIZE 56
#define RECT_SIZE 8
#define ASH_SIZE 56
#define AIE_SIZE 16


#ifdef USE_GCC


/* AVI Main File Header */
typedef struct AviMainHeader_Tag {
	guint32 micro_sec_per_frame __attribute__((packed));
	guint32 max_bytes_per_sec __attribute__((packed));
	guint32 padding_granularity __attribute__((packed));
	guint32 flags __attribute__((packed));
	guint32 total_frames __attribute__((packed));
	guint32 initial_frames __attribute__((packed));
	guint32 streams __attribute__((packed));
	guint32 suggested_buffer_size __attribute__((packed));
	guint32 width __attribute__((packed));
	guint32 height __attribute__((packed));
	guint32 reserved[4] __attribute__((packed));
} AviMainHeader;
/* Rectangle */
typedef struct Rect_Tag {
	gint16 left __attribute__((packed));
	gint16 top __attribute__((packed));
	gint16 right __attribute__((packed));
	gint16 bottom __attribute__((packed));
} Rect;
/* AVI Stream Header */
typedef struct AviStreamHeader_Tag {
	guint32 type __attribute__((packed));
	guint32 handler __attribute__((packed));
	guint32 flags __attribute__((packed));
	guint16 priority __attribute__((packed));
	guint16 language __attribute__((packed));
	guint32 initial_frames __attribute__((packed));
	guint32 scale __attribute__((packed));
	guint32 rate __attribute__((packed));
	guint32 start __attribute__((packed));
	guint32 length __attribute__((packed));
	guint32 suggested_buffer_size __attribute__((packed));
	guint32 quality __attribute__((packed));
	guint32 sample_size __attribute__((packed));
	Rect frame __attribute__((packed));
} AviStreamHeader;
/* AVI Index Entry */
typedef struct AviIndexEntry_Tag {
	guint32 ckid __attribute__((packed));
	guint32 flags __attribute__((packed));
	guint32 offset __attribute__((packed));
	guint32 length __attribute__((packed));
} AviIndexEntry;


#else


typedef struct { guint8 dummy[AMH_SIZE]; } AviMainHeader;
typedef struct { guint8 dummy[RECT_SIZE]; } Rect;
typedef struct { guint8 dummy[ASH_SIZE]; } AviStreamHeader;
typedef struct { guint8 dummy[AIE_SIZE]; } AviIndexEntry;


#endif


/******************************************************************************
*                                                                             *
* ¤Υޥ                                                                *
*                                                                             *
******************************************************************************/
#define amh_get_micro_sec_per_frame(amh) GUINT32_FROM_LE(*(guint32 *)(amh))
#define amh_get_max_bytes_per_sec(amh)										\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+4))
#define amh_get_padding_granularity(amh)									\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+8))
#define amh_get_flags(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+12))
#define amh_get_total_frames(amh)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+16))
#define amh_get_initial_frames(amh)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+20))
#define amh_get_streams(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+24))
#define amh_get_suggested_buffer_size(amh)									\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+28))
#define amh_get_width(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+32))
#define amh_get_height(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+36))
#define amh_set_micro_sec_per_frame(amh,micro_sec_per_frame)				\
						(*(guint32 *)(amh)=GUINT32_TO_LE(micro_sec_per_frame))
#define amh_set_max_bytes_per_sec(amh,max_bytes_per_sec)					\
			(*(guint32 *)((guint8 *)(amh)+4)=GUINT32_TO_LE(max_bytes_per_sec))
#define amh_set_padding_granularity(amh,padding_granularity)				\
		(*(guint32 *)((guint8 *)(amh)+8)=GUINT32_TO_LE(padding_granularity))
#define amh_set_flags(amh,flags)											\
						(*(guint32 *)((guint8 *)(amh)+12)=GUINT32_TO_LE(flags))
#define amh_set_total_frames(amh,total_frames)								\
				(*(guint32 *)((guint8 *)(amh)+16)=GUINT32_TO_LE(total_frames))
#define amh_set_initial_frames(amh,initial_frames)							\
			(*(guint32 *)((guint8 *)(amh)+20)=GUINT32_TO_LE(initial_frames))
#define amh_set_streams(amh,streams)										\
					(*(guint32 *)((guint8 *)(amh)+24)=GUINT32_TO_LE(streams))
#define amh_set_suggested_buffer_size(amh,suggested_buffer_size)			\
		(*(guint32 *)((guint8 *)(amh)+28)=GUINT32_TO_LE(suggested_buffer_size))
#define amh_set_width(amh,width)											\
						(*(guint32 *)((guint8 *)(amh)+32)=GUINT32_TO_LE(width))
#define amh_set_height(amh,height)											\
					(*(guint32 *)((guint8 *)(amh)+36)=GUINT32_TO_LE(height))


#define ash_get_type(ash) GUINT32_FROM_LE(*(guint32 *)(ash))
#define ash_get_handler(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+4))
#define ash_get_flags(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+8))
#define ash_get_priority(ash) GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+12))
#define ash_get_language(ash) GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+14))
#define ash_get_initial_frames(ash)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+16))
#define ash_get_scale(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+20))
#define ash_get_rate(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+24))
#define ash_get_start(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+28))
#define ash_get_length(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+32))
#define ash_get_suggested_buffer_size(ash)									\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+36))
#define ash_get_quality(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+40))
#define ash_get_sample_size(ash)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+44))
#define ash_get_frame_left(ash)												\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+48))
#define ash_get_frame_top(ash)												\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+50))
#define ash_get_frame_right(ash)											\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+52))
#define ash_get_frame_bottom(ash)											\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+54))
#define ash_set_type(ash,type) (*(guint32 *)(ash)=GUINT32_TO_LE(type))
#define ash_set_handler(ash,handler)										\
					(*(guint32 *)((guint8 *)(ash)+4)=GUINT32_TO_LE(handler))
#define ash_set_flags(ash,flags)											\
						(*(guint32 *)((guint8 *)(ash)+8)=GUINT32_TO_LE(flags))
#define ash_set_priority(ash,priority)										\
					(*(guint16 *)((guint8 *)(ash)+12)=GUINT16_TO_LE(priority))
#define ash_set_language(ash,language)										\
					(*(guint16 *)((guint8 *)(ash)+14)=GUINT16_TO_LE(language))
#define ash_set_initial_frames(ash,initial_frames)							\
			(*(guint32 *)((guint8 *)(ash)+16)=GUINT32_TO_LE(initial_frames))
#define ash_set_scale(ash,scale)											\
						(*(guint32 *)((guint8 *)(ash)+20)=GUINT32_TO_LE(scale))
#define ash_set_rate(ash,rate)												\
						(*(guint32 *)((guint8 *)(ash)+24)=GUINT32_TO_LE(rate))
#define ash_set_start(ash,start)											\
						(*(guint32 *)((guint8 *)(ash)+28)=GUINT32_TO_LE(start))
#define ash_set_length(ash,length)											\
					(*(guint32 *)((guint8 *)(ash)+32)=GUINT32_TO_LE(length))
#define ash_set_suggested_buffer_size(ash,suggested_buffer_size)			\
		(*(guint32 *)((guint8 *)(ash)+36)=GUINT32_TO_LE(suggested_buffer_size))
#define ash_set_quality(ash,quality)										\
					(*(guint32 *)((guint8 *)(ash)+40)=GUINT32_TO_LE(quality))
#define ash_set_sample_size(ash,sample_size)								\
				(*(guint32 *)((guint8 *)(ash)+44)=GUINT32_TO_LE(sample_size))
#define ash_set_frame_left(ash,frame_left)									\
				(*(guint16 *)((guint8 *)(ash)+48)=GUINT16_TO_LE(frame_left))
#define ash_set_frame_top(ash,frame_top)									\
				(*(guint16 *)((guint8 *)(ash)+50)=GUINT16_TO_LE(frame_top))
#define ash_set_frame_right(ash,frame_right)								\
				(*(guint16 *)((guint8 *)(ash)+52)=GUINT16_TO_LE(frame_right))
#define ash_set_frame_bottom(ash,frame_bottom)								\
				(*(guint16 *)((guint8 *)(ash)+54)=GUINT16_TO_LE(frame_bottom))


#define aie_get_ckid(aie) GUINT32_FROM_LE(*(guint32 *)(aie))
#define aie_get_flags(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+4))
#define aie_get_offset(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+8))
#define aie_get_length(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+12))

#define aie_set_type(aie,ckid) (*(guint32 *)(aie)=GUINT32_TO_LE(ckid))
#define aie_set_flags(aie,flags)											\
						(*(guint32 *)((guint8 *)(aie)+4)=GUINT32_TO_LE(flags))
#define aie_set_offset(aie,offset)											\
						(*(guint32 *)((guint8 *)(aie)+8)=GUINT32_TO_LE(offset))
#define aie_set_length(aie,length)											\
					(*(guint32 *)((guint8 *)(aie)+12)=GUINT32_TO_LE(length))


#ifdef __cplusplus
}
#endif
#endif
