/*
    avicore
    copyright (c) 2000-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "avibase.h"
#include "avifmt.h"
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/******************************************************************************
*                                                                             *
* ¸ؿ()                                                            *
*                                                                             *
******************************************************************************/
#define AVI_HEADERSIZE 2048


/*	¸ѤΥץ
	avi_save,ץ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_save_free(AviSave *avi_save)
{
	gint i;

	if (avi_save==NULL)
		return FALSE;
	if (avi_save->avi_opt!=NULL) {
		for (i=0;avi_save->avi_opt[i].type!=0;i++) {
			g_free(avi_save->avi_opt[i].param);
			g_free(avi_save->avi_opt[i].bmih);
			g_free(avi_save->avi_opt[i].wfx);
		}
		g_free(avi_save->avi_opt);
	}
	g_free(avi_save);
	return TRUE;
}


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	  avi_opt,ץ
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_avi(AviEdit *avi_edit[],const gchar *file,
							AviOptions *avi_opt,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gboolean key_frame;	/* TRUE:ե졼,FALSE:󥭡ե졼 */
	gboolean recompress;/* TRUE:ư,FALSE:ư̤ʤ */
	gint current;		/* Ǥ1ô֤Υե졼ʤȥ꡼ */
	gint longer=0;		/* Ǥ֤Ĺȥ꡼ */
	gint times;			/* Ǥ1ô֤Υե졼ʤȥ꡼λ */
	gint timer=0;		/* currentλν񤭹ߤδȤʤ */
	gint streams;		/* ȥ꡼ο */
	gint head,header;	/* 饤Ȥ줿إåΥ,إåΥ */
	gint entries=0;		/* AviIndexEntry¤Το */
	gint i,j,samples,length,audio=1,video=1;
	guint8 *p,*data=NULL;
	guint32 fourcc,size;
	AviIndexEntry *index=NULL;
	BitmapInfoHeader *bmih;
	off_t offset;		/* եΥեå */
	static const guint8 dummy=0;
	struct Stream_Tag {
		gboolean active;	/* TRUE:on,FALSE:off */
		gsize size;			/* ̤줿Ȥκ祵 */
		gpointer fmt;		/* ȥ꡼Υإå */
		gsize fmt_size;		/* ȥ꡼ΥإåΥ */
		gint pos;			/* ȥ꡼θ߰ */
		gchar *name;		/* ȥ꡼̾ؤΥݥ */
		AviFrame *avi_frame;
		IcmObject *icm_object;
	} *stream;

	if (avi_edit==NULL || file==NULL)
		return FALSE;
	for (streams=0;avi_edit[streams]!=NULL;streams++);
	if (streams<=0)
		return FALSE;
	if (streams==1 && avi_type(avi_edit[0])==streamtypeAUDIO)
		return avi_save_wave(avi_edit[0],file,func,user_data);
	stream=g_malloc0(streams*sizeof(struct Stream_Tag));

	/* ȥ꡼̾ */
	for (i=0;i<streams;i++)
		switch (avi_type(avi_edit[i])) {
			case streamtypeVIDEO:
				stream[i].name=g_strdup_printf("Video #%d",video++);
				break;
			case streamtypeAUDIO:
				stream[i].name=g_strdup_printf("Audio #%d",audio++);
				break;
			default:
				while (i>0)
					g_free(stream[--i].name);
				g_free(stream);
				return FALSE;
		}

	/* إå׻ */
	header=sizeof(guint32)										/* 'RIFF' */
			+sizeof(guint32)									/*  */
			+sizeof(guint32)									/* 'AVI ' */
				+sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'hdrl' */
					+sizeof(guint32)							/* 'avih' */
					+sizeof(guint32)							/*  */
					+((AMH_SIZE+1)&~1)							/* ¤ */
				+sizeof(guint32)								/* 'JUNK' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32);								/* 'movi' */
	for (i=0;i<streams;i++) {
		switch (avi_type(avi_edit[i])) {
			case streamtypeVIDEO:/* ӥǥ */
				if (avi_opt!=NULL && avi_opt[i].handler!=0
						&& (stream[i].icm_object=icm_open(avi_opt[i].handler,
												ICM_MODE_COMPRESS))!=NULL
						&& (avi_opt[i].param_size<=0
							|| icm_set_state(stream[i].icm_object,
									avi_opt[i].param,avi_opt[i].param_size))
						&& icm_compress_frames_info(stream[i].icm_object,
										avi_edit[i]->bmih,
										avi_opt[i].bmih,avi_opt[i].bmih_size,
										avi_opt[i].key_frame,
										avi_opt[i].quality,
										avi_opt[i].data_rate,
										avi_get_rate(avi_edit[i]),
										avi_get_scale(avi_edit[i]))
						&& (stream[i].fmt_size=icm_compress_get_format_size(
											stream[i].icm_object,
											avi_edit[i]->bmih))>=BMIH_SIZE) {
					/*  */
					stream[i].fmt=g_malloc(stream[i].fmt_size);
					if (!icm_compress_get_format(stream[i].icm_object,
											avi_edit[i]->bmih,stream[i].fmt)) {
						g_free(stream[i].fmt);
						stream[i].fmt=NULL;
					}
				}
				if (stream[i].fmt==NULL) {
					/* ̤ */
					if (stream[i].icm_object!=NULL) {
						icm_close(stream[i].icm_object);
						stream[i].icm_object=NULL;
					}
					stream[i].fmt_size=bx_header_bytes(
										avi_get_width(avi_edit[i]),
										avi_get_height(avi_edit[i]),
										avi_get_bit_count(avi_edit[i]),
										avi_get_compression(avi_edit[i]),0);
					stream[i].fmt=g_malloc(stream[i].fmt_size);
					g_memmove(stream[i].fmt,avi_edit[i]->bmih,BMIH_SIZE);
					bmih_set_color_used(stream[i].fmt,0);
					bmih_set_color_important(stream[i].fmt,0);
					switch (bmih_get_bit_count(stream[i].fmt)) {
						case 1:g_memmove((guint8 *)stream[i].fmt+BMIH_SIZE,
												rgb2,RGBQUAD_SIZE*2);break;
						case 4:g_memmove((guint8 *)stream[i].fmt+BMIH_SIZE,
												rgb16,RGBQUAD_SIZE*16);break;
						case 8:g_memmove((guint8 *)stream[i].fmt+BMIH_SIZE,
												rgb256,RGBQUAD_SIZE*256);
					}
				}
				break;
			case streamtypeAUDIO:/* ǥ */
				stream[i].fmt_size=wf_header_bytes(avi_edit[i]->wfx);
				stream[i].fmt=g_memdup(avi_edit[i]->wfx,stream[i].fmt_size);
		}
		header+=sizeof(guint32)									/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'strl' */
					+sizeof(guint32) 							/* 'strh' */
					+sizeof(guint32)							/*  */
					+((ASH_SIZE+1)&~1)							/* ¤ */
					+sizeof(guint32) 							/* 'strf' */
					+sizeof(guint32)							/*  */
					+((stream[i].fmt_size+1)&~1)				/* ¤ */
					+sizeof(guint32) 							/* 'strn' */
					+sizeof(guint32)							/*  */
					+((g_strlen(stream[i].name)+2)&~1);			/* ʸ */
	}
	head=(header/AVI_HEADERSIZE+1)*AVI_HEADERSIZE;

	/* ե򳫤 */
	if ((fd=open(file,O_CREAT|O_EXCL|O_WRONLY,
#ifdef WIN32
					S_IREAD|S_IWRITE
#else
					S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH
#endif
																	))==-1) {
		for (i=0;i<streams;i++) {
			g_free(stream[i].name);
			g_free(stream[i].fmt);
			if (stream[i].icm_object!=NULL)
				icm_close(stream[i].icm_object);
		}
		g_free(stream);
		return FALSE;
	}
	if (
#ifdef HAVE_FLOCK
		flock(fd,LOCK_EX)==-1 ||
#endif
												lseek(fd,head,SEEK_SET)==-1) {
		close(fd);
		for (i=0;i<streams;i++) {
			g_free(stream[i].name);
			g_free(stream[i].fmt);
			if (stream[i].icm_object!=NULL)
				icm_close(stream[i].icm_object);
		}
		g_free(stream);
		return FALSE;
	}
	offset=head;

	/* Ǥ1ô֤Υե졼ʤȥ꡼õ */
	for (current=0;current<streams;current++)
		if (avi_type(avi_edit[current])==streamtypeVIDEO)
			break;
	if (current>=streams) {
		/* ӥǥȥ꡼बʤȤ */
		current=-1;
		times=1000;
	} else {
		for (i=0;i<streams;i++)
			if (avi_type(avi_edit[i])==streamtypeVIDEO
					&& (gint64)avi_get_rate(avi_edit[i])
											*avi_get_scale(avi_edit[current])
							<(gint64)avi_get_rate(avi_edit[current])
												*avi_get_scale(avi_edit[i]))
				current=i;
		times=avi_length_time(avi_edit[current])/avi_length(avi_edit[current]);
	}
	/* Ǥ֤Ĺȥ꡼õ */
	for (i=1;i<streams;i++)
		if (avi_length_time(avi_edit[longer])<avi_length_time(avi_edit[i]))
			longer=i;
	/* ե졼 */
	for (i=0;i<streams;i++)
		if (avi_type(avi_edit[i])==streamtypeVIDEO
			&& (stream[i].avi_frame=avi_get_frame_open(avi_edit[i]))==NULL) {
			while (i>0)
				if (stream[--i].avi_frame!=NULL)
					avi_get_frame_close(stream[i].avi_frame);
			close(fd);
			for (i=0;i<streams;i++) {
				g_free(stream[i].name);
				g_free(stream[i].fmt);
				if (stream[i].icm_object!=NULL)
					icm_close(stream[i].icm_object);
			}
			g_free(stream);
			return FALSE;
		}
	while (TRUE) {
		/* ǥå */
		if (func!=NULL && !func(stream[longer].pos*100
									/avi_length(avi_edit[longer]),user_data))
			break;
		/* ٤ƽϤ齪λ */
		for (i=0;i<streams;i++)
			if (stream[i].pos<avi_length(avi_edit[i]))
				break;
		if (i>=streams)
			break;
		for (i=0;i<streams;i++)
			if (stream[i].pos<avi_length(avi_edit[i])) {
				samples=MIN(current>=0
						?i==current?1:avi_time_to_sample(avi_edit[i],
										avi_sample_to_time(avi_edit[current],
										stream[current].pos+1))-stream[i].pos
						:avi_time_to_sample(avi_edit[i],timer)-stream[i].pos,
										avi_length(avi_edit[i])-stream[i].pos);
				if (samples<=0)
					continue;
				if (avi_type(avi_edit[i])==streamtypeVIDEO) { /* ӥǥ */
					for (j=0;j<samples;j++) {
						if (stream[i].icm_object==NULL) {
							/* ̤ */
							bmih=avi_get_frame(stream[i].avi_frame,
											stream[i].pos+j,
											bmih_get_width(stream[i].fmt),
											bmih_get_height(stream[i].fmt),
											bmih_get_bit_count(stream[i].fmt));
							if (bmih==NULL) {
								close(fd);
								for (i=0;i<streams;i++) {
									g_free(stream[i].name);
									g_free(stream[i].fmt);
									if (stream[i].active)
										icm_compress_end(stream[i].icm_object);
									if (stream[i].icm_object!=NULL)
										icm_close(stream[i].icm_object);
									if (stream[i].avi_frame!=NULL)
										avi_get_frame_close(
														stream[i].avi_frame);
								}
								g_free(stream);
								g_free(data);
								g_free(index);
								return FALSE;
							}
							length=bm_image_bytes(bmih);
							fourcc=GUINT32_TO_LE(
										make4cc(i/10+'0',i%10+'0','d','b'));
							size=GUINT32_TO_LE(length);
							if (write(fd,&fourcc,sizeof(guint32))
															!=sizeof(guint32)
								|| write(fd,&size,sizeof(guint32))
														!=sizeof(guint32)
								|| write(fd,(guint8 *)bmih
										+bm_header_bytes(bmih),length)!=length
								|| ((length&1)!=0 && write(fd,&dummy,1)!=1)) {
								close(fd);
								for (i=0;i<streams;i++) {
									g_free(stream[i].name);
									g_free(stream[i].fmt);
									if (stream[i].active)
										icm_compress_end(stream[i].icm_object);
									if (stream[i].icm_object!=NULL)
										icm_close(stream[i].icm_object);
									if (stream[i].avi_frame!=NULL)
										avi_get_frame_close(
														stream[i].avi_frame);
								}
								g_free(stream);
								g_free(data);
								g_free(index);
								return FALSE;
							}
							fourcc=make4cc(i/10+'0',i%10+'0','d','b');
							key_frame=TRUE;
						} else {
							/*  */
							recompress=avi_opt[i].recompress;
							key_frame=avi_is_keyframe(avi_edit[i],
															stream[i].pos+j);
							if (!recompress) {
								/* AVIե */
								avi_get_file(avi_edit[i],stream[i].pos+j);
								recompress=
									avi_edit[i]->file->handler
														!=avi_opt[i].handler
									|| bmih_get_size(avi_edit[i]->file->bmih)
											!=bmih_get_size(stream[i].fmt)
									|| bmih_get_width(avi_edit[i]->file->bmih)
											!=bmih_get_width(stream[i].fmt)
									|| bmih_get_height(avi_edit[i]->file->bmih)
											!=bmih_get_height(stream[i].fmt)
									|| bmih_get_planes(avi_edit[i]->file->bmih)
											!=bmih_get_planes(stream[i].fmt)
									|| bmih_get_bit_count(
													avi_edit[i]->file->bmih)
											!=bmih_get_bit_count(stream[i].fmt)
									|| bmih_get_compression(
													avi_edit[i]->file->bmih)
											!=bmih_get_compression(
																stream[i].fmt)
									|| (avi_edit[i]->offset==stream[i].pos+j
																&& !key_frame);
							}
							if (recompress) {
								/* ư */
								if (!stream[i].active) {
									icm_compress_begin(stream[i].icm_object);
									stream[i].active=TRUE;
									stream[i].size=icm_compress_get_size(
														stream[i].icm_object);
								}
								data=g_realloc(data,(stream[i].size+1)&~1);
								if ((bmih=avi_get_frame(
										stream[i].avi_frame,
										stream[i].pos+j,
										avi_get_width(avi_edit[i]),
										avi_get_height(avi_edit[i]),
										avi_get_bit_count(avi_edit[i])))==NULL
									|| (length=icm_compress(
										stream[i].icm_object,
										&key_frame,
										(guint8 *)bmih+bm_header_bytes(bmih),
										data))<=0) {
									close(fd);
									for (i=0;i<streams;i++) {
										g_free(stream[i].name);
										g_free(stream[i].fmt);
										if (stream[i].active)
											icm_compress_end(
														stream[i].icm_object);
										if (stream[i].icm_object!=NULL)
											icm_close(stream[i].icm_object);
										if (stream[i].avi_frame!=NULL)
											avi_get_frame_close(
														stream[i].avi_frame);
									}
									g_free(stream);
									g_free(data);
									g_free(index);
									return FALSE;
								}
							} else {
								/* ư̤ʤ */
								if (stream[i].active) {
									icm_compress_end(stream[i].icm_object);
									stream[i].active=FALSE;
								}
								length=avi_sample_size(avi_edit[i],
															stream[i].pos+j,1);
								data=g_realloc(data,(length+1)&~1);
								avi_read(avi_edit[i],stream[i].pos,1,data);
							}
							if ((length&1)!=0)
								data[length]=0;
							fourcc=GUINT32_TO_LE(
										make4cc(i/10+'0',i%10+'0','d','c'));
							size=GUINT32_TO_LE(length);
							if (write(fd,&fourcc,sizeof(guint32))
															!=sizeof(guint32)
									|| write(fd,&size,sizeof(guint32))
															!=sizeof(guint32)
									|| write(fd,data,(length+1)&~1)
														!=((length+1)&~1)) {
								close(fd);
								for (i=0;i<streams;i++) {
									g_free(stream[i].name);
									g_free(stream[i].fmt);
									if (stream[i].active)
										icm_compress_end(stream[i].icm_object);
									if (stream[i].icm_object!=NULL)
										icm_close(stream[i].icm_object);
									if (stream[i].avi_frame!=NULL)
										avi_get_frame_close(
														stream[i].avi_frame);
								}
								g_free(stream);
								g_free(data);
								g_free(index);
								return FALSE;
							}
							fourcc=make4cc(i/10+'0',i%10+'0','d','c');
						}
						/* ǥå */
						index=g_realloc(index,(entries+1)*AIE_SIZE);
						p=(guint8 *)index+entries++*AIE_SIZE;
						aie_set_type(p,fourcc);
						aie_set_flags(p,key_frame?AVIIF_KEYFRAME:0);
						aie_set_offset(p,offset-head+sizeof(guint32));
						aie_set_length(p,length);
						offset+=((length+1)&~1)+sizeof(guint32)*2;
					}
				} else { /* ǥ */
					length=avi_sample_size(avi_edit[i],stream[i].pos,samples);
					data=g_realloc(data,(length+1)&~1);
					avi_read(avi_edit[i],stream[i].pos,samples,data);
					if ((length&1)!=0)
						data[length]=0;
					fourcc=GUINT32_TO_LE(make4cc(i/10+'0',i%10+'0','w','b'));
					size=GUINT32_TO_LE(length);
					if (write(fd,&fourcc,sizeof(guint32))!=sizeof(guint32)
							|| write(fd,&size,sizeof(guint32))!=sizeof(guint32)
							|| write(fd,data,(length+1)&~1)!=((length+1)&~1)) {
						close(fd);
						for (i=0;i<streams;i++) {
							g_free(stream[i].name);
							g_free(stream[i].fmt);
							if (stream[i].active)
								icm_compress_end(stream[i].icm_object);
							if (stream[i].icm_object!=NULL)
								icm_close(stream[i].icm_object);
							if (stream[i].avi_frame!=NULL)
								avi_get_frame_close(stream[i].avi_frame);
						}
						g_free(stream);
						g_free(data);
						g_free(index);
						return FALSE;
					}
					/* ǥå */
					index=g_realloc(index,(entries+1)*AIE_SIZE);
					p=(guint8 *)index+entries++*AIE_SIZE;
					aie_set_type(p,make4cc(i/10+'0',i%10+'0','w','b'));
					aie_set_flags(p,0);
					aie_set_offset(p,offset-head+sizeof(guint32));
					aie_set_length(p,length);
					offset+=((length+1)&~1)+sizeof(guint32)*2;
				}
				if (i!=current)
					stream[i].pos+=samples;
			}
		if (current>=0) {
			stream[current].pos++;
			if (avi_length(avi_edit[current])<=stream[current].pos) {
				timer=avi_length_time(avi_edit[current]);
				current=-1;
			}
		} else {
			timer+=times;
		}
	}
	g_free(data);
	/* ե졼/ */
	for (i=0;i<streams;i++)
		if ((stream[i].active && !icm_compress_end(stream[i].icm_object))
			| (stream[i].icm_object!=NULL && !icm_close(stream[i].icm_object))
			| (stream[i].avi_frame!=NULL
							&& !avi_get_frame_close(stream[i].avi_frame))) {
			close(fd);
			while (++i<streams) {
				if (stream[i].active)
					icm_compress_end(stream[i].icm_object);
				if (stream[i].icm_object!=NULL)
					icm_close(stream[i].icm_object);
				if (stream[i].avi_frame!=NULL)
					avi_get_frame_close(stream[i].avi_frame);
			}
			for (i=0;i<streams;i++) {
				g_free(stream[i].name);
				g_free(stream[i].fmt);
			}
			g_free(stream);
			g_free(index);
			return FALSE;
		}

	/* ٤ƤΥȥ꡼ब1ץʾϤȤå */
	current=-1;
	for (i=0;i<streams;i++)
		if (stream[i].pos<=0)
			break;
	if (i>=streams)
		for (i=0;i<streams;i++)
			if (avi_type(avi_edit[i])==streamtypeVIDEO
						&& (current==-1 || stream[i].pos>stream[current].pos))
				current=i;/* ǤĹӥǥȥ꡼ */

	/* ǥå */
	fourcc=GUINT32_TO_LE(ckidAVINEWINDEX);
	size=GUINT32_TO_LE(entries*AIE_SIZE);
	if (current<0 || write(fd,&fourcc,sizeof(guint32))!=sizeof(guint32)
					|| write(fd,&size,sizeof(guint32))!=sizeof(guint32)
					|| write(fd,index,entries*AIE_SIZE)!=entries*AIE_SIZE) {
		close(fd);
		for (i=0;i<streams;i++) {
			g_free(stream[i].name);
			g_free(stream[i].fmt);
		}
		g_free(stream);
		g_free(index);
		return FALSE;
	}
	g_free(index);

	/* إåꤹ */
	data=g_malloc0(head);
	p=data;

	*(guint32 *)p=GUINT32_TO_LE(FOURCC_RIFF);
	((guint32 *)p)++;											/* 'RIFF' */
	*(guint32 *)p=GUINT32_TO_LE(offset+entries*AIE_SIZE);
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(formtypeAVI);
	((guint32 *)p)++;											/* 'AVI ' */
	*(guint32 *)p=GUINT32_TO_LE(FOURCC_LIST);
	((guint32 *)p)++;											/* 'LIST' */
	*(guint32 *)p=GUINT32_TO_LE(sizeof(guint32)				/* 'hdrl' */
								+sizeof(guint32)			/* 'avih' */
								+sizeof(guint32)			/*  */
								+AMH_SIZE);					/* ¤ */
	for (i=0;i<streams;i++)
		*(guint32 *)p+=GUINT32_TO_LE(
				sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)							/*  */
				+sizeof(guint32)							/* 'strl' */
					+sizeof(guint32) 						/* 'strh' */
					+sizeof(guint32)						/*  */
					+ASH_SIZE								/* ¤ */
					+sizeof(guint32) 						/* 'strf' */
					+sizeof(guint32)						/*  */
					+((stream[i].fmt_size+1)&~1)			/* ¤ */
					+sizeof(guint32) 						/* 'strn' */
					+sizeof(guint32)						/*  */
					+((g_strlen(stream[i].name)+2)&~1));	/* ʸ */
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(listtypeAVIHEADER);
	((guint32 *)p)++;											/* 'hdrl' */
	*(guint32 *)p=GUINT32_TO_LE(ckidAVIMAINHDR);
	((guint32 *)p)++;											/* 'avih' */
	*(guint32 *)p=GUINT32_TO_LE(AMH_SIZE);
	((guint32 *)p)++;											/*  */
	amh_set_micro_sec_per_frame(p,0);
	amh_set_padding_granularity(p,AVI_HEADERSIZE);
	amh_set_flags(p,AVIF_HASINDEX | AVIF_MUSTUSEINDEX);
	amh_set_total_frames(p,stream[current].pos);
	for (i=0;i<streams;i++)
		if (stream[i].pos>0)
			amh_set_streams(p,amh_get_streams(p)+1);
	amh_set_width(p,bmih_get_width(stream[current].fmt));
	amh_set_height(p,bmih_get_height(stream[current].fmt));
	p+=AMH_SIZE;												/* ¤ */

	for (i=0;i<streams;i++)
		if (stream[i].pos>0) {
			*(guint32 *)p=GUINT32_TO_LE(FOURCC_LIST);
			((guint32 *)p)++;									/* 'LIST' */
			*(guint32 *)p=GUINT32_TO_LE(
						sizeof(guint32)						/* 'strl' */
						+sizeof(guint32) 					/* 'strh' */
						+sizeof(guint32)					/*  */
						+ASH_SIZE							/* ¤ */
						+sizeof(guint32) 					/* 'strf' */
						+sizeof(guint32)					/*  */
						+((stream[i].fmt_size+1)&~1)		/* ¤ */
						+sizeof(guint32) 					/* 'strn' */
						+sizeof(guint32)					/*  */
						+((g_strlen(stream[i].name)+2)&~1));/* ʸ */
			((guint32 *)p)++;									/*  */
			*(guint32 *)p=GUINT32_TO_LE(listtypeSTREAMHEADER);
			((guint32 *)p)++;									/* 'strl' */

			*(guint32 *)p=GUINT32_TO_LE(ckidSTREAMHEADER);
			((guint32 *)p)++;									/* 'strh' */
			*(guint32 *)p=GUINT32_TO_LE(ASH_SIZE);
			((guint32 *)p)++;									/*  */
			ash_set_type(p,avi_type(avi_edit[i]));
			if (avi_type (avi_edit[i]) == streamtypeVIDEO)
				ash_set_handler (p, avi_opt == NULL || avi_opt[i].handler == 0
												|| stream[i].icm_object == NULL
										? comptypeDIB : avi_opt[i].handler);
			ash_set_scale(p,avi_get_scale(avi_edit[i]));
			ash_set_rate(p,avi_get_rate(avi_edit[i]));
			ash_set_length(p,stream[i].pos);
			ash_set_quality(p,-1);
			if (avi_type(avi_edit[i])==streamtypeVIDEO) {
				ash_set_frame_right(p,avi_get_width(avi_edit[i]));
				ash_set_frame_bottom(p,avi_get_height(avi_edit[i]));
			}
			p+=ASH_SIZE;										/* ¤ */

			*(guint32 *)p=GUINT32_TO_LE(ckidSTREAMFORMAT);
			((guint32 *)p)++;									/* 'strf' */
			*(guint32 *)p=GUINT32_TO_LE((stream[i].fmt_size+1)&~1);
			((guint32 *)p)++;									/*  */
			g_memmove(p,stream[i].fmt,stream[i].fmt_size);
			p+=(stream[i].fmt_size+1)&~1;						/* ¤ */

			*(guint32 *)p=GUINT32_TO_LE(ckidSTREAMNAME);
			((guint32 *)p)++;									/* 'strn' */
			*(guint32 *)p=GUINT32_TO_LE((g_strlen(stream[i].name)+2)&~1);
			((guint32 *)p)++;									/*  */
			g_memmove(p,stream[i].name,g_strlen(stream[i].name));
			p+=(g_strlen(stream[i].name)+2)&~1;					/* ʸ */
		}

	*(guint32 *)p=GUINT32_TO_LE(ckidAVIPADDING);
	((guint32 *)p)++;											/* 'JUNK' */
	*(guint32 *)p=GUINT32_TO_LE(head-header);					/*  */

	p=data+head-sizeof(guint32);
	*(guint32 *)p=GUINT32_TO_LE(listtypeAVIMOVIE);
	((guint32 *)p)--;											/* 'movi' */
	*(guint32 *)p=GUINT32_TO_LE(offset-head+sizeof(guint32));
	((guint32 *)p)--;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(FOURCC_LIST);					/* 'LIST' */

	for (i=0;i<streams;i++) {
		g_free(stream[i].name);
		g_free(stream[i].fmt);
	}
	g_free(stream);

	if (lseek(fd,0,SEEK_SET)==-1 || write(fd,data,head)!=head) {
		close(fd);
		g_free(data);
		return FALSE;
	}

	g_free(data);
	return close(fd)==0;
}


/*	ӥåȥޥåץե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	    start,ǽΥե졼
	      end,ǸΥե졼
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_bitmap(AviEdit *avi_edit,
							const gchar *file,const gint start,const gint end,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gboolean result=TRUE;
	gchar *format,*dir,*name,*ext;
	gint i,s,length;
	AviFrame *avi_frame;
	BitmapFileHeader bmfh;
	BitmapInfoHeader *bmih;

	if (avi_edit==NULL || file==NULL)
		return FALSE;
	dir=g_dirname(file);
	name=g_strdup(g_basename(file));
	for (i=g_strlen(name)-1;i>=0;i--)
		if (name[i]=='.')
			break;
	if (i>=0) {
		ext=g_strdup(name+i);
		name[i]='\0';
	} else {
		ext=g_strdup("");
	}
	for (i=0,s=end;s!=0;s/=10)
		i++;
	format=g_strdup_printf("%s/%s%%0%dd%s",dir,name,i,ext);
	g_free(dir);
	g_free(name);
	g_free(ext);

	g_memset(&bmfh,0,BMFH_SIZE);
	bmfh_set_type(&bmfh,0x4d42);
	bmfh_set_size(&bmfh,bm_all_bytes(avi_edit->bmih)+BMFH_SIZE);
	bmfh_set_off_bits(&bmfh,bm_header_bytes(avi_edit->bmih)+BMFH_SIZE);

	if ((avi_frame=avi_get_frame_open(avi_edit))==NULL) {
		g_free(format);
		return FALSE;
	}
	for (i=start;i<=end;i++) {
		/* ǥå */
		if (func!=NULL && !func((i-start)*100/(end-start+1),user_data))
			break;

		if ((bmih=avi_get_frame(avi_frame,i,avi_get_width(avi_edit),
										avi_get_height(avi_edit),
										avi_get_bit_count(avi_edit)))==NULL) {
			result=FALSE;
			break;
		}
		bmih_set_x_pixels_per_meter(bmih,avi_get_x_pixels_per_meter(avi_edit));
		bmih_set_y_pixels_per_meter(bmih,avi_get_y_pixels_per_meter(avi_edit));
		length=bm_all_bytes(bmih);

		name=start==end?g_strdup(file):g_strdup_printf(format,i);
		fd=open(name,O_CREAT|O_EXCL|O_WRONLY,
#ifdef WIN32
							S_IREAD|S_IWRITE);
#else
							S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
#endif
		g_free(name);
		if (fd==-1) {
			result=FALSE;
			break;
		}
		if (
#ifdef HAVE_FLOCK
			flock(fd,LOCK_EX)==-1 ||
#endif
			write(fd,&bmfh,BMFH_SIZE)!=BMFH_SIZE
											|| write(fd,bmih,length)!=length) {
			close(fd);
			result=FALSE;
			break;
		}
		if (close(fd)!=0) {
			result=FALSE;
			break;
		}
	}
	g_free(format);
	return avi_get_frame_close(avi_frame) && result;
}


/*	WAVEե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_wave(AviEdit *avi_edit,const gchar *file,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gint length,pos=0,samples,written=0,header;
	guint8 *p,*data;

	if (avi_edit==NULL || file==NULL)
		return FALSE;
	/* إå׻ */
	header=	sizeof(guint32)										/* 'RIFF' */
			+sizeof(guint32)									/*  */
			+sizeof(guint32)									/* 'WAVE' */
			+sizeof(guint32)									/* 'fmt ' */
			+sizeof(guint32)									/*  */
			+((wf_header_bytes(avi_edit->wfx)+1)&~1)			/* ¤ */
			+sizeof(guint32)									/* 'data' */
			+sizeof(guint32);									/*  */
	/* ե򳫤 */
	if ((fd=open(file,O_CREAT|O_EXCL|O_WRONLY,
#ifdef WIN32
						S_IREAD|S_IWRITE
#else
						S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH
#endif
																		))==-1)
		return FALSE;
	if (
#ifdef HAVE_FLOCK
		flock(fd,LOCK_EX)==-1 ||
#endif
											lseek(fd,header,SEEK_SET)==-1) {
		close(fd);
		return FALSE;
	}
	/* ǡ */
	length=avi_sample_size(avi_edit,0,1);
	if (length<65536) {
		samples=65536/length;
		length*=samples;
	} else {
		samples=1;
	}
	data=g_malloc(length);
	while (pos<avi_length(avi_edit)) {
		/* ǥå */
		if (func!=NULL && !func(pos*100/avi_length(avi_edit),user_data))
			break;
		if (avi_length(avi_edit)<pos+samples) {
			samples=avi_length(avi_edit)-pos;
			length=avi_sample_size(avi_edit,pos,samples);
		}
		avi_read(avi_edit,pos,samples,data);
		pos+=samples;
		if (write(fd,data,length)!=length) {
			close(fd);
			g_free(data);
			return FALSE;
		}
		written+=length;
	}
	if ((written&1)!=0) {
		data[0]=0;
		if (write(fd,data,1)!=1) {
			close(fd);
			g_free(data);
			return FALSE;
		}
	}
	/* إåꤹ */
	p=data=g_realloc(data,header);
	*(guint32 *)p=GUINT32_TO_LE(FOURCC_RIFF);
	((guint32 *)p)++;											/* 'RIFF' */
	*(guint32 *)p=GUINT32_TO_LE(header-sizeof(guint32)*2+((written+1)&~1));
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(formtypeWAVE);
	((guint32 *)p)++;											/* 'WAVE' */
	*(guint32 *)p=GUINT32_TO_LE(ckidWAVEFORMAT);
	((guint32 *)p)++;											/* 'fmt ' */
	*(guint32 *)p=GUINT32_TO_LE(wf_header_bytes(avi_edit->wfx));
	((guint32 *)p)++;											/*  */
	g_memmove(p,avi_edit->wfx,wf_header_bytes(avi_edit->wfx));
	if ((wf_header_bytes(avi_edit->wfx)&1)!=0)
		p[wf_header_bytes(avi_edit->wfx)]=0;
	p+=(wf_header_bytes(avi_edit->wfx)+1)&~1;
	*(guint32 *)p=GUINT32_TO_LE(ckidWAVEDATA);
	((guint32 *)p)++;											/* 'data' */
	*(guint32 *)p=GUINT32_TO_LE(written);						/*  */
	if (lseek(fd,0,SEEK_SET)==-1 || write(fd,data,header)!=header) {
		close(fd);
		g_free(data);
		return FALSE;
	}
	g_free(data);
	return close(fd)==0;
}


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	 avi_save,ץ
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_with_options(AviEdit *avi_edit[],const gchar *file,
		AviSave *avi_save,gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gboolean result=FALSE;
	gchar *scenario;
	gint length;

	switch (avi_save->type) {
		case AVI_TYPE_AVI:
			result=avi_save_avi(avi_edit,file,
											avi_save->avi_opt,func,user_data);
			break;
		case AVI_TYPE_BITMAP:
			result=avi_save_bitmap(avi_edit[avi_save->stream],file,
								avi_save->start,avi_save->end,func,user_data);
			break;
		case AVI_TYPE_WAVE:
			result=avi_save_wave(avi_edit[avi_save->stream],file,
															func,user_data);
			break;
		default:
			if ((scenario=avi_to_scenario(avi_edit,FALSE))!=NULL
				&& (fd=open(file,O_CREAT|O_EXCL|O_WRONLY,
#ifdef WIN32
					S_IREAD|S_IWRITE
#else
					S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH
#endif
																	))!=-1) {
				length=g_strlen(scenario);
				result=(
#ifdef HAVE_FLOCK
						flock(fd,LOCK_EX)==-1 &&
#endif
						write(fd,scenario,length)==length) & (close(fd)==0);
			}
			g_free(scenario);
	}
	return result;
}
