/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    protected String text;
    protected int strLength;
    protected String nontokenDelims;
    protected String tokenDelims;
    protected int position;
    protected boolean emptyReturned;
    protected char maxDelimChar;
    protected boolean returnEmptyTokens;
    protected int delimsChangedPosition;
    protected int tokenCount;

    public StringTokenizer(String text, String nontokenDelims, String tokenDelims) {
        this(text, nontokenDelims, tokenDelims, false);
    }

    public StringTokenizer(String text, String nontokenDelims, String tokenDelims, boolean returnEmptyTokens) {
        this.setDelims(nontokenDelims, tokenDelims);
        this.setText(text);
        this.setReturnEmptyTokens(returnEmptyTokens);
    }

    public StringTokenizer(String text, String delims, boolean delimsAreTokens) {
        this(text, delimsAreTokens ? null : delims, delimsAreTokens ? delims : null);
    }

    public StringTokenizer(String text, String nontokenDelims) {
        this(text, nontokenDelims, null);
    }

    public StringTokenizer(String text) {
        this(text, " \t\n\r\f", null);
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
        this.strLength = text.length();
        this.emptyReturned = false;
        this.position = this.strLength > 0 ? 0 : -1;
        this.delimsChangedPosition = 0;
        this.tokenCount = -1;
    }

    private void setDelims(String nontokenDelims, String tokenDelims) {
        this.nontokenDelims = nontokenDelims;
        this.tokenDelims = tokenDelims;
        this.delimsChangedPosition = this.position != -1 ? this.position : this.strLength;
        this.maxDelimChar = '\u0000';
        int i = 0;
        while (nontokenDelims != null && i < nontokenDelims.length()) {
            if (this.maxDelimChar < nontokenDelims.charAt(i)) {
                this.maxDelimChar = nontokenDelims.charAt(i);
            }
            ++i;
        }
        i = 0;
        while (tokenDelims != null && i < tokenDelims.length()) {
            if (this.maxDelimChar < tokenDelims.charAt(i)) {
                this.maxDelimChar = tokenDelims.charAt(i);
            }
            ++i;
        }
        this.tokenCount = -1;
    }

    public boolean hasMoreTokens() {
        if (this.tokenCount == 0) {
            return false;
        }
        if (this.tokenCount > 0) {
            return true;
        }
        int savedPosition = this.position;
        boolean savedEmptyReturned = this.emptyReturned;
        int workingPosition = this.position;
        boolean workingEmptyReturned = this.emptyReturned;
        boolean onToken = this.advancePosition();
        while (this.position != workingPosition || this.emptyReturned != workingEmptyReturned) {
            if (onToken) {
                this.position = savedPosition;
                this.emptyReturned = savedEmptyReturned;
                return true;
            }
            workingPosition = this.position;
            workingEmptyReturned = this.emptyReturned;
            onToken = this.advancePosition();
        }
        this.position = savedPosition;
        this.emptyReturned = savedEmptyReturned;
        return false;
    }

    public String nextToken() {
        int workingPosition = this.position;
        boolean workingEmptyReturned = this.emptyReturned;
        boolean onToken = this.advancePosition();
        while (this.position != workingPosition || this.emptyReturned != workingEmptyReturned) {
            if (onToken) {
                --this.tokenCount;
                return this.emptyReturned ? "" : this.text.substring(workingPosition, this.position != -1 ? this.position : this.strLength);
            }
            workingPosition = this.position;
            workingEmptyReturned = this.emptyReturned;
            onToken = this.advancePosition();
        }
        throw new NoSuchElementException();
    }

    public boolean skipDelimiters() {
        int workingPosition = this.position;
        boolean workingEmptyReturned = this.emptyReturned;
        boolean onToken = this.advancePosition();
        this.tokenCount = -1;
        while (this.position != workingPosition || this.emptyReturned != workingEmptyReturned) {
            if (onToken) {
                this.position = workingPosition;
                this.emptyReturned = workingEmptyReturned;
                return true;
            }
            workingPosition = this.position;
            workingEmptyReturned = this.emptyReturned;
            onToken = this.advancePosition();
        }
        return false;
    }

    public int countTokens() {
        if (this.tokenCount >= 0) {
            return this.tokenCount;
        }
        int tokenCount = 0;
        int savedPosition = this.position;
        boolean savedEmptyReturned = this.emptyReturned;
        int workingPosition = this.position;
        boolean workingEmptyReturned = this.emptyReturned;
        boolean onToken = this.advancePosition();
        while (this.position != workingPosition || this.emptyReturned != workingEmptyReturned) {
            if (onToken) {
                ++tokenCount;
            }
            workingPosition = this.position;
            workingEmptyReturned = this.emptyReturned;
            onToken = this.advancePosition();
        }
        this.position = savedPosition;
        this.emptyReturned = savedEmptyReturned;
        this.tokenCount = tokenCount;
        return tokenCount;
    }

    public void setDelimiters(String delims) {
        this.setDelims(delims, null);
    }

    public void setDelimiters(String delims, boolean delimsAreTokens) {
        this.setDelims(delimsAreTokens ? null : delims, delimsAreTokens ? delims : null);
    }

    public void setDelimiters(String nontokenDelims, String tokenDelims) {
        this.setDelims(nontokenDelims, tokenDelims);
    }

    public void setDelimiters(String nontokenDelims, String tokenDelims, boolean returnEmptyTokens) {
        this.setDelims(nontokenDelims, tokenDelims);
        this.setReturnEmptyTokens(returnEmptyTokens);
    }

    public int countTokens(String delims) {
        this.setDelims(delims, null);
        return this.countTokens();
    }

    public int countTokens(String delims, boolean delimsAreTokens) {
        this.setDelims(delimsAreTokens ? null : delims, delimsAreTokens ? delims : null);
        return this.countTokens();
    }

    public int countTokens(String nontokenDelims, String tokenDelims) {
        this.setDelims(nontokenDelims, tokenDelims);
        return this.countTokens();
    }

    public int countTokens(String nontokenDelims, String tokenDelims, boolean returnEmptyTokens) {
        this.setDelims(nontokenDelims, tokenDelims);
        this.setReturnEmptyTokens(returnEmptyTokens);
        return this.countTokens();
    }

    private boolean advancePosition() {
        char c;
        if (this.returnEmptyTokens && !this.emptyReturned && (this.delimsChangedPosition == this.position || this.position == -1 && this.strLength == this.delimsChangedPosition)) {
            if (this.strLength == this.delimsChangedPosition) {
                this.emptyReturned = true;
                return true;
            }
            c = this.text.charAt(this.position);
            if (c <= this.maxDelimChar && this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) {
                this.emptyReturned = true;
                return true;
            }
        }
        if (this.position != -1) {
            int nextDelimiter;
            c = this.text.charAt(this.position);
            if (this.returnEmptyTokens && !this.emptyReturned && this.position > this.delimsChangedPosition) {
                char c1 = this.text.charAt(this.position - 1);
                if (c <= this.maxDelimChar && c1 <= this.maxDelimChar && (this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) && (this.nontokenDelims != null && this.nontokenDelims.indexOf(c1) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c1) != -1)) {
                    this.emptyReturned = true;
                    return true;
                }
            }
            int n = nextDelimiter = this.position < this.strLength - 1 ? this.indexOfNextDelimiter(this.position + 1) : -1;
            if (c > this.maxDelimChar || (this.nontokenDelims == null || this.nontokenDelims.indexOf(c) == -1) && (this.tokenDelims == null || this.tokenDelims.indexOf(c) == -1)) {
                this.position = nextDelimiter;
                this.emptyReturned = false;
                return true;
            }
            if (this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) {
                this.emptyReturned = false;
                this.position = this.position < this.strLength - 1 ? this.position + 1 : -1;
                return true;
            }
            this.emptyReturned = false;
            this.position = this.position < this.strLength - 1 ? this.position + 1 : -1;
            return false;
        }
        if (this.returnEmptyTokens && !this.emptyReturned && this.strLength > 0 && ((c = this.text.charAt(this.strLength - 1)) <= this.maxDelimChar && this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1)) {
            this.emptyReturned = true;
            return true;
        }
        return false;
    }

    public String nextToken(String nontokenDelims, String tokenDelims) {
        this.setDelims(nontokenDelims, tokenDelims);
        return this.nextToken();
    }

    public String nextToken(String nontokenDelims, String tokenDelims, boolean returnEmptyTokens) {
        this.setDelims(nontokenDelims, tokenDelims);
        this.setReturnEmptyTokens(returnEmptyTokens);
        return this.nextToken();
    }

    public String nextToken(String delims, boolean delimsAreTokens) {
        return delimsAreTokens ? this.nextToken(null, delims) : this.nextToken(delims, null);
    }

    public String nextToken(String nontokenDelims) {
        return this.nextToken(nontokenDelims, null);
    }

    private int indexOfNextDelimiter(int start) {
        char c;
        int next = start;
        while ((c = this.text.charAt(next)) > this.maxDelimChar || (this.nontokenDelims == null || this.nontokenDelims.indexOf(c) == -1) && (this.tokenDelims == null || this.tokenDelims.indexOf(c) == -1)) {
            if (next == this.strLength - 1) {
                return -1;
            }
            ++next;
        }
        return next;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    public Object next() {
        return this.nextToken();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setReturnEmptyTokens(boolean returnEmptyTokens) {
        this.tokenCount = -1;
        this.returnEmptyTokens = returnEmptyTokens;
    }

    public int getCurrentPosition() {
        return this.position;
    }

    public String[] toArray() {
        String[] tokenArray = new String[this.countTokens()];
        int i = 0;
        while (this.hasMoreTokens()) {
            tokenArray[i] = this.nextToken();
            ++i;
        }
        return tokenArray;
    }

    public String restOfText() {
        return this.nextToken(null, null);
    }

    public String peek() {
        int savedPosition = this.position;
        boolean savedEmptyReturned = this.emptyReturned;
        int savedtokenCount = this.tokenCount;
        String retval = this.nextToken();
        this.position = savedPosition;
        this.emptyReturned = savedEmptyReturned;
        this.tokenCount = savedtokenCount;
        return retval;
    }
}

