/***************************************************************************/
/*! \file   cladspafactory.h
    \brief  饹CLadspaPluginLibraryΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  7 30  23:55:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CLADSPAFACTORY_H
#define CLADSPAFACTORY_H

#include <ladspa.h>
#include <qobject.h>
#include <qlibrary.h>
#include <qstring.h>
#include <qvaluevector.h>
#include "cladspaeffect.h"

/*-------------------------------------------------------------------------*/
/*! \class  CLadspaFactory
    \brief  LADSPAץ饰饹SingletonǼƤ롣
*/
/*-------------------------------------------------------------------------*/
class CLadspaFactory : public QObject
{
  Q_OBJECT

public:
  //! \brief  Singleton󥹥󥹤롣
  //! \return trueƤfalse֤
  //! \param  strLadspaPath LADSPA_PATH
  static bool createInstance(const QString& strLadspaPath);
  //! \brief  Singleton󥹥󥹤˴롣
  static void destroyInstance();
  //! \brief  Singleton󥹥󥹤ؤΥݥ󥿤֤
  //! \return ƤʤϡNULLݥ󥿤֤
  static CLadspaFactory* instance();

  //! \brief  ɤƤ륨եȿ֤
  int effectCount() const;
  //! \brief  ꤵ줿եȤ֤
  CLadspaEffect effect(int nID) const;

private:
  //! Singleton󥹥󥹡
  static CLadspaFactory* ladspaFactory;

  //! եȡ
  QValueVector<CLadspaEffect> vEffects;

  //! \brief  󥹥ȥ饯
  //! \param  strLadspaPath LADSPA_PATH
  CLadspaFactory(const QString& strLadspaPath);
  //! \brief  ǥȥ饯
  virtual ~CLadspaFactory();
  //! \brief  黻ҡѶػߡ
  CLadspaFactory& operator=(const CLadspaFactory& src);

public slots:
  //! \brief եȤƥɤ롣
  //! ˥ɤƤեȤϲ롣
  //! \param strLadspaPath LADSPA_PATH
  void slotReload(const QString& strLadspaPath);

signals:
  //! \brief եȤƥɤ줿ȯ륷ʥ롣
  void reloaded();
};

#endif
