/***************************************************************************/
/*! \file   cecaiamanager.h
    \brief  饹CEcaIAManagerΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  17:35:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CECAIAMANAGER_H_
#define _CECAIAMANAGER_H_

#include <qobject.h>
#include <qvaluevector.h>
#include <qstringlist.h>
#include <qstring.h>
#include <qdatetime.h>
#include <eca-control-interface.h>
#include "ctrackinf.h"

//! 󥸥󥹥ơ
typedef int Status;

/*-------------------------------------------------------------------------*/
/*! \class  CEcaIAManager
    \brief  Ecasound󥿥饯ƥ֥⡼ɤ椹뤿Υ饹
*/
/*-------------------------------------------------------------------------*/
class CEcaIAManager : public QObject
{
  Q_OBJECT
public:
  enum RunningStatus {
    NotRunning,
    Playing,
    Recording,
    Mixing
  };

  //! \brief 󥹥ȥ饯
  CEcaIAManager();
  //! \brief ǥȥ饯
  ~CEcaIAManager();

  //! \brief  Ծ֤֤
  //! \return Ծ֡
  RunningStatus runningStatus() const;
  //! \brief  ꤵ줿ȥå̾Τ˥󥻥åȥåפ¸ߤ뤫ɤ֤
  //! \param  strTrackName ȥå̾Ρ
  //! \return ¸ߤƤ硢true֤
  bool isExisting(const QString& strTrackName) const;
  //! \brief  󥻥åȥåפϲǽɤ֤
  //! \return (ޤϿ)ǽʾ硢true֤
  bool isValidChainsetup();
  //! \brief  ꤵƤϤο֤
  //! \return Ϥο
  int numberOfInputs();
  //! \brief  ꤵƤϤο֤
  //! \return Ϥο
  int numberOfOutputs();

public slots:
  //! \brief 󥻥åȥåפ򿷵롣
  //! \param strChainsetup 󥻥åȥå̾Ρ
  void slotCreateNewChainsetup(const QString& strChainsetup);
  //! \brief 󥻥åȥåפ˴롣
  void slotReleaseCurrentChainsetup();

  //! \brief 
  //! \param bRecord ϿꤵƤtrueꡣ
  void slotPlay(bool bRecord);
  //! \brief ߡ
  void slotStop();
  //! \brief ߡ
  void slotPause();
  //! \brief ޥݥѹ롣
  //! \param Time ְ֡
  void slotSetMasterPosition(const QTime& Time);
  //! \brief ֤ذư
  //! \param nSec ð֡
  void slotSetMasterPosition(int nSec);
  //! \brief ÿ󥻥åȥåפ᤹
  //! \param nSecond ᤷÿ
  void slotRewind(int nSecond);
  //! \brief ÿ󥻥åȥåפꤹ롣
  //! \param nSecond ꤷÿ
  void slotForward(int nSecond);
  //! \brief ߥå
  //! \param bWithPlaying ʤߥå󤹤trueꡣ
  //! \param strChainsetup ߥåѥ󥻥åȥå̾Ρ
  //! \param strFileName ߥåե̾Ρ
  void slotMixdown(bool bWithPlaying, 
                   const QString& strChainsetup, 
                   const QString& strFileName);

  //! \brief ȥåȤɲä롣
  //! \param TrackInfAdd Ȥɲäȥå
  void slotAddChain(const CTrackInf& TrackInfAdd);
  //! \brief 롣
  //! \param strTrackName ȥå̾Ρ
  void slotRemoveChain(const QString& strTrackName);
  //! \brief 롣
  //! \param nID ȥåID
  void slotRemoveChain(int nID);
  //! \brief ƤΥ롣
  void slotRemoveAllChains();
  //! \brief ƤϤ롣
  void slotRemoveAllInputs();
  //! \brief ƤνϤ롣
  void slotRemoveAllOutputs();

  //! \brief ץ쥤ХåǥХѹ
  void slotChangePlaybackDevice(const QString& strTrackName,
                                const QString& strDevice);
  //! \brief 쥳ǥ󥰥ǥХѹ
  void slotChangeRecordingDevice(const QString& strTrackName,
                                 const QString& strDevice);
  //! \brief ե̾ѹ
  void slotChangeFileName(const QString& strTrackName, const QString& strFileName);
  //! \brief ٥ѹ
  void slotChangeLevel(const QString& strTrackName, int nLevel);
  //! \brief ѥѹ
  void slotChangePan(const QString& strTrackName, int nPan);
  //! \brief ߥ塼Ⱦѹ
  void slotToggleMute(const QString& strTrackName, bool bMute);
  //! \brief Ͽѹ
  void slotToggleRec(const QString& strTrackName, bool bRec);
  //! \brief ϰѹ
  void slotChangeStartPosition(const QString& strTrackName, const QTime& StartPosition);
  //! \brief եåѹ
  void slotChangeOffset(const QString& strTrackName, const QTime& Offset);
  //! \brief Ĺѹ
  void slotChangeLength(const QString& strTrackName, const QTime& Length);

private:
  //! \brief ԡ󥹥ȥ饯ԡػߤ뤿ᡢprivate
  CEcaIAManager(const CEcaIAManager&);
  //! \brief 黻ҡػߤ뤿ᡢprivate
  CEcaIAManager& operator=(const CEcaIAManager&);

  //! Ecasound Control Interface
  ECA_CONTROL_INTERFACE EcaControler;
  //! ȥå٥
  QValueVector<CTrackInf> vTrackChains;
  //! Ewfѥȥå٥
  QValueVector<CTrackInf> vPrepareTrackChains;
  //! IDEcasoundλ(Finished)Ƚ˻ѡ
  int nTimerIDFinished;
  //! ޥݥ(ϰ())
  int nMasterPosition;
  //! ե̾Υꥹȡ
  QStringList strlTmpFiles;
  //! Ծ
  RunningStatus rStatus;

  //! ֥륯
  static const QString DQ;
  //! 󥸥ξ֡¹档
  static const Status Running;
  //! 󥸥ξ֡¹Ԥ
  static const Status NotStarted;
  //! 󥸥ξ֡ߡ
  static const Status Stopped;
  //! 󥸥ξ֡¹Խλ
  static const Status Finished;
  //! 󥸥ξ֡ưԤ
  static const Status NotReady;
  //! 󥸥ξ֡顼
  static const Status Error;

  //! \brief ȥå̾ΤФȥåΥǥ֤
  //! ꤵ줿ȥå̾ΤФȥå󤬸Ĥʤ硢
  //! -1֤롣
  //! \param strTrackName ȥå̾Ρ
  int getIndexByName(const QString& strTrackName) const;
  //! \brief EcaControler˥ޥɤ롣
  //! \param strCommand EIAMޥɡ
  //! \param bOut ɸϤ˼¹ԤޥɤϤ硢trueꡣ
  void command(const QString& strCommand, bool bOut=true);
  //! \brief ϥեȥǥХEcaControlerꤹ롣
  //! \param bRecord 쥳ǥ󥰤ͭˤʤäƤtrueꡣ
  //! \todo  too heavy
  //! ʣΥɥǥХбɬפ롣
  void setIOToCurrentChainsetup(bool bRecord);
  //! \brief ߥåѤEcaControlerꤹ롣
  //! \param bWithPlaying ʤߥå󤹤trueꡣ
  //! \param strFileName ߥåե̾Ρ
  void setMixdownIOToCurrentChainsetup(bool bWithPlaying, const QString& strFileName);
  //! \brief ߤξ֤֤
  Status engineStatus();
  //! \brief ޥ٥ȡ
  //! Ecasoundκλ(Finished)Ƚꤹ뤿Υޥ٥ȡ
  void timerEvent(QTimerEvent* TimerEvent);
  //! \brief .ewfե롣
  //! \param strTrackName ȥå̾Ρ
  //! \param strFileName ե̾Ρ
  void writeEwf(const QString& strTrackName, const QString& strFileName);
  //! \brief .ewfե롣
  //! \param nIndex ȥåǥ
  //! \param strFileName ե̾Ρ
  void writeEwf(int nIndex, const QString& strFileName);
  //! \brief ȥåФɬפ.ewfեνԤ
  //! ȥåνԤ줿ȥåvPrepareTrackChains
  //! ˳Ǽ롣
  //! setIOToCurrentChainsetupΤ߸ƤӽФġ
  //! \param bIgnoresRecord ƥȥåΥ쥳ǥ󥰥ե饰̵뤹롣
  //! ߥåϡtrueꤹ롣
  //! \todo ߤϡΥȥåvPrepareTrackChains˳ǼƤ롣
  //! setIOToCurrentChainsetupvPrepareTrackChains
  //! Ȥ褦ˤ̵̤ʤʤ롣
  //! 硢vPrepareTrackChainsˤϡΤǤϤʤ
  //! EwfѤΥȥåǼФ褤
  void prepareTracks(bool bIgnoresRecord=false);
  //! \brief ȥå˹Ԥä.ewfեν򸵤᤹
  //! setIOToCurrentChainsetupΤ߸ƤӽФġ
  //! \todo setIOToCurrentChainsetupvPrepareTrackChains
  //! Ȥ褦ˤ餳δؿɬפʤʤ롣
  void destroyPreparings();
  //! \brief ƥݥե롣
  void removeTmpFiles();
  //! \brief ߤ
  void doDetailStopped();

private slots:
  //! \brief 
  //! \param strTrackName 򤷤ȥå̾Ρ
  //! ʣ򤷤硢','Ƕڤ롣
  void slotSelectChain(const QString& strTrackName);

signals:
  //! \brief ޥݥѹ줿ȯ륷ʥ롣
  void masterPositionChanged(const QTime&);
  //! \brief Ecasoundξ֤Finishedˤʤäȯ륷ʥ롣
  //! Stopped֤ˤʤäƤȯʤ
  void finished();
  //! \brief å줿ȯ륷ʥ롣
  //! \param strMessage å
  void messageGenerated(const QString& strMessage);
};

#endif
