/***************************************************************************
                          wsoundlocator.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5 30  02:16:12 JST
    copyright            : (C) 2003 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qfileinfo.h>
#include "wsoundlocator.h"
#include "cecatools.h"

/////////////////////////////////////////////////////////////////////////////

WSoundLocator::WSoundLocator(QWidget *WidgetParent, const char *cName)
 : QScrollView(WidgetParent, cName)
{
  setFrameStyle(QFrame::WinPanel | QFrame::Plain);
  setHScrollBarMode(QScrollView::AlwaysOn);

  WidgetBase = new QWidget(this);
  GanttItem = new WGanttItem(QColor(111, 109, 158), 
                             QColor(138, 136, 197), 
                             WidgetBase);
  WidgetBase->setMinimumWidth(1000);
  WidgetBase->setMaximumHeight(GanttItem->height());
  WidgetBase->setMinimumHeight(GanttItem->height());
  addChild(WidgetBase);
  GanttItem->move(0, 0);

  GanttItem->hide();

  connect(GanttItem, 
          SIGNAL(startPositionChanged(int)), 
          this, 
          SLOT(slotChangedStartPosition(int)));
  connect(GanttItem, 
          SIGNAL(offsetChanged(int)), 
          this,
          SLOT(slotChangedOffset(int)));
  connect(GanttItem, 
          SIGNAL(lengthChanged(int)), 
          this, 
          SLOT(slotChangedLength(int)));
}

/////////////////////////////////////////////////////////////////////////////

WSoundLocator::~WSoundLocator()
{
}

/////////////////////////////////////////////////////////////////////////////

void
WSoundLocator::bind(const QString& strFileName)
{
  strSrcFileName = strFileName;

  QFileInfo fileInfo(strFileName);
  if ( !fileInfo.exists() ) {
    GanttItem->hide();
    return;
  }

  CEcaTools ecaTools;
  QTime time = ecaTools.sourceLength(strFileName);
  QTime timeTmp;
  GanttItem->slotSetMaximumLength(timeTmp.secsTo(time));
  GanttItem->show();
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::setBaseColor(const QColor& color)
{
  WidgetBase->setPaletteBackgroundColor(color);
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::setItemFaceColor(const QColor& color)
{
  GanttItem->setPaletteBackgroundColor(color);
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::setItemEdgeColor(const QColor& color)
{
  GanttItem->setPaletteEdgeColor(color);
}

/////////////////////////////////////////////////////////////////////////////

QTime
WSoundLocator::sourceLength() const
{
  CEcaTools ecaTools;
  return ecaTools.sourceLength(strSrcFileName);
}

/////////////////////////////////////////////////////////////////////////////

QTime
WSoundLocator::startPosition() const
{
  QTime time;
  return time.addSecs(GanttItem->startPosition());
}

/////////////////////////////////////////////////////////////////////////////

QTime
WSoundLocator::offset() const
{
  QTime time;
  return time.addSecs(GanttItem->offset());
}

/////////////////////////////////////////////////////////////////////////////

QTime 
WSoundLocator::length() const
{
  QTime time;
  return time.addSecs(GanttItem->length());
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotSetStartPosition(const QTime& time)
{
  QTime timeTmp;
  GanttItem->slotSetStartPosition(timeTmp.secsTo(time));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotSetOffset(const QTime& time)
{
  QTime timeTmp;
  GanttItem->slotSetOffset(timeTmp.secsTo(time));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotSetLength(const QTime& time)
{
  QTime timeTmp;
  GanttItem->slotSetLength(timeTmp.secsTo(time));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotChangedStartPosition(int nSecond)
{
  QTime time;
  emit startPositionChanged(time.addSecs(nSecond));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotChangedOffset(int nSecond)
{
  QTime time;
  emit offsetChanged(time.addSecs(nSecond));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotChangedLength(int nSecond)
{
  QTime time;
  emit lengthChanged(time.addSecs(nSecond));
}

/////////////////////////////////////////////////////////////////////////////

#include "wsoundlocator.moc"
