/***************************************************************************/
/*! \file   wganttitem.h
    \brief  饹WGanttItemΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5 30  02:19:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WGANTTITEM_H
#define WGANTTITEM_H

#include <qframe.h>
#include <qlabel.h>
#include <qpoint.h>
#include <qcolor.h>

/*-------------------------------------------------------------------------*/
/*! \class  WGanttItem
    \brief  ֤ԤΥåȡ
*/
/*-------------------------------------------------------------------------*/
class WGanttItem : public QFrame
{
  Q_OBJECT

public:
  //! \brief 󥹥ȥ饯
  //! \param colorMid ܥǥο
  //! \param colorEdge åο
  WGanttItem(const QColor& colorMid, 
             const QColor& colorEdge, 
             QWidget* WidgetParent=0, 
             const char* cName=0);
  //! \brief ǥȥ饯
  virtual ~WGanttItem();

  //! \brief ϰ֤֤
  int startPosition() const;
  //! \brief եåȤ֤
  //! x()
  int offset() const;
  //! \brief Ĺ֤
  //! width()Ȱ㤦åȴĹ֤
  int length() const;
  //! \brief Ĺ֤
  int maximumLength() const;
  //! \brief ϰ֤ꤹ롣
  void setStartPosition(int nStartPosition);
  //! \brief եåȤꤹ롣
  void setOffset(int nOffset);
  //! \brief Ĺꤹ롣
  void setLength(int nLen);
  //! \brief Ĺꤹ롣
  //! setMaximumWidthȤϰۤʤ롣
  void setMaximumLength(int nLen);

  //! \brief ɸ᤹
  void reset();

  //! \brief ꡣ
  void setPaletteEdgeColor(const QColor& color);

public slots:
  //! \brief ϰ֤ꤹ롣
  void slotSetStartPosition(int nStartPosition);
  //! \brief եåȤꤹ롣
  void slotSetOffset(int nOffset);
  //! \brief Ĺꤹ롣
  //! \param bLeft û硢trueꡣǥեȤfalse
  void slotSetLength(int nLen, bool bLeft=false);
  //! \brief Ĺꤹ롣
  //! setMaximumWidthȤϰۤʤ롣
  void slotSetMaximumLength(int nLen);

protected:
  void mousePressEvent(QMouseEvent* Event);
  void mouseReleaseEvent(QMouseEvent*);
  void mouseMoveEvent(QMouseEvent*);

private:
  enum MouseState 
  {
    Suspended, 
    Moving, 
    LeftResizing, 
    RightResizing
  };

  QFrame* FrameFace;
  QColor  colorFace;
  QColor  colorStretcher;
  int nMaxLen;
  int nXCursorMoveStart;
  int nXMoveStart;
  int nWidthResizeStart;
  int nLeftDiff;
  int nRightDiff;
  MouseState mouseState;

signals:
  void startPositionChanged(int);
  void offsetChanged(int);
  void lengthChanged(int);
};

#endif
