/*
 * FIRFilter.cpp
 *
 *  Created on: 2008/07/31
 *      Author: syn
 */

#include <cstring>
#include "FIRFilter.h"

FIRFilter::FIRFilter() {
	mBuffer = new float[16*2];
	for(int i = 0; i < 16*2; i++){
		mBuffer[i] = 0;
	}
	mOutBuffer = new float[4096*2];
}

FIRFilter::~FIRFilter() {
	delete[] mBuffer;
}

void FIRFilter::doMix(float* p, const int len){
	float a, b;
	int idx;

	// filter -> mOutBuffer
	for(int i = 0; i < len/2; i++){
		a = 0; b = 0;
		for(int j = -15; j <= 0; j++){
			if(j%2){
				continue;
			}
			idx = i+j;
			if(idx < 0){
				a += mBuffer[(15+idx)*2 +0];
				b += mBuffer[(15+idx)*2 +1];
			}else{
				a += p[idx*2 +0];
				b += p[idx*2 +1];
			}
		}
		a /= 8;
		b /= 8;
		mOutBuffer[i*2 +0] = a;
		mOutBuffer[i*2 +1] = b;
	}

	// save last samples
	for(int i = 0; i < 16; i++){
		mBuffer[i*2 +0] = p[(len/2 -16+i)*2 +0];
		mBuffer[i*2 +1] = p[(len/2 -16+i)*2 +1];
	}

	// copy mOutBuffer -> p
	memcpy(p, mOutBuffer, len*sizeof(float));
}
