/*
 * Synthesizer.cpp
 *
 *  Created on: 2008/07/26
 *      Author: syn
 */

#include <iostream>
#include <unistd.h>
#include <SDL/SDL.h>
#include <SDL/SDL_audio.h>
#include <lo/lo.h>
#include "Module.h"
#include "Synthesizer.h"

Synthesizer* gSelf;
static void callback_audio(void*p, Uint8* stream, int len);
static int callback_lo(const char* path, const char* types, lo_arg **argv, int argc, void* data, void* p);

Synthesizer::Synthesizer(){
	mInitialized = false;
}

Synthesizer::~Synthesizer() {
	// TODO Auto-generated destructor stub
	if(mInitialized){
		SDL_CloseAudio();
		SDL_Quit();
	}
}

bool Synthesizer::initialize(){
	if(SDL_Init(SDL_INIT_AUDIO) < 0){
		std::cout << "SDL_Init failed." << std::endl;
		return false;
	}

	SDL_AudioSpec fmt;
	fmt.freq = 44100;
	fmt.format = AUDIO_S16;
	fmt.channels = 2;
	fmt.samples = 1024;
	fmt.callback = callback_audio;
	fmt.userdata = this;
	if(SDL_OpenAudio(&fmt, 0) < 0){
		std::cout << "SDL_OpenAudio failed." << std::endl;
		return false;
	}

	mBuffer = new float[1024*2];

	mLOServer = lo_server_thread_new("7700", 0);
	lo_server_thread_add_method(mLOServer, "/ocillator/frequency", "i", callback_lo, this);
	lo_server_thread_add_method(mLOServer, "/NOTE_ON", "i", callback_lo, this);
	lo_server_thread_add_method(mLOServer, "/SQUARE_GENERATOR/duty", "i", callback_lo, this);
	lo_server_thread_start(mLOServer);

	mInitialized = true;

	return true;
}

void Synthesizer::addModule(Module* m){
	mModuleList.push_back(m);
}

void* Synthesizer::run(){
	if(!initialize()){
		return 0;
	}

	SDL_PauseAudio(0);

	return 0;
}

void Synthesizer::doMix(unsigned char* p, int len){
	std::list<Module*>::iterator I;
	for(I = mModuleList.begin(); I != mModuleList.end(); ++I){
		(*I)->doMix(mBuffer, len/2);
	}

	signed short* sp = (signed short*)p;
	for(int i = 0; i < len/2; i++){
		if(mBuffer[i] > 1.0)	sp[i] = 0x7fff;
		else if(mBuffer[i] < -1.0) sp[i] = -32767;
		else sp[i] = (signed short)(32767*mBuffer[i]);
	}
}

void Synthesizer::eventHandler(const char *path, const char *types, lo_arg **argv, int argc, void *data){
	std::list<Module*>::iterator I;
	if(strcmp(types, "i") == 0){
		for(I = mModuleList.begin(); I != mModuleList.end(); ++I){
			(*I)->eventHandler(path, argv[0]->i32);
		}
	}
}

void callback_audio(void*p, Uint8* stream, int len){
	Synthesizer* self = (Synthesizer*)p;
	self->doMix(stream, len);
}

int callback_lo(const char *path, const char *types, lo_arg **argv, int argc, void *data, void *p){
	Synthesizer* self = (Synthesizer*)p;
	self->eventHandler(path, types, argv, argc, data);

	return 0;
}

