/*
 * main.cpp
 *
 *  Created on: 2008/07/26
 *      Author: syn
 */

#include <string>
#include <stdio.h>
#include <unistd.h>
#include "Synthesizer.h"
#include "SineGenerator.h"
#include "SawGenerator.h"
#include "SquareGenerator.h"
#include "WhiteNoiseGenerator.h"
#include "EnvelopeGenerator.h"
#include "Recorder.h"
#include "Echo.h"
#include "FIRFilter.h"
#include "RCFilter.h"
#include "RLCFilter.h"


bool buildSynthesizer(Synthesizer* s, const std::string& configPath);

int main(){
	Synthesizer* syn = new Synthesizer();

	if(!buildSynthesizer(syn, "Synthesizer.txt")){
		delete syn;
		return 0;
	}

	syn->start();

	while(true){
		sleep(1);
	}

	delete syn;

	return 0;
}

bool buildSynthesizer(Synthesizer* s, const std::string& configPath){
	bool ret = true;
	FILE* f;
	char line[256];
	char* p;

	f = fopen(configPath.c_str(), "r");
	if(f == 0){
		perror("fopen");
		return false;
	}

	int lineCnt = 1;
	while(fgets(line, sizeof(line), f)){
		p = strtok(line, " \n");
		if(p == 0){
			continue;
		}
		if(strcmp(p, "SineGenerator") == 0){
			s->addModule(new SineGenerator());
		}
		else if(strcmp(p, "SawGenerator") == 0){
			s->addModule(new SawGenerator());
		}
		else if(strcmp(p, "SquareGenerator") == 0){
			s->addModule(new SquareGenerator());
		}
		else if(strcmp(p, "WhiteNoiseGenerator") == 0){
			s->addModule(new WhiteNoiseGenerator());
		}
		else if(strcmp(p, "EnvelopeGenerator") == 0){
			s->addModule(new EnvelopeGenerator());
		}
		else if(strcmp(p, "FIRFilter") == 0){
			s->addModule(new FIRFilter());
		}
		else if(strcmp(p, "RCFilter") == 0){
			s->addModule(new RCFilter());
		}
		else if(strcmp(p, "RLCFilter") == 0){
			s->addModule(new RLCFilter());
		}
		else if(strcmp(p, "Echo") == 0){
			s->addModule(new Echo());
		}
		else if(strcmp(p, "Recorder") == 0){
			p = strtok(0, " \n");
			if(p == 0){
				fprintf(stderr, "Line %d: Recorder: no output file.", lineCnt);
				ret = false;
				break;
			}else{
				s->addModule(new Recorder(p));
			}
		}
		else{
			fprintf(stderr, "Line %d: unknown command: %s", lineCnt, p);
			ret = false;
			break;
		}
		lineCnt++;
	}

	fclose(f);

	return ret;
}
