/*
 * SynthController.cpp
 *
 *  Created on: 2008/08/02
 *      Author: syn
 */

#include <iostream>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>
#include "notify_timer.h"
#include "Controller.h"
#include "SynthController.h"

#define WINDOW_WIDTH	(350)
#define WINDOW_HEIGHT (48)

SynthController::SynthController() {
	// TODO Auto-generated constructor stub

}

SynthController::~SynthController() {
	// TODO Auto-generated destructor stub
}

bool SynthController::initialize(){
	if(SDL_Init(SDL_INIT_VIDEO| SDL_INIT_AUDIO) < 0){
		std::cout << "SDL_Init SDL_MOUSE_BUTTON_EVENTfailed." << std::endl;
		return false;
	}

	mScreen = SDL_SetVideoMode(WINDOW_WIDTH, WINDOW_HEIGHT, 32, SDL_OPENGL);
	if(mScreen == 0){
		std::cout << "SDL_SetVideoMode failed." << std::endl;
		return false;
	}
	SDL_WM_SetCaption("==TSUKUNE== SampleController", "==TSUKUNE== SampleController");
	initializeGL();

	return true;
}

void SynthController::initializeGL(){
	// 2Dmode, lighting off
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(0, WINDOW_WIDTH, WINDOW_HEIGHT, 0);
	glMatrixMode(GL_MODELVIEW);
	glDisable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	glClearColor(0.1, 0.1, 0.2, 0);
}

void SynthController::render(){
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	std::list<Controller*>::iterator I;

	for(I = mControllerSet.begin(); I != mControllerSet.end(); ++I){
		(*I)->render();
	}

	glFlush();
	SDL_GL_SwapBuffers();
}

void SynthController::addController(Controller* c){
	mControllerSet.push_back(c);
}

void* SynthController::run(){
	if(!initialize()){
		return 0;
	}

	NotifyTimer timer(1000/60);
	timer.start();

	render();

	SDL_Event evt;
	bool done = false;
	while(!done && SDL_WaitEvent(&evt)){
		int btn = 0;
		switch(evt.type){
		case SDL_MOUSEBUTTONDOWN:
			handleMouseButtonDown(evt.button.x, evt.button.y);
			break;
		case SDL_MOUSEBUTTONUP:
			handleMouseButtonUp(evt.button.x, evt.button.y);
			break;
		case SDL_MOUSEMOTION:
			if(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON_LEFT){
				btn = 1;
			}
			handleMouseMotion(btn, evt.button.x, evt.button.y);
			break;
		case SDL_QUIT:
			done = true;
			break;
		}
		render();
	}

	SDL_Quit();

	return 0;
}

void SynthController::handleMouseButtonDown(const int x, const int y){
	std::list<Controller*>::iterator I;

	int localX, localY;
	for(I = mControllerSet.begin(); I != mControllerSet.end(); ++I){
		localX = x -(*I)->getLocationX();
		localY = y -(*I)->getLocationY();
		(*I)->handleMouseButtonDown(localX, localY);
	}
}

void SynthController::handleMouseButtonUp(const int x, const int y){
	std::list<Controller*>::iterator I;

	int localX, localY;
	for(I = mControllerSet.begin(); I != mControllerSet.end(); ++I){
		localX = x -(*I)->getLocationX();
		localY = y -(*I)->getLocationY();
		(*I)->handleMouseButtonUp(localX, localY);
	}
}

void SynthController::handleMouseMotion(const int btn, const int x, const int y){
	std::list<Controller*>::iterator I;

	int localX, localY;
	for(I = mControllerSet.begin(); I != mControllerSet.end(); ++I){
		localX = x -(*I)->getLocationX();
		localY = y -(*I)->getLocationY();
		(*I)->handleMouseMotion(btn, localX, localY);
	}
}
