/*
 * SynthController.h
 *
 *  Created on: 2008/08/02
 *      Author: syn
 */

#ifndef SYNTHCONTROLLER_H_
#define SYNTHCONTROLLER_H_

#include <list>
#include <SDL/SDL.h>
#include "thread.h"

class Controller;

class SynthController:public Thread{
public:
	SynthController();
	virtual ~SynthController();

public:
	void* run();
	void render();
	void addController(Controller* c);

protected:
	bool initialize();
	void initializeGL();
	void handleMouseButtonDown(const int x, const int y);
	void handleMouseButtonUp(const int x, const int y);
	void handleMouseMotion(const int btn, const int x, const int y);

protected:
	SDL_Surface* mScreen;
	std::list<Controller*> mControllerSet;
};

#endif /* SYNTHCONTROLLER_H_ */
