/*
 * SineGenerator.cpp
 *
 *  Created on: 2008/07/26
 *      Author: syn
 */

#include <iostream>
#include <math.h>
#include "SineGenerator.h"

SineGenerator::SineGenerator() {
	// TODO Auto-generated constructor stub
	mPhase = 0;
	mFreq = 440;
	mTable = new float[44100];

	float f;
	for(int i = 0; i < 44100; i++){
		f = (float)i/44100;
		mTable[i] = sin(2*M_PI*f);
	}
}

SineGenerator::~SineGenerator() {
	// TODO Auto-generated destructor stub
	delete[] mTable;
}

void SineGenerator::doMix(float*p, const int len){
	int phase = mPhase;
	for(int i = 0; i < len/2; i++){
		p[i*2 +0] = mTable[phase];
		p[i*2 +1] = mTable[phase];
		phase += mFreq;
		phase %= 44100;
	}
	mPhase = phase;
}

void SineGenerator::setFreq(int n){
	mFreq = n;
}

void SineGenerator::eventHandler(const char* path, const int n){
	if(strcmp(path, "/ocillator/frequency") == 0){
		this->setFreq(n);
	}else if(strcmp(path, "/NOTE_ON") == 0){
		this->setFreq(MIDINoteToFreq(n));
	}
}

