/*
 * SquareGenerator.h
 *
 *  Created on: 2008/07/31
 *      Author: syn
 */

#ifndef SQUAREGENERATOR_H_
#define SQUAREGENERATOR_H_

#include "GenericOcillator.h"

class SquareGenerator:public GenericOcillator{
public:
	SquareGenerator();
	virtual ~SquareGenerator();

public:
	void doMix(float* p, const int len);
	void setFreq(int n);
	void setDuty(int duty); // 0 < duty < 100
	void setPortament(const int frame);
	void eventHandler(const char* path, const int n);

protected:
	int mFreq;
	int mBaseFreq;  // For portament
	int mTargetFreq;    // For portament
	int mPhase;
	int mPortament;
	int mPortamentPhase;
	float mDutyRatio;
	signed short* mTable;
};

#endif /* SQUAREGENERATOR_H_ */
