/*
 * Synthesizer.h
 *
 *  Created on: 2008/07/26
 *      Author: syn
 */

#ifndef SYNTHESIZER_H_
#define SYNTHESIZER_H_

#include <string>
#include <list>
#include <lo/lo.h>
#include "thread.h"

class Module;

class Synthesizer:public Thread{
public:
	Synthesizer();
	virtual ~Synthesizer();

public:
	void* run();
	void doMix(unsigned char* p, int len);
	void eventHandler(const char *path, const char *types, lo_arg **argv, int argc, void *data);
	void addModule(Module* m);
	void removeModule(Module* m);
	void clearModules();

protected:
	bool initialize();

protected:
	float* mBuffer;
	std::list<Module*> mModuleList;
	pthread_mutex_t mModuleListMutex;
	lo_server_thread mLOServer;
	bool mInitialized;
};

#endif /* SYNTHESIZER_H_ */
