#ifndef THREAD_H
#define THREAD_H

#include <pthread.h>

class Thread{
protected:
	typedef void* (*EntryPoint)(void*);

public:
	Thread();
	virtual ~Thread();

public:
	virtual void start();
	virtual void stop();
	virtual pthread_t getThreadId();

public:
	static int join(Thread* t);

protected:
	virtual void* run() = 0;
	static void* entryPoint(void* p);

protected:
	pthread_t mThreadId;
};

#endif
