/*
 * SquareOcillator.cpp
 *
 *  Created on: 2008/08/14
 *      Author: syn
 */

#include <iostream>
#include <GL/gl.h>
#include <FTGL/ftgl.h>
#include <lo/lo.h>
#include "SynthController.h"
#include "SquareOcillator.h"
#include "Knob.h"

#define HEIGHT (92)
#define WIDTH (30)

SquareOcillator::SquareOcillator()
:Controller(), KnobListener(){
	mDutyKnob = new Knob(10, 90, 50, this);
	mDutyKnob->moveTo(16, 30);

	mPortaKnob = new Knob(0, 4096, 0, this);
	mPortaKnob->moveTo(16, 68);
}

SquareOcillator::~SquareOcillator() {
	delete mDutyKnob;
	delete mPortaKnob;
}

void SquareOcillator::render(){
	FTBufferFont* font = SynthController::getInstance()->getFont();

	glPushMatrix();
	glTranslatef(mLocX, mLocY, 0);
	glColor3f(1, 1, 1);

	// Logo
	glBegin(GL_LINE_STRIP);
	glVertex3f(4, 10, 0);
	glVertex3f(4, 4, 0);
	glVertex3f(10, 4, 0);
	glVertex3f(10, 10, 0);
	glVertex3f(16, 10, 0);
	glVertex3f(16, 4, 0);
	glEnd();

	// Frame
	glBegin(GL_LINE_STRIP);
	glVertex3f(0, 0, 0);
	glVertex3f(0, HEIGHT, 0);
	glVertex3f(WIDTH, HEIGHT, 0);
	glVertex3f(WIDTH, 0, 0);
	glVertex3f(0, 0, 0);
	glEnd();

	// Duty Knob
	mDutyKnob->render();
	glColor3f(1, 1, 1);
	glPushMatrix();
	glTranslatef(4, 48, 0);
	glScalef(1, -1, 1);
	font->FaceSize(10);
	font->Render("Duty");
	glPopMatrix();

	// Portament Knob
	mPortaKnob->render();
	glColor3f(1, 1, 1);
	glPushMatrix();
	glTranslatef(2, 86, 0);
	glScalef(1, -1, 1);
	font->FaceSize(10);
	font->Render("Porta.");
	glPopMatrix();

	glPopMatrix();
}

void SquareOcillator::handleMouseButtonDown(const int x, const int y){
	int lx, ly;

	lx = x -16;
	ly = y -30;
	mDutyKnob->handleMouseButtonDown(lx, ly);

	lx = x -16;
	ly = y -68;
	mPortaKnob->handleMouseButtonDown(lx, ly);
}

void SquareOcillator::handleMouseButtonUp(const int x, const int y){
	int lx, ly;
	lx = x -16;
	ly = y -30;
	mDutyKnob->handleMouseButtonUp(lx, ly);

	lx = x -16;
	ly = y -68;
	mPortaKnob->handleMouseButtonUp(lx, ly);
}

void SquareOcillator::handleMouseMotion(const int btn, const int x, const int y){
	int lx, ly;
	lx = x -16;
	ly = y -30;
	mDutyKnob->handleMouseMotion(btn, lx, ly);

	lx = x -16;
	ly = y -68;
	mPortaKnob->handleMouseMotion(btn, lx, ly);
}

void SquareOcillator::knobValueChanged(Knob* what, const int val){
	SynthController* synth = SynthController::getInstance();

	if(what == mDutyKnob){
		lo_address to = synth->getSynthAddress();
		lo_send(to, "/SQUARE_GENERATOR/duty", "i", val);
	}
	else if(what == mPortaKnob){
		lo_address to = synth->getSynthAddress();
		lo_send(to, "/SQUARE_GENERATOR/portament", "i", val);
	}
}
