/*
  URGView ̃fNX
  Satofumi KAMIMURA
  $Id$
*/

#include "urgViewDemo.h"
#include "urgViewResource.h"
#include "fileUtils.h"


void URGViewDemo::URGViewProperty::evaluate(void) {
  const char* home_str = getenv("HOME");
  std::string home_path = std::string((home_str ? home_str : ".")) + "/.vxv";
  value(ttf_file, "ttf_path", (home_path + "/font.ttf").c_str());
}


URGViewDemo::URGViewDemo(void)
  : times_text(NULL), times_label(NULL),
    back(NULL), frame(NULL), button_back(NULL), button_focused_back(NULL),
    larger_text(NULL), larger_normal(NULL), larger_focused(NULL),
    smaller_text(NULL), smaller_normal(NULL), smaller_focused(NULL),
    quit_text(NULL), quit_normal(NULL), quit_focused(NULL), pause_text(NULL), 
    urg(NULL), view_offset(Grid(0, 0)), property(*new URGViewProperty()) {
  for (unsigned int i = 0; i < M_LINES; ++i) {
    m_surface[i] = NULL;
  }

  const char* home_str = getenv("HOME");
  std::string home_path = std::string((home_str ? home_str : ".")) + "/.vxv";
  const char* searchPath[] = { ".", home_path.c_str(), NULL };
  property.load("monitorconf", searchPath);

  // monitorconf tHgʒu̓ǂݏo
  const char* dummyPath[] = { "", NULL };
  ttf_path = VXV::searchFile(property.ttf_file.c_str(), dummyPath);
  if (ttf_path.empty() && (ttf_path = searchTTF()).empty()) {
    printf("Please edit ttf_path in ~/.vxv/moniorconf\n");
  }
}


URGViewDemo::~URGViewDemo(void) {
  win->activate(false);

  delete times_text;
  delete back;
  delete frame;
  delete button_back;
  delete button_focused_back;
  delete larger_text;
  delete larger_normal;
  delete larger_focused;
  delete smaller_text;
  delete smaller_normal;
  delete smaller_focused;
  delete quit_text;
  delete quit_normal;
  delete quit_focused;
  delete pause_text;
  delete urg;
  for (unsigned int i = 0; i < M_LINES; ++i) {
    delete m_surface[i];
  }
}


void URGViewDemo::updateMagnify(double magnify) {
  view->updateMagnify(magnify);
  view->setViewToRangeGrid(view_offset,
			   Grid((win->w - FrameWidth)/2, win->h/2));

  sensed->updateMagnify(magnify);
  sensed->setViewToRangeGrid(view_offset,
			     Grid((win->w - FrameWidth)/2, win->h/2));

  // Pʂ̕`ʒu𒲐
  for (unsigned int i = 0; i < M_LINES; ++i) {
    int x = (win->w -FrameWidth)/2 - static_cast<int>(magnify * view_offset.x);
    int y = win->h/2
      - static_cast<int>(magnify * view_offset.y + magnify * 1000*(i+1));
    m_label[i]->setPosition(Grid(x, y), Center | Middle);
  }
}


int URGViewDemo::Initialize(int argc, char *argv[]) {
#ifdef Monitor
  urg = new mURGCtrl();
#else
  urg = new URGCtrl();
#endif
  int ret_value = urg->connect(argc, argv, false);
  if (ret_value < 0) {
    printf("URGCtrl::connect: %s\n", urg->what());
    return ret_value;
  }
  urg->adjustCrdPosition(Position(0, 0, Direction::deg(-90)));

  win->setTitle("URG View");
  win->activate(true);

  ttf = new TTF_Draw();
  ttf->load(ttf_path.c_str());

  // ʂ̏`
  enum { FontSize = 22, };
  back = new FillSurface(Rect(win->w - FrameWidth, win->h), BackColor);
  win->add(new LabelComponent(back));

  // ⏕
  view = new ViewComponent(Rect(win->w -FrameWidth, win->h));
  int line_pos = static_cast<int>(10000 * sqrt(2) / 2.0);
  view->add(new LineDraw(Grid(0, 0),
			 Grid(+line_pos, -line_pos), LineColor));
  view->add(new LineDraw(Grid(0, 0),
			 Grid(-line_pos, -line_pos), LineColor));
  for (unsigned int i = 1; i <= M_LINES; ++i) {
    view->add(new CircleDraw(Grid(0, 0), 1000 * i, LineColor));
    for (unsigned int j = 1; j <= 9; ++j) {
      view->add(new CircleDraw(Grid(0, 0), 1000 * (i-1) + 100 * j, Gray7));
    }
  }
  base_magnify = win->h / 4000.0;
  int_magnify = 0;
  magnify_max = win->h / 400.0;
  magnify_min = win->h / 22000.0;
  win->add(view);

  // Pʂ̃x
  for (unsigned int i = 0; i < M_LINES; ++i) {
    char text[] =  "XX[m]";
    sprintf(text, "%d[m]", i+1);
    m_surface[i] = new DrawSurface(ttf->createText(text, 16,
						   LineColor, BackColor));
    m_label[i] = new LabelComponent(m_surface[i]);
    win->add(m_label[i]);
  }
  // ZTl̕\p
  sensed = new ViewComponent(Rect(view->w, view->h));
  win->add(sensed);

  // t[
  frame = new FillSurface(Rect(win->w - FrameWidth, FrameWidth, 100, win->h),
			  Black);
  win->add((new LabelComponent(frame))
	   ->setPosition(Grid(win->w - FrameWidth, 0)));

  // {^
  Rect button_size = Rect(0,0, 76, 24);
  button_back = new FillSurface(button_size, Gray6);
  button_focused_back = new FillSurface(button_size, Gray8);

  // g{^
  larger_button = new ButtonComponent(button_size);
  larger_text = new DrawSurface(ttf->createText(Button_Larger,
						FontSize, White, Gray7), true);
  larger_normal = new MultiSurface(button_size);
  larger_normal->addSurface(button_back);
  larger_normal->addSurface(larger_text, Center | Middle);

  larger_focused = new MultiSurface(button_size);
  larger_focused->addSurface(button_focused_back);
  larger_focused->addSurface(larger_text, Center | Middle);

  larger_button->setNormalSurface(larger_normal);
  larger_button->setFocusedSurface(larger_focused);
  larger_button->setPosition(Grid(win->w -12, 12), Right | Top);
  win->add(larger_button);

  // k{^
  smaller_button = new ButtonComponent(button_size);
  smaller_text =
    new DrawSurface(ttf->createText(Button_Smaller,
				    FontSize, White, Gray7), true);
  smaller_normal = new MultiSurface(button_size);
  smaller_normal->addSurface(button_back);
  smaller_normal->addSurface(smaller_text, Center | Middle);

  smaller_focused = new MultiSurface(button_size);
  smaller_focused->addSurface(button_focused_back);
  smaller_focused->addSurface(smaller_text, Center | Middle);

  smaller_button->setNormalSurface(smaller_normal);
  smaller_button->setFocusedSurface(smaller_focused);
  smaller_button->setPosition(Grid(win->w -12, 12 + button_size.h + 12),
			      Right | Top);
  win->add(smaller_button);

  // I{^
  quit_button = new ButtonComponent(button_size);
  quit_text = new DrawSurface(ttf->createText(Button_Quit,
					      FontSize, White, Gray7), true);

  quit_normal = new MultiSurface(button_size);
  quit_normal->addSurface(button_back);
  quit_normal->addSurface(quit_text, Center | Middle);

  quit_focused = new MultiSurface(button_size);
  quit_focused->addSurface(button_focused_back);
  quit_focused->addSurface(quit_text, Center | Middle);

  quit_button->setNormalSurface(quit_normal);
  quit_button->setFocusedSurface(quit_focused);
  quit_button->setPosition(Grid(win->w -12, win->h -12), Right | Bottom);
  win->add(quit_button);

  // "pause" 
  pause_text =
    new DrawSurface(ttf->createText("Pause", 32, White, Gray7), true);
  updateMagnify(base_magnify);

  return 0;
}


int URGViewDemo::MainLoop(void) {

  UserInput::userInput_t ui;
  bool quit = false;
  bool pause = false;
  bool next = false;
  int times = 0;
  Grid drag_begin, drag_diff = Grid(0, 0);
  bool now_drag = false;
  do{
    // ZTl擾
    if (!pause || next) {
      urg->capture();
      times = urg->getCaptureTimes();
      next = false;
    }

    // ͏
    win->lock();
    ui = UserInput::getInputed();

    // hbOψʂ̍쐬
    if (ui.left_clicked) {
      if (ui.mpos.x < (win->w - FrameWidth)) {
	drag_begin = ui.mpos;
	now_drag = true;
      }
    }
    if (ui.left_released && now_drag) {
      now_drag = false;
      if (ui.mpos.x < (win->w - FrameWidth)) {
	drag_diff = ui.mpos - drag_begin;
      }
    }

    // I
    quit = ui.quit | quit_button->isPressed();

    // J[\ɂ\͈͂̃XN[
    double magnify = base_magnify * pow(1.3, int_magnify);
    int scroll = static_cast<int>(50 / magnify);
    Grid pre_offset = view_offset;
    if (ui.isPressedCode(SDLK_UP)) {
      view_offset.y -= scroll;
    } else if (ui.isPressedCode(SDLK_DOWN)) {
      view_offset.y += scroll;
    } else if (ui.isPressedCode(SDLK_RIGHT)) {
      view_offset.x += scroll;
    } else if (ui.isPressedCode(SDLK_LEFT)) {
      view_offset.x -= scroll;
    }

    // }EXhbOɂ\͈͂̃XN[
    view_offset -= Grid(static_cast<int>(drag_diff.x / magnify),
			static_cast<int>(drag_diff.y / magnify));
    drag_diff = Grid(0, 0);

    // sŕ\͈͂WԂɐݒ
    if (ui.isPressedCode(SDLK_RETURN)) {
      view_offset = Grid(0, 0);
      int_magnify = 0;
    }

    // Xy[Xɂꎞ~
    if (ui.isPressed(' ')) {
      pause = !pause;
      if (pause) {
	win->add((new LabelComponent(pause_text))
		 ->setPosition(Grid(10,10)), LogLevel);
      } else {
	win->clear(LogLevel);
      }
    }
    // ꎞ~̃R}
    if (ui.isPressedCode(SDLK_n)) {
      next = true;
    }

    // gAk̏
    int magnify_diff = ui.wheel_moved
      + ((larger_button->isPressed() || ui.isPressed('0')) ? +1 : 0)
      + ((smaller_button->isPressed() || ui.isPressed('9')) ? -1 : 0);
    if (magnify_diff ||
	(view_offset.x != pre_offset.x || view_offset.y != pre_offset.y)) {
      if ((magnify_diff < 0) && (magnify > magnify_min)) {
	--int_magnify;
      } else if ((magnify_diff > 0) && (magnify < magnify_max)) {
	++int_magnify;
      }
      double next_magnify = base_magnify * pow(1.3, int_magnify);
      if ((next_magnify < magnify_max) || (next_magnify > magnify_min)) {
	if (ui.wheel_moved) {
	  // gAkɁAJ[\ʒu̍WړȂ
	  view_offset.x += static_cast<int>((ui.mpos.x - (win->w-FrameWidth)/2)
					    * (1/magnify - 1/next_magnify));
	  view_offset.y += static_cast<int>((ui.mpos.y - win->h/2)
					    * (1/magnify -  1/next_magnify));
	}
	magnify = next_magnify;
	updateMagnify(magnify);
      }
    }

    // \ZTf[^̍XV
    urg->convert();
    sensed->clear();
    for (std::vector<Grid3D>::iterator it = urg->crd_points.begin();
	 it != urg->crd_points.end(); ++it) {
      sensed->add(new PixelDraw(-it->x, -it->y, Red));
    }

    // ticks ̕`
    if (times_text) {
      win->del(times_label, LogLevel);
      delete times_text;
    }
    char times_str[20];
    sprintf(times_str, "%d [capture]", times);
    times_text =
      new DrawSurface(ttf->createText(times_str, 24, White, Gray7), true);
    times_label = new LabelComponent(times_text);
    win->add(times_label
	     ->setPosition(Grid(win->w - FrameWidth - 8 - times_text->w,
				win->h -8), Bottom), LogLevel);
    win->unlock();

    SDL_Delay(10);
  } while (!quit);

  win->activate(false);
  return 0;
}
