#ifndef COMBO_BOX_COMPONENT_H
#define COMBO_BOX_COMPONENT_H

/*!
  \file
  \brief R{{bNX̃R|[lg
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "ttfDraw.h"
#include "menuComponent.h"
#include "drawSurface.h"
#include "fillSurface.h"
#include "multiSurface.h"


/*!
  \brief R{{bNX\̃R|[lg
*/
class ComboBoxComponent : public FocusComponentInterface {
  enum { DefaultFontSize = 24 };
  TTF_Draw& ttf;
  unsigned long fore_color;
  unsigned long back_color;
  unsigned long focused_fore_color;
  unsigned long focused_back_color;

  MenuComponent* menu;
  ButtonComponent* selected_item;
  MultiSurface* selected_surface;
  LabelComponent* button_label;
  DrawSurface* button_surface;
  VXV::Grid button_offset;
  FillSurface* fill_normal;
  FillSurface* fill_focused;
  std::vector<DrawSurface*> surface_normal;
  std::vector<DrawSurface*> surface_focused;
  std::vector<MultiSurface*> items_normal;
  std::vector<MultiSurface*> items_focused;
  std::vector<ButtonComponent*> items;
  std::vector<const Uint16*> add_text;
  std::vector<Uint16*> char_text;
  unsigned int now_index;
  bool view_list;
  int font_size;
  bool focused;
  bool decided;

  void deleteObject(void);

public:
  /*!
    \brief TrueTypeFont\[Xw̃RXgN^

    \param ttf_resource [i] TrueTypeFont\[X
  */
  ComboBoxComponent(TTF_Draw& ttf_resource);
  ~ComboBoxComponent(void);
  bool draw(unsigned long ticks, const UserInput& ui);
  /*!
    \brief \ڂ̒ǉ

    \param text [i] \
  */
  void add(const Uint16* text);

  void add(const char* text);

  void setColor(unsigned long fore, unsigned long back,
		unsigned long focused_fore, unsigned long focused_back);

  /*!
    \brief tHgTCYύX

    \param size [i] tHgTCY
  */
  void setFontSize(int size);

  // !!! R|[lg̑傫
  // Xg̔wiF, tH[JXF
  // !!! g̕AF

  /*!
    \brief ĨNA
  */
  void updateSelected(void);

  /*!
    \brief `

    \param on [i] `悷Ƃ true
  */
  void activate(bool on);

  /*!
    \brief Iڂ̋w

    \param index [i] Iڔԍ
  */
  void setNowIndex(int index);

  bool isDecided(void);

  /*!
    \brief Iڂ̎擾

    \return Iڔԍ
  */
  unsigned int getNowIndex(void);

  void beginFocus(void);
  void endFocus(void) ;
};

#endif /* !COMBO_BOX_COMPONENT_H */
