/*
  WCXeBbN̑NX
  Satofumi KAMIMURA
  $Id$
*/

#include "joystickCtrl.h"
#include <SDL.h>


bool JoystickCtrl::joystick_initialized = false;
JoystickCtrl::JoystickResource JoystickCtrl::jsr;


void JoystickCtrl::initJoystickSystem(void) {
  if (SDL_InitSubSystem(SDL_INIT_JOYSTICK) < 0) {
    throw SDL_Exception();
  }
  SDL_JoystickEventState(SDL_ENABLE);
  jsr.num_max = SDL_NumJoysticks();
  jsr.js.resize(jsr.num_max);
}


void JoystickCtrl::init(void) {
  if (!joystick_initialized) {
    initJoystickSystem();
    joystick_initialized = true;
  }
}


JoystickCtrl::JoystickCtrl(void) : own_index(-1) {
  init();
}


JoystickCtrl::~JoystickCtrl(void) {
  if (own_index >= 0) {
    SDL_JoystickClose(jsr.js[own_index].ptr);
    jsr.js[own_index].ptr = NULL;
    jsr.js[own_index].used = false;
    own_index = -1;
  }
}


const char* JoystickCtrl::what(void) {
  return "";
}


int JoystickCtrl::size(void) {
  init();
  return (jsr.num_max - jsr.used_num);
}


bool JoystickCtrl::activate(int index) {

  // gĂȂ Joystick ̌
  if (index == FreeIndex) {
    int free_index = 0;
    for (std::vector<EachJoystick>::iterator it = jsr.js.begin();
	 it != jsr.js.end(); ++it) {
      if (!it->used) {
	index = free_index;
	break;
      }
      ++free_index;
    }
  }

  if ((index < 0) || (index >= static_cast<int>(jsr.js.size())) ||
      jsr.js[index].used) {
    return false;
  }
  own_index = index;
  EachJoystick* js = &jsr.js[own_index];

  // ڑ
  if (!js->ptr) {
    js->ptr = SDL_JoystickOpen(own_index);
  }
  js->used = true;

  js->num_axis = SDL_JoystickNumAxes(js->ptr);
  //js->num_hats = SDL_JoystickNumHats(js->ptr);
  //js->num_balls = SDL_JoystickNumBalls(js->ptr);
  js->num_buttons = SDL_JoystickNumButtons(js->ptr);
  js->axis_value.resize(js->num_axis);
  js->buttons_value.resize(js->num_buttons);

  for (int i = 0; i < js->num_axis; ++i) {
    js->axis_value[i] = 0;
  }
  // !!! num_hats
  // !!! num_balls
  for (int i = 0; i < js->num_buttons; ++i) {
    js->buttons_value[i] = false;
  }

  return true;
}


void JoystickCtrl::joystickEventHandler(SDL_Event& event) {

  switch (event.type) {

  case SDL_JOYAXISMOTION:
    JoystickCtrl::joyAxisEventHandler(event.jaxis);
    break;

  case SDL_JOYBALLMOTION:
    JoystickCtrl::joyBallEventHandler(event.jball);
    break;

  case SDL_JOYHATMOTION:
    JoystickCtrl::joyHatEventHandler(event.jhat);
    break;

  case SDL_JOYBUTTONDOWN:
  case SDL_JOYBUTTONUP:
    JoystickCtrl::joyButtonEventHandler(event.jbutton);
    break;
  }
}


void JoystickCtrl::joyAxisEventHandler(SDL_JoyAxisEvent& event) {
  jsr.js[event.which].axis_value[event.axis] = event.value;
}


void JoystickCtrl::joyBallEventHandler(SDL_JoyBallEvent& event) {
  fprintf(stderr, "ball event: Not implemented\n");
}


void JoystickCtrl::joyHatEventHandler(SDL_JoyHatEvent& event) {
  fprintf(stderr, "hat event: Not implemented\n");
}


void JoystickCtrl::joyButtonEventHandler(SDL_JoyButtonEvent& event) {
  jsr.js[event.which].buttons_value[event.button] =
    (event.state == SDL_PRESSED) ? true : false;
}


bool JoystickCtrl::isActivated(void) const {
  return (own_index >= 0) ? true : false;
}

int JoystickCtrl::getNumAxis(void) const {
  return jsr.js[own_index].num_axis;
}


int JoystickCtrl::getNumButtons(void) const {
  return jsr.js[own_index].num_buttons;
}


short JoystickCtrl::getAxisValue(int index) const {
  return jsr.js[own_index].axis_value[index];
}


bool JoystickCtrl::getButtonValue(int index) const {
  return jsr.js[own_index].buttons_value[index];
}
