/*
  dˍ킹T[tFX
  Satofumi KAMIMURA
  $Id$
*/

#include "multiSurface.h"


MultiSurface::  MultiSurface(const VXV::Rect& size) {
  w = size.w;
  h = size.h;
}


MultiSurface::~MultiSurface(void) {
}


bool MultiSurface::draw(const VXV::Rect& size, const VXV::Grid& pos,
			unsigned long ticks) {

  for (surface_t::iterator it = objs.begin();
       it != objs.end(); ++it) {
    it->surface->draw(it->range, pos + it->offset, ticks);
  }
  return true;
}


void MultiSurface::addSurface(SurfaceInterface* surface, char align,
			      const VXV::Grid& pos) {
  surfaceOffset_t surfaceInfo;
  surfaceInfo.surface = surface;

  // \ʒu̒
  // !!! animationSurface.cpp, componentInterface.cpp Ƃ̋ʉ͂
  surfaceInfo.offset.x = 0;
  if (align & VXV::Center) {
    surfaceInfo.offset.x = w/2 - surface->w/2;
  } else if (align & VXV::Right) {
    surfaceInfo.offset.x = w - surface->w;
  }
  surfaceInfo.offset.y = 0;
  if (align & VXV::Middle) {
    surfaceInfo.offset.y = h/2 - surface->h/2;
  } else if (align & VXV::Bottom) {
    surfaceInfo.offset.y = h - surface->h;
  }

  // !!! ͂ݏoɂĂ̌vZ 
  surfaceInfo.range = VXV::Rect(surface->w, surface->h);

  objs.push_back(surfaceInfo);
}
