/*
  SDL  Window NX
  Satofumi KAMIMURA
  $Id$
*/

#include "sdlWindow.h"


SDL_Window::SDL_Window(bool fullscreen_mode) : SDL_Video() {
  w = ScreenWidth;
  h = ScreenHeight;
  fullscreen = fullscreen_mode;
}


SDL_Window::~SDL_Window(void) {
  clear(All);
  activate(false);
}


void SDL_Window::setTitle(const char *title, const char *icon) {
  SDL_Video::setTitle(title, icon);
}


void SDL_Window::autoHideCursor(int waitMsec) {
  SDL_Video::autoHideCursor(waitMsec);
}


void SDL_Window::activate(bool on) {
  SDL_Video::activate(on);
}


unsigned long SDL_Window::getTicks(void) {
  return SDL_Video::getTicks();
}


void SDL_Window::delay(unsigned long ticks) {
  SDL_Delay(ticks);
}


void SDL_Window::lock(void) {
  SDL_Video::lock();
}


void SDL_Window::unlock(void) {
  SDL_Video::unlock();
}


void SDL_Window::add(ComponentInterface* component, char depth) {
  if (!component) {
    return;
  }
  draws[depth].push_back(component);
}


void SDL_Window::del(ComponentInterface* component, char depth) {
  if (!component) {
    return;
  }
  delInputComponent(component);

  draws[depth].remove(component);
  delete component;
  component = NULL;
}


void SDL_Window::clear(char depth) {
  if (depth != All) {
    for (std::list<ComponentInterface*>::iterator it = draws[depth].begin();
	 it != draws[depth].end();) {
      std::list<ComponentInterface*>::iterator it_next = it;
      ++it_next;

      del(*it, depth);
      it = it_next;
    }
    draws[depth].clear();

  } else {
    for (std::map<char,drawList>::iterator it = draws.begin();
	 it != draws.end(); ++it) {
      clear(it->first);
    }
  }
}


void SDL_Window::addInputComponent(FocusComponentInterface* component,
				   char depth) {
  inputList.push_back(component);
  add(component, depth);
}


void SDL_Window::toggleFocus(void) {
  SDL_Video::toggleFocus();
}


void SDL_Window::setFocus(FocusComponentInterface* component) {
  SDL_Video::setFocus(component);
}


void SDL_Window::setFullscreen(bool on) {
  if (fullscreen != on) {
    fullscreen = on;
    fullscreen_trigger = true;
  }
}


bool SDL_Window::getNowFullscreen(void) {
  return fullscreen;
}
