/*
  L[͗p̃R|[lg
  Satofumi KAMIMURA
  $Id$
*/

#include "textInputComponent.h"
#include "drawSurface.h"
#include <SDL.h>


TextInputComponent::TextInputComponent(TTF_Draw& ttfObj, int pxSize,
				       const VXV::Rect& size,
				       unsigned long color, unsigned long back)
  : ttf(ttfObj), px_size(pxSize), draw_rect(size),
    fore_color(color), back_color(back), buffer_max(BufferSize),
    decided(false), ctrl_disable(false), cursor_it(inputed.end()),
    back_surface(NULL) {
  w = draw_rect.w;
  h = draw_rect.h;
  position = VXV::Grid(0, 0);
  back_surface = new FillSurface(draw_rect, back_color);
}


TextInputComponent::~TextInputComponent(void) {
  delete back_surface;
  back_surface = NULL;
}


void TextInputComponent::setBufferMax(int maxSize) {
  buffer_max = maxSize;
}


void TextInputComponent::addInputToBuffer(const UserInput& ui) {

  int n = ui.keys_sys.size();
  for (int i = 0; i < n; ++i) {
    char ch = ui.keys_sys[i];
    if (isprint(ch)) {
      inputed.insert(cursor_it, ch);
      continue;
    }
    bool ctrl_pressed = (ui.sdl_mods_sys[i] & KMOD_CTRL) ? true : false;
    switch (ui.sdl_keys_sys[i]) {
    case SDLK_RETURN:
      decided = true;
      return;
      break;

    case SDLK_h:
      if (!ctrl_pressed) {
	break;
      }
    case SDLK_BACKSPACE:
    if (cursor_it != inputed.begin()) {
	cursor_it = inputed.erase(--cursor_it);
      }
      break;

    case SDLK_b:
      if (!ctrl_pressed) {
	break;
      }
    case SDLK_LEFT:
      if (cursor_it != inputed.begin()) {
	--cursor_it;
      }
      break;

    case SDLK_f:
      if (!ctrl_pressed) {
	break;
      }
    case SDLK_RIGHT:
      if (cursor_it != inputed.end()) {
	++cursor_it;
      } else {
	inputed.insert(cursor_it, ' ');
      }
      break;

    case SDLK_d:
      if (!ctrl_pressed) {
	break;
      }
    case SDLK_DELETE:
      if (cursor_it != inputed.end()) {
	cursor_it = inputed.erase(cursor_it);
      }
      break;
    }
  }
}


bool TextInputComponent::drawChar(Uint16 uch, unsigned long fore,
				  unsigned long back, VXV::Grid& next) {
  bool ch_draw = false;

  Uint16 ch[] = { uch, 0x0000 };
  DrawSurface* surface =
    new DrawSurface(ttf.createText(ch, px_size, fore, back), false);
  int width = surface->w;
  if (next.x + width <= draw_rect.w) {
    ch_draw = true;
    LabelComponent* label = new LabelComponent(surface);
    label->draw(position, VXV::Rect(0, 0, w, h), 1.0, next, false);
    delete label;
  }
  delete surface;
  next.x += width;

  return ch_draw;
}


bool TextInputComponent::draw(unsigned long ticks, const UserInput& ui) {

  // obt@̏
  // !!! ϊIuWFNgg悤ɕύX

  if (!ctrl_disable && !decided) {
    addInputToBuffer(ui);
  }

  // wiFœhԂ
  back_surface->draw(draw_rect, position, ticks);

  // \̕`
  inputed.push_back(0x0000);

  // ̕`
  bool cursor_found = false;
  bool cursor_on = (ticks & 0x200) ? (!ctrl_disable && !decided) : false;
  VXV::Grid next = VXV::Grid(0, 0);
  int index = 0;
  for (std::list<unsigned short>::iterator it = inputed.begin();
       it != inputed.end(); ++it, ++index) {

    // 
    cursor_found |= (it != cursor_it);
    if (index > buffer_max) {
      inputed.erase(it, inputed.end());
      if (!cursor_found) {
	cursor_it = inputed.end();
      }
      break;
    }
    if ((it == cursor_it) && cursor_on) {
      drawChar(*it, back_color, fore_color, next);
    } else {
      drawChar(*it, fore_color, back_color, next);
    }
  }
  if ((cursor_it == inputed.end()) && cursor_on) {
    drawChar(' ', back_color, fore_color, next);
  }

  inputed.pop_back();
  return true;
}


void TextInputComponent::clear(void) {
  inputed.clear();
}


void TextInputComponent::setText(const char* text) {
  clear();
  int n = strlen(text);
  n = (n > buffer_max) ? buffer_max : n;
  for (int i = 0; i < n; ++i) {
    inputed.push_back(text[i]);
  }
}


void TextInputComponent::activate(bool on) {
}


bool TextInputComponent::isDecided(void) {
  return decided;
}


void TextInputComponent::disable(bool on) {
  ctrl_disable = on;
  if (!on) {
    decided = false;
  }
}


void TextInputComponent::beginFocus(void) {
  SDL_EnableKeyRepeat(500, 25);
  ctrl_disable = false;
  disable(false);
}


void TextInputComponent::endFocus(void) {
  SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
  ctrl_disable = true;
  disable(true);
}
